clear all
close all
clc

%% dorsiflexion

Cw = 0;
K = .84;

% hard-coded nodes on dorsiflexion curve
xint1 = 0.11;   x1 = -0.10;    y1 = 65*K;
yturn = 160*K;  xturn = -0.175;
xint = xint1;   xadjust = x1;  yadjust = y1;

pos_a = 7:-.1:-10;
pos_a = pos_a*pi/180;

for i = 1:length(pos_a);
    % depending where we are on the curve, create a line in angle-torque space to follow
    if pos_a(i) > xadjust      % if we're in the shallow part
        m = (0-yadjust)/(xint-xadjust);
        b = yadjust - xadjust*m;
    else                    % we're in the steeper part
        m = (yturn-yadjust)/(xturn-xadjust);
        b = yturn - xturn*m;
    end
    % desired torque is a linear fit on these terms
    taudes(i) = [pos_a(i) 1]*[m b]';

    % Disallow negative torques
    taudes(i) = max(taudes(i),0);
end

work_dorsi = trapz(pos_a,taudes);

pos_a_dorsi = pos_a;
taudes_dorsi = taudes;

%% plantarflexion
clearvars -except work_dorsi K yturn xturn pos_a_dorsi taudes_dorsi

Cw = 1;

% hard-coded nodes on dorsiflexion curve
xint1 = 0.11;   x1 = -0.10;    y1 = 65*K;

% Cw dependent nodes on plantarflexion curve
if Cw >= 0 && Cw <= 1
    xint = xint1 + (0.22 - xint1)*Cw;
    xadjust = x1 + (0.03 - x1)*Cw;
    yadjust = y1 + (42*K - y1)*Cw;
elseif Cw > 1
    xint = .22; % fixed max plantar
    m = (.22-.03)/4; b = .03 - m; % denominator in m equation + 1 => Cw for max work
    xadjust = m*Cw + b;
    m = (yturn - 42*K)/4; b = 42*K - m;
    yadjust = m*Cw + b;
else
    xint = .11; % fixed max plantar
    m = (xturn + .1)/-1.5; b = -.1; % denominator in m equation => Cw for min work
    xadjust = m*Cw + b;
    m = (-65*K)/-1.5; b = 65*K;
    yadjust = m*Cw + b;
end

pos_a = -10:.1:20;
pos_a = pos_a*pi/180;

for i = 1:length(pos_a);
    % depending where we are on the curve, create a line in angle-torque space to follow
    if pos_a(i) > xadjust      % if we're in the shallow part
        m = (0-yadjust)/(xint-xadjust);
        b = yadjust - xadjust*m;
    else                    % we're in the steeper part
        m = (yturn-yadjust)/(xturn-xadjust);
        b = yturn - xturn*m;
    end
    % desired torque is a linear fit on these terms
    taudes(i) = [pos_a(i) 1]*[m b]';

    % Disallow negative torques
    taudes(i) = max(taudes(i),0);
end

work_plantar = trapz(pos_a,taudes);

work_net = work_dorsi+work_plantar

pos_a_plantar = pos_a;
taudes_plantar = taudes;

load anklewalkdata

%% Work-loop
figure(1)
hold on
plot([pos_a_dorsi pos_a_plantar],[taudes_dorsi taudes_plantar],'b')
hold on
plot(theta,torque*K,'k--')
hold off

work_net_norm = trapz(theta,torque*K)

% %% Power-time
% figure
% plot(1:length(torque),torque.*thetadot)

