function plotdata_step(filename,t_s,t_e,workoffset)

close all
% clear all
clc

%% Datafile Conditioning

load anklewalkdata

eval(['load(''Data\' filename '.mat'');']);
eval(['time = ' filename '.X.Data;']);
eval(['ydata = ' filename '.Y;']);

for i = 1:length(ydata)
    namestr = ydata(i).Name;
    namestr(findstr(' ',namestr)) = '_';
    if namestr(end) == '_'; namestr = namestr(1:end-1); end;
    eval([namestr ' = ' filename '.Y(1,' num2str(i) ').Data;']);   
end

% keyboard

if nargin > 1;
    torque = torque*workoffset;
end

if nargin < 3;
    ind_s = find(time>0,1,'first');
    ind_e = find(time>0,1,'last');
else
    ind_s = find(time>t_s,1,'first');
    ind_e = find(time>t_e,1,'first'); 
end

%% Averaging
start = 0;
k = 0;

for i = ind_s:ind_e
    if(Desired_Torque(i)<=30)
        start = 1;
    else if(start == 1 && Desired_Torque(i)>40)
            k = k + 1;
            step(k) = i - 1 - 150;
            start = 0;
        end    
    end
end

Ankle_Torque = Out1;
Desired_Power = Desired_Torque_No_Prediction .* Ankle_Velocity * pi/180;

for k = 1:length(step)-1
    temp = Ankle_Torque(step(k):step(k+1));
    Ankle_Torque_steps(k,:) = resample(temp,100,length(temp));
    
    temp = Desired_Torque_No_Prediction(step(k):step(k+1));
    Desired_Torque_steps(k,:) = resample(temp,100,length(temp));
    
    temp = Desired_Torque_No_Prediction(step(k):step(k+1));
    Desired_Torque_Ideal_steps(k,:) = resample(temp,100,length(temp));
    
    temp = Ankle_Position(step(k):step(k+1));
    Ankle_Position_steps(k,:) = resample(temp,100,length(temp));
    
    temp = Ankle_Velocity(step(k):step(k+1));
    Ankle_Velocity_steps(k,:) = resample(temp,100,length(temp));
    
    temp = Ankle_Power(step(k):step(k+1));
    Ankle_Power_steps(k,:) = resample(temp,100,length(temp));
    
    temp = Desired_Power(step(k):step(k+1));
    Desired_Power_steps(k,:) = resample(temp,100,length(temp));
    
    temp = time(step(k+1))-time(step(k));
    duration_steps(k) = temp;  
end

Ankle_Torque_avg = mean(Ankle_Torque_steps);
Desired_Torque_avg = mean(Desired_Torque_steps);
Ankle_Position_avg = mean(Ankle_Position_steps);
Ankle_Velocity_avg = mean(Ankle_Velocity_steps);
Ankle_Power_avg = mean(Ankle_Power_steps);
Desired_Power_avg = mean(Desired_Power_steps);
duration_avg = mean(duration_steps);
duration_std = std(duration_steps);
work_avg = trapz(linspace(0,duration_avg,length(Ankle_Power_avg)),Ankle_Power_avg);
work_desired_avg = trapz(linspace(0,duration_avg,length(Desired_Power_avg)),Desired_Power_avg);
fprintf('work_avg = %g, work_desired_avg = %g \n', work_avg, work_desired_avg);

%%% Plotting

stride = 1:100;

%% Torque-stance
f = figure(1);
set(f,'Name','Torque-stance')
plot(stride,Ankle_Torque_avg,'b-',stride,Desired_Torque_avg,'g-',stride,Ankle_Torque_steps','.')
ylabel('Ankle Torque (Nm)')
xlabel('% Stride')
legend('Measured','Desired')

%% Position-stance
f = figure(2);
set(f,'Name','Position-stance')
plot(stride,Ankle_Position_avg,'b-',stride,Ankle_Position_steps','.')
ylabel('Ankle Position (deg)')
xlabel('% Stride')

%% Velocity-stance
f = figure(3);
set(f,'Name','Velocity-stance')
plot(stride,Ankle_Velocity_avg,'b-',stride,Ankle_Velocity_steps','.')
ylabel('Ankle Velocity (deg/s)')
xlabel('% Stride')

%% Power-stance
f = figure(4);
set(f,'Name','Power-stance')
plot(stride,Ankle_Power_avg,'b-',stride,Desired_Power_avg,'g-',stride,Ankle_Power_steps','.')
ylabel('Ankle Power (W)')
xlabel('% Stride')
legend('Measured','Desired')

%% Work loop
f = figure(5);
set(f,'Name','Torque-Position')
plot(theta*180/pi,torque,'k--',Ankle_Position_avg,Ankle_Torque_avg,'b-',Ankle_Position_avg,Desired_Torque_avg,'g-',Ankle_Position_steps',Ankle_Torque_steps','.')
xlabel('Ankle Position (deg)')
ylabel('Ankle Torque (Nm)')
legend('Normal Walking Data','Measured','Desired')
