% function plotdata(filename,workoffset,t_s,t_e)
function plotdata(filename,t_s,t_e)

% For plotting of the data produced by ControlDesk

close all
clc

load anklewalkdata

if nargin < 1; filename = 'rec001'; end
eval(['load(''Data\' filename '.mat'');']);
eval(['time = ' filename '.X.Data;']);
eval(['ydata = ' filename '.Y;']);

tempindex = 1;
for i = 1:length(ydata)
% 	ind = max(findstr('/',ydata(i).Path));
    namestr = ydata(i).Name; % (ind+1:end);
    namestr(findstr(' ',namestr)) = '_';
    if namestr(end) == '_'; namestr = namestr(1:end-1); end;
    eval([namestr ' = ' filename '.Y(1,' num2str(i) ').Data;']);
end

% keyboard

% if nargin > 1;
%     torque = torque*workoffset;   
% end

if nargin < 3;
    ind_s = find(time>0,1,'first');
    ind_e = find(time>0,1,'last');
else
    ind_s = find(time>t_s,1,'first');
    ind_e = find(time>t_e,1,'first'); 
end

% Rename, change units, and crop vars of interest
time = time(ind_s:ind_e);
tau_a = Out1(ind_s:ind_e);
tau_a_d = Desired_Torque_No_Prediction(ind_s:ind_e);
pos_a = Ankle_Position(ind_s:ind_e)*pi/180;
pos_s = Sprocket_Position(ind_s:ind_e)*pi/180;
pos_m = Motor_Position(ind_s:ind_e)*pi/180;
vel_a = Ankle_Velocity(ind_s:ind_e)*pi/180;
vel_s = Sprocket_Velocity(ind_s:ind_e)*pi/180;
vel_m = Motor_Velocity(ind_s:ind_e)*pi/180;
work_a = work_a(ind_s:ind_e);
power_a = Ankle_Power(ind_s:ind_e);
state_w = state_walk(ind_s:ind_e);
state_m = state_mode(ind_s:ind_e);
error_l = Error_Flag_Limits(ind_s:ind_e);
error_w = error_flag(ind_s:ind_e);
vel_m_d = Desired_Velocity(ind_s:ind_e);
pos_a_pred = Predicted_Position(ind_s:ind_e);

%% Torque-time
f = figure(1);
set(f,'Name','Torque-Time')
plot(time,tau_a,'b.',time,tau_a_d,'g.');
hold on; plot(time,tau_a,'b',time,tau_a_d,'g'); hold off
xlabel('Time (s)'); ylabel('Ankle Torque (Nm)'); legend('Measured','Desired')

%% Position-time
f = figure(2);
set(f,'Name','Position-Time')
plot(time,pos_a*180/pi,'b.',time,pos_a_pred*180/pi,'b.',time,pos_s*180/pi,'c.',time,pos_m*180/pi,'m.');
hold on; plot(time,pos_a*180/pi,'b',time,pos_a_pred*180/pi,'b--',time,pos_s*180/pi,'c',time,pos_m*180/pi,'m'); hold off
xlabel('Time (s)'); ylabel('Position (Deg)'); legend('Ankle','Ankle-Predicted','Sprocket','Motor Pulley')

%% Velocity-time
f = figure(3);
set(f,'Name','Velocity-Time')
plot(time,vel_a*180/pi,'b.',time,vel_s*180/pi,'c.',time,vel_m*180/pi,'m.');
hold on; plot(time,vel_a*180/pi,'b',time,vel_s*180/pi,'c',time,vel_m*180/pi,'m'); hold off
xlabel('Time (s)'); ylabel('Velocity (Deg/s)'); legend('Ankle','Sprocket','Motor Pulley')

%% Power-time
f = figure(4);
set(f,'Name','Power-Time')
power_a_ph = tau_a.*vel_a;
plot(time,power_a,'b.');
hold on; plot(time,power_a_ph,'g--'); hold off;
xlabel('Time (s)'); ylabel('Power (W)'); legend('Real-Time','Post-Hoc')

%% Work-time
f = figure(5);
work_a_ph = cumtrapz(time,power_a);
set(f,'Name','Work-Time')
plot(time,work_a,'b.')
hold on; plot(time,work_a_ph,'g'); hold off;
xlabel('Time (s)'); ylabel('Per-Step Work (J)'); legend('Real-Time','Post-Hoc')

%% State
f = figure(6);
set(f,'Name','State')
plot(time,state_m,'k.',time,state_w,'r.');
xlabel('Time (s)'); ylabel('State'); legend('Mode','Walk')

%% Errors
f = figure(7);
set(f,'Name','Errors')
plot(time,error_l,'k.',time,error_w,'r.');
xlabel('Time (s)'); ylabel('Error'); legend('Software Limits','Walking')

%% Commanded Velocity
f = figure(8);
set(f,'Name','Commanded (Motor) Velocity')
plot(time,vel_m_d*180/pi,'b.');
hold on; plot(time,vel_m_d*180/pi,'b'); hold off;
xlabel('Time (s)'); ylabel('Comanded Velocity (Deg/s)');

%% Work Loop
f = figure(9);
set(f,'Name','Work Loop')
plot(pos_a*180/pi,tau_a,'b.');
hold on; plot(pos_a*180/pi,tau_a,'b'); hold off;
xlabel('Ankle Position (Deg)'); ylabel('Ankle Torque (Nm)');
