/*
 *  sudo version 1.1 allows users to execute commands as root
 *  Copyright (C) 1991  The Root Group, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  If you make modifications to the source, we would be happy to have
 *  them to include in future releases.  Feel free to send them to:
 *      Jeff Nieusma                       nieusma@rootgroup.com
 *      3959 Arbol CT                      (303) 447-8093
 *      Boulder, CO 80301-1752             
 *
 **************************************************************************
 *
 *   sudo.c
 *
 *   This is the main() routine for sudo
 *
 *   sudo is a program to allow users to execute commands 
 *   as root.  The commands are defined in a global network-
 *   wide file and can be distributed.
 *
 *   sudo has been hacked far and wide.  Too many people to
 *   know about.  It's about time to come up with a secure
 *   version that will work well in a network.
 *
 *   This most recent version is done by:
 *
 *              Jeff Nieusma <nieusma@rootgroup.com>
 *              Dave Hieb    <davehieb@rootgroup.com>
 */

#define MAIN
#define VAR_NAME "LD_LIB"

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <pwd.h>
#include <netdb.h>
#include <sys/param.h>
#include "sudo.h"
extern char *malloc();

int  Argc;
char **Argv;
char *sudo_host;
char *sudo_user;
char *sudo_cmnd;
#ifdef MULTIMAX
unsigned short sudo_uid;
#else
uid_t sudo_uid;
#endif



/********************************************************************
 *
 *  main ()
 *
 *  the driving force behind sudo...
 */

main(argc, argv, envp)
int argc;
char *argv[];
char *envp[];
{
   extern void *usage();
   extern int list_privs();
   int rtn;
   register char **cpp;
   register char **xpp;
   register char *cp;

   Argv=argv;
   Argc=argc;

   /* First handle Bug in SunOS 4.1.1 */ 

   for( cpp = envp ; cp = *cpp;) { 
      if( strncmp(cp, VAR_NAME, strlen(VAR_NAME))==0) { 
	 for (xpp = cpp; xpp[0] = xpp[1] ; xpp++);
	 /* void */ ;
      }
      else { 
	 cpp++;
      }
   }

   if( argc < 2 ) { 
      usage();
      exit(0);
   }
   /* load the user host cmnd and uid variables */
   load_globals();  

   setuid(0); 
   if( strcmp(Argv[1], "-list") == 0 ) { 
      rtn=list_privs();
   }
   else { 
      rtn=validate();
   }
   setruid(sudo_uid);
   switch ( rtn ) {

   case LISTPRIVS_OK:
      exit(0);
      break;
   case VALIDATE_OK:
      /* check_user();  */
      setuid(0); 
      log_error( ALL_SYSTEMS_GO );
      execv(sudo_cmnd, &Argv[1]);
      break;
      
   case VALIDATE_NO_USER:
   case VALIDATE_NOT_OK: 
   case VALIDATE_ERROR:
   case LISTPRIVS_ERROR:
   case LISTPRIVS_PTS_ERROR:
   case LISTPRIVS_NO_USER:
   default:
      setuid( 0 ); 
      log_error ( rtn );
      setuid ( sudo_uid );
      inform_user ( rtn );
      exit (1);
      break;
      
   }
   
   
}





/**********************************************************************
 *
 *  load_gl[Bobals[B()
 *
 *  This function primes the important global variables:
 *  user, host, cmnd, uid
 */

void load_globals()
{
   struct passwd *pw_ent;
   struct hostent *h_ent;
   char path[MAXPATHLEN+1];
   char *p;
   
   
   if ( (sudo_user=malloc(9)) == NULL ) {
      perror ("malloc");
      exit (1);
   }
   if ( (sudo_host=malloc(MAXHOSTNAMELEN+1)) == NULL ) {
      perror ("malloc");
      exit (1);
   }
   
   sudo_uid = getuid();            /* we need to tuck this away for safe keeping */
   
   
   /* loading the cmnd global variable from argv[1] */
   if( Argc > 1 && (strcmp(Argv[1], "-list")) ) { 
      strcpy(path, Argv[1]);      /* make a copy of the argv[1] */
      sudo_cmnd = find_path ( path );  /* get the absolute path */
      if ( sudo_cmnd == NULL ) {
       fprintf ( stderr, "%s: %s: command not found\n", Argv[0], Argv[1] );
       exit (1);
    }
      sudo_cmnd = strdup ( sudo_cmnd );
   }
   else { 
      sudo_cmnd = "";  
   }
   
#ifdef NO_ROOT_SUDO
   if ( sudo_uid == 0 ) {
      fprintf(stderr, "You are already root, you don\'t need to use sudo.\n");
      exit (1);
   }
#endif

   /* loading the user global variable from the passwd file */
   
   if ( (pw_ent = getpwuid( sudo_uid )) == NULL ) {
      sprintf ( sudo_user, "%u", sudo_uid );
      log_error( GLOBAL_NO_PW_ENT );
      inform_user ( GLOBAL_NO_PW_ENT );
      exit (1);
   }
   strcpy ( sudo_user, pw_ent -> pw_name );
   
   
   /* loading the host global variable from gethostname() & gethostbyname() */

   if (( gethostname ( sudo_host, MAXHOSTNAMELEN ))) {
      strcpy ( sudo_host, "amnesiac" );
      log_error ( GLOBAL_NO_HOSTNAME );
      inform_user ( GLOBAL_NO_HOSTNAME );
   }
   else {
      if ( ( h_ent = gethostbyname (sudo_host) ) == NULL ) 
	 log_error ( GLOBAL_HOST_UNREGISTERED );
      else 
	 strcpy ( sudo_host, h_ent -> h_name );

      /* We don't want to return the fully quallified name all the time...  */
      
#ifndef FQDN
      if ( (p = index ( sudo_host, '.' )) ) *p='\0';
#endif
   }
   
}




/**********************************************************************
 *
 * usage()
 *
 *  this function just gives you instructions and exits
 */

void *usage()
{
   fprintf( stderr, "usage: %s command\n", *Argv);
   fprintf( stderr, "       %s -list\n" );
}

