/*
 *  sudo version 1.1 allows users to execute commands as root
 *  Copyright (C) 1991  The Root Group, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  If you make modifications to the source, we would be happy to have
 *  them to include in future releases.  Feel free to send them to:
 *      Jeff Nieusma                       nieusma@rootgroup.com
 *      3959 Arbol CT                      (303) 447-8093
 *      Boulder, CO 80301-1752             
 *
********************************************************************************
* list_privs.c, sudo project
* Shiva 
* June 16th 1992
*
* Routines for Listing priv's.
*******************************************************************************/
#include <stdio.h>
#include <strings.h>
#include <ctype.h>
#include <afs/param.h>
#include <afs/stds.h>
#include <ctype.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <stdio.h>
#include <rx/rx.h>
#include <rx/xdr.h>
#include <rx/rxkad.h>
#include <afs/auth.h>
#include <afs/cellconfig.h>

#include "sudo.h"

extern int user_list_found;
extern int unixgroup_list_found;
extern int ptsgroup_list_found;
extern int list_num, new_list[NUM_LISTS];
extern int parse_error, found_user;
extern int next_type, num_host_alias, num_cmnd_alias;
extern int num_unixgroup, num_ptsgroup;
extern char entity_permitted[80], entity_depermitted[80];
extern LINK tmp_ptr, reset_ptr, save_ptr, list_ptr[NUM_LISTS];


int list_privs() 
{ 


   FILE *sudoers_fp;
   int i, return_code; 
   long is_member_flag;
   long pts_retval, retval;
   int pts_member_found;
   int security_level;
   char *ConfDir, *CellName;
   char *grp_name;
   LINK temp_ptr;
   gid_t grps[MAX_UNIXGRPS];
   int  num_grps;
   int unixgrp_member_found;
   struct group *grp_ptr;

   extern FILE *yyin, *yyout;
   extern void print_user_list(), print_pts_list(), print_unixgrp_list();


   setuid(0);

   if( (sudoers_fp = fopen(SUDOERS, "r")) == NULL) { 
      perror(SUDOERS);
      log_error( NO_SUDOERS_FILE );
      exit(1);
   }

   yyin = sudoers_fp;
   yyout = stdout; 

   for( i = 0; i < NUM_LISTS; i++ ) 
      new_list[i] = TRUE;
   reset_ptr = (LINK) NULL;
   found_user = FALSE; 

   /*
    * yyparse() returns with one of 3 values: 0) yyparse() worked fine;
    * 1) yyparse() failed; FOUND_USER) the user was found and yyparse()
    * was returned from prematurely.
    *
    */

   return_code = yyparse();

   (void) fclose( sudoers_fp );

   /* 
    * There's no point in running setuid more than necessary.
    *
    */

   /* if a parsing error occurred, set return_code accordingly */

   if (parse_error == TRUE) {
      return(VALIDATE_ERROR);
   }
   
   setruid( sudo_uid );

   /*
    * The lists are all in place now. 
    * Scan them and print the information.
    *
    */

   if( found_user == TRUE ) { 

      /* 
       * This user has a direct entry.
       * Just list the information in USER_LIST
       * 
       */ 

      (void) print_user_list( list_ptr[USER_LIST] );

      exit(0);

   }

#ifdef PTSGRP_CHECK

   /*
    * Now check all the AFS pts groups. 
    *
    */
   

   /* First delete the USER_LIST. We may need to re-use it. */
   delete_list(USER_LIST);

   security_level = AFS_SECURITY_LEVEL;
   ConfDir        = AFS_CONFIG_DIRECTORY;
   CellName       = AFS_CELLNAME;

   pts_retval = pr_Initialize( security_level,
                              ConfDir,
                              CellName );
   if( pts_retval ) {
      fprintf(stderr, "Error initializing AFS Protection DataBase Query.\n");
      fprintf(stderr, "Aborting Query.\n");
      return(LISTPRIVS_PTS_ERROR);
    }

   temp_ptr = list_ptr[PTSGROUP_LIST];

   while( (num_ptsgroup > 0) && (temp_ptr  != (LINK)NULL) ) {
      if( temp_ptr->type == TYPE1 ) {

         /* An AFS pts group name */

         if( temp_ptr->data[0] != '~' ) {
            fprintf(stderr, "Inconsistency in Internal Lists Detected.\n");
            fprintf(stderr, "Send Mail to repair@rpi.edu.\n");
            return(LISTPRIVS_ERROR);
         }
         grp_name = &(temp_ptr->data[1]);
#ifdef DEBUG
         printf("Checking Group: %s\n", grp_name);
#endif DEBUG

         pts_retval = pr_IsAMemberOf( sudo_user, grp_name, &is_member_flag );
         if( pts_retval ) {
            fprintf(stderr, "Error Querying Protection Database.\n");
            fprintf(stderr, "Aborting Query.\n");
            return( LISTPRIVS_PTS_ERROR );
         }
         if( is_member_flag ) {

            pts_member_found = TRUE;
#ifdef DEBUG
            printf("Found in group %s, printing list.\n", grp_name);
#endif
	    (void) print_pts_list( temp_ptr ); 
         }

         temp_ptr = temp_ptr->next;
      }
      else {
         temp_ptr = temp_ptr->next;
      }
   }

#endif PTSGRP_CHECK

#ifdef UNIXGRP_CHECK

   /* 
    * Now checking all UNIX groups. 
    *
    */

   num_grps = getgroups( MAX_UNIXGRPS, grps );


   temp_ptr = list_ptr[UNIXGROUP_LIST];
   while( (num_unixgroup > 0) && (temp_ptr  != (LINK)NULL) ) { 
      if( temp_ptr->type == TYPE1 ) { 

	 /* An UNIX group name */ 

	 if( temp_ptr->data[0] != ':' ) { 
	    fprintf(stderr, "Inconsistency in Internal Lists Detected.\n");
	    fprintf(stderr, "Send Mail to repair@rpi.edu.\n");
	    return(VALIDATE_ERROR);
	 }
	 grp_name = &(temp_ptr->data[1]);
#ifdef DEBUG
         printf("Checking Unix Group: %s\n", grp_name);
#endif DEBUG	 
	 
	 grp_ptr = getgrnam( grp_name );
	 if( grp_ptr ) { 

	    /* The group exists. */

	    for( i = 0; i < num_grps ; i ++ ) { 

	       if( grp_ptr->gr_gid == grps[i] ) { 


		  unixgrp_member_found = TRUE;
#ifdef DEBUG		  
		  printf("Found in group %s, printing list.\n", grp_name);
#endif DEBUG		  
                  (void) print_unixgrp_list( temp_ptr );

	       }
	    }
	 }
	 temp_ptr = temp_ptr->next;
      }
      else { 
	 temp_ptr = temp_ptr->next;
      }
   }

#endif UNIXGRP_CHECK
   if( (unixgrp_member_found == TRUE) || (pts_member_found == TRUE) ) {
      strcpy( entity_permitted, sudo_user );
      return( LISTPRIVS_OK );
   }
   else {
      strcpy( entity_depermitted, sudo_user );
      return( LISTPRIVS_NO_USER );
   }

}


void expand_cmnd_list( c_ptr ) 
LINK c_ptr; 
{ 

   extern void print_cmnd_list(); 

   LINK cl_ptr; 

   cl_ptr = list_ptr[CMND_LIST]; 

   if( ! list_ptr[CMND_LIST] ) { 
      
     /* Error. No Command Aliases defined, and the Command does not
      * begin with a '/'.
      */
      
      fprintf(stderr, "Invalid Sudoer's file specification.\n");
      fprintf(stderr, "Please report this to repair@rpi.edu.\n\n");
      exit(1);
   }
   if( cl_ptr->type != TYPE1 ) {
      fprintf(stderr, "Error in Internal lists.\n");
      fprintf(stderr, "Please report this to repair@rpi.edu.\n\n");
   }
   cl_ptr = cl_ptr->next; 
   while( cl_ptr ) { 
      if( (cl_ptr->type == TYPE2) && 
	 (strcmp( cl_ptr->data, c_ptr->data ) == 0) ) { 
	 cl_ptr = cl_ptr->next; 
	 if( cl_ptr && (cl_ptr->type == TYPE3) ) { 
	    print_cmnd_list( cl_ptr ); 
	    return;
	 }
	 return;
      }
      else { 
	 cl_ptr = cl_ptr->next; 
      }
   }
}


void print_cmnd_list( l_ptr )
LINK l_ptr; 
{

   while( l_ptr && (l_ptr->type == TYPE3) ) { 
      if( l_ptr->data[0] == '/' ) { 
	 printf( "%s ", l_ptr->data );
      }
      else if( strcmp( l_ptr->data, "ALL" ) == 0 ) { 
	 printf( "%s ", l_ptr->data ); 
      }
      else { 
	 expand_cmnd_list( l_ptr ); 
      }
      l_ptr = l_ptr->next; 
   }
}
	 


void print_user_list( usr_ptr ) 
LINK usr_ptr; 
{

   LINK t_ptr; 
   char *t_host; 

   t_ptr = usr_ptr; 
   if( t_ptr->type != TYPE1 ) { 
      fprintf( stderr, "Error. Internal Error in Lists." );
      fprintf( stderr, "Report this error to repair@rpi.edu" );
      exit(1);
   }
   t_ptr = usr_ptr->next; 
   while( t_ptr ) { 
      if( t_ptr->type != TYPE2 ) { 
	 t_ptr = t_ptr->next; 
      }
      else { 
	 t_host = t_ptr->data; 
	 if( pts_host_type_ok( t_ptr ) == TRUE ) { 
	    printf( "%s@%s: ",  usr_ptr->data, sudo_host ); 
	    t_ptr = t_ptr->next; 
	    if( t_ptr && (t_ptr->type == TYPE3) ) { 
	       print_cmnd_list( t_ptr ); 
	       printf("\n");
	       t_ptr = t_ptr->next; 
	    }
	 }
	 else { 
            if( t_ptr->type == TYPE2 ) t_ptr = t_ptr->next; 
	    while( t_ptr && (t_ptr->type == TYPE3) ) t_ptr = t_ptr->next; 
	 }
      }
   }
} 





void print_pts_list( pts_ptr ) 
LINK pts_ptr; 
{ 

   LINK t_ptr; 
   char *pts_grp_name, *t_host; 

   t_ptr = pts_ptr; 

   if( (t_ptr->type != TYPE1) || ( t_ptr->data[0] != '~') ) { 
      fprintf(stderr, "Error in Internal Lists.\n");
      fprintf(stderr, "Please report this to repair@rpi.edu");
      exit(0);
   }
   
   pts_grp_name = &(pts_ptr->data[1]); 

   t_ptr = pts_ptr->next; 

   while( t_ptr && (t_ptr->type != TYPE1) ) { 
      if( (t_ptr->type == TYPE2) ) { 
	 t_host = t_ptr->data; 
	 if( pts_host_type_ok( t_ptr ) == TRUE ) { 
	    printf( "%s@%s: ", pts_grp_name, sudo_host ); 
	    t_ptr = t_ptr->next; 
	    if( t_ptr && (t_ptr->type == TYPE3) ) { 
	       print_cmnd_list( t_ptr ); 
	       printf("\n");
	       t_ptr = t_ptr->next; 
	    }
	 }
	 else { 
	    t_ptr = t_ptr->next; 
	    while( t_ptr && (t_ptr->type == TYPE3) ) t_ptr = t_ptr->next; 
	 }
      }
      else { 
	 t_ptr = t_ptr->next; 
      } 
   }
}




void print_unixgrp_list( unixgrp_ptr ) 
LINK unixgrp_ptr; 
{ 

   LINK t_ptr; 
   char *unixgrp_name, *t_host; 

   t_ptr = unixgrp_ptr; 

   if( (t_ptr->type != TYPE1) || ( t_ptr->data[0] != ':') ) { 
      fprintf(stderr, "Error in Internal Lists.\n");
      fprintf(stderr, "Please report this to repair@rpi.edu");
      exit(0);
   }
   
   unixgrp_name = &(unixgrp_ptr->data[1]); 

   t_ptr = unixgrp_ptr->next; 

   while( t_ptr && (t_ptr->type != TYPE1) ) { 
      if( (t_ptr->type == TYPE2) ) { 
	 t_host = t_ptr->data; 
	 if( pts_host_type_ok( t_ptr ) == TRUE ) { 
	    printf( "%s@%s: ", unixgrp_name, sudo_host ); 
	    t_ptr = t_ptr->next; 
	    if( t_ptr && (t_ptr->type == TYPE3) ) { 
	       print_cmnd_list( t_ptr ); 
	       printf("\n");
	       t_ptr = t_ptr->next; 
	    }
	 }
	 else { 
	    t_ptr = t_ptr->next; 
	    while( t_ptr && (t_ptr->type == TYPE3) ) t_ptr = t_ptr->next; 
	 }
      }
      else { 
	 t_ptr = t_ptr->next; 
      } 
   }
}





