c     FullMonte.f                       ver. 1.0  15JUN01  TKH
c	BASIC code complete			   3JUL01  TKH
c       Add build PDB code by JAL                  6JUL01  TKH
c	Add MATCHING to HA/HB shifts
c       compares both pairs.  	                  16JUL01  TKH
c	ADD MATCHING to old output tables.        18JUL01  TKH
c					          25JUL01  TKH
c	(2)HA shifts will force residue type=GLY  13AUG01  TKH
c       Fix HTML output with Nn & Nc missmatch    14Aug01  TKH
c	Fixed problem of reading pdb in DISTANCE  21Aug01  TKH
c	Fixed SCORE_J routine for Mac Linux       22Aug01  TKH
c	Add Postscript code from GSR		  23AUG01  TKH
c	Fix READ_PDB for different chain.	  26OCT01  TKH
c	Fixed bug with oldmatch			   7NOV01  TKH
c	Fixed bug with postscript output no NOEs   7NOV01  GSR
c       ADD Amide protons to pdb code (from JAL)  12NOV01  TKH
c	ADD Secondary structure calc (from JAL)   13NOV01  TKH
c       Option to use 2H corrected shifts         18Sep02  GSR
c       Licence key verification                  18Oct02  GSR
c       Fix  Residue_Type bug (else statement)    20Jan03  TKH
c       Fix License_check -err not enough char    20Jan03  TKH
c       Modify Corr.ps call (conditional SL>2)    20Jan03  TKH
c       Bug fix in residue type identification    24Mar03  GSR
c           Set arg to Guassian to a max of 10 to
c           avoid underflows in sum of probabilities
c       Error check of input cs data              24Mar03  GSR
c           Spin systems that don't match any amino acid are
c           listed in the log file.
c       SS input file was not being used to gen   10Apr03  GSR
c           pdb or NOE, changed order of call.
c       Fixed non 2010 compliant licence check    20Apr10  GSR
c
	Program FullMonte


	integer atmnum(500),rtype(500),len,verbose
	integer nres,npro,peak,peak_inp
	integer rtnum(20)
	integer index_rnum(500)
	integer sscode(500)
	integer dmap(500,500),hn_map(500,0:20)
	real ca_off,cb_off,co_off,cg_off,n_off
	real sig_a,sig_b,sig_o,sig_g,sig_n
	integer j_scale(10),oj_scale(8)
	integer csmatch_tot(10),csmatch_old(10),csmatch_new(10)  
	integer rt_scale,rtmo_scale,nsl_scale,csl_scale
	integer atomtable(20,20),oldtable(10,20)
	integer oldmatch(6,500,500)
	integer nstep,swap(20)
	real nsr(20)
	integer assn(500),s(500,20),npeaks
	integer old_s(500,20),old_assn(500),old_peaks,old_sft
	integer xtra_npeaks
	integer cs_olp(20,0:100)
	integer ocs_olp(20,0:100)
	integer iolp,ival,oldmax,oldlook(6)
	integer nsl_lkup(500,20),csl_lkup(500,20)
	Integer j_mat(20,3),nmatch
	integer prob_res(500,20,3),prob_resmo(500,20,3)
	integer start_sec,isec,time
	integer no_swap(500)
	integer peaknew(500),peakold(500),cng(500),ichange
	integer type1,type2
	integer nshift
	integer path_len
	integer ipdb,iss,i3dh,i3dn,i4d,iment

c  indexing variables
	integer H,NH,CA,COCA,CB,COCB,CACO,CO,CG,COCG
	integer HA1,HA2,COHA1,COHA2,HB1,HB2,COHB1,COHB2
	integer NHld,Hld,COld,CACOld
	integer CAld,COCAld,CBld,COCBld
	real hntol,ntol,cotol,catol,cbtol,cgtol,hatol,hbtol
	real o_hntol,o_ntol,o_catol,o_cbtol,o_cotol
	real tstart(20),tstep(20),tfin(20),nc_root(20),gamma(20)
	real temp
	integer co_r(0:20),ca_r(0:20),ha_r(0:20),cb_r(0:20),hb_r(0:20)
	real x(500),y(500),z(500)

	real cac(20),cas(20),cah(20),cbc(20),cbs(20),cbh(20)
	real cgs(20),cofc(20),cofs(20),cofh(20)
	real nfc(20),nfs(20),nfh(20)
        Integer deut_cs

	real index_x(500),index_y(500),index_z(500)
	real pin(500)
	real tprob(20,3),sum
	real dcut
	real ohntol,ontol,ocotol,ocatol,ocbtol
	real ohatol,ohbtol,ocgtol
	character*1 one(20)
	character*2 fnum(0:50)
	character*3 rname(500),three(20),ext3
	character*5 colhead(20)
	character*7 ext7
	character*60 filename,tfile
	character*100 path,parfile,ofile,logfile
	logical HAmatch,HAswap,HBmatch,HBswap
	integer h_score


ccccccc  Simulated Annealing Defines

	Integer peak_array(50,500),e_max(50),min_e,idx_e
	Integer max_swap,ipeak(20)
	Integer swap_num
	Integer peakmax(500)
	integer ncycle,nrej
	integer j_tot(10),j_old(10),j_new(10)
	integer o_score(10),n_score(10)
	integer blk1_s,blk1_e,blk2_s,blk2_e
	integer pen_tot,emax
	real noe_scale
	integer del_pen,new_tot,old_tot
	integer rt_old,rtmo_old,rt_new,rtmo_new
	integer rt_tot,rtmo_tot,rt_score,rtmo_score
	integer c13_old,c13_new,n15_old,n15_new,c13_tot,n15_tot
	integer dist_tot,dist_new,dist_old
	integer ijunk_tot(10)
	integer hn_noe(500,0:10,2),hn_noelk(500,500)
	logical hnnoe(500),lflag
	logical pdb ,ssfile,noe3dh,noe3dn,noe4d
	logical ps_out,html_out
	integer insl,icsl 
	logical nslfile,cslfile 
	logical old,t_logic
	logical HA12,COHA12,gly,glymo
	integer row,col,len_ps
	logical noe_ps
	Integer peak_stat(50,500),score_stat(50),num_stat,SL
	integer top_score
	real r_NH,r_CH,r_OH
	integer iserno
c  maximum number of atoms - 5000
	real xx(3,500), yy(3,500), zz(3,500)

c License defines
	logical lfile
	character*12 lkey

c   Parameter file common
	Common /atom/ atomtable
	Common /offset/ ca_off,cb_off,co_off,cg_off,n_off
	Common /sig/ sig_a,sig_b,sig_o,sig_g,sig_n
	Common /weight1/ j_scale
	Common /weight2/ rt_scale,rtmo_scale,nsl_scale,csl_scale
	Common /tolerence/ hntol,ntol,catol,cbtol,cotol,hatol,hbtol,cgtol
	Common /parflags/ ipdb,iss,i3dh,i3dn,i4d,iment,insl,icsl,ips,ihtm
	Common /matchold/ ofile,oldtable
	Common /oweight/ oj_scale
	Common /o_tolerence/ ohntol,ontol,ocotol,ocatol,ocbtol
	Common /o_weight/ ohn_scale,on_scale,oco_scale,oca_scale
     +				,ocb_scale,ohb_scale,ocg_scale
	Common /anneal/tstart,tstep,nstep,tfin,nc_root,gamma,swap,nsr
	Common /repel/ co_r,ca_r,ha_r,cb_r,hb_r
	Common /hn_noe/ hn_noe
	Common /hn_noelk/ hn_noelk,hnnoe

	Common /shift_look/ cs_olp
	Common /oshift_look/ ocs_olp

	Common /jcoup/ pin,assn,peak_inp
	Common /jcoups/ s
	Common /aa/ rtnum,one,three
	Common /bmrb/ cac,cas,cah,cbc,cbs,cbh,cgs,cofc,cofs,cofh
	Common /bmrb1/ nfc,nfs,nfh,deut_cs
	Common /pdb/ atmnum, rname, rtype, x, y, z
	Common /pdb2/ index_rnum,index_x,index_y,index_z
	Common /dist/ dmap,hn_map
	Common /ss/ sscode
	Common /match/ j_mat,nmatch
	Common /prob_res/ prob_res,prob_resmo
	Common /noswap/ no_swap
	Common /e_max/ peak_array,e_max
	Common /header/ colhead
	Common /dcut/ dcut
	Common /path/ path,path_len
	Common /old_J/ old_s,old_assn
	common /postscript/ len_ps,noe_ps,scale_ps
	Common /statistics/ peak_stat,score_stat,num_stat,SL
	Common /extension/ fnum


c
c   For add NH routine
c
	common /block1/ iserno
	common /bond_len/ r_NH, r_CH, r_OH

c
c  for calc sec structure
c
	common /coords /xx, yy, zz

	DATA H,NH,CACO,CO,CA,COCA,CB,COCB,CG,COCG,Nn,Nc /12*0/
	DATA HA1,HA2,COHA1,COHA2,HB1,HB2,COHB1,COHB2 /8*0/
	DATA NHld,Hld,COld,CACOld /4*0/
	DATA CAld,COCAld,CBld,COCBld /4*0/
	verbose=1

	ssfile=.false.
	nslfile=.false.
	cslfile=.false.
	pdb=.false.
	old=.false.
	noe3dh=.false.
	noe3dn=.false.
	noe4d=.false.
	noe_ps=.false.

	WRITE(6,*)
	WRITE(6,*)
	WRITE(6,*) 'FM v2.03'
	WRITE(6,*) 'Automated NMR assignments'
	WRITE(6,*)
	WRITE(6,*) 'Copyright ',char(169),' 2003'
	WRITE(6,*) 'Carnegie Mellon University'
	Write(6,*) '   T.Kevin Hitchens'
	WRITE(6,*) '   Jonathan A. Lukin'
	WRITE(6,*) '   Yiping Zhan      '
	Write(6,*) '   Gordon S. Rule  '
	WRITE(6,*)	
cccccccccccccccccccccccccccccccccccccccccccc
c
c       License Key Verification
c       Check for presence of license file
c       Contents of file are a 12 character string
c       that is decoded in the subrountine License_Check
c
cccccccccccccccccccccccccccccccccccccccccccc
	inquire (file='monte.license',exist=lfile)
	if(lfile)then
		   open(unit=10,file='monte.license',status='old')
		   read(10,'(a12)')lkey
		   close(10)
                   call License_Check(lkey)
	   else
	      write(6,*)'Sorry, the license file was not found.'
	      write(6,*)'Please contact rule@andrew.cmu.edu'
	      stop
	   endif
cccccccccccccccccccccccccccccccccccccccccccc
c
c	Begin Main
c
cccccccccccccccccccccccccccccccccccccccccccc
c	WRITE(6,'(a15$)') 'Parameter file:'
c   	READ(5,100) parfile
c100	format(a100:)

	call getarg (1,parfile)
	if (iargc ().eq.0) then
	write(6,*) 'ERROR'
	write(6,*) 'Insufficient arguments'
	write(6,*) 'Usage: fm.exe [local path/parfile]'
	write(6,*)
	stop
	endif

c
c  Get inital starting time
c

	start_sec=time()


	Call INIT
	Call READ_PARAM(parfile,filename,len,verbose,deut_cs)
	Call MAKE_DIRECTORY(path,path_len)
c
c
c    open log file
c
c
	logfile= path(1:path_len)//filename(1:len)//'.log'
	open(unit=15,file=logfile,status='unknown')



	if (ipdb.gt.0) pdb=.true.
	if (iss.gt.0) ssfile=.true.
	if (i3dh.gt.0) noe3dh=.true.
	if (i3dn.gt.0) noe3dn=.true.
	if (i4d.gt.0) noe4d=.true.
	if (iment.gt.0) old=.true.
	if (insl.gt.0) nslfile=.true.
	if (icsl.gt.0) cslfile=.true.
	if (ips.gt.0) ps_out=.true.
	if (ihtm.gt.0) html_out=.true.

	Call READ_BMRB(verbose)

	if(ssfile) 
     +	Call SEC_STRUCTURE(filename,len,nres,verbose)

	
	if (pdb) then
		write(6,'(a30)')' Adding Amide Protons...      '
		Call ADD_AMIDE(filename,len)
		tfile='temp'
		Call READ_PDB(tfile,4,nres,verbose)
		Call DISTANCE(tfile,4,nres,verbose)
	
	else
		Call READ_SEQUENCE(filename,len,nres,verbose)
		write(6,'(a30)')' Building Peptide Sequence... '
		Call BUILD_PEPTIDE(nres)
		tfile='temp'
		Call READ_PDB(tfile,4,nres,verbose)
		Call DISTANCE(tfile,4,nres,verbose)
	endif


	if ((.not.ssfile).and.(pdb))
     +  Call CALC_SEC_STRUCTURE(nres)

	t_logic=.false.
	Call READ_CS(filename,len,npeaks,nshift,t_logic,verbose)
c    	write(6,*)'nshift', nshift,'npeaks',npeaks,'nres',nres

cccccccc
c
c	determine where particular atom types are in the shift matrix.
c		this is defined by the user in the .par file
c
cccccccc


c	do 30 i=1,18
c30	write(6,121) (atomtable(i,j),j=1,20)
121 	FOrmat(20i3)

c
c  zero header for output
c
	do i=1,20
		colhead(i)='    '
	enddo

c
c
c

		do i=1,20
		if (atomtable(1,i).ne.0) then 
				NH=i
				colhead(i)=' N   '
				endif
		if (atomtable(2,i).ne.0) then
				H=i
				colhead(i)=' H   '
				endif
		if (atomtable(3,i).ne.0) then
				CACO=i
				colhead(i)='CaCO '
				endif
		if (atomtable(4,i).ne.0) then
				CO=i
				colhead(i)='CO   ' 
				endif
		if (atomtable(5,i).ne.0) then
				CA=i
				colhead(i)='Ca   '
				endif
		if (atomtable(6,i).ne.0) then
				COCA=i
				colhead(i)='Ca(-)'
				endif
		if (atomtable(7,i).ne.0) then
				HA1=i
				colhead(i)='Ha   '
				endif
		if (atomtable(8,i).ne.0) then
				HA2=i
				colhead(i)='Ha   '
				endif
		if (atomtable(9,i).ne.0) then 
				COHA1=i
				colhead(i)='Ha(-)'
				endif
		if (atomtable(10,i).ne.0) then 
				COHA2=i
				colhead(i)='Ha(-)'
				endif
		if (atomtable(11,i).ne.0) then
				CB=i
				colhead(i)='Cb   '
				endif
		if (atomtable(12,i).ne.0) then
				COCB=i
				colhead(i)='Cb(-)'
				endif
		if (atomtable(13,i).ne.0) then
				HB1=i
				colhead(i)='Hb   '
				endif
		if (atomtable(14,i).ne.0) then
				HB2=i
				colhead(i)='Hb   '
				endif
		if (atomtable(15,i).ne.0) then
				COHB1=i
				colhead(i)='Hb(-)'
				endif
		if (atomtable(16,i).ne.0) then
				COHB2=i
				colhead(i)='Hb(-)'
				endif
		if (atomtable(17,i).ne.0) then
				CG=i
				colhead(i)='Cg   '
				endif
		if (atomtable(18,i).ne.0) then
				COCG=i
				colhead(i)='Cg(-)'
				endif
		if (atomtable(19,i).ne.0) then
				Nn=i
				colhead(i)='Nn   '
				endif
		if (atomtable(20,i).ne.0) then 
				Nc=i
				colhead(i)='Nc   '
				endif
		enddo




ccc
c	build matching matrix
c		j_mat(nmatch,3) (inter index, intra index, pair type)
c				match (i)   to   (i-1) , type
c		nmatch = number of rows in matrix	
c	CO=1,CA=2,HA=3,CB=4,HB=5,CG=6,NNn=7,NNc=8,HH=9
ccc	

	HAmatch=.false.
	HAswap=.false.
	HBmatch=.false.
	HBswap=.false.

		nmatch=0
		if ((CACO.ne.0).and.(CO.ne.0)) Call PUT(CO,CACO,1)
		if ((CA.ne.0).and.(COCA.ne.0)) Call PUT(COCA,CA,2)
		if ((CB.ne.0).and.(COCB.ne.0)) Call PUT(COCB,CB,4)
		if ((CG.ne.0).and.(COCG.ne.0)) Call PUT(COCG,CG,6)
		if ((NH.ne.0).and.(Nn.ne.0)) Call PUT(Nn,NH,7)
		if ((NH.ne.0).and.(Nc.ne.0)) Call PUT(NH,Nc,8) 

		if ((HA1.ne.0).and.(COHA1.ne.0)) then
			HAmatch=.true.
			Call PUT(COHA1,HA1,3)
		if ((HA2.ne.0).and.(COHA2.ne.0)) then
			HAswap=.true.
			Call PUT(COHA2,HA2,3)	
		endif
		endif

		if ((HB1.ne.0).and.(COHB1.ne.0)) then
			HBmatch=.true.
			Call PUT(COHB1,HB1,5)
		if ((HB2.ne.0).and.(COHB2.ne.0)) then
c
c  if both HB shifts are present, allow for swaping
c  COHB1 and COHB2 for highest matching score
c

			HBswap=.true.
			Call PUT(COHB2,HB2,5)
		endif
		endif

	if ((.not.HBswap).and.(HBmatch)) then
	write(6,*) 'Hb matching turned OFF...'
	Write(6,*) '....must define Hb2 and COHb2 in chemical shift table'
	nmatch = nmatch-1
	HBmatch=.false.
	endif

c
c  if both of these conditions are true then we will
c  loop through these conditions separatly in chemical
c  shift scoring...remove from nmatch
c
	if ((HBswap).and.(HBmatch)) nmatch=nmatch-2

c
c  if only 1 HA pair of shifts is defined, then 
c  match in normal loop.
c
	if ((.not.HAswap).and.(HAmatch)) then
	write(6,*) 'Only matching single Ha shift'
	HAmatch=.false.
	endif

c
c  if both conditions are true, then need to score
c  separatly - swapping COHA1 and COHA2 shifts if 
c  more than one.
c

	if ((HAswap).and.(HAmatch)) nmatch=nmatch-2

	
c		write(6,*)  'inter intra  type'
c	do i=1,nmatch
c		write(6,*) (j_mat(i,j),j=1,3)
c	enddo

c	GENERATE cs_olp(1..10)
c	Do not use repulsive terms here!

	Call OVERLAP_TABLES(0,verbose)

	if (noe3dh) then
	ext7='3dh_noe'
      	Call READ_3D_NOE(filename,len,NH,H,H,ext7,verbose)

		if (noe3dn) then
		ext7='3dn_noe'
      		Call READ_3D_NOE(filename,len,NH,H,NH,ext7,verbose)
		endif

	Call GEN_NOE_3DLOOK(H,NH,noe3dn,verbose)
	endif

	if (noe4d) then
     	Call READ_4D_NOE(filename,len,verbose)
	Call GEN_NOE_LOOKUP(H,NH,verbose)
	endif

cccccccc	
c	For matching n-15 or n-15/1C-13 specific labeling
cccccccc

	do i=1,500
		do j=1,20
		nsl_lkup(i,j)=0
		csl_lkup(i,j)=0
		enddo
	enddo

	ext3='nsl'
	if(nslfile) 
     +	Call SLAB_LOOKUP(filename,len,verbose,nsl_lkup,H,NH,ext3)
	ext3='csl'
	if(cslfile) 
     +	Call SLAB_LOOKUP(filename,len,verbose,csl_lkup,H,NH,ext3)

c
c	Build Residue Type lookup tables
c
c
	HA12=.false.
	COHA12=.false.
	gly=.false.

	if((HA1.gt.0).and.(HA2.gt.0)) HA12=.true.
	if((COHA1.gt.0).and.(COHA2.gt.0)) COHA12=.true.

	write(15,*)'Checking intra-residue shifts'
	write(6,*)'Checking intra-residue shifts'

	do peak = 1, npeaks

	if(HA12) then
	gly=.false.
	if ((s(peak,HA1).gt.0).and.(s(peak,HA2).gt.0)) gly=.true.
	endif


	if (gly) then
		do j=1,3
		do i=1,20
		prob_res(peak,i,j)=0
		enddo
		prob_res(peak,7,j)=100
		enddo
		
	else

c	This call returns tprob(i,j) for each peak.
c             i=1,20 residue type
c             j=1,2,3 secondary structure
c                             
	Call RESIDUE_TYPE(peak,CACO,CA,CB,CG,NH,tprob)
c
c
	do j=1,3
		sum=0
c can't be PRO
		tprob(20,j)=0.0
		do 50 i=1,19
50		sum=sum+tprob(i,j)
c		write(6,*)peak,pin(peak),j,sum
		do 60 i=1,20
60		Call ROUND( (100.*(tprob(i,j)/sum)) ,prob_res(peak,i,j) )
	enddo	

	endif

	enddo
c	[end of loop over all peaks]

	write(15,*)'Checking inter-residue shifts'
	write(6,*)'Checking inter-residue shifts'

	gly=.false.

	do peak=1,npeaks

	if(COHA12) then
	gly=.false.
	if ((s(peak,COHA1).gt.0).and.(s(peak,COHA2).gt.0)) gly=.true.
	endif


	if (gly) then
		do j=1,3
		do i=1,20
		prob_resmo(peak,i,j)=0
		enddo
		prob_resmo(peak,7,j)=100
		enddo
		
	else



	
c
c  for the (i-1) residue, send 0 for nitrogen shift index
c
	Call RESIDUE_TYPE(peak,CO,COCA,COCB,COCG,0,tprob)

	do j=1,3
	sum=0
 	do 70 i=1,20
70		sum=sum+tprob(i,j)
c		write(6,*)peak,pin(peak),j,sum
		do 80 i=1,20
80		Call ROUND( (100.*(tprob(i,j)/sum)) ,prob_resmo(peak,i,j) )	
	enddo

	endif

 	enddo
c	[end of loop over all peaks]

cccccc
c	write probability tables, if desired
cccccc
 	if (verbose.ge.2) then
	write(15,*)  'probabilities for Residue (i): [random coil]'
	Write(15,1301) 'PIN ',(three(j),j=1,20)
	do i=1,peak_inp
	write(15,1300) pin(i),(prob_res(i,j,1),j=1,20)
	enddo
	endif
1300	format (f5.1,2x,20i4)
1301 	format (1x,a4,3x,20a4)
	 	
	if (verbose.ge.2) then
	write(15,*)  'probabilities for Residue (i-1): [random coil]'
	Write(15,1301) 'PIN ',(three(j),j=1,20)
	do i=1,peak_inp
	write(15,1300) pin(i), (prob_resmo(i,j,1),j=1,20)
	enddo
	endif
c::::::

	if (verbose.ge.2) then
	write(15,*) 'PDB coordinates                       sscode 1=c,2=s,3=h '
	do i=1,nres
110     format(a6,i5,1x,a4,a1,a3,1x,a1,i4,4x,f8.3,f8.3,f8.3)	
        write(15,120) i,rname(i),x(i),y(i),z(i),sscode(i)
120	format(i3,2x,a3,3x,3f9.2,2x,i2)
	enddo
	endif



	if(old) then

c       oj_scale 1=CO  2=CA  3=CB
c	fix oj_scale CO=1,2  CA=3,4  CB=5,6
		oj_scale(6)=oj_scale(3)
		oj_scale(5)=oj_scale(3)
		oj_scale(4)=oj_scale(2)
		oj_scale(3)=oj_scale(2)
		oj_scale(2)=oj_scale(1)

c
		Call EXTRACT_OLD(NHld,Hld,COld,CACOld,CAld,COCAld,CBld,COCBld)
		Call READ_OLD(old_peaks,old_sft,old,verbose)
c	write(6,*)NHld,Hld,COld,CACOld,CAld,COCAld,CBld,COCBld
c
c   check how many to look up.
c       loop i 1 to oldmax to index oldlook(i)
c

	oldmax=0
	if ((CO.ne.0).and.(COld.ne.0)) 	then
		oldmax=oldmax+1
		oldlook(oldmax)=1
					endif
	if ((CACO.ne.0).and.(CACOld.ne.0))	then
		oldmax=oldmax+1
		oldlook(oldmax)=2
					endif
	if ((COCA.ne.0).and.(COCAld.ne.0))	then
		oldmax=oldmax+1
		oldlook(oldmax)=3
					endif
	if ((CA.ne.0).and.(CAld.ne.0)) 	then
		oldmax=oldmax+1
		oldlook(oldmax)=4
					endif
	if ((COCB.ne.0).and.(COCBld.ne.0))	then
		oldmax=oldmax+1
		oldlook(oldmax)=5
					endif
	if ((CB.ne.0).and.(CBld.ne.0)) 	then
		oldmax=oldmax+1
		oldlook(oldmax)=6
					endif


c	write(6,*) 
c	do i=1,oldmax
c	write(6,*) i,oldlook(i)
c	enddo

c	write(6,*)'peaks', old_peaks,peak_inp,npeaks

	do 131 i=1,old_peaks
		if ((old_s(i,Hld).le.0).or.(old_s(i,NHld).le.0))  goto 131

		do 130 j=1,peak_inp
c	write(6,*) i,j,s(jlp,H),s(jlp,NH)

		if ((s(j,H).le.0).or.(s(j,NH).le.0)) goto 130
c	write(6,*) i,j,s(jlp,H),s(j,NH),s(j,CO),'CO',CO,COld

c
c  ocs_olp
c    1=CO, 2=CA, 3=CB, 4=N, 5=H
c
c  oldmatch
c    1=CO, 2=CACO, 3=COCA, 4=CA, 5=COCB, 6=CB
c


		iolp=1
	if ( (CO.ne.0).or.(COld.ne.0)) then
     		Call BLK_OLD_LOOK (i,j,iolp,NH,H,CO,NHld,Hld,COld,ival)
			oldmatch(1,i,j)=ival
	endif
	if ( (CACO.ne.0).or.(CACOld.ne.0)) then
 		Call BLK_OLD_LOOK (i,j,iolp,NH,H,CACO,NHld,Hld,CACOld,ival)
			oldmatch(2,i,j)=ival
	endif
		iolp=2
	if ( (COCA.ne.0).or.(COCAld.ne.0)) then
     		Call BLK_OLD_LOOK (i,j,iolp,NH,H,COCA,NHld,Hld,COCAld,ival)
			oldmatch(3,i,j)=ival
	endif
	if ( (CA.ne.0).or.(CAld.ne.0)) then
     		Call BLK_OLD_LOOK (i,j,iolp,NH,H,CA,NHld,Hld,CAld,ival)
			oldmatch(4,i,j)=ival
	endif
		iolp=3
	if ( (COCB.ne.0).or.(COCBld.ne.0)) then
     		Call BLK_OLD_LOOK (i,j,iolp,NH,H,COCB,NHld,Hld,COCBld,ival)
			oldmatch(5,i,j)=ival
	endif
	if ( (CB.ne.0).or.(CBld.ne.0)) then
     		Call BLK_OLD_LOOK (i,j,iolp,NH,H,CB,NHld,Hld,CBld,ival)
			oldmatch(6,i,j)=ival
	endif
130			continue
c [endloop over newpeaks]

c	write(6,*) 'old peak',i
c	do l37=1,oldmax
c	write(6,*)l37,oldlook(l37)
c	write(6,'(40i3:)')(oldmatch(oldlook(l37),i,j),j=1,npeaks)
c	enddo

131			continue
c [endloop over oldpeaks]
			
		
		
	endif
c [end 'old' .true.]


c	do i=1,npeaks
c	write(6,*) pin(i),s(i,NH),s(i,H)	
c	enddo

	Call CHECK_CS(nres,npeaks,npro)
c   	write(6,*)'nshift', nshift,'npeaks',npeaks,'nres',nres

c	do i=1,npeaks
c	write(6,*) pin(i),s(i,NH),s(i,H)	
c	enddo


c
c
c  SUPER CYCLE BEGINS HERE!
c
c
	do 3000 SL = 1, num_stat

	Write(6,'(a18,i2,a1,i2)')'  ANNEALING CYCLE ',SL,'/',num_stat
c	write(6,*)




cccccccccccccccccccccccc
c	RANDOM SEED 
cccccccccccccccccccccccc
	isec= time()
        magn= int(log10(1.*isec))
        iscale= 10**(magn-4)
        iseed= abs(iscale*int(1.*isec/iscale)-isec)

c	write(6,*) 
	write(6,'(a29)') ' Making random assignments...'
	Call RANDOM_ASSIGNMENT(npeaks,nres,npro,peakold,iseed)
	do i=1,npeaks
		peaknew(i)=peakold(i)
c	write(6,*) pin(i),s(i,NH),s(i,H),peakold(i)
		peakmax(i)=peakold(i)
		enddo

c Not going to swap PRO residues
c  nres to npeaks rtype set to 0
	no_swap(1)=1
	do i=2,npeaks
	no_swap(i)=0
	if(rtype(i).eq.20) no_swap(i)=1
	enddo

	do i=1,npeaks
c	write(6,*) i,no_swap(i)
	enddo

	itmp=0
	ncycle=0
	nrej=0

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc	
c	generate outfile name extensions                          c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	do i=0,5
	do j=0,9
	idx=i*10+j
	if(idx.le.51)fnum(idx)=char(i+48)//char(j+48)
	enddo
	enddo

	Write(6,'(a30:)') 'Start Monte Carlo/SA'
	CALL WRITE_OUTPUT(itmp,filename,len,nres,npeaks,nshift,peakmax)

c	peak_inp - contains the origonal number of peaks
c	Common
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c		SIMULATED ANNEALING PARAMETERS                    c
c	tstart:       starting temp                               c
c	tstep:        temperature step                            c
c	tfin:         final temp                                  c
c	nc_root: starting number of cycles                        c
c       gamma:        rate to increase number of cycles           c
c       swap:         max number of swaps                         c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

CCCCCCCCCCCCCCCCCCCCCCCCCCCWorking HereCCCCCCCCCCCCCCCCCCCCCCCCCC
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                                              			c
c	SIMULATED ANNEAL                           	        c
c                                                       	c
c	MAJOR LOOP IS KLP                                       c
c                                                               c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
	do 2001 klp=1,nstep
	ncyclim=nc_root(klp)
c
c	build lookup tables for chemical shift matching
c	again for each look (include repulsive term) (klp)
c
	Call OVERLAP_TABLES(klp,verbose)


c
c	reset energies and such
c
	noe_scale=nsr(klp)
	do l=1,20
	e_max(l)=0
	enddo
	pen_tot=0
	emax=0
	do i=1,npeaks
		do j=1,20
		peak_array(j,i)=0
		enddo
	enddo

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	First DETERMINE SCORE for all residues
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccc   J-Coupling  ccccccccccccccccc
	
	rt_tot=0
	rtmo_tot=0
	n15_tot=0
	c13_tot=0
	dist_tot=0

	do i=1,10
	j_tot(i)=0
	csmatch_tot(i)=0
	o_score(i)=0
	n_score(i)=0
	enddo

	

c
c  Calculate scores for ALL residues
c
	do k=2,nres
c
c  Calculate J-matching score
c
	Call SCORE_J(peakold(k),peakold(k-1),o_score)
	do i=1,10
	j_tot(i)=j_tot(i)+(j_scale(i)*o_score(i))
	enddo


	if (HAmatch) then

c
c  HA is index 3 for matching and scaling
c
			itype=3
		Call SCORE_H_PAIR(peakold(k),peakold(k-1),
     +	                    HA1,HA2,COHA1,COHA2,itype,h_score)
	j_tot(3)=j_tot(3)+h_score*j_scale(3)

	endif


	if (HBmatch) then 
c
c  HB is index 5 for matching and scaling
c
			itype=5
       		Call SCORE_H_PAIR(peakold(k),peakold(k-1),
     +	                    HB1,HB2,COHB1,COHB2,itype,h_score)	
	j_tot(5)=j_tot(5)+h_score*j_scale(5)
	endif


c
c  Calculate AA type score
c        
	Call SCORE_AATYPE (k,peakold(k),rtype(k),rtype(k-1),rt_score,rtmo_score)
	rt_tot=rt_tot+(rt_scale*rt_score)
	rtmo_tot=rtmo_tot+(rtmo_scale*rtmo_score)
c
c  Calculate specfic label score
c
	n15_tot=n15_tot+nsl_scale*nsl_lkup(peakold(k),rtype(k))
	c13_tot=c13_tot+csl_scale*csl_lkup(peakold(k),rtype(k-1))

c
c  Calculate NOE score
c
	if (noe_scale.gt.0) then
		if (hn_map(k,0).gt.0) then
c 	WRITE(6,*) k,hn_map(k,0)
c	write(6,*) (hn_map(k,m),m=1,hn_map(k,0))
c 	write(6,*) (hn_noelk(peakold(k),peakold(hn_map(k,l))),l=1,hn_map(k,0))
		do l=1,hn_map(k,0)

		dist_tot=dist_tot+hn_noelk(peakold(k),peakold(hn_map(k,l)))
		enddo
		endif
	endif
c 	write(6,*) 'dist_tot',dist_tot

c
c  Calculate Matching old shifts score
c
c k is residue number
c
	if (old) then
	    do i=1,old_peaks
		if(old_assn(i).eq.k) then
		do l=1,oldmax
	    csmatch_tot(oldlook(l))=csmatch_tot(oldlook(l))+  (
     +	          oldmatch(oldlook(l),i,peakold(k))*oj_scale(oldlook(l)))
		enddo
		endif
	    enddo
	endif

c
c  enddo for k=1,nres
c
	enddo

ccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccccc  Calculate pen_tot
	pen_tot=0
	do i=1,10
	pen_tot=pen_tot+j_tot(i)
	if(old) pen_tot=pen_tot+csmatch_tot(i)
	enddo


	dist_tot=int(dist_tot*noe_scale)

	pen_tot=pen_tot+rt_tot+rtmo_tot+c13_tot+n15_tot+dist_tot

c	WRITE(6,*)'pen_tot',pen_tot
ccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	max_swap=0
	temp=tstart(klp)+tstep(klp)

1009	temp=temp-tstep(klp)
	ncyclim=nc_root(klp)*exp( log(gamma(klp))* ( (tstart(klp)-temp) / (tstart(klp)-tfin(klp))) )


	idx=6
c	Call WRITE_TIME(idx,seed)

	Call WRITE_SCORE(6,klp,temp,ncycle,nrej,emax,max_swap,
     +         noe_scale,j_tot,rt_tot,rtmo_tot,n15_tot,c13_tot,
     +         dist_tot,pen_tot,csmatch_tot,old)


	if (verbose.ge.1) 
     +	Call WRITE_SCORE(15,klp,temp,ncycle,nrej,emax,max_swap,
     +         noe_scale,j_tot,rt_tot,rtmo_tot,n15_tot,c13_tot,
     +         dist_tot,pen_tot,csmatch_tot,old)
	
	ncycle=0
	nrej=0
	if(temp .le. tfin(klp))goto 2000

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cc									cc
cc		     MONTE CARLO BEGINS HERE	         		cc
cc									cc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	Switch residues
c
150		ncycle=ncycle+1

		if(ncycle .gt. ncyclim)goto 1009

		if (swap(klp).gt.1) then
	Call PICK_NSWAP(swap_num,swap(klp),tstart(klp),temp,tfin(klp),iseed)
		else 
		swap_num=1
		endif

	if (swap_num.gt.max_swap) max_swap=swap_num
	Call PICK_SWAP(swap_num,nres,npeaks,blk1_s,blk2_s,iseed)

	blk1_e=blk1_s+swap_num-1
	blk2_e=blk2_s+swap_num-1


	do i=1,swap_num
		ipeak(i)=peaknew(blk1_s+i-1)
		enddo

	if ( (blk1_e).ge.blk2_s) then
cccccccccccccccccccccccccccccccccccccccccccccccc
c		overlap in range -shuffle
cccccccccccccccccccccccccccccccccccccccccccccccc
			do i=1, (blk2_s-blk1_s)
			peaknew(blk1_s+i-1)=peaknew(blk1_s+swap_num+i-1)
			enddo
		do i=1,swap_num
		peaknew(blk2_s+i-1)=ipeak(i)
		enddo 
	else
ccccccccccccccccccccccccccccccccccccccccccccccccccc
c		No overlap
ccccccccccccccccccccccccccccccccccccccccccccccccccc
	do i=1,swap_num
		peaknew(blk1_s+i-1)=peaknew(blk2_s+i-1)
		peaknew(blk2_s+i-1)=ipeak(i)
		enddo
	endif

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c		DETERMINE SCORE DIFFERENCE
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	ichange=0
	dist_old=0
	dist_new=0
	rt_old=0
	rtmo_old=0
	rt_new=0
	rtmo_new=0
	c13_old=0
	n15_old=0
	c13_new=0
	n15_new=0
	old_tot=0
	new_tot=0

	do i=1,10
	j_old(i)=0
	j_new(i)=0
	csmatch_old(i)=0
	csmatch_new(i)=0
	ijunk_tot(i)=0
	enddo



c	WRITE(6,*)'===================='
c	WRITE(6,*) 'START  swap',blk1_s,blk2_s,swap_num

c
c  Calculate scores for changed residues
c
	itemp=blk2_e+1
	if (itemp.gt.nres) itemp=nres 
	do k=blk1_s,itemp


	if(( (peaknew(k)) .ne. (peakold(k)) ).or. 
     +	   ( (peaknew(k-1)) .ne. (peakold(k-1)) )) then


c
c  Calculate J-matching score
c
	Call SCORE_J(peakold(k),peakold(k-1),o_score)
	Call SCORE_J(peaknew(k),peaknew(k-1),n_score)

	do i=1,10
	j_old(i)=j_old(i)+(j_scale(i)*o_score(i))
	j_new(i)=j_new(i)+(j_scale(i)*n_score(i))
	enddo


c
c  Calculate difference in HA,HB if necessary...
c

	if (HAmatch) then

c
c  HB is index 3 for matching and scaling
c
			itype=3
		Call SCORE_H_PAIR(peakold(k),peakold(k-1),
     +	                    HA1,HA2,COHA1,COHA2,itype,h_score)
	j_old(3)=j_old(3)+h_score*j_scale(3)

		Call SCORE_H_PAIR(peaknew(k),peaknew(k-1),
     +	                    HA1,HA2,COHA1,COHA2,itype,h_score)
	J_new(3)=j_new(3)+h_score*j_scale(3)

	endif


	if (HBmatch) then 
c
c  HB is index 5 for matching and scaling
c
			itype=5
       		Call SCORE_H_PAIR(peakold(k),peakold(k-1),
     +	                    HB1,HB2,COHB1,COHB2,itype,h_score)	
	j_old(5)=j_old(5)+h_score*j_scale(5)

       		Call SCORE_H_PAIR(peaknew(k),peaknew(k-1),
     +	                    HB1,HB2,COHB1,COHB2,itype,h_score)	
	j_new(5)=j_new(5)+h_score*j_scale(5)

	endif


c
c  for J-match if...
c
	endif

	if (peaknew(k) .ne. peakold(k)) then 
c
c  Calculate NOE,RT(i),RT(i-1),specfic label
c  Start with NOE
c
	if (noe_scale.gt.0) then
		
c
c  add score for changed residue out to others
c  and back - only if not calculated before
	do l=1,hn_map(k,0)
		lflag=.true.
		do m=1,ichange
		if (hn_map(k,l).eq.cng(m)) lflag=.false.
		enddo
	if (lflag) then			
	dist_old=dist_old+hn_noelk(peakold(k),peakold(hn_map(k,l)))
	dist_old=dist_old+hn_noelk(peakold(hn_map(k,l)),peakold(k))

	dist_new=dist_new+hn_noelk(peaknew(k),peaknew(hn_map(k,l)))
	dist_new=dist_new+hn_noelk(peaknew(hn_map(k,l)),peaknew(k))
	endif
		enddo
		ichange=ichange+1
		cng(ichange)=k

	endif
	

c
c  Calculate AA type score
c
	Call SCORE_AATYPE (k,peakold(k),rtype(k),rtype(k-1),rt_score,rtmo_score)
	rt_old=rt_old+(rt_scale*rt_score)
	rtmo_old=rtmo_old+(rtmo_scale*rtmo_score)

	Call SCORE_AATYPE (k,peaknew(k),rtype(k),rtype(k-1),rt_score,rtmo_score)

c	write(6,*) k, peaknew(k),rt_score,rtmo_score,rt_scale

	rt_new=rt_new+(rt_scale*rt_score)
	rtmo_new=rtmo_new+(rtmo_scale*rtmo_score)
c
c  Calculate specfic label score
c
	n15_old=n15_old+nsl_scale*nsl_lkup(peakold(k),rtype(k))
	n15_new=n15_new+nsl_scale*nsl_lkup(peaknew(k),rtype(k))

	c13_old=c13_old+csl_scale*csl_lkup(peakold(k),rtype(k-1))
	c13_new=c13_new+csl_scale*csl_lkup(peaknew(k),rtype(k-1))

c
c  Calculate old matching score
c
	if (old) then
	    do i=1,old_peaks
		if(old_assn(i).eq.k) then
		do l=1,oldmax
	    csmatch_old(oldlook(l))=csmatch_old(oldlook(l))+  (
     +	          oldmatch(oldlook(l),i,peakold(k))*oj_scale(oldlook(l)))

	    csmatch_new(oldlook(l))=csmatch_new(oldlook(l))+  (
     +	          oldmatch(oldlook(l),i,peaknew(k))*oj_scale(oldlook(l)))
		enddo
		endif
	    enddo
	endif


	endif
	enddo

c
c  Sum j scores
c
	do i=1,10
	old_tot=old_tot + j_old(i)+csmatch_old(i)
	new_tot=new_tot + j_new(i)+csmatch_new(i)
	enddo



	dist_old=int(dist_old*noe_scale)
	dist_new=int(dist_new*noe_scale)
c
c  Sum other scores
c
	old_tot=old_tot+rt_old+rtmo_old+n15_old+c13_old+dist_old
	new_tot=new_tot+rt_new+rtmo_new+n15_new+c13_new+dist_new


c	write(6,*) blk1_s,blk2_s,swap_num


cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c		END Energy calculations
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 	del_pen=new_tot - old_tot

c  	WRITE(6,*) 'del_pen   new_tot  old_tot   pen_tot'
c	WRITE(6,4333) del_pen,new_tot,old_tot,pen_tot
c	WRITE(6,*)'---------------------------------------'
4333	format(4i8)
	if(del_pen .ge. 0)goto 500
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c		score worse, see if you want it				c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 	tprob_b=randx(iseed)
	cprob=exp(del_pen/temp)
	if(cprob .ge. tprob_b)goto 500
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	            dont want it, reset					c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	WRITE(6,*) 'REJECT!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
	nrej=nrej+1
	do i=1,npeaks
	peaknew(i)=peakold(i)
	enddo
c	WRITE(6,*) 'o/j',j_tot(1),ijunk_tot(1)
	goto 150
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c		  change it anyhow					c
c									c
c		score better, keep it					c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
500	do i=1,npeaks
	peakold(i)=peaknew(i)
	enddo

c   	WRITE(6,*) 'KEEP'
c
c		ENERGY LOG
c
c	change all the energies
c

c
c  change j-matching score
c

	do i=1,10
	j_tot(i)=j_tot(i)+j_new(i)-j_old(i)
c
c  and matching old table
c
	if (old)
     +	csmatch_tot(i)=csmatch_tot(i)+csmatch_new(i)-csmatch_old(i)
	enddo
	
c
c  change residue type matching scores
c
	rt_tot=rt_tot+(rt_new - rt_old)
	rtmo_tot=rtmo_tot+(rtmo_new - rtmo_old)
c
c  change specfic label scores
c
	n15_tot=n15_tot+(n15_new - n15_old)
	c13_tot=c13_tot+(c13_new - c13_old)
c
c  change noe score
c
	dist_tot=dist_tot+(dist_new-dist_old)

c
c  change total score
c
	pen_tot=pen_tot+del_pen

	if(emax.ge.pen_tot)goto 212
	emax=pen_tot
	do i=1,npeaks
		peakmax(i)=peakold(i)
		enddo
c	WRITE(6,222) (peakmax(i),i=1,nres)
222	format(209i4)

212	continue
c
c	Not highest E, but check to see if solution should be stored anyhow
c
	min_e=e_max(1)
	idx_e=1
	do k=1,20
		if(e_max(k).lt.min_e)then
			idx_e=k
			min_e=e_max(k)
			endif
		enddo
	if(pen_tot .lt. e_max(idx_e))goto 213
	do i=1,nres
		peak_array(idx_e,i)=peakold(i)
		enddo
		e_max(idx_e)=pen_tot

213	goto 150

2000	CALL WRITE_OUTPUT(klp,filename,len,nres,npeaks,nshift,peakmax)

c
c  end klp loop
c	
2001	continue


c
c  end SUPER LOOP
c

c
c  keep best scored solution
c

	score_stat(SL)=emax
	do i=1,npeaks
		peak_stat(SL,i)=peakmax(i)
	enddo

c
c
c  copy best solution 
c



	call system('cp '//path(1:path_len)//'anneal.'//fnum(klp-1)//' '//
     +      path(1:path_len)//'solutions/'//filename(1:len)//'_'//
     +	    fnum(SL)//'.soln') 



3000	continue


c
c  move best scored solution to peak_max()
c  currently need to do this for WRITE_PS
c
	idx=1
	top_score=score_stat(1)
	do i=1,num_stat
		if (score_stat(i).gt.top_score) then
			top_score=score_stat(i)
			idx=i
		endif
	enddo
 	do i=1,nres
	peakmax(i)=peak_stat(idx,i)
	enddo




	Call WRITE_FRAME(filename,len)
	Call WRITE_HEAD(filename,len)
	Call WRITE_AAPROB(filename,len,npeaks,peakmax,nres)

	CALL WRITE_HTML(klp,filename,len,nres,npeaks,nshift,peakmax,
     +  HAmatch,HA1,HA2,COHA1,COHA2,HBmatch,HB1,HB2,COHB1,COHB2)

	CALL WRITE_PS(klp,filename,len,nres,npeaks,nshift,peakmax,
     +  HAmatch,HA1,HA2,COHA1,COHA2,HBmatch,HB1,HB2,COHB1,COHB2,
     +  nsl_lkup,csl_lkup)

	if (SL.gt.2) Call WRITE_CORRELATION(filename,len,nres,peakmax)


c	Write(6,*) 'scores'	
c 	do i=1,num_stat
c 	write(6,*) score_stat(i)
c 	enddo
c	write(6,*) 'peaks'
c 	do i=1,nres
c 		write(6,'(21i4)') i,(peak_stat(j,i),j=1,num_stat)
c 	enddo

	CALL WRITE_FINAL(filename,len,nres,npeaks,nshift)

	write(6,*)
	write(6,*) 'Full Monte Complete'
	idx=6
	call WRITE_TIME(idx,start_sec)
	write(6,*)
	write(6,*)

c
c  close logfile
c
	close(15)

	stop
	end

cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
cxx							xxx
cxx		END MAIN				xxx
cxx							xxx
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx


	Subroutine WRITE_SCORE(U,klp,temp,ncycle,nrej,emax,max_swap,
     +          noe_scale,j_tot,rt_tot,rtmo_tot,n15_tot,c13_tot,
     +	        dist_tot,pen_tot,csmatch_tot,old)


	integer klp,ncycle,nrej,emax,max_swap
	real noe_scale
	integer j_tot(10),rt_tot,rtmo_tot,pen_tot
	integer csmatch_tot(10)
	integer n15_tot,c13_tot
	integer dist_tot
	integer U
	logical old
c
c  j_tot has the following index
c  CO=1,CA=2,HA=3,CB=4,HB=5,CG=6,NNn=7,NNc=8,HH=9
c  for reporting amide/amide connect add (7) and (8)
c  probably only do one expt. anyway
c
 	write(U,*)
	write(U,*)"anneal                                                 max    max   NOE"
 	write(U,*)"sched  temp      ncyc    n-suc    n-rej     score     score  swap  scale"
 	write(U,3004)klp,temp,ncycle,ncycle-nrej,nrej,pen_tot,emax,max_swap,noe_scale
	write(U,*)"------------------------------------------------------------------------"
	write(U,*)"|     CO      Ca       Ha      Cb      Hb      Cg     Nn/Nc            |"
	write(U,3002)"|", (j_tot(i),i=1,6),(j_tot(7)+j_tot(8)),"|"
 	write(U,*)"------------------------------------------------------------------------"
c	write(U,*)
c	write(U,*)"------------------------------------------------------------------------"
	write(U,*)"|   rt(i)   rt(i-1)  N(15)  1-C(13)  | NH      NH      HA       HB     |"
	write(U,3003)"|",rt_tot,rtmo_tot,n15_tot,c13_tot,"| NOE",dist_tot,"|"
	write(U,*)"------------------------------------------------------------------------"
	if (old) then
	write(U,*)"|     Matching old assignments                                         |"
	write(U,*)"|     CO      CaCO    COCa    Ca      COCb    Cb                       |"
	write(U,3005)"|", (csmatch_tot(i),i=1,6),"|"
	write(U,*)"------------------------------------------------------------------------"
	endif
	write(U,*)

3002    format(1x,a1,7i8,14x,a1)
3003    format(1x,a1,4i8,4x,a5,i8,21x,a1)
3004	format(i2,4x,f6.1,i10,2i9,2i10,i5,2x,f4.1)
3005    format(1x,a1,6i8,22x,a1)

	return
	end


	Subroutine WRITE_OUTPUT(klp,file,len,nres,npeaks,nsft,peakmax)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer peakmax(500),nres,peak_inp,nsft
	integer atmnum(500),rtype(500)
	integer klp,len,s(500,20),assn(500)
	integer peak_array(50,500),e_max(50)
	integer ichange,change(500)
	real st(20),pin(500)
	real x(500),y(500),z(500)
	character*1 pdiff(50),good
	character*2 fnum(0:50)
	character*3 rname(500)
	character*28 date_time
	character*60 file
	character*100 outfile
	integer path_len
	character*100 path,fname
	
	Common /path/ path,path_len
	
	Common	Common /pdb/ atmnum, rname, rtype, x, y, z
	Common /jcoup/ pin,assn,peak_inp
	Common /jcoups/ s
	Common /e_max/ peak_array,e_max
	Common /extension/ fnum


	outfile= path(1:path_len)//'anneal.'//fnum(klp)
	open(unit=10,file=outfile,status='unknown')
		
	call fdate(date_time)
	write(10,102)'%%',date_time
102	format(a2,48x,a28)
c
c
c
c
c		WRITE OUT 20 ELEMENTS OF PEAK_ARRAY
c
c		SORT THEM FIRST
c
	do i=1,19
		do j=i+1,20
 			if(e_max(i).lt.e_max(j))then
				itemp=e_max(i)
				e_max(i)=e_max(j)
				e_max(j)=itemp
				do k=1,npeaks
					itemp=peak_array(i,k)
					peak_array(i,k)=peak_array(j,k)
					peak_array(j,k)=itemp
				enddo
			endif
		enddo
	enddo
c


c	write(10,'(8x,20I8)')(e_max(k),k=1,20)
	do i=1,nres
		ichange=0
		do k=1,20
		pdiff(k)=' '
		enddo
		do k=1,19
		if( (peak_array(k,i).ne.peak_array(k+1,i) ) .and. (peak_array(k+1,i).ne.0.0) )then
			pdiff(k)='*'
			ichange=ichange+1
			endif
		enddo

	change(i)=ichange



c	write(10,'(i3,2x,i2,1x,20(2x,f5.1,a1))')i,ichange,(pin(peak_array(k,i)),pdiff(k),k=1,20)


	enddo

 	do i=1,nres
			l=peakmax(i)
			do m=1,nsft
			st(m)=s(l,m)/100.00
			enddo		
	good=' '
	if (klp.ne.0) then
	if ((change(i).eq.0).and.(pin(peakmax(i)).ne.0.0).and.(pin(peakmax(i)).ne.999.0)) good='>'
	endif

	Write(10,100)i,good,rname(i),pin(peakmax(i)),assn(peakmax(i)),(st(m),m=1,nsft)

100 	FORMAT(i3,a1,1x,a3,1x,f5.1,i4,20f7.2:)


 	enddo

	Write(10,'(a2)') '%%'
	write(10,'(a2)') '%%'
	Write(10,'(a25)') '%%  Spin Systems not used'
	do i=nres+1,npeaks
			l=peakmax(i)
			do m=1,nsft
			st(m)=s(l,m)/100.00
			enddo		
  	if (pin(peakmax(i)).ne.0.0) then 
	Write(10,101)'%%',rname(i),pin(peakmax(i)),assn(peakmax(i)),(st(m),m=1,nsft)
  	endif
	enddo
101 	FORMAT(a2,2x,1x,a3,1x,f5.1,i4,20f7.2:)

	close(10)
	return
	end


	Subroutine READ_3D_NOE(file,len,NH,H,idx,ext,verbose)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	
	integer NH,H,idx
	integer len,verbose
	integer hn_noe(500,0:10,2)
	integer assn(500),peak_inp
	integer ass,flg,nshift
	real st(20),pin_noe,pin(500),cs(40)
	character*7 comt,ext
	character*60 file,noe_file
	character*256 str
	logical dv
	integer path_len
	character*100 path,fname
	
	Common /path/ path,path_len
	Common /hn_noe/ hn_noe
	Common /jcoup/ pin,assn,peak_inp

	dv=.false.


	noe_file= file(1:len)//'.'//ext
	if(verbose.ge.1) then
		write(6,*) 'READ :',noe_file
		write(15,*) 'READ :',noe_file
		endif
	fname=path(1:path_len)//noe_file
	open(unit=10,file=fname,status='old')

30	read(10,'(a256:)',end=40)str
	if(verbose.ge.3) write(15,*) str

	call parse(dv,str,pin_noe,comt,ass,flg,nshift,cs)
c	write(6,'(12f7.2)') (cs(k),k=1,nshift)
c	write(6,*) 'nshift',nshift


	do j=1,peak_inp
	if (pin(j).eq.pin_noe) then

c
c  hn_noe contains noe chemical shifts
c  hn_noe(500,0:10,2)  (500) spin system,
c  0:10 index 0 contains parent shift 
c  1,2  Nitrogen and proton shift.  <--
c  this index follows definintions from
c  chemical shift tables
c
	l=0
	hn_noe(j,l,H)=int(cs(H)*100)
	hn_noe(j,l,NH)=int(cs(NH)*100)

	do k=3,nshift
	l=l+1
	hn_noe(j,l,idx)=int(cs(k)*100)
	enddo

c  
c 	write(6,'(12i8)') ((hn_noe(j,l,m),m=1,2),l=0,5)

        endif
	enddo                           	

	goto 30
40	close(10)
	
	return
	end



	Subroutine READ_4D_NOE(file,len,verbose)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	
	integer len,verbose
	integer hn_noe(500,0:10,2)
	integer assn(500),peak_inp
	integer ass,flg,nshift
	real st(20),pin_noe,pin(500),cs(40)
	character*7 comt
	character*60 file,noe_file
	character*256 str
	logical dv
	integer path_len
	character*100 path,fname
	
	Common /path/ path,path_len
	Common /hn_noe/ hn_noe
	Common /jcoup/ pin,assn,peak_inp

	dv=.false.

	noe_file= file(1:len)//'.4dnoe'
	if(verbose.ge.1)then
		 write(6,*) 'READ :',noe_file
		 write(15,*) 'READ :',noe_file
		endif
	fname=path(1:path_len)//noe_file
	open(unit=10,file=fname,status='old')
	i=0
20	i=i+1
30	read(10,'(a256:)',end=40)str
	if(verbose.ge.3) write(15,*) str
	call parse(dv,str,pin_noe,comt,ass,flg,nshift,cs)
c	write(6,'(12f7.2)') (cs(k),k=1,nshift)
c	write(6,*) 'nshift',nshift


	do j=1,peak_inp
	if (pin(j).eq.pin_noe) then

	l=0
	do k=1,nshift,2

c
c  hn_noe contains noe chemical shifts
c  hn_noe(500,0:10,2)  (500) spin system,
c  0:10 index 0 contains parent shift 
c  1,2  Nitrogen and proton shift.  <--
c  this index follows definintions from
c  chemical shift tables
c

	hn_noe(j,l,1)=int(cs(k)*100)
	hn_noe(j,l,2)=int(cs(k+1)*100)
	l=l+1

	enddo

c	write(6,'(12i8)') ((hn_noe(j,l,m),m=1,2),l=0,5)

        endif
	enddo                           	

	goto 20
40	close(10)
	
	return
	end


	Subroutine GEN_NOE_3DLOOK(H,NH,N_3dnoe,verbose)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Generates a look-up table of possible NOE matches
c  from a 3d H-amide or a pair of 3d H-NH N-NH noesy's
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer H,NH
	integer cs_olp(20,0:100),s(500,20)
	integer verbose,num
	integer sftn,sfth
	integer hn_noe(500,0:10,2),hn_noelk(500,500),n_noelk(500,500)
	integer assn(500),peak_inp
	real pin(500)
	logical hnnoe(500),N_3dnoe

	Common /hn_noe/ hn_noe
	Common /hn_noelk/ hn_noelk,hnnoe
	Common /shift_look/ cs_olp
	Common /jcoup/ pin,assn,peak_inp
	Common /jcoups/ s

	do i=1,500
		hnnoe(i)=.false.
		do j=1,500
		hn_noelk(i,j)=0
		enddo
	enddo

c
c
c  score separatly 
c
	do 40 i=1,peak_inp
		num=0
	do 30 m=1,10

		sfth=hn_noe(i,m,H)

		if (sfth .le. 0) goto 15
		num=num+1

			do 10 l=1,peak_inp
			if(i.eq.l)goto 10
			if (s(l,H).le. 0)goto 10
			idx1=abs(sfth - s(l,H))
			if(idx1.gt.100)idx1=100
c
c  cs_olp(x,idx)  x(9)=H
c 
	if ( hn_noelk(i,l).gt.(cs_olp(9,idx1))) goto 10
	hn_noelk(i,l)=(cs_olp(9,idx1))

10			continue


15	if(N_3dnoe) then
		
		sftn=hn_noe(i,m,NH)

		if (sftn .le. 0) goto 25
		num=num+1

			do 20 l=1,peak_inp
			if(i.eq.l)goto 20
			if (s(l,NH).le. 0)goto 20
			idx2=abs(sftn - s(l,NH))
			if(idx2.gt.100)idx2=100
c
c  cs_olp(x,idx) x(8)=NH
c 
	if ( n_noelk(i,l).gt.(cs_olp(8,idx2))) goto 20
	n_noelk(i,l)=(cs_olp(8,idx2))


20			continue
25	continue
	endif
30 	continue

	if(num.gt.0)  hnnoe(i)=.true.
40	continue


c
c  if there are two 3d's then multiply the 
c  two tables together
c
	
	if(N_3dnoe) then
	
  	do i=1,peak_inp
   	if(hnnoe(i)) then
		do l=1,peak_inp
 		hn_noelk(i,l)=int( ( (hn_noelk(i,l)/100.0)* ( n_noelk(i,l)/100.0) )*100)
		enddo
	endif
	enddo
	endif


	if (verbose.ge.2) then
	write(15,*) 'NOE probability table:'

	do i=1,peak_inp
	if (hnnoe(i)) then
  	write(15,'(a7,i3,2x,a14,f5.1)')'index :',i, 'peak number : ',pin(i)

  	write(15,100) (hn_noelk(i,l),l=1,peak_inp)
100	Format(20i4:)
	endif  
	enddo
 	endif



	return
	end







	Subroutine GEN_NOE_LOOKUP(H,NH,verbose)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Generates a look-up table of possible NOE matches
c  from a 4d amide-amide NOE
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer H,NH
	integer cs_olp(20,0:100),s(500,20)
	integer verbose,num
	integer sftn,sfth
	integer hn_noe(500,0:10,2),hn_noelk(500,500)
	integer assn(500),peak_inp
	real pin(500)
	logical hnnoe(500)

	Common /hn_noe/ hn_noe
	Common /hn_noelk/ hn_noelk,hnnoe
	Common /shift_look/ cs_olp
	Common /jcoup/ pin,assn,peak_inp
	Common /jcoups/ s

	do i=1,500
		hnnoe(i)=.false.
		do j=1,500
		hn_noelk(i,j)=0
		enddo
	enddo
c
c
c  score pairs of noe's
c
	do 30 i=1,peak_inp
		num=0
	do 20 m=1,5

		sftn=hn_noe(i,m,NH)
		sfth=hn_noe(i,m,H)
		if( (sftn.le.0).and.(sfth .le. 0)) goto 20
		num=num+1
			do 10 l=1,peak_inp
			if(i.eq.l)goto 10
			if( (s(l,H).le. 0).or.(s(l,NH).le. 0))goto 10

			idx1=abs(sfth - s(l,H))
			idx2=abs(sftn - s(l,NH))
			if(idx1.gt.100)idx1=100
			if(idx2.gt.100)idx2=100
c
c  cs_olp(x,idx) x(8)=NH, x(9)=H
c 


	if (sftn.le.0) then

c
c  if the nitrogen shif is absent, only use proton
c
	if ( hn_noelk(i,l).gt.(cs_olp(9,idx1))) goto 5
	hn_noelk(i,l)=(cs_olp(9,idx1))
5	continue
	else
c
c  otherwise, use both
c

     	hn_noelk(i,l)=hn_noelk(i,l)+int(( (cs_olp(9,idx1)/100.0)*
     +	                    (cs_olp(8,idx2)/100.0))*100.0)
	endif

10			continue

20	continue
	
	if(num.gt.0)  hnnoe(i)=.true.

30	continue

	if(verbose.ge.2) then
	write(15,*) 'NOE probability table:'
  	do i=1,peak_inp

   	if(hnnoe(i)) then
  	write(15,'(a7,i3,2x,a14,f5.1)')'index :',i, 'peak number : ',pin(i)
  	write(15,100) (hn_noelk(i,l),l=1,peak_inp)
100	Format(20i4:)
   	endif
  	enddo
	endif

	return
	end

cccccccccccccccccccccccccccccccccccccccccccccccc
c
c	writes out a file that sets up the frames
c   	for looking at the html output
c
ccccccccccccccccccccccccccccccccccccccccccccccccc
	Subroutine WRITE_FRAME(file,len)

	character*60 file
	character*100 path,fname,outfile
	integer path_len,len

	Common /path/ path,path_len
	
	fname=path(1:path_len)//'main.html'
	open(unit=10,file=fname,status='unknown')
	Write(10,*)'<HTML><head><title>Monte v2.02: ',file
	Write(10,*)'</title> </head>'
	Write(10,*)'<FRAMESET ROWS="*,50,80">'
	outfile= file(1:len)//'_out.html'
	Write(10,*)'<FRAME NORESIZE SRC="',outfile	
	Write(10,*)' "NAME="CS">'
	Write(10,*)'<FRAME NORESIZE SCROLLING=AUTO SRC="aahead.html" NAME="H">'
	Write(10,*)'<FRAME NORESIZE SCROLLING=AUTO SRC="aaprob.html" NAME="D">'
	Write(10,*)'</FRAMESET>'
	Write(10,*)'<NOFRAMES>'
	Write(10,*)'</NOFRAMES>'
	Write(10,*)'</HTML>'
	Write(10,*) 

	close(10)
	
	return
	end

	Subroutine WRITE_HEAD(file,len)
cccccccccccccccccccccccccccccccccccccccccccccccc
c
c	header file
c   	for AA type probabilities
c
ccccccccccccccccccccccccccccccccccccccccccccccccc
	character*60 file
	character*100 path,fname,outfile
	integer path_len,len
	integer rtnum(20)
	character*3 three(20)
	character*1 one(20)

	Common /path/ path,path_len
	common /aa/ rtnum,one,three
	
	fname=path(1:path_len)//'aahead.html'
	open(unit=10,file=fname,status='unknown')
	Write(10,*)'<HTML>'
	Write(10,*)'<Table> <TR> <TD width=35> res'
	do i=1,20
	Write(10,*)'<TD width=35>',three(i)
	enddo
	Write(10,*)'</TR></TABLE></HTML>'
	close(10)
	
	return
	end

	Subroutine WRITE_AAPROB(file,len,npeaks,peakmax,nres)
cccccccccccccccccccccccccccccccccccccccccccccccc
c
c	header file
c   	for AA type probabilities
c
ccccccccccccccccccccccccccccccccccccccccccccccccc
	character*60 file
	character*100 path,fname,outfile
	integer path_len,len,c_type,p_type
	integer rtnum(20)
	character*3 three(20)
	character*1 one(20)
	integer prob_res(500,20,3),prob_resmo(500,20,3)
	real pin(500)
	integer assn(500)
	integer peak_inp
	integer res_max,resmo_max
	integer sscode(500)
	integer peakmax(500),nres
	integer cur
	integer atmnum(500),rtype(500)
	character*3 rname(500)
	real x(500),y(500),z(500)

	Common /prob_res/ prob_res,prob_resmo
	Common /path/ path,path_len
	common /aa/ rtnum,one,three
	Common /jcoup/ pin,assn,peak_inp
	Common /ss/ sscode
	Common	Common /pdb/ atmnum, rname, rtype, x, y, z
	
	fname=path(1:path_len)//'aaprob.html'
	open(unit=10,file=fname,status='unknown')
	Write(10,*)'<HTML>'


	do i=1,peak_inp

c
c  find residue assignment for peak i
c  cur is then index for sscode
c
c
	type=0
	cur=1
		do l=1,nres
			if (peakmax(l).eq.i) then
				cur=l
				c_type=rtype(l)
				p_type=rtype(l-1)
			endif
		enddo


	write(10,100) 'Peak #',pin(i),'<A name="',i,'"> </A>'
100	format(a6,f5.1,a9,i3,a7)
	Write(10,*)'<Table> <TR> <TD width=35>(i-1)'
c
c  find max to add bold
c
	res_max=0
	resmo_max=0
	do k=1,20
	if(prob_resmo(i,k,sscode(cur-1)).gt.resmo_max) 
     +	resmo_max=prob_resmo(i,k,sscode(cur-1))
	
	if(prob_res(i,k,sscode(cur)).gt.res_max) 
     +	res_max=prob_res(i,k,sscode(cur))
	enddo

	do j=1,20

	if (j.eq.p_type) then
	write(10,105) '<TD bgcolor="#99FF33" width=35>'
	else
	write(10,110) '<TD width=35>'
	endif


	if(prob_resmo(i,j,sscode(cur-1)).eq.resmo_max) write(10,120) '<B>'
	write(10,130) prob_resmo(i,j,sscode(cur-1))
	if(prob_resmo(i,j,sscode(cur-1)).eq.resmo_max) write(10,140) '</B>'
	enddo
	write(10,*) '</TR>'
	write(10,*) '<TR> <TD width=35> (i)'
	do j=1,20

	if (j.eq.c_type) then
	write(10,105) '<TD bgcolor="#99FF33" width=35>'
	else
	write(10,110) '<TD width=35>'
	endif

	if(prob_res(i,j,sscode(cur)).eq.res_max) write(10,120) '<B>'
	write(10,130) prob_res(i,j,sscode(cur))
	if(prob_res(i,j,sscode(cur)).eq.res_max) write(10,140) '</B>'
	enddo
	Write(10,*)'</TR></TABLE>'
	enddo
	write(10,*)'</HTML>'
	close(10)
105	format(a31,$)
110	format(a13,$)
120	format(a3,$)
130	format(i3,$)
140	format(a4,$)

	return
	end

	Subroutine WRITE_HTML(klp,file,len,nres,npeaks,nsft,peakmax,
     +  	HAmatch,HA1,HA2,COHA1,COHA2,HBmatch,HB1,HB2,COHB1,COHB2)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer peakmax(500),nres,peak_inp,nsft
	integer atmnum(500),rtype(500)
	integer klp,len,s(500,20),assn(500)
	integer peak_array(50,500),e_max(50)
	integer ichange,change(500)
	Integer j_mat(20,3),nmatch
	integer more,noemax,noe_num
	integer dmap(500,500),hn_map(500,0:20),hn_noelk(500,500)
	integer hn_noe(500,0:10,2)
	integer iwrite
	integer HA1,HA2,COHA1,COHA2,HB1,HB2,COHB1,COHB2
	real st(20),pin(500),chk,chk1,chk2
	real x(500),y(500),z(500)
	real hntol,ntol,cotol,catol,cbtol,cgtol,hatol,hbtol,hgtol
	real tol
	character*1 pdiff(50)
	character*3 rname(500)
	character*5 colhead(20)
	character*60 file,outfile
	logical good,hnnoe(500),HAmatch,HBmatch,found
	integer path_len
	character*100 path,fname
	Integer peak_stat(50,500),score_stat(50),num_stat,SL
	
	Common /path/ path,path_len
	Common	Common /pdb/ atmnum, rname, rtype, x, y, z
	Common /jcoup/ pin,assn,peak_inp
	Common /jcoups/ s
	Common /e_max/ peak_array,e_max
	Common /match/ j_mat,nmatch
	Common /tolerence/ hntol,ntol,catol,cbtol,cotol,hatol,hbtol,cgtol
	Common /dist/ dmap,hn_map
	Common /hn_noelk/ hn_noelk,hnnoe
	Common /header/ colhead
	Common /hn_noe/ hn_noe
	Common /statistics/ peak_stat,score_stat,num_stat,SL


c
c       TKH 20Jan2003
c       Common block statistics needed to find if solution is unique
c       for SL>1 to determine if bold.
c
c       peak_max used for spin systems since the best score solution
c       is copied into this variable before calling this routine
c


	outfile= file(1:len)//'_out.html'
c	write(6,*) outfile
	fname=path(1:path_len)//outfile
	open(unit=10,file=fname,status='unknown')

	Write(10,*) '<HTML>'
	Write(10,*) '<BODY>'
	write(10,*) '<TABLE BORDER=1>'
	write(10,*) '<TR><TH> &gt;1x<TH>   &gt;2x<TH>   &gt;3x<TH>   tolerance</TR>'
	Write(10,*) '<TR><TD bgcolor="#FFFFCC">&nbsp;&nbsp; <TD bgcolor="#FFFF66">&nbsp;&nbsp;'
   	Write(10,*) '<TD bgcolor="#FF0000">&nbsp;&nbsp; '
	Write(10,*) '</TR></TABLE>'

	do i=1,nres
		ichange=0
		do k=1,num_stat
		if( (peakmax(i).ne.peak_stat(k,i) ) .and. (peak_array(k,i).ne.0.0) )then
			ichange=ichange+1
			endif
		enddo

	change(i)=ichange



c	write(10,'(i3,2x,i2,1x,20(2x,f5.1,a1))')i,ichange,(pin(peak_array(k,i)),pdiff(k),k=1,20)


	enddo

	
	write(10,*)'<TABLE><TR><TH width=30> res# <TH width=40>type '
	write(10,*) '<TH width=40> peak# <TH width=30> asn#'

	do i=1,20
		if (colhead(i).eq.'     ') then
c
c check to see if there are any more
c
		more=0
		do j=i,20
 		if (colhead(j).ne.'     ') more =more +1
		enddo
		if (more.gt.0) write(10,98) '<TH WIDTH=60>',colhead(i)
			
		else  
		write(10,98) '<TH WIDTH=50>',colhead(i)
		endif

98	FORMAT(a20:)
	enddo

	noemax=0
	do i=1,peak_inp
		if(hn_map(i,0).gt.noemax) noemax=hn_map(i,0)
	enddo
	if (noemax.gt.1) write(10,99) '<TH colspan=',noemax,'> Amide NOEs '
	write(10,*) '</TR>'
99	FORMAT(a12,i3,a14)

 	do i=1,nres
			l=peakmax(i)
			do m=1,nsft
			st(m)=s(l,m)/100.00
			enddo		
	good=.false.

	
c
c       check for bold
c

	if (num_stat.gt.1) then

	   if ((change(i).eq.0).and.
     +    (pin(peakmax(i)).ne.0.0).and.(pin(peakmax(i)).ne.999.0)) then
		good=.true.
	   endif

	     endif


	

	write(10,*) '<TR>'
	if (good) then
		Write(10,101)'<TD><B>',i,'</B>'
			else 
			Write(10,100)'<TD>',i
	endif
	if (good) then
		Write(10,111)'<TD><B>',rname(i),'</B>'
			else 
			Write(10,110)'<TD>',rname(i)
	endif
	Write(10,145)'<TD> <A HREF="aaprob.html#',peakmax(i),'" TARGET=D>'
145	format(a26,i3,a13)
	write(10,146) pin(peakmax(i)),'</A>'
146	format(f5.1,a4)
	Write(10,130)'<TD>',assn(peakmax(i))

	do m=1,nsft
	iwrite=0
	found=.false.
	do k=1,nmatch
ccc
c		j_mat(nmatch*3) (inter index, intra index, pair type)
c				match (i)   to   (i-1) , type
c		nmatch = number of rows in matrix	
c	CO=1,CA=2,HA=3,CB=4,HB=5,CG=6,NNn=7,NNc=8,HH=9
ccc	

	if (j_mat(k,3).eq.1)tol=cotol
	if (j_mat(k,3).eq.2)tol=catol
	if (j_mat(k,3).eq.3)tol=hatol
	if (j_mat(k,3).eq.4)tol=cbtol
	if (j_mat(k,3).eq.5)tol=hbtol
	if (j_mat(k,3).eq.6)tol=cgtol
	if (j_mat(k,3).eq.7)tol=ntol	
	if (j_mat(k,3).eq.8)tol=ntol	

	if (m.eq.j_mat(k,2)) then
		found=.true.
	if (s(peakmax(i),j_mat(k,2))*s(peakmax(i+1),j_mat(k,1)).eq.0) goto 20
	
	chk=abs( ( s(peakmax(i),j_mat(k,2)) - s(peakmax(i+1),j_mat(k,1)))/100.0)
			if ((chk.gt.tol*3).and.(iwrite.lt.3)) iwrite=3
			if ((chk.gt.tol*2).and.(iwrite.lt.2)) iwrite=2
			if ((chk.gt.tol).and.(iwrite.lt.1))   iwrite=1
20	endif
	if (m.eq.j_mat(k,1)) then
		found=.true.
	if (s(peakmax(i),j_mat(k,1))*s(peakmax(i-1),j_mat(k,2)).eq.0) goto 30

	chk=abs((  s(peakmax(i),j_mat(k,1)) - s(peakmax(i-1),j_mat(k,2)))/100.0)
			if ((chk.gt.tol*3).and.(iwrite.lt.3)) iwrite=3
			if ((chk.gt.tol*2).and.(iwrite.lt.2)) iwrite=2
			if ((chk.gt.tol).and.(iwrite.lt.1))   iwrite=1
30	endif
	enddo


	if(.not.found) then

c
c might be HA or HB

	if (.not.HAmatch) goto 60
		tol=hatol
	if (m.eq.HA1) then
	if (s(peakmax(i),HA1).le.0) goto 70
		if (s(peakmax(i+1),COHA1).le.0) then
		chk1= 100 
		else
		chk1=abs((s(peakmax(i),HA1) - s(peakmax(i+1),COHA1))/100.0)
		endif

		if (s(peakmax(i+1),COHA2).le.0) then
		chk2= 100
		else
		chk2=abs((s(peakmax(i),HA1) - s(peakmax(i+1),COHA2))/100.0)
		endif


	if (chk1.lt.chk2) chk=chk1
	if (chk2.lt.chk1) chk=chk2 
	if ((chk1.eq.100).and.(chk2.eq.100)) chk=0
	
			if (chk.le.tol)   iwrite=0
			if (chk.gt.tol)   iwrite=1
			if (chk.gt.tol*2) iwrite=2
			if (chk.gt.tol*3) iwrite=3
		goto 70
		endif
c
c check second HA
c
	if (m.eq.HA2) then
	if (s(peakmax(i),HA2).le.0) goto 70

		if (s(peakmax(i+1),COHA1).le.0) then
		chk1= 100 
		else
		chk1=abs((s(peakmax(i),HA2) - s(peakmax(i+1),COHA1))/100.0)
		endif

		if (s(peakmax(i+1),COHA2).le.0) then
		chk2= 100
		else
		chk2=abs((s(peakmax(i),HA2) - s(peakmax(i+1),COHA2))/100.0)
		endif


	if (chk1.lt.chk2) chk=chk1
	if (chk2.lt.chk1) chk=chk2 
	if ((chk1.eq.100).and.(chk2.eq.100)) chk=0
	
			if (chk.le.tol)   iwrite=0
			if (chk.gt.tol)   iwrite=1
			if (chk.gt.tol*2) iwrite=2
			if (chk.gt.tol*3) iwrite=3
		goto 70
		endif

	if (m.eq.COHA1) then
	if (s(peakmax(i),COHA1).le.0) goto 70

		if (s(peakmax(i-1),HA1).le.0) then
		chk1= 100 
		else
		chk1=abs((s(peakmax(i),COHA1) - s(peakmax(i-1),HA1))/100.0)
		endif

		if (s(peakmax(i-1),HA2).le.0) then
		chk2= 100
		else
		chk2=abs((s(peakmax(i),COHA1) - s(peakmax(i-1),HA2))/100.0)
		endif


	if (chk1.lt.chk2) chk=chk1
	if (chk2.lt.chk1) chk=chk2 
	if ((chk1.eq.100).and.(chk2.eq.100)) chk=0
	
			if (chk.le.tol)   iwrite=0
			if (chk.gt.tol)   iwrite=1
			if (chk.gt.tol*2) iwrite=2
			if (chk.gt.tol*3) iwrite=3
		goto 70
		endif

	if (m.eq.COHA2) then
	if (s(peakmax(i),COHA2).le.0) goto 70

		if (s(peakmax(i-1),HA1).le.0) then
		chk1= 100 
		else
		chk1=abs((s(peakmax(i),COHA2) - s(peakmax(i-1),HA1))/100.0)
		endif

		if (s(peakmax(i-1),HA2).le.0) then
		chk2= 100
		else
		chk2=abs((s(peakmax(i),COHA2) - s(peakmax(i-1),HA2))/100.0)
		endif


	if (chk1.lt.chk2) chk=chk1
	if (chk2.lt.chk1) chk=chk2 
	if ((chk1.eq.100).and.(chk2.eq.100)) chk=0
	
			if (chk.le.tol)   iwrite=0
			if (chk.gt.tol)   iwrite=1
			if (chk.gt.tol*2) iwrite=2
			if (chk.gt.tol*3) iwrite=3
		goto 70
		endif

60	if (.not.HBmatch) goto 70
		tol=hatol
	if (m.eq.HB1) then
	if (s(peakmax(i),HB1).le.0) goto 70
		if (s(peakmax(i+1),COHB1).le.0) then
		chk1= 100 
		else
		chk1=abs((s(peakmax(i),HB1) - s(peakmax(i+1),COHB1))/100.0)
		endif

		if (s(peakmax(i+1),COHB2).le.0) then
		chk2= 100
		else
		chk2=abs((s(peakmax(i),HB1) - s(peakmax(i+1),COHB2))/100.0)
		endif


	if (chk1.lt.chk2) chk=chk1
	if (chk2.lt.chk1) chk=chk2 
	if ((chk1.eq.100).and.(chk2.eq.100)) chk=0
	
			if (chk.le.tol)   iwrite=0
			if (chk.gt.tol)   iwrite=1
			if (chk.gt.tol*2) iwrite=2
			if (chk.gt.tol*3) iwrite=3
		goto 70
		endif
c
c check second HB
c
	if (m.eq.HB2) then
	if (s(peakmax(i),HB2).le.0) goto 70

		if (s(peakmax(i+1),COHB1).le.0) then
		chk1= 100 
		else
		chk1=abs((s(peakmax(i),HB2) - s(peakmax(i+1),COHB1))/100.0)
		endif

		if (s(peakmax(i+1),COHB2).le.0) then
		chk2= 100
		else
		chk2=abs((s(peakmax(i),HB2) - s(peakmax(i+1),COHB2))/100.0)
		endif


	if (chk1.lt.chk2) chk=chk1
	if (chk2.lt.chk1) chk=chk2 
	if ((chk1.eq.100).and.(chk2.eq.100)) chk=0
	
			if (chk.le.tol)   iwrite=0
			if (chk.gt.tol)   iwrite=1
			if (chk.gt.tol*2) iwrite=2
			if (chk.gt.tol*3) iwrite=3
		goto 70 
		endif

	if (m.eq.COHB1) then
	if (s(peakmax(i),COHB1).le.0) goto 70

		if (s(peakmax(i-1),HB1).le.0) then
		chk1= 100 
		else
		chk1=abs((s(peakmax(i),COHB1) - s(peakmax(i-1),HB1))/100.0)
		endif

		if (s(peakmax(i-1),HB2).le.0) then
		chk2= 100
		else
		chk2=abs((s(peakmax(i),COHB1) - s(peakmax(i-1),HB2))/100.0)
		endif


	if (chk1.lt.chk2) chk=chk1
	if (chk2.lt.chk1) chk=chk2 
	if ((chk1.eq.100).and.(chk2.eq.100)) chk=0
	
			if (chk.le.tol)   iwrite=0
			if (chk.gt.tol)   iwrite=1
			if (chk.gt.tol*2) iwrite=2
			if (chk.gt.tol*3) iwrite=3
		goto 70 
		endif

	if (m.eq.COHB2) then
	if (s(peakmax(i),COHB2).le.0) goto 70

		if (s(peakmax(i-1),HB1).le.0) then
		chk1= 100 
		else
		chk1=abs((s(peakmax(i),COHB2) - s(peakmax(i-1),HB1))/100.0)
		endif

		if (s(peakmax(i-1),HB2).le.0) then
		chk2= 100
		else
		chk2=abs((s(peakmax(i),COHB2) - s(peakmax(i-1),HB2))/100.0)
		endif


	if (chk1.lt.chk2) chk=chk1
	if (chk2.lt.chk1) chk=chk2 
	if ((chk1.eq.100).and.(chk2.eq.100)) chk=0
	
			if (chk.le.tol)   iwrite=0
			if (chk.gt.tol)   iwrite=1
			if (chk.gt.tol*2) iwrite=2
			if (chk.gt.tol*3) iwrite=3
		goto 70 
		endif


c
c end not found if
c
	endif


c
c   now write shift
c

	
70	if (iwrite.eq.0) Write(10,140)'<TD>',st(m)
	if (iwrite.eq.1) Write(10,142)'<TD bgcolor="#FFFFCC">',st(m)
	if (iwrite.eq.2) Write(10,141)'<TD bgcolor="#FFFF66">',st(m)
	if (iwrite.eq.3) Write(10,141)'<TD bgcolor="#FF0000">',st(m)
		
	enddo
		
c
c  count how man noe's input and write out
c
	noe_num=0
	do 80 n=1,10
80	if ((hn_noe(peakmax(i),n,1).gt.0).or.(hn_noe(peakmax(i),n,2).gt.0)) noe_num=noe_num+1


		write(10,'(a9,i1,a4)') '<TD> &lt;',noe_num, '&gt;' 

	do j=1,hn_map(i,0)
		
c
c  can set threshold for reporting noe matches here currently    20
c		
		if( hn_noelk(peakmax(i),peakmax(hn_map(i,j))).gt.20) then
		Write(10,151) '<TD><B>' ,hn_map(i,j),'</B>'
		else
		write(10,150) '<TD>' ,hn_map(i,j)
		endif 
150	FORMAT($,a4,i4)
151	FORMAT($,a7,i4,a4)
	enddo

	
	write(10,*)'</TR>'


100 	FORMAT(a4,i3)
101 	FORMAT(a7,i3,a4)
110 	FORMAT(a4,a3)
111 	FORMAT(a7,a3,a4)
120 	FORMAT(a4,f5.1)
130	FORMAT(a4,i4)
140 	FORMAT($,a4,f7.2)
141 	FORMAT($,a22,f7.2)
142 	FORMAT($,a22,f7.2)


 	enddo
	Write(10,*) '</TABLE>'
	Write(10,*) '</BODY>'
	write(10,*) '</html>'
	close(10)
	return
	end

	SUBROUTINE License_Check(lkey)
ccccccccccccccccccccccccccccccccccccccccccccccc
c
c   The license key is a 12 letter ascii sting
c   The contents of the license file are generated by the utility lgen.f
c
cccccccccccccccccccccccccccccccccccccccccccccc
	character*12 lkey
	character*5 d
	character*3 month(12)
	data month /'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'/
	integer kin(12),imo,iday,iyr
c	unpack license key
	idx=65
        read(lkey(7:12),err=880,'(6i1)')(kin(i),i=1,6)
        imo= 10*(ichar(lkey(1:1))-idx-kin(1))+(ichar(lkey(2:2))-idx-kin(2))
        iday=10*(ichar(lkey(3:3))-idx-kin(3))+(ichar(lkey(4:4))-idx-kin(4))
        iyr= 10*(ichar(lkey(5:5))-idx-kin(5))+(ichar(lkey(6:6))-idx-kin(6))
        write(6,'(a30,a3,a3,i2)')'Your current license expires: ',month(imo),' 20',iyr
c
c       get system time, calculate diff in months
c
        call idate(imonth,iday,iyear)
        icur=iyear*12+imonth
        ilic=iyr*12+imo
        idel=ilic-icur
	goto 890

c       TKH 20Jan2003
c       Code added for error if license key
c       is present but not enough characters.
c

 880	write(6,*)'Your license key appears to be invalid'
	write(6,*)'Please contact rule@andrew.cmu.edu'
	stop

 890	continue
	write(6,'(a28,a3,a3,i2)')'The current system date is: ',month(imonth),' 20',iyear
	if(idel.ge.0)return
	write(6,*)'Your license has expired!'
	write(6,*)'Please contact rule@andrew.cmu.edu for a new one'
	stop
	end


	SUBROUTINE PARSE(old,instr,ss,comt,assign,rflg,nshift,cs)	
c parse.f - parses chemical shift input files
c
c ideal input:  sss.s res#comment flg cs1 cs2 cs3 cs4 ...., e.g.
c               100.0 Ala112? + 8.10 111.1 56.4 60.2 ...
c
c	sss.s	- spin system number
c	res#com	- comment field (a7), assignment (i3) is extracted out if present
c	flg	- is reliability flag, expecting + for reliable assignment (=1), null for unreliable(=0)
c	cs1	- chemical shift(s)
c
c	returned output:
c		sss.s (f5.1),res#com (a7), res# (i3), reliability (0,1), n-shifts, cs(n)
c

c Parse rules: Null lines or lines beginning with %% or ## return null (zero)
c	values for all fields. Fields must be separated by commas or spaces.
c	The presence of a '+' character sets RFLG to 1.  The following special
c	characters are currently purged from the file (!@#$%^&*). To change
c	this, change the variable PURGE and its declaration. Note that '+' is
c	always purged.  The first field is assumed to be the peak number
c	(SS,real).  The second field is assumed to be a comment (COMT,a7) from
c	which an integer string (ASSIGN) is extracted. ASSIGN is assumed to be
c	a user assignment. If the second field is all numeric and contains a
c	decimal, it is assumed to be a chemical shift.  All subsequent fields
c	are assumed to be chemical shifts.
c
c  if old. then first fields are consistent with old output, i.e.
c  i3,a1,1x,a3   '100+ GLN '  residue number, confidence, residue type  
c



	character*256 instr
	character*7 comt,blank
	real ss,cs(40)
	integer assign,rflg,err_flg,stack(100,3),st_pnt,st_depth
	integer res,nshift
	logical old
	character*8 purge
	purge='!@#$%^&*'

c
c	null fields
c	
	comt="       "
	ss=0
	assign=0
	rflg=0
	nshift=0
	do i=1,40
		cs(i)=0.0
	enddo
c
c	Check for comment fields
c
	if((instr(1:2).eq.'%%').or.(instr(1:2).eq.'##'))return	
c
c	Find overall length, if null string return
c
	len_str=256
	i=len(instr)
1		if(instr(i:i).ne. ' ')then
		len_str=i
		goto 20
		endif
	i=i-1
	if(i.eq.0)return
	goto 1
20	continue
c
c	replace comma with space
c
	do i=1,len_str
	if(instr(i:i).eq.',')instr(i:i)=' '
	enddo
c
c	purge special symbols & look for '+'
c
	do i=1,len_str
		if(instr(i:i).eq.'+')then
			instr(i:i)=' '
			rflg=1
			endif
		do j=1,len(purge)
		if(instr(i:i).eq.purge(j:j))instr(i:i)=' '
c
c get rid of tabs too
c
		if(instr(i:i).eq.'\t')instr(i:i)=' '
		enddo
	enddo
c
c	Fill stack
c
	i=1
c
c  if old i3,2x,a3  residue#, residue type- -
c  only need to extract residue# and skip 5 characters.
c
	if (old) then
		i=9
		read(instr(1:3),*) res

	endif

	st_pnt=0
	st_depth=0
	
25	if(instr(i:i).ne.' ')goto 30
	i=i+1
	if(i.lt.len_str)goto 25
30	idx1=i
	i=idx1
35	if(instr(i:i).eq.' ')goto 40
	i=i+1
	if(i.lt.len_str)goto 35
	goto 50
40	idx2=i-1
	st_depth=st_depth+1
	stack(st_depth,1)=idx1
	stack(st_depth,2)=idx2
	i=idx2+1
	goto 25
50	st_depth=st_depth+1
	stack(st_depth,1)=idx1
	stack(st_depth,2)=len_str
c
c	generate type (0=alpha:1=num,no dec:2=num with dec)
c
	do i=1,st_depth
	stack(i,3)=0
		iflg=0
		ndec=0
		do j=stack(i,1),stack(i,2)
			if(ichar(instr(j:j)).gt.57)iflg=1
			if(ichar(instr(j:j)).lt.45)iflg=1
			if(ichar(instr(j:j)).eq.47)iflg=1
			if(ichar(instr(j:j)).eq.46)ndec=ndec+1
		enddo
		if(iflg.eq.0)stack(i,3)=1
		if((iflg.eq.0).and.(ndec.eq.1))stack(i,3)=2
		if((iflg.eq.0).and.(ndec.gt.1))then
			write(6,*)'WARNING, extra decimal in input field'
			write(6,*)'Input string was: ',instr(1:len_str)
			stack(i,3)=3
			endif
			
c	write(6,'(4i5,a10)')i,stack(i,1),stack(i,2),stack(i,3),instr(stack(i,1):stack(i,2))
	enddo
c
c	assume 1st is spin system
c
	if((stack(1,3).eq.0).or.(stack(1,3).eq.3))then
		write(6,*)'Parse error:non-numerical character in peak id field'
	else
		read(instr(stack(1,1):stack(1,2)),*)ss
		st_pnt=2
	endif
c
c	assume 2nd is comment, unless it has a single decim, in which case it is a shift.
c
	if( (stack(2,3).le.1) .or. (stack(2,3).gt.2))then
		read(instr(stack(2,1):stack(2,2)),'(a:)')comt
		st_pnt=st_pnt+1
c
c	extract assignment from comment
c
		blank=comt
		do i=1,len(blank)
		if((ichar(blank(i:i)).lt.48) .or. (ichar(blank(i:i)).gt.57) )blank(i:i)=' '
		enddo
		read(blank,*)assign		
		endif
c
c	hopefully the rest are chemical shifts
c
	do i=st_pnt,st_depth
	if( (stack(i,3).eq.1) .or. (stack(i,3).eq.2) )then
		nshift=nshift+1
		read(instr(stack(i,1):stack(i,2)),*)cs(nshift)
		else
		write(6,*)'Parse error:non-numerical character in chemical shift field'
		endif
	enddo	

c
c  if this is an old table to match 
c  set the assignment to extracted
c  residue number
c

	IF (old) assign=res

	return
	end

	Subroutine READ_SEQUENCE(file,length,nres,verbose)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	In the absence of a pdb file, read in the 1' sequence
c	and generate pseudo a-helical coordinates 
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer sn,trnum,atmnum(500),rtype(500),length,verbose
 	integer type,nres,rtnum(20),mul
	real x(500),y(500),z(500),tx,ty,tz
	real hx,hy,hz
	integer sscode(500)
	logical helix
	character*1 one(20)
	character*3 trname,rname(500),three(20)
	character*60 file,seqfile
	character*256 instr
	integer path_len
	character*100 path,fname
	
	Common /path/ path,path_len
	common /pdb/ atmnum, rname, rtype, x, y, z
	common /aa/ rtnum,one,three
	Common /ss/ sscode

	seqfile= file(1:length)//'.seq'
	if (verbose.ge.1) then
		write(6,*) 'READ :',seqfile
		write(15,*) 'READ :',seqfile
		endif
	fname=path(1:path_len)//seqfile
	open(unit=10,file=fname,status='old')

	helix=.false.
	tx=1
	ty=1
	tz=1
	mul=1
c
c  check to see if 1 letter or 3 letter codes
c
	nres=1

5	read(10,'(a256:)',end=1000)instr
	if (verbose.ge.3) write(15,'(a256:)')instr

	len_str=256
	i=len(instr)
10		if(instr(i:i).eq. ' ')then
		len_str=i
		goto 20
		endif
	i=i-1
	if(i.eq.0) goto 5
	goto 10
20	continue

	j=0
30	j=j+1
	if (j.ge.len_str) goto 5
	if (instr(j:j).eq.' ') goto30


	do l=1,20
		if (instr(j:j+2).eq.three(l)) then
		rname(nres)=three(l)
		rtype(nres)=l
		endif
	enddo

c
c  increment by two more characters 
c  and increment the number of residues 
c  by 1
c

	j=j+2
	nres=nres+1

	goto30

1000	close(10)
	nres=nres-1
	return
	end



	Subroutine WRITE_TIME(idx,isec)
c**********************************************************
c
c	This subroutne writes out the elapsed time 
c  	to file format (idx)
c
c**********************************************************
	integer idx,isec
	integer sec,min,time

	sec=time()-isec
	min=int(sec/60)
	sec=sec-(min*60)
 	write(idx,100)'    Elapsed time (m:s) ',min,':',sec
100	format(a23,i10,a1,i2)
	return
	end


	Subroutine PICK_NSWAP(swap_num,max,tstart,temp,tfin,iseed)
c**********************************************************
c
c	This subroutne picks the number of residues to
c  	swap up to max...
c
c**********************************************************
	integer swap_num
	integer max
	real xreal,tstart,temp,tfin
	real xt0

c	xreal=max*exp(((tstart-temp)/(tstart-tfin))/2.718) 
c 	xt0=(randx(iseed)*xreal+.5)
 	xt0=(randx(iseed)*max+.5)
	swap_num=int(xt0)
	if (swap_num.lt.1) swap_num=1
	return
	end


	Subroutine PICK_SWAP(swap_num,nres,npeaks,idx1,idx2,iseed)

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c          Pick Swap residues - never include N-term or Pro            c
c	idx1 to (idx1+swap-1) first block
c	idx2 to (idx2+swap-1) second block
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer idx1,idx2,idxt
	integer swap_num,nres,lim2
	integer no_swap(500)
	integer k
	real xt


	Common /noswap/ no_swap
c
c  Pick first from 1 to nres
c
10	xt=randx(iseed)*nres+.5
	idx1=int(xt)
	if((idx1.le.1).or.(idx1.gt.(nres-swap_num+1))) goto 10
	k=0
20	if (k.eq.swap_num) goto 40
	if(no_swap(idx1+k).eq. 1) goto 10
	k=k+1
	goto 20
c
c  Pick 2nd 1 to npeaks
c	
40	xt=randx(iseed)*npeaks+.5
	idx2=int(xt)
c
c  cannot be same as 1st
	if (idx2.eq.idx1) goto 40
c
c  cannot be first residue
c  or go past npeaks
	if((idx2.le.1).or.(idx2.gt.(npeaks-swap_num+1))) goto 40
c
c  cannot span nres
	itemp=(idx2+swap_num-1)
	if ((idx2.le.nres).and.(itemp.gt.nres)) goto 40
	k=0
50	if(k.eq. swap_num)goto 60
	if (no_swap(idx2+k).eq. 1) goto 40
	k=k+1		
	goto 50
	
	if (idx2.gt.nres) write(6,*) idx2


c
c	make sure idx1 < idx2
c	this is important for shuffle

60	if(idx1 .gt. idx2)then
        idxt=idx1
	idx1=idx2
	idx2=idxt
	endif

	return
	end

 	Subroutine RANDOM_ASSIGNMENT(npeaks,nres,npro,peakold,iseed)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c								c
c	Randomly assign peaks 					c
c								c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	integer npeaks,nres,endpeaks,npro
	integer peakold(500)
	integer idx
	real xt
	integer atmnum(500),rtype(500)
	real x(500),y(500),z(500)
	logical flag,used(500)
	character*3 rname(500)

	Common /pdb/ atmnum, rname, rtype, x, y, z

	
	npeaks=npeaks-npro

	do i=1,500
	  used(i)=.true.
	  if (i.le.npeaks) used(i)=.false.
	enddo




	i=0
20	i=i+1

	if(i.gt.nres) goto 50	
	if((i.eq.1).or.(rtype(i).eq.20))then
c
c fill in pro residue with false peaks
c

		peakold(i)=500
		
	else

30	xt=npeaks*randx(iseed)+.5
	idx=int(xt)
c	write(6,*) idx
	if((idx .lt. 1).or.(idx .gt. npeaks)) goto 30	
	if (used(idx)) goto 30	
		peakold(i)=idx
		used(idx)=.true.
	endif

	goto 20
50	continue


c
c  Random assignment done, place unused peaks
c  at end. (nres+1 to npeaks)
c

	npeaks=npeaks+npro

	i=nres
60	i=i+1
	if (i.gt.npeaks) goto 70
			flag=.true.
		do j=1,npeaks	
		 if (flag.and.(.not.used(j))) then
c		write(6,*) j,'not used'
			used(j)=.true.
			flag=.false.
			peakold(i)=j
		 endif
		enddo
	goto 60

70	return
	end



	Subroutine PUT(x,y,type)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	This subroutine is called to build j_mat          c
c	this is used to determine what shifts to                 c
c	match and what columns of s(res,shift) to look in        c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer x,y,type,nmatch
	Integer j_mat(20,3)

	Common /match/ j_mat,nmatch
			nmatch=nmatch+1
			j_mat(nmatch,1)=x
			j_mat(nmatch,2)=y
			j_mat(nmatch,3)=type
			
	return
	end






	Subroutine READ_PARAM(parfile,filename,len,verbose,deut_cs)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	          READ PARAMETER FILE                            c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer len,verbose
	real ca_off,cb_off,co_off,cg_off,n_off
	real sig_a,sig_b,sig_o,sig_g,sig_n
	integer j_scale(10),oj_scale(8)
	integer rt_scale,rtmo_scale,nsl_scale,csl_scale
	integer deut_cs
	integer ipdb,iss,i3dh,i3dn,i4d,iment,insl,icsl,ips,ihtm
	real hntol,ntol,catol,cbtol,cotol,hatol,hbtol,cgtol
	real ohntol,ontol,ocotol,ocatol,ocbtol
	real dcut,nsr(20)
	integer nstep,swap(20),atomtable(20,20),oldtable(10,20)
	integer co_r(0:20),ca_r(0:20),ha_r(0:20),cb_r(0:20),hb_r(0:20)
	real tstart(20),tstep(20),tfin(20),nc_root(20),gamma(20)
	integer len_ps
	real scale_ps
	logical noe_ps
	Integer peak_stat(50,500),score_stat(50),num_stat,SL


	character*60 filename
	integer path_len
	character*100 path,fname,ofile,parfile,text
	
	Common /path/ path,path_len
	Common /atom/ atomtable
	Common /offset/ ca_off,cb_off,co_off,cg_off,n_off
	Common /sig/ sig_a,sig_b,sig_o,sig_g,sig_n
	Common /weight1/ j_scale
	Common /weight2/ rt_scale,rtmo_scale,nsl_scale,csl_scale
	Common /tolerence/ hntol,ntol,catol,cbtol,cotol,hatol,hbtol,cgtol
	Common /o_tolerence/ ohntol,ontol,ocotol,ocatol,ocbtol
	Common /o_weight/ ohn_scale,on_scale,oco_scale,oca_scale
     +				,ocb_scale,ohb_scale,ocg_scale
	Common /anneal/tstart,tstep,nstep,tfin,nc_root,gamma,swap,nsr
	Common /repel/ co_r,ca_r,ha_r,cb_r,hb_r
	Common /dcut/ dcut
	Common /parflags/ ipdb,iss,i3dh,i3dn,i4d,iment,insl,icsl,ips,ihtm
	Common /matchold/ ofile,oldtable
	Common /oweight/ oj_scale
	Common /postscript/ len_ps,noe_ps,scale_ps
	Common /statistics/ peak_stat,score_stat,num_stat,SL


	len=index(parfile,' ') -1
	text=' READ :'//parfile(1:len)
	if(verbose.ge.1) write(6,'(a100:)') text

	open(unit=10,file=parfile,status='old')
	read(10,*)
	read(10,'(a60:)')filename
	len=index(filename,' ')-1
	read(10,*)
	read(10,'(a100:)')path
	path_len=index(path,' ')-1
	read(10,*)
	read(10,*)verbose
	read(10,*)
	read(10,*)
	read(10,*)ipdb,iss,i3dh,i3dn,i4d,icsl,insl
	read(10,*)
	read(10,*) ihtm,ips
	read(10,*)
	read(10,*) len_ps,scale_ps,inoe_ps
	if (inoe_ps.eq.1) noe_ps=.true.
	read(10,*)
	read(10,*)dcut
	do 9 i=1,4
9	read(10,*)
	do 20 i=1,20
20	read(10,100) (atomtable(i,j),j=1,20)
100	format(5x,20i3)
	do 21 i=1,3
21	read(10,*)
	read(10,*)ca_off,cb_off,co_off,cg_off,n_off
	do 22 i=1,3
22	read(10,*)
	read(10,*)sig_a,sig_b,sig_o,sig_g,sig_n
	read(10,*)
	read(10,*)
	read(10,*)deut_cs
	do 23 i=1,3
23	read(10,*)
	read(10,*)(j_scale(i),i=1,9)
	read(10,*)
 	read(10,*)rt_scale,rtmo_scale,nsl_scale,csl_scale
	do 24 i=1,3
24	read(10,*)
	read(10,*)ntol,hntol,cotol,catol,hatol,cbtol,hbtol,
     +               cgtol
	read(10,*)
	read(10,*)
	read(10,*)iment
	read(10,*)
	read(10,*)
	read(10,'(a100:)')ofile
	do 25 i=1,4
25	read(10,*)
	do i=1,8
		read(10,100) (oldtable(i,j),j=1,20)
c		write(6,100) (oldtable(i,j),j=1,20)
		enddo

	do 31 i=1,3
31	read(10,*)
	read(10,*)ontol,ohntol,ocotol,ocatol,ocbtol
	do 32 i=1,3
32	read(10,*)
	read(10,*) (oj_scale(i),i=1,3)
c	write(6,*) (oj_scale(i),i=1,3)
	read(10,*)
	read(10,*)
	read(10,*) num_stat
	do 33 i=1,4
33	read(10,*)
	k=0
1241	k=k+1
     	read(10,*)i,tstart(k),tstep(k),tfin(k),nc_root(k),gamma(k),swap(k),nsr(k)
     +               ,co_r(k),ca_r(k),ha_r(k),cb_r(k),hb_r(k)
c	write(6,*)i,tstart(k),nsr(k)
	if(i.gt.0)goto 1241
	nstep=k-1
	close(10)
c
c  these two parameters used in the noe tolerance (shift*100)
c
	h_tol=hntol*100
	n_tol=ntol*100


	return
	end





	Subroutine INIT
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	              zero distance,resname,cstable            c 
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer atmnum(500),rtype(500),index_rnum(500)
	integer co_r(0:20),ca_r(0:20),ha_r(0:20),cb_r(0:20),hb_r(0:20)
	real x(500),y(500),z(500)
	character*3 rname(500)

	real index_x(500),index_y(500),index_z(500)

	integer sscode(500)
	integer s(500,20),peak_inp
	integer assn(500)
	real pin(500)

	Common /pdb/ atmnum, rname, rtype, x, y, z
	Common /pdb2/ index_rnum,index_x,index_y,index_z
	Common /ss/ sscode
	Common /jcoup/ pin,assn,peak_inp
	Common /jcoups/ s
	Common /repel/ co_r,ca_r,ha_r,cb_r,hb_r

	do j=1,500
		index_rnum(j)=999
		x(j)=-9999
		y(j)=-9999
		z(j)=-9999
		index_x(j)=-9999
		index_y(j)=-9999
		index_z(j)=-9999
		sscode(j)=1
		rtype(j)=20
		rname(j)='PRO'
		assn(j)=0
		pin(j)=999
		do k=1,20
		s(j,k)=0
			co_r(k)=0
			ca_r(k)=0
			ha_r(k)=0
			cb_r(k)=0
			hb_r(k)=0
		enddo			
	enddo
	
	

	return
	end
	

	Subroutine READ_BMRB(verbose)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	          READ DATA BASE FILE                            c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer rtnum(20),verbose
	real cac(20),cas(20),cah(20),cbc(20),cbs(20),cbh(20)
	real cgs(20),cofc(20),cofs(20),cofh(20)
	real nfc(20),nfs(20),nfh(20)
        integer deut_cs
	character*1 one(20)
	character*3 three(20)

	
	common /bmrb/ cac,cas,cah,cbc,cbs,cbh,cgs,cofc,cofs,cofh
	Common /bmrb1/ nfc,nfs,nfh,deut_cs
	common /aa/ rtnum,one,three

	if(deut_cs.eq.0)then
		open(unit=10,file='aaconv',status='old')
		if(verbose.ge.1) write(6,*) 'READ :aaconv'
		if(verbose.ge.1) write(15,*) 'READ :aaconv'
		endif
	if(deut_cs.eq.1)then
		open(unit=10,file='aaconv_deut',status='old')
		if(verbose.ge.1) write(6,*) 'READ :aaconv_deut'
		if(verbose.ge.1) write(15,*) 'READ :aaconv_deut'
		endif
	read(10,*)
	read(10,*)
	do 20 i=1,20
	read(10,100)rtnum(i),one(i),three(i),cac(i),cas(i),cah(i),cbc(i)
     +		,cbs(i),cbh(i),cgs(i),cofc(i),cofs(i),cofh(i)
     +          ,nfc(i),nfs(i),nfh(i)
	if (verbose.ge.3) then
     	write(15,100)rtnum(i),one(i),three(i),cac(i),cas(i),cah(i),cbc(i)
     +          ,cbs(i),cbh(i),cgs(i),cofc(i),cofs(i),cofh(i)
     +	        ,nfc(i),nfs(i),nfh(i)
	endif
20	continue
100	format(i2,a1,1x,a3,3f6.2,1x,3f6.2,1x,f5.1,1x,3f7.2,1x,3f6.1)
	close(10)

	return
	end






	Subroutine READ_PDB(file,len,nres,verbose)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	The purpose of this subroutine is to read the pdb file
c	and extract 
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 	
	integer sn,trnum,atmnum(500),rtype(500),len,verbose
	integer type,nres,rtnum(20)
	real x(500),y(500),z(500),tx,ty,tz
	character*1 al,ch,one(20),chain_c
	character*3 trname,rname(500),three(20)
	character*4 anm
	character*6 atm
	character*60 file,pdbfile
	integer path_len
	character*100 path,fname
	character*256 str
	logical next,chain_f
	real xx(3,500), yy(3,500), zz(3,500)
	
	Common /path/ path,path_len
	common /pdb/ atmnum, rname, rtype, x, y, z
	common /aa/ rtnum,one,three
	common /coords /xx, yy, zz
	k=0

	chain_f=.false.

	pdbfile= file(1:len)//'.pdb'
	if (verbose.ge.1) then
		write(6,*) 'READ :',pdbfile
		write(15,*) 'READ :',pdbfile
		endif
	fname=path(1:path_len)//pdbfile
	open(unit=10,file=fname,status='old')
10      read(10,'(a256:)',end=40) str
	if (str(1:4).ne.'ATOM') goto 10

	read(str,100)atm,sn,anm,al,trname,ch,trnum,tx,ty,tz


	if (.not.chain_f) then
		chain_c=ch
		chain_f=.true.
		endif

	if (ch.ne.chain_c)  goto 10

	id=0

	if(anm .eq. ' N  ') id=1
	if(anm .eq. ' CA ') id=2
	if(anm .eq. ' C  ') id=3
	
	if (id.gt.0) then
		xx(id,trnum)=tx
		yy(id,trnum)=ty
		zz(id,trnum)=tz
	endif


c
c  make sure first residue is not set to
c  pro because there is no amide proton.
c

	if(trnum.eq.1) then
		Call AA_CONVERT(trname,type)
		rtype(1)=type
	endif


100     format(a6,i5,1x,a4,a1,a3,1x,a1,i4,4x,f8.3,f8.3,f8.3)
	rname(trnum)=trname
	next=.true.
	if(anm .eq. ' H  ') next=.false.
	if(anm .eq. ' HN ') next=.false.
	if (next) goto 10


 	if (verbose.ge.3)
     +	write(15,100)atm,sn,anm,al,trname,ch,trnum,tx,ty,tz

	nres=trnum
	atmnum(trnum)=sn
	x(trnum)=tx
	y(trnum)=ty
	z(trnum)=tz

	Call AA_CONVERT(trname,type)
	rtype(trnum)=type

32	goto 10
40      close(10)
	return
	end





	Subroutine SEC_STRUCTURE(file,len,nres,verbose)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	     read in secondary structure info sscode(i)		  c	
c		coil=   1					  c
c		sheet = 2					  c
c		helix = 3					  c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer len,nhelix,nbeta,verbose
	integer nres
	integer sscode(500)
	integer path_len
	character*100 path,fname

	character*60 file,ssfile

	Common /ss/ sscode
	Common /path/ path,path_len

	do 20 i=1,500
20	sscode(i)=1

	ssfile= file(1:len)//'.ss'
	if (verbose.ge.1) then
		 write(6,*) 'READ :',ssfile
		 write(15,*) 'READ :',ssfile
	endif
	fname= path(1:path_len)//ssfile
	open(unit=10,file=fname,status='old')
	read(10,*)nhelix
	if (verbose.ge.3) write(15,'(a9,i4)') '#helix  :',nhelix
	if(nhelix .eq. 0)goto 40
		do i=1,nhelix
		read(10,*)j,l
			do k=j,l
			sscode(k)=3
			end do
		end do
40	read(10,*)nbeta
	if (verbose.ge.3) write(15,'(a9,i4)') '#sheets :',nbeta
	if(nbeta .eq. 0)goto 50
		do i=1,nbeta
		read(10,*)j,l
c	write(6,*)j,l
			do k=j,l
			sscode(k)=2
			end do
		end do     
50	continue

	return
	end
	





	Subroutine DISTANCE(file,len,nres,verbose)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c									c
c			determine distance matrix			c
c									c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer len,nres,verbose
	integer dmap(500,500),hn_map(500,0:20),inum
	integer index_rnum(500),trnum,sn
	real dist,index_x(500),index_y(500),index_z(500)
	real tx,ty,tz
	real dcut
	character*1 al,ch,one(20)
	character*3 trname
	character*4 anm
	character*6 atm
	character*60 file,pdbfile
	integer path_len
	character*100 path,fname
	character*256 str
	
	Common /path/ path,path_len
	Common /pdb2/ index_rnum,index_x,index_y,index_z
	Common /dist/ dmap,hn_map
	Common /dcut/ dcut


c
c  filename may be temp.pdb
c  if created from primary sequence
c

	pdbfile= file(1:len)//'.pdb'
	fname=path(1:path_len)//pdbfile
	open(unit=10,file=fname,status='old')
	i=1

10      read(10,'(a256:)',end=40) str

	if (str(1:4).ne.'ATOM') goto 10
20      read(str,100)atm,sn,anm,al,trname,ch,trnum,tx,ty,tz 
c  	write(6,100)atm,sn,anm,al,trname,ch,trnum,tx,ty,tz 
100     format(a6,i5,1x,a4,a1,a3,1x,a1,i4,4x,f8.3,f8.3,f8.3)       
	if ((anm.ne.' H  ').and.(anm.ne.' HN ')) goto 10
25	index_rnum(i)=trnum
	if((index_rnum(i).eq.i).or.(index_rnum(i).eq.(i-nres))) goto 30
	index_rnum(i)=0
	i=i+1
	goto 25
	index_rnum(i)=trnum
30	index_x(i)=tx
	index_y(i)=ty
	index_z(i)=tz

c	write(6,*) trnum,tx

	i=i+1
 	index_nres=i
	goto 10
40      close(10)
	index_nres=index_nres-1
c
c		zero matrix
c

c	do i = 1,index_nres
c	enddo

c	do i=1,nres
c		write(6,*) i,index_rnum(i),index_x(i)
c	enddo


 	do 70 i=1,nres
 		do 50 j=1,nres
50		dmap(i,j)=0

	if(index_rnum(i).eq.0)goto 70
	if(index_x(i).eq.-9999)goto 70

	do 60 j=1,index_nres
	if(index_rnum(j).eq.0)goto 60


	if(index_x(j).eq.-9999)goto 60

	dist=sqrt(((index_x(i)-index_x(j))**2)+
     +		  ((index_y(i)-index_y(j))**2)+
     +		  ((index_z(i)-index_z(j))**2))
	k=index_rnum(j)

	if(dist.le.dcut) then
	
	if((dist.le.1.4).and.(dist.ge.0.2)) dmap(i,k)=1
	if((dist.gt.1.4).and.(dist.le.2.4)) dmap(i,k)=2
	if((dist.gt.2.4).and.(dist.le.3.4)) dmap(i,k)=3
	if((dist.gt.3.4).and.(dist.le.4.4)) dmap(i,k)=4
	if((dist.gt.4.4).and.(dist.le.5.4)) dmap(i,k)=5
	if(dist.gt.5.4) dmap(i,k)=6
	endif

60	continue
70	continue

c
c  old > 
c
c 	if (verbose.ge.2) then
c	write(6,*)'pdb Distance matrix:'
c	do i=1,nres
c	write(6,*)'residue : ',i
c	write(6,200)(dmap(i,j),j=1,nres)
200	format (500i2:)
c	enddo
c	endif
c
c  < old
c
	if (verbose.ge.2) then
	write(15,'(a50:)')"Possible NOE matches between residues i and j:"
	write(15,'(a22,f5.1)')"pdb distance cut-off: ",dcut
	write(15,'(a20:)')"i   N   j1  j2  ..."
	endif
	do i=1,nres
	inum=0
	do j=1,nres
	
		if (dmap(i,j).gt.0) then
		inum=inum+1
		hn_map(i,inum)=j
		endif
	enddo
	hn_map(i,0)=inum


  	if (verbose.ge.2) write(15,210) i,(hn_map(i,j),j=0,inum)
210	FORMAT(21i4:)
	enddo

	return
	end

	Subroutine READ_OLD(old_peaks,nsft,old,verbose)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c									c
c			READ IN OLD OUT FILE				c
c									c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer verbose,len
	integer old_s(500,20),old_peaks
	integer oldtable(10,20)
	integer old_assn(500),ass,nsft,flg
	real st(20),pin(500)
	character*7 com(500)
	character*100 fname,ofile
	logical old
	real cs(40),ss
	character*256 str,text
	character*7 comment
	integer nshift

	
	Common /matchold/ ofile,oldtable
	Common /old_J/ old_s,old_assn


	len=index(ofile,' ') -1
	text=' READ :'//ofile(1:len)
	fname=ofile(1:len)
	if (verbose.ge.1) then
		write(6,'(a100:)') text
		write(15,'(a100:)') text
		endif
	open(unit=10,file=fname,status='old')
	nsft=0
	j=0
20	j=j+1

30	read(10,'(a256:)',end=50)str
	if (verbose.ge.3) write(15,'(a256:)') str

c
c  here old should be true
c

	call parse(old,str,ss,comment,ass,flg,nshift,cs)

	if (flg.ne.1) goto 30
	if (nshift.gt.nsft) nsft=nshift
	old_assn(j)=ass

	do 40 k=1,nshift
40		old_s(j,k)=int(100*cs(k))
	

	if (verbose.ge.3) then
	write(6,'(i3,1x,20f7.2)') old_assn(j),(cs(k),k=1,nshift)	
  	write(15,'(i3,1x,20f7.2)') old_assn(j),(cs(k),k=1,nshift)
  	endif

	goto 20


50	continue
	npeaks=j-1
	old_peaks=npeaks
	close(10)

	return
	end



	Subroutine READ_CS(file,len,npeaks,nsft,old,verbose)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c									c
c			READ IN CS DATABASE				c
c									c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer len,verbose
	integer s(500,20),peak_inp,npeaks
	integer assn(500),nsft
	real st(20),pin(500)
	character*7 com(500)
	character*60 file,dbfile
	logical old

	real cs(40),ss
	character*256 str
	character*7 comment
	integer ass,flg,nshift
	integer path_len
	character*100 path,fname
	
	Common /path/ path,path_len
	Common /jcoup/ pin,assn,peak_inp
	Common /jcoups/ s

	dbfile= file(1:len)//'.cs'
	if (verbose.ge.1) then
		write(6,*) 'READ :',dbfile
		write(15,*) 'READ :',dbfile
		endif

	if (verbose.ge.3) write(15,*) "Duplicate shifts indicates format o.k"


	fname=path(1:path_len)//dbfile
	open(unit=10,file=fname,status='old')
	nsft=0
	j=0
20	j=j+1

30	read(10,'(a256:)',end=50)str

	if (verbose.ge.3) write(15,'(a256:)')str

	call parse(old,str,ss,comment,ass,flg,nshift,cs)

	if (ss.eq.0.0) goto 30
	if (nshift.gt.nsft) nsft=nshift
	pin(j)=ss
	com(j)=comment
	assn(j)=ass
	do 40 k=1,nshift
40		s(j,k)=int(100*cs(k))
	


	
 	if (verbose.ge.2) then
	write(15,100) pin(j),assn(j),(cs(k),k=1,nshift)
	write(15,100)
100     format(f5.1,4x,i3,6x,20f7.2:)

 	endif

	goto 20


50	continue
	npeaks=j-1
	peak_inp=npeaks
	close(10)
c
c	check for duplicate peak numbers
c
	do i=1,peak_inp-1
		do j=i+1,peak_inp
		if(pin(i).eq.pin(j))then
			write(6,*)'WARNING - duplicate peak numbers'
			
			write(6,*)'entry ',i,' peak number ',pin(i)
			write(6,*)'entry ',j,' peak number ',pin(j)
			write(6,*)
			endif
		enddo
	enddo

	return
	end





	Subroutine OVERLAP_TABLES(l,verbose)
cccccccccccccccccccccccccccccccccccccccccccc
c
c	generate overlap functions matching shifts
c
cccccccccccccccccccccccccccccccccccccccccccc

	integer verbose,tmp,l
	integer cs_olp(20,0:100)
	integer ocs_olp(20,0:100)
	integer co_r(0:20),ca_r(0:20),ha_r(0:20),cb_r(0:20),hb_r(0:20)
	real hntol,ntol,catol,cbtol,cotol,hatol,hbtol,cgtol
	real ohntol,ontol,ocatol,ocbtol,ocotol
	real temp
	Common /tolerence/ hntol,ntol,catol,cbtol,cotol,hatol,hbtol,cgtol
	Common /o_tolerence/ ohntol,ontol,ocotol,ocatol,ocbtol
	Common /repel/ co_r,ca_r,ha_r,cb_r,hb_r
	Common /shift_look/ cs_olp
	Common /oshift_look/ ocs_olp

c  for cs_olp
c	CO=1,CA=2,HA=3,CB=4,HB=5,CG=6,NNn=7,NNc=8,HH=9
c	



	do i=0,100
	tmp=i**2
	cs_olp(1,i)=int((co_r(l)+100)*exp(-1.0*tmp/(2*(cotol*100)**2))-co_r(l))
	cs_olp(2,i)=int((ca_r(l)+100)*exp(-1.0*tmp/(2*(catol*100)**2))-ca_r(l))
 	cs_olp(3,i)=int((ha_r(l)+100)*exp(-1.0*tmp/(2*(hatol*100)**2))-ha_r(l))
	cs_olp(4,i)=int((cb_r(l)+100)*exp(-1.0*tmp/(2*(cbtol*100)**2))-cb_r(l))
 	cs_olp(5,i)=int((hb_r(l)+100)*exp(-1.0*tmp/(2*(hbtol*100)**2))-hb_r(l))
 	cs_olp(6,i)=int(100.0*exp(-1.0*tmp/(2*( cgtol*100)**2)))
	cs_olp(7,i)=int(100.0*exp(-1.0*tmp/(2*(  ntol*100)**2)))
	cs_olp(8,i) =int(100.0*exp(-1.0*tmp/(2*(  ntol*100)**2)))
	cs_olp(9,i) =int(100.0*exp(-1.0*tmp/(2*(hntol*100)**2)))


	ocs_olp(1,i) =int(100.0*exp(-1.0*tmp/(2*( ocotol*100)**2)))
	ocs_olp(2,i) =int(100.0*exp(-1.0*tmp/(2*( ocatol*100)**2)))
	ocs_olp(3,i) =int(100.0*exp(-1.0*tmp/(2*( ocbtol*100)**2)))
	ocs_olp(4,i) =int(100.0*exp(-1.0*tmp/(2*(  ontol*100)**2)))
	ocs_olp(5,i) =int(100.0*exp(-1.0*tmp/(2*(ohntol*100)**2)))	

	enddo
c
c	truncate at 1ppm match  i.e.  all olp(100)=0
c
	do i=1,10
	if (cs_olp(i,100).gt.0) cs_olp(i,100) = 0
	if (ocs_olp(i,100).gt.0) ocs_olp(i,100)=0
	enddo


  	if (verbose.ge.2) then

	write(15,*)'Scoring for chemical shift differences:'
	write(15,*)'ppm    CO   Ca   Ha   Cb   Hb   Cg   Nn   Nn   HH'

		do j=0,100
			temp=j/100.0
		write(15,100) temp,(cs_olp(i,j),i=1,9)
100		format(f5.2, 10i5:)
		enddo
 	endif

	return
	end


	Subroutine SLAB_LOOKUP(file,f_len,verbose,label,H,NH,ext)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c								c
c		determine prob based on spec labeling		c
c								c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer f_len, type,temp,verbose
	integer H,NH
	integer assn(500),s(500,20),peak_inp
	integer label(500,20)
	integer idx
	real sl(2)
	real pin(500)
	integer cs_olp(20,0:100)
	character*3 slres,ext
	character*60 file,dbfile
	integer path_len,len_str
	character*100 path,fname,str,str1
	
	Common /path/ path,path_len
	Common /jcoup/ pin,assn,peak_inp
	Common /jcoups/ s
	Common /shift_look/ cs_olp

c  already set to zero in the main code

c	do i=1,500
c	do j=1,20
c	label(i,j)=0
c	enddo
c	enddo



	dbfile= file(1:f_len)//'.'//ext(1:3)
	if(verbose.ge.1) then
		write(6,*) 'READ :',dbfile
		write(15,*) 'READ :',dbfile
		endif
	fname=path(1:path_len)//dbfile
	open(unit=10,file=fname,status='old')
	j=0
	
20	read(10,'(a100:)',end=40)str
	i=0

		len_str=len(str)
25		i=i+1
		if(str(i:i).eq. ' ') goto 25
		if(str(i:i).eq. '\t')goto 25
	if (i.gt.99) goto 20

c
c  if not space or tab, must be three letter code
c

		slres=str(i:i+2)
c
c  read the other 
c
	str1=str(i+3:len_str)
	len_str=len_str-(i+2)

	read(str1(1:len_str),*),sl(1),sl(2)	



c100	format(a3,1x,2f7.2)
	j=j+1
	type=0
	Call AA_CONVERT(slres,type)

	do 30 i=1,peak_inp
	if ((s(i,NH).le.0).or.(s(i,H).le.0)) goto 30
	idx1=abs(s(i,NH)-int(sl(NH)*100))
	if (idx1.gt.100) idx1=100
	idx2=abs(s(i,H)-int(sl(H)*100))
	if (idx2.gt.100) idx2=100

	temp=int(100*( (cs_olp(7,idx1)/100.0)*(cs_olp(9,idx2)/100.0) ))

	if (temp.gt.label(i,type)) label(i,type)= temp 

30 	continue


	goto 20
40	close(10)

 	if(verbose.ge.2) then
	if (ext(1:3).eq.'nsl') write(15,*) 'Nitrogen sl Lookup table'
	if (ext(1:3).eq.'csl') write(15,*) 'Carbon sl Lookup table'
	do i=1,peak_inp
	write(15,200) i, (label(i,j),j=1,20),s(i,1),s(i,2)
200	format (i4,22i6)
	enddo
 	endif

	return
	end





	Subroutine AA_CONVERT(slres,type)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c								c
c		convert aa name					c
c								c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	integer type,rtnum(20)
	character*1 one(20)
	character*3 slres,three(20)
	
	common /aa/ rtnum,one,three

	do 20 j=1,20
	if(slres .ne. three(j))goto 20
	type=j
20	continue
	return
	end




	Subroutine RESIDUE_TYPE(peak,CO,CA,CB,CG,NH,tprob)
c  input:
c  peak= i.d. of spin system.  CO, CA, CB, CG, NH= integer
c   specifying column # of each chem shift in cs table.
c  output: tprob(i,j)= joint probability of assigning chem
c  shifts to A.A. type i, sec. struct type j={coil,helix,sheet}.
c  Modified by J.A.L.  1/16/2002
c  Uses AA type distributions of Ca, Cb, CO, NH from Lukin et al, 
c  J. Biomol. NMR 9 (1997) 151-166.  Cg estimated from BMRB.
c  Changed score to product of Gaussians.
c
c  GSR - underflow was occuring with certain data sets, set max of
c        arguments to guassian at 10, e^(-10)~10^(-5)
c        including warning if a matching aa can't be found
c  
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c									c
c	create lookup table for residue type				c
c	ca shifts are col 3						c
c	cb shifts are col 5   if cb=-1 force to GLY			c
c       co are in col 9							c
c									c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer CO,CA,CB,CG,NH,peak
	integer s(500,20)
	real sig_a,sig_b,sig_o,sig_g,sig_n
	real sa,sb,so,sg,sn
	real ca_off,cb_off,co_off,cg_off,n_off
	real cac(20),cas(20),cah(20),cbc(20),cbs(20),cbh(20)
	real cgs(20),cofc(20),cofs(20),cofh(20)
	real nfc(20),nfs(20),nfh(20)
	real arga, argb, argo, argg, argnh
	real tprob(20,3)
	integer assn(500),peak_inp
	real st(20),pin(500)
	real camean,cbmean,comean,cgmean,nhmean
	real sig_ca,sig_cb,sig_co,sig_cg,sig_nh
c  Widths of Ca, Cb, CO, NH distributions from Lukin et al, 
c  J. Biomol. NMR 9 (1997) 151-166.  Cg estimated from BMRB.
c	parameter (sig_ca= 1.42, sig_cb=1.31, sig_co= 1.32,
c     +   sig_cg= 1.5, sig_nh= 4.07)
c
	Common /bmrb/ cac,cas,cah,cbc,cbs,cbh,cgs,cofc,cofs,cofh
	Common /bmrb1/ nfc,nfs,nfh,deut_cs
	Common /offset/ ca_off,cb_off,co_off,cg_off,n_off
	Common /sig/ sig_a,sig_b,sig_o,sig_g,sig_n
	Common /jcoup/ pin,assn,peak_inp
	Common /jcoups/ s
c
c Convert s(i,j) back to chemical shifts
c Apply user shift offsets
c sb and sg set to -1 representing inverted peaks in HNCB/HNCG
c
c  s(i,j)= 100 * c.s. in column j of row (peak) i.
	if (CO.eq.0) then
	   so= 0.
	else
	   if (s(peak,CO).eq.0) then
	      so= 0.
	   else
	      so=(s(peak,CO)+co_off*100)/100.0
	   endif
	endif
c
	if (CA.eq.0) then
	   sa= 0.
	else
	   if (s(peak,CA).eq.0) then
	      sa= 0.
	   else
	      sa= (s(peak,CA)+ca_off*100)/100.0
	   endif
	endif
c
	if (NH.eq.0) then
	   sn= 0.
	else
	   if (s(peak,NH).eq.0) then
	      sn= 0.
	   else
	      sn= (s(peak,NH)+n_off*100)/100.0
	   endif
	endif
c
	if (CB.eq.0) then
	   sb= 0.
	else
	   if (s(peak,CB).eq.0) then
	      sb= 0.
	   else if (s(peak,CB).eq.-100) then
	      sb= -1.
	   else
	      sb= (s(peak,CB)+cb_off*100)/100.0
	   endif
	endif
c
	if (CG.eq.0) then
	   sg= 0.
	else
	   if (s(peak,CG).eq.0) then
	      sg= 0.
	   else if (s(peak,CG).eq.-100) then
	      sg= -1.
	   else
	      sg= (s(peak,CG)+cg_off*100)/100.0
	   endif
	endif
c
c flags for detecting poor shifts
c
	sigcut=3
	iglobal=1
c
c  Define mean shifts based on secondary structure.
c
	do l=1,3
	   do k=1,20
c
c	flags for detecting poor shifts
c
	iaflg=1
	ibflg=1
	ioflg=1
	inflg=1
	igflg=1
c
	      if(l.eq.1)camean=cac(k)
	      if(l.eq.3)camean=cah(k)
	      if(l.eq.2)camean=cas(k)
	      if(l.eq.1)cbmean=cbc(k)
	      if(l.eq.3)cbmean=cbh(k)
	      if(l.eq.2)cbmean=cbs(k)
	      if(l.eq.1)comean=cofc(k)
	      if(l.eq.3)comean=cofh(k)
	      if(l.eq.2)comean=cofs(k)
	      cgmean=cgs(k)
	      if(l.eq.1)nhmean=nfc(k)
	      if(l.eq.3)nhmean=nfh(k)
	      if(l.eq.2)nhmean=nfs(k)

c CA Shift
	      if(sa .gt. 5.) then
	         arga= 0.5*((sa-camean)/sig_a)**2
	      else
	         arga=0.
	      endif
	      if(arga .gt. 10)arga=10
	      if(arga .lt. sigcut)iaflg=0

c CB Shift
c    -guassian if b shift present and b carbon present
c    -argb=0.001 if b shift inverted and b carbon absent
c    -argb=10  if b shift inverted and b carbon present

	      argb=0.
              if(sb  .gt.  5)argb= 0.5*((sb-cbmean)/sig_b)**2
              if((sb .eq. -1).and.(cbmean.eq.-1))argb=0.001
              if((sb .eq. -1).and.(cbmean.gt.0))argb=10
              if(sb  .eq.  0) argb=0
              if(argb .gt. 10)argb=10
              if(argb .lt. sigcut)ibflg=0


c CO Shift
	      if(so .gt. 100.)then
		 argo= 0.5*((so-comean)/sig_o)**2
	      else 
		 argo=0.
	      endif
	      if(argo .gt. 10)argo=10
              if(argo .lt. sigcut)ioflg=0

c CG Shift
c    -guassian if g shift present and g carbon present
c    -argg=0.001 if g shift inverted and g carbon absent
c    -argg=10 if g shift inverted and g carbon present

	      argg=0.
	      if(sg .gt. 5) argg= 0.5*((sg-cgmean)/sig_g)**2
	      if((sg.eq.-1).and.(cgmean.eq.-1)) argg=0.001
	      if((sg.eq.-1).and.(cgmean.gt.0)) argg=10
	      if(sg .eq. 0) argg=0
	      if(argg .gt. 10)argg=10
              if(argg .lt. sigcut)igflg=0

c N shift
	      argnh=0
	      if(sn .gt. 80) argnh= 0.5*((sn-nhmean)/sig_n)**2
	      if(nhmean.eq.0) argnh=0.
	      if(argnh .gt. 10)argnh=10.
              if(argnh .lt. sigcut)inflg=0

cc  		tprob(k,l)=exp(-1.0*arga)*exp(-1.0*argb)*exp(-1.0*argo)
cc     +                      *exp(-1.0*argg)*exp(-1.0*argnh)
cc  changed to sum of inverted parabolic potentials, cut off at 
cc  | (s - s_mean)/sig | > 4.
cc   	      tprob(k,l)= max(0.0, (8.0-arga)/8.0) + 
cc     +                    max(0.0, (8.0-argb)/8.0) +
cc     +	                  max(0.0, (8.0-argo)/8.0) +
cc     +                    max(0.0, (8.0-argg)/8.0) +
cc     +                    max(0.0, (8.0-argnh)/8.0)
cc  Alternatively, comment out the last 5 lines and uncomment
cc  the next 3, to get product of gaussians.
	      tprob(k,l)=exp(-1.0*arga)*exp(-1.0*argb)*
     +                     exp(-1.0*argo)*exp(-1.0*argg)*
     +                     exp(-1.0*argnh)
	if((iaflg.eq.0).and.(ibflg.eq.0).and.(ioflg.eq.0).and.(igflg.eq.0).and.(inflg.eq.0))iglobal=0
	   enddo
	enddo

	if(iglobal.eq.1)write(15,*)'Warning: Peak ',pin(peak),'does not match any amino acids, check input shifts.'
	if(iglobal.eq.1)write(6,*)'Warning: Peak ',pin(peak),'does not match any amino acids, check input shifts.'

	return
	end




	Subroutine CHECK_CS(nres,npeaks,npro)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	This subroutine checks to see if there atleast one
c	spin system (peaks) per residue, if not, adds the
c 	appropriate number of peaks with zero's
c	additional PRO residues are added at Random assignment
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer atmnum(500),rtype(500),index_rnum(500)
	integer peak_inp,npeaks
	integer assn(500)
	integer npro
	real pin(500)
	real x(500),y(500),z(500)
	character*3 rname(500)


	Common /jcoup/ pin,assn,peak_inp
	Common /pdb/ atmnum, rname, rtype, x, y, z
	
	
c
c pro and 1st set to pin(500), set to 0
c
	pin(500)=0.0

	npro=0
	do i=1,nres
	if(rtype(i).eq.20) npro=npro+1
	enddo
c
c  Add enough false peaks to fill and 
c  extra 20% swap area.  pro residues
c  are added in Random_Assignment
c	
	itmp=int(nres*1.2)
c
c  Set residue type to 0 so that the extra  
c  residues will be swapped
c
	do 10 i=nres+1,itmp
	rtype(i)=0
10	rname(i)='   '

	if(npeaks.lt.(nres-1-npro))then

		write(6,*)'Not enough spin systems:'
		WRITE(6,*)nres,' Residues in protein'
		write(6,*)nres-1-npro,' spin systems needed'
		write(6,*)peak_inp,' spin systems input'
		
		write(6,'(a35)')'Filling in cs table with spin systems '
		WRITE(6,*) 
		WRITE(6,*)

	npeaks=itmp


	do 30 i=peak_inp+1,npeaks
30		pin(i)=0.0

c
c  want to keep PRO pin [peak id num]= 999
c  PRO residues are filled in from last peak 
c  backwards in Random_Assignment
c



	else
c	npeaks greater than nres-pro
c
c  number of peaks greater than number of resides
c  add enough for 20 % headroom and PRO
c

		if (npeaks.gt.itmp-npro) then
			WRITE(6,*) 'Too many peaks > 120% in protein'
			Write(6,*) 'FATAL ERROR'
			STOP
			endif

	npeaks=itmp

		do 60 i=peak_inp+1,npeaks
60			pin(i)=0.0



	endif

	return 
	end

	Subroutine SCORE_H_PAIR (idx1,idx2,H1,H2,COH1,COH2,type,max)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	Score pairs of Proton Shifts,
c       Pass back score of either combination.
c  
c       type is the index for cs_olp
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	integer idx1,idx2,type,max
	integer st_score,sw_score
	integer cs_olp(20,0:100)
	integer s(500,20)
	integer H1,H2,COH1,COH2

	Common /shift_look/ cs_olp
	Common /jcoups/ s


c	idx1=(i)spin idx2=(i-1)spin

	max=0
	st_score=0
	sw_score=0

	if((s(idx1,COH1).le. 0).and.
     +     (s(idx1,COH2).le. 0)) goto 60

	if((s(idx2,H1).le. 0).and.
     +     (s(idx2,H2).le. 0)) goto 60


c	write(6,*) H1,H2,COH1,COH2
c	write(6,*) s(idx1,COH1),s(idx2,H1)


	if ((s(idx1,COH1).le. 0).or.(s(idx2,H1).le. 0)) goto 20
	idx3=abs(s(idx1,COH1)-s(idx2,H1))
	if (idx3.gt.100) idx3=100
	st_score= cs_olp(type,idx3)

20	if ((s(idx1,COH2).le. 0).or.(s(idx2,H2).le. 0)) goto 30
	idx3=abs(s(idx1,COH2)-s(idx2,H2))
	if (idx3.gt.100) idx3=100
	st_score = st_score + cs_olp(type,idx3)


c
c  now do opposite combination....
c

30	if ((s(idx1,COH2).le. 0).or.(s(idx2,H1).le. 0)) goto 40
	idx3=abs(s(idx1,COH2)-s(idx2,H1))
	if (idx3.gt.100) idx3=100
	sw_score= cs_olp(type,idx3)

40	if ((s(idx1,COH1).le. 0).or.(s(idx2,H2).le. 0)) goto 50
	idx3=abs(s(idx1,COH1)-s(idx2,H2))
	if (idx3.gt.100) idx3=100
	sw_score = sw_score + cs_olp(type,idx3)


c
c  look to find maxium and return
c
50	if (sw_score.gt.st_score) then
		max=sw_score
	else
		max=st_score
	endif

c	write(6,*) 'Matching HA',idx1,idx2
c	write(6,*) s(idx1,COH1),s(idx2,H1)
c	write(6,*) s(idx1,COH2),s(idx2,H2)
c	write(6,*) idx3,sw_score,st_score,max
c
c	if ((idx1.eq.16).and.(idx2.eq.15)) then
c	write(6,*) 'HERE'
c	write(6,*) sw_score,st_score,max
c	endif

60	return
	end

	Subroutine SCORE_J(idx1,idx2,score)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	Score J-coupling matches
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	integer idx1,idx2,score(10)
	integer cs_olp(20,0:100)
	integer s(500,20)
	Integer j_mat(20,3),nmatch

	Common /shift_look/ cs_olp
	Common /jcoups/ s
	Common /match/ j_mat,nmatch

c	idx1=(i)spin idx2=(1-i)spin


c
c  Zero all scores
c



	do i=1,nmatch
	score(j_mat(i,3))=0
	if((s(idx1,j_mat(i,1)).le. 0).or.
     +     (s(idx2,j_mat(i,2)).le. 0)) goto 20

	idx3=abs(s(idx1,j_mat(i,1))-s(idx2,j_mat(i,2)))
	if (idx3.gt.100) idx3=100
	score(j_mat(i,3))= cs_olp(j_mat(i,3),idx3)

c	if (i.eq.1) then
c	write(6,*) 'nmatch:',nmatch
c	write(6,*) '      spin     s(intra)    s(inter)    idx3    score   stype '  
c	endif
c	 write(6,100) i,s(idx1,j_mat(i,1)),s(idx2,j_mat(i,2))
c    +    ,idx3, cs_olp(j_mat(i,3),idx3), j_mat(i,3)
c100 	format (6i10)
	
20	continue
	enddo
	return 
	end

	Subroutine SCORE_AATYPE(res,idx1,type1,type2,score1,score2)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	integer res,idx1,rt_score,rtmo_score
	integer type1,type2
	integer score1,score2
	integer sscode(500)
	integer prob_res(500,20,3),prob_resmo(500,20,3)

	Common /ss/  sscode
	Common /prob_res/ prob_res,prob_resmo


c	type is coil,sheet,helix

c	if(type1.gt.3) type1=1
c	if(type2.gt.3) type2=1

	score1=prob_res(idx1,type1,sscode(res))
	score2=prob_resmo(idx1,type2,sscode(res-1))

c	write(6,*) 'SCORE:', score1,score2
c	Write(6,*) 'PROB_res'
c	write(6,1302)idx1,(prob_res(idx1,j,sscode(res)),j=1,20)
c	Write(6,*) 'PROB_resmo'
c	write(6,1302) idx1,(prob_resmo(idx1,j,sscode(res-1)),j=1,20)
1302	FORMAT (i4,10i4)
c	WRITE(6,*)'---------'

	return
	end

cccccccccccccccccccccccccccccccccccccc
c
c	random number generator
c
cccccccccccccccccccccccccccccc
      	function randx(iseed)
      	iseed=2045*iseed+1
      	iseed=iseed-(iseed/1048576)*1048576
      	randx= real(iseed+1)/1048577.0
	return
	end
ccccccccccccccccccccccccccccccccccccccccccccc
c
c	round a real to an integer
c
cccccccccccccccccccccccccccccccccccccccccccc
	subroutine ROUND(re,in)
	
	integer in
	real re,dec

	in = int(re)
	dec = re-in
	if (dec.gt.0.5) in=in+1
	
	return
	end


	Subroutine EXTRACT_OLD(NHld,Hld,COld,CACOld,CAld,COCAld,CBld,COCBld)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	extract out the index numbers for old 
c	chemical shift matching
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer old_assn(500)
	integer old_s(500,20)
	integer oldtable(10,20)
	character*100 ofile
	character*5 oldhead(20)

	integer NHld,Hld,COld,CACOld
	integer CAld,COCAld,CBld,COCBld


	Common /old_J/ old_s,old_assn
	Common /matchold/ ofile,oldtable

		do 10 i=1,20
		if (oldtable(1,i).ne.0) then 
				NHld=i
				oldhead(i)=' N   '
				endif
		if (oldtable(2,i).ne.0) then
				Hld=i
				oldhead(i)=' H   '
				endif
		if (oldtable(3,i).ne.0) then
				CACOld=i
				oldhead(i)='CaCO '
				endif
		if (oldtable(4,i).ne.0) then
				COld=i
				oldhead(i)='CO   ' 
				endif
		if (oldtable(5,i).ne.0) then
				CAld=i
				oldhead(i)='Ca   '
				endif
		if (oldtable(6,i).ne.0) then
				COCAld=i
				oldhead(i)='Ca(-)'
				endif
		if (oldtable(7,i).ne.0) then
				CBld=i
				oldhead(i)='Cb   '
				endif
		if (oldtable(8,i).ne.0) then
				COCBld=i
				oldhead(i)='Cb(-)'
				endif
10		enddo


	return
	end

	subroutine BLK_OLD_LOOK (i,j,iolp,NH,H,SFT,NHld,Hld,SFTld,ival)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  	i=oldtable peak index
c	j=current assignment peak index
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer i,j
	integer iolp
	integer NH,H,NHld,Hld
	integer SFT,SFTld
	integer ival
	integer idx1,idx2,idx3
	integer s(500,20)
	integer old_s(500,20),old_assn(500)
	integer ocs_olp(20,0:100)

	Common /jcoups/ s
	Common /old_J/ old_s,old_assn
	Common /oshift_look/ ocs_olp

	ival=0


	if (old_s(i,SFTld).le.0) goto 100
	if (s(j,SFT).le.0) goto 100

	idx1=abs (old_s(i,NHld)-s(j,NH))
	if (idx1.gt.100) idx1=100
	idx2=abs (old_s(i,Hld)-s(j,H))
	if (idx2.gt.100) idx2=100
	idx3=abs (old_s(i,SFTld)-s(j,SFT))
	if (idx3.gt.100) idx3=100



	ival=int((   (ocs_olp(4,idx1)/100.0)*
     +		     (ocs_olp(5,idx2)/100.0)*
     +		  (ocs_olp(iolp,idx3)/100.0))*100)

100	return
	end

ccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c     Build a pdb file
c
cccccccccccccccccccccccccccccccccccccccccccccccccccc

	Subroutine BUILD_PEPTIDE(nres)
c  7/14/2001 J.A. Lukin
c  Construct the PDB file for a polypeptide, including
c  all atoms except backbone Oxygen.
c  NOTE: For Proline, torsion angle PHI = -72.4,
c        CHI1= 29.9, CHI2= -36.4.
c        For other amino acids, all side-chain torsion
c        angles CHI(i)= -60.
c        Side-chain OH hydrogen is included for TYR,
c        but not GLU and ASP.
c        Side-chain SH hydrogen is included for CYS,
c        i.e. CYS is assumed to be reduced.
c        Both side-chain NH hydrogens are included for HIS.
c
c  Internal variables:
c  n_inres(i) is the number of atoms in the i'th residue.
c  res_ln(j) is a character string containing the PDB file
c    line for the j'th atom within the residue.
	character*3 rname(500), rnm
	character*80 res_ln(30)
	character rectype*6, atmname*4, chain*1, resname*3
	integer serno, seqno
	real xx_N(3),xx_Ca(3),xx_CO(3),xx_O(3),xx_NH(3),
     1   xx_Cb(3)
	real xx_Ha1(3),xx_Ha2(3),xx_Ha(3)
	real uu_NH(3),uu_CH1(3),uu_CH2(3),uu_CH(3)
	real xx_N_pre(3), xx_Ca_pre(3),xx_CO_pre(3)
	real x_chi(6)
	real phi(500), psi(500), psi_next(500)
	integer sscode(500),path_len,nres
	integer rtype(500),atmnum(500)
	real x(500),y(500),z(500)
	character*100 path,file_out
c
	parameter(pi=3.14159)
     	parameter (chain= ' ', rectype= 'ATOM  ')
     	parameter (occ= 1.0, bfact= 0.0)
c
     	common /pdb/ atmnum,rname,rtype,x,y,z
     	common /ss/ sscode
     	common /path/ path,path_len
     	common /chi_angles/ x_chi
c
	data r_CON,r_NCa,r_CaCO /1.335,1.449,1.522/
	data r_NH,r_CH,r_OH,r_SH /1.01,1.09,0.96,1.34/
	data alpha_CaCON,alpha_CONCa,alpha_NCaCO 
     1    /116.6,121.8,109.8/
	data alpha_HNCa /119.1/

c
	file_out= path(1:path_len)//'temp.pdb'
	open(unit=11,file=file_out,status='unknown',
     1   form='formatted')
	serno= 0
c
c  Convert angles to radians:
	alpha_CaCON= alpha_CaCON*pi/180.
	alpha_CONCa= alpha_CONCa*pi/180.
	alpha_NCaCO= alpha_NCaCO*pi/180.
	alpha_HNCa= alpha_HNCa*pi/180.
c
c
c  Set up backbone torsion angles.
	do ires= 1, nres
	   if (sscode(ires).eq.3) then
c  Dihedral angles for alpha helix.
	      phi(ires)= -57.*pi/180.
	      psi(ires)= -47.*pi/180.
	   else
c  Dihedral angles for parallel beta strand.
	      phi(ires)= -119.*pi/180.
	      psi(ires)= 113.*pi/180.
	   endif
c  Torsion angle phi is fixed for PRO.
	   if (rname(ires).eq.'PRO') then
	      phi(ires)=-72.4*pi/180.
	   endif
c  PSI for the next residue is needed to calculate
c  coords of carbonyl oxygen.
	   if (ires.lt.nres) then
	      if (sscode(ires+1).eq.3) then
		 psi_next(ires)= -47.*pi/180.
	      else
		 psi_next(ires)= 135.*pi/180.
	      endif
	   else
	      psi_next(ires)= pi
	   endif
	enddo
c
	do ires= 1, nres
c  For the first residue, N is at the origin, CA is on the 
c  x-axis, and CO is in the xy plane.
	   if (ires.eq.1) then
	      do i= 1, 3
		 xx_N(i)= 0.
		 xx_Ca(i)= 0.
		 xx_CO(i)= 0.
		 xx_NH(i)= 0.
	      enddo
	      xx_NH(1)= r_NH*cos(alpha_HNCa)
	      xx_NH(2)= r_NH*sin(alpha_HNCa)
	      xx_Ca(1)= r_NCa
	      xx_CO(1)= r_NCa + r_CaCO*cos(pi-alpha_NCaCO)
	      xx_CO(2)= r_CaCO*sin(pi-alpha_NCaCO)
c  Add Carbonyl Oxygen atom.
	      call add_O(xx_N, xx_Ca, xx_CO, psi_next(ires), 
     1                   xx_O)
	   else
	      omega= pi
c  Construct coordinates of atom N(ires).
	      call construct_atom(xx_N_pre, xx_Ca_pre, 
     1        xx_CO_pre, xx_N, r_CON, alpha_CaCON, psi(ires))
c  Construct coordinates of atom Ca(ires).
	      call construct_atom(xx_Ca_pre, xx_CO_pre, xx_N, 
     1	      xx_Ca, r_NCa, alpha_CONCa, omega)
c  Construct coordinates of atom CO(ires). 
	      call construct_atom(xx_CO_pre, xx_N, xx_Ca, 
     1	      xx_CO, r_CaCO, alpha_NCaCO, phi(ires))
c  Add Carbonyl Oxygen atom.
	      call add_O(xx_N, xx_Ca, xx_CO, psi_next(ires), 
     1                   xx_O)
c  Calculate amide N->H unit vector.
	      call calc_planar1(xx_CO_pre,xx_Ca,xx_N,uu_NH)
c  Construct position of atom NH(ires). 
	      do i= 1, 3
		 xx_NH(i)= r_NH*uu_NH(i)+xx_N(i)
	      enddo
	   endif
c  Write backbone coords to character array res_ln.
	   do i= 1, 30
	      res_ln(i)= ' '
	   enddo
	   seqno= ires
	   resname= rname(ires)
	   serno= serno+1
	   atmname= ' N  '
	   write(res_ln(1),990) rectype,serno,atmname,
     1	   resname,chain,seqno,(xx_N(i), i=1,3),occ,bfact
	   serno= serno+1
	   atmname= ' CA '
	   write(res_ln(2),990) rectype,serno,atmname,
     1	   resname,chain,seqno,(xx_Ca(i), i=1,3),occ,bfact
	   serno= serno+1
	   atmname= ' C  '
	   write(res_ln(3),990) rectype,serno,atmname,
     1	   resname,chain,seqno,(xx_CO(i), i=1,3),occ,bfact
	   serno= serno+1
	   atmname= ' O  '
	   write(res_ln(4),990) rectype,serno,atmname,
     1	   resname,chain,seqno,(xx_O(i), i=1,3),occ,bfact
	   n_inres= 4
c  Write amide proton for residues other than PRO.
	   if (resname.ne.'PRO') then
	      n_inres= n_inres+1
	      serno= serno+1
	      atmname=' H  '
	      write(res_ln(n_inres),990) rectype,serno,atmname,
     1	      resname,chain,seqno,(xx_NH(i), i=1,3),occ,bfact
	   endif
	   if (resname.eq.'GLY') then
c  For GLY, calculate coords of both alpha protons.
	      call calc_tetra2(xx_CO,xx_N,xx_Ca,uu_CH1,uu_CH2)
	      do i= 1, 3
		 xx_Ha1(i)= r_CH*uu_CH1(i)+xx_Ca(i)
		 xx_Ha2(i)= r_CH*uu_CH2(i)+xx_Ca(i)
	      enddo
	      n_inres= n_inres+1
	      serno= serno+1
	      atmname='1HA '
	      write(res_ln(n_inres),990) rectype,serno,atmname,
     1	      resname,chain,seqno,(xx_Ha1(i), i=1,3),occ,bfact
	      n_inres= n_inres+1
	      serno= serno+1
	      atmname='2HA '
	      write(res_ln(n_inres),990) rectype,serno,atmname,
     1	      resname,chain,seqno,(xx_Ha2(i), i=1,3),occ,bfact
	   else
c  For non-GLY, calculate coords of alpha proton, beta carbon.
c  Then call one of 19 subroutines (one per AA) to build the 
c  side-chain.
	      do i= 1, 6
	         x_chi(i)= -60.
	      enddo
c  Sidechain torsion angles are fixed for PRO.
	      if (resname.eq.'PRO') then
	         x_chi(1)= 29.9
	         x_chi(2)= -36.4
	      endif
c  Calculate coords of beta carbon.
	      call calc_Cb(xx_N,xx_Ca,xx_CO,xx_Cb,resname)
c  Calculate coords of alpha proton.
	      call calc_tetra1(xx_CO,xx_N,xx_Cb,xx_Ca,uu_CH)
	      do i= 1, 3
		 xx_Ha(i)= r_CH*uu_CH(i)+xx_Ca(i)
	      enddo
	      n_inres= n_inres+1
	      serno= serno+1
	      atmname=' HA '
	      write(res_ln(n_inres),990) rectype,serno,atmname,
     1	      resname,chain,seqno,(xx_Ha(i), i=1,3),occ,bfact
	      n_inres= n_inres+1
	      serno= serno+1
	      atmname=' CB '
	      write(res_ln(n_inres),990) rectype,serno,atmname,
     1	      resname,chain,seqno,(xx_Cb(i), i=1,3),occ,bfact
	      if (resname.eq.'ALA') then
	         call Alanine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH)
	      else if (resname.eq.'VAL') then
	         call Valine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH)
	      else if (resname.eq.'ILE') then
	         call Isoleucine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH)
	      else if (resname.eq.'LEU') then
	         call Leucine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH)
	      else if (resname.eq.'GLU') then
	         call Glutamate(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH)
	      else if (resname.eq.'ASP') then
	         call Aspartate(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH)
	      else if (resname.eq.'ASN') then
	         call Asparagine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH,r_NH)
	      else if (resname.eq.'GLN') then
	         call Glutamine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH,r_NH)
	      else if (resname.eq.'MET') then
	         call Methionine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH)
	      else if (resname.eq.'LYS') then
	         call Lysine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH,r_NH)
	      else if (resname.eq.'ARG') then
	         call Arginine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH,r_NH)
	      else if (resname.eq.'THR') then
	         call Threonine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH,r_OH)
	      else if (resname.eq.'SER') then
	         call Serine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH,r_OH)
	      else if (resname.eq.'CYS') then
	         call Cysteine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH,r_SH)
	      else if (resname.eq.'PHE') then
	         call Phenylalanine(resname,n_inres,res_ln,
     1             seqno,serno,xx_N,xx_Ca,xx_Cb,r_CH)
	      else if (resname.eq.'TYR') then
	         call Tyrosine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH,r_OH)
	      else if (resname.eq.'HIS') then
	         call Histidine(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH,r_NH)
	      else if (resname.eq.'TRP') then
	         call Tryptophan(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH,r_NH)
	      else if (resname.eq.'PRO') then
	         call Proline(resname,n_inres,res_ln,seqno,
     1             serno,xx_N,xx_Ca,xx_Cb,r_CH)
	      else
	         write(6,*) resname
	         pause 'unrecognized AA type'
	      endif
	   endif
c  Set coords of preceding residue backbone atoms equal to
c  those of current residue.
	   do i_inres= 1, n_inres
	      write(11,900) res_ln(i_inres)
	   enddo
	   do i= 1, 3
	      xx_N_pre(i)= xx_N(i)
	      xx_Ca_pre(i)= xx_Ca(i)
	      xx_CO_pre(i)= xx_CO(i)
	   enddo
c
	enddo
	close(unit=11)
 900	format(A)
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	end
c
c
	subroutine add_O(xx_N, xx_Ca, xx_CO, psi_next, xx_O)
c  Add carbonyl-bonded O atom.  Store its coordinates in
c  array xx_O(*)
	real xx_N(3), xx_Ca(3), xx_CO(3), xx_O(3)
	parameter (r_CO= 1.23, alpha_NCOO= 121.1,
     1	  pi= 3.14159)
c
	psi= psi_next-pi
	r= r_CO
	alpha= alpha_NCOO*pi/180.
	call construct_atom(xx_N, xx_Ca, xx_CO, xx_O, 
     1	  r, alpha, psi)
	return
	end
c
c
	subroutine construct_atom(xx_1, xx_2, xx_3, xx_4, 
     1	  r34, alpha, theta)
c  Construct the coordinates of atom #4 given alpha= 
c  angle(2,3,4) and theta= torsion angle.
	implicit real (A-H,O-Z)
	real xx_1(3), xx_2(3), xx_3(3), xx_4(3), aa(3), dd(3),
     1	  xx(3), rr_12(3), rr_23(3), uu_23(3), uuu(3,3)
c
	call unit_disp(xx_1, xx_2, rr_12)
	call unit_disp(xx_2, xx_3, rr_23)
	call cross_prod(rr_12, rr_23, aa)
	call cross_prod(aa, rr_23, dd)
	call unit_vec(aa)
	call unit_vec(dd)
	do i= 1, 3
	   uu_23(i)= rr_23(i)
	enddo
	call unit_vec(uu_23)
	do i= 1, 3
	   xx(i)= r34*(-cos(alpha)*uu_23(i) + sin(alpha)*dd(i))
	enddo
c  Rotate by torsion angle.
	call calc_rot(uu_23,-theta,uuu)
c  UUU is the rotation matrix.
c  Multiply coordinates of atom 4 by matrix UUU.
	call mult_vec(uuu,xx,xx_4)
	do i= 1, 3
	   xx_4(i)= xx_4(i) + xx_3(i)
	enddo
	return
	end
c
c
	subroutine calc_planar1(xx_CO,xx_Ca,xx_N,uu_NH)
c  Calculate amide N->H unit vector, given coordinates of
c  CO of preceding amino acid, and CA and N of this amino
c  acid.
	real xx_CO(3),xx_N(3),xx_Ca(3),uu_NCO(3),uu_NCa(3),
     1	  uu_NH(3)
	call unit_disp(xx_N,xx_CO,uu_NCO)
	call unit_disp(xx_N,xx_Ca,uu_NCa)
	do i= 1, 3
	   uu_NH(i)= -(uu_NCO(i)+uu_NCa(i))
	enddo
	call unit_vec(uu_NH)
	return
	end
c
c
	subroutine calc_planar2(xx_OD,xx_CB,xx_CG,uu_NH1,uu_NH2)
c  Calculate NH2 N->H unit vectors for Asn side-chain, given 
c  coordinates of OD1, CB, and CG.
	real xx_OD(3),xx_CB(3),xx_CG(3),uu_NH1(3),uu_NH2(3),
     1	  uu_ODCG(3),uu_CBCG(3)
	call unit_disp(xx_OD,xx_CG,uu_ODCG)
	call unit_disp(xx_CB,xx_CG,uu_CBCG)
	do i= 1, 3
	   uu_NH1(i)= uu_ODCG(i)
	   uu_NH2(i)= uu_CBCG(i)
	enddo
	return
	end
c
c
	subroutine calc_tetra1(xx_CO,xx_N,xx_Cb,xx_Ca,uu_CH)
c  Calculate CA->HA unit vector, given coordinates of
c  CO, CB, CA, and N of this amino acid.
	real xx_CO(3),xx_N(3),xx_Ca(3),xx_Cb(3),uu_CaCO(3),
     1	  uu_CaN(3),uu_CaCb(3),uu_CH(3)
	call unit_disp(xx_Ca,xx_CO,uu_CaCO)
	call unit_disp(xx_Ca,xx_N,uu_CaN)
	call unit_disp(xx_Ca,xx_Cb,uu_CaCb)
	do i= 1, 3
	   uu_CH(i)= -(uu_CaCO(i)+uu_CaN(i)+uu_CaCb(i))
	enddo
	call unit_vec(uu_CH)
	return
	end
c
c
	subroutine calc_tetra2(xx_CO,xx_N,xx_Ca,uu_CH1,uu_CH2)
c  Calculate CA->HA unit vectors for Gly, given coordinates of
c  CO, CA, and N of this amino acid.
	real xx_CO(3),xx_N(3),xx_Ca(3),uu_CaCO(3),uu_CaN(3),
     1	  uu_CH1(3),uu_CH2(3),cc(3)
     	parameter(a= 0.86603)
	call unit_disp(xx_Ca,xx_CO,uu_CaCO)
	call unit_disp(xx_Ca,xx_N,uu_CaN)
	call cross_prod(uu_CaCO,uu_CaN,cc)
	do i= 1, 3
	   uu_CH1(i)=  a*cc(i)-0.5*(uu_CaCO(i)+uu_CaN(i))
	   uu_CH2(i)= -a*cc(i)-0.5*(uu_CaCO(i)+uu_CaN(i))
	enddo
	call unit_vec(uu_CH1)
	call unit_vec(uu_CH2)
	return
	end
c
c
	subroutine calc_tetra3(xx_N,xx_CA,xx_CB,uu_CH1,uu_CH2,
     1	  uu_CH3,r_CH)
c  Calculate CB->HB unit vectors for Ala, given coordinates of
c  N, CA, and CB of this amino acid.
	real xx_CA(3),xx_CB(3),xx_N(3),uu_CAN(3),
     1	  uu_CH1(3),uu_CH2(3),uu_CH3(3),xx_CH1(3)
c  Unit vector Cb->Hb1 = -(unit vector Ca->N)
     	call unit_disp(xx_CA,xx_N,uu_CAN)
	do i= 1, 3
	   uu_CH1(i)= -uu_CAN(i)
	   xx_CH1(i)= r_CH*uu_CH1(i)+xx_CB(i)
	enddo
c  Now we have positions of CA, HB1, and CB.  Calculate
c  unit vectors CB->CH2 and CB->CH3
	call calc_tetra2(xx_CA,xx_CH1,xx_CB,uu_CH2,uu_CH3)
	return
	end
c
c
	subroutine calc_tetra4(xx_CG,xx_SD,xx_CE,uu_CHE1,uu_CHE2,
     1	      uu_CHE3,r_CH)
c  Calculate CE->HE unit vectors for Met, given coordinates of
c  CG, SD, and CE of this amino acid.
	real xx_CG(3),xx_SD(3),xx_CE(3),uu_GD(3),uu_DE(3),
     1	  xx_CHE1(3),uu_CHE1(3),uu_CHE2(3),uu_CHE3(3)
c  Atoms 1HE, CE, SD, and CG are coplanar.
	call unit_disp(xx_CG,xx_SD,uu_GD)
	call unit_disp(xx_SD,xx_CE,uu_DE)
	cos_theta= -uu_GD(1)*uu_DE(1)-uu_GD(2)*uu_DE(2)
     1	  -uu_GD(3)*uu_DE(3)
     	sin_theta= sqrt(1.00001-cos_theta**2.)
     	b= (sqrt(8.)*cos_theta/sin_theta+1.)/3.
     	a= (sqrt(8.)*sin_theta-cos_theta)/3.+cos_theta*b
	do i= 1, 3
	   uu_CHE1(i)= a*uu_GD(i)+b*uu_DE(i)
	   xx_CHE1(i)= r_CH*uu_CHE1(i)+xx_CE(i)
	enddo
c  Now we have positions of SD, CHE1, and CE.  Calculate
c  unit vectors CE->CHE2 and CE->CHE3
	call calc_tetra2(xx_SD,xx_CHE1,xx_CE,uu_CHE2,uu_CHE3)
	return
	end
c
c
	subroutine calc_Cb(xx_N,xx_Ca,xx_CO,xx_Cb,resname)
c  Calculate CB coordinates.
	character*3 resname
	real xx_N(3),xx_Ca(3),xx_CO(3),xx_Cb(3)
	real uu_CaN(3), uu_CaCO(3), uu_x(3), uu_y(3), 
     1	  uu_z(3), uu_CaCb(3)
     	parameter (pi= 3.14159)
     	parameter (alpha_tet= 109.471, r_CC= 1.54)
c
	call unit_disp(xx_Ca, xx_N, uu_CaN)
	call unit_disp(xx_Ca, xx_CO, uu_CaCO)
	call cross_prod(uu_CaN, uu_CaCO, uu_x)
	call unit_vec(uu_x)
	do i= 1, 3
	    uu_y(i)= -(uu_CaN(i)+uu_CaCO(i))
	 enddo
	call unit_vec(uu_y)
c  Now uu_x is the unit vector perpendicular to the (N,Ca,CO)
c  plane, and uu_y points in the direction between Ca->Ha and
c  Ca->Cb.
	if (resname .eq. 'PRO') then
c  Construct Ca->Cb unit vector for Proline, using parameters 
c  based on coordinates of PRO 5 of Crambin.
	    call cross_prod(uu_x, uu_y, uu_z)
	    do i= 1, 3
	        uu_CaCb(i)= 0.8083*uu_x(i) + 0.5841*uu_y(i) + 
     1		  0.0751*uu_z(i)
	    enddo
	else
c  For amino acids other than Pro, build Cb in tetrahedral
c  coordination with Ca.
	    alpha= alpha_tet*pi/180.
	    do i= 1, 3
	    	uu_CaCb(i)= sin(alpha/2.)*uu_x(i) + 
     1		  cos(alpha/2.)*uu_y(i)
	    enddo
	endif
	do i= 1, 3
	    xx_Cb(i)= xx_Ca(i)+r_CC*uu_CaCb(i)
	enddo
	return
	end
c
c
	subroutine calc_rot(rotaxis,phi,rotmatrix)
c  Calculate rotation matrix for rotation of phi about given 
c  axis.
	implicit real (A-H,O-Z)
	real rotaxis(3), xxn(3), rotmatrix(3,3)
	r= sqrt(rotaxis(1)**2 + rotaxis(2)**2 + rotaxis(3)**2)
	xxn(1)= rotaxis(1)/r
	xxn(2)= rotaxis(2)/r
	xxn(3)= rotaxis(3)/r
c  Calculate Euler parameters.
	e0= cos(phi/2.)
	e1= xxn(1)*sin(phi/2.)
	e2= xxn(2)*sin(phi/2.)
	e3= xxn(3)*sin(phi/2.)
c  Calculate products of Euler parameters.
	e00= e0*e0
	e01= e0*e1
	e02= e0*e2
	e03= e0*e3
	e11= e1*e1
	e12= e1*e2
	e13= e1*e3
	e22= e2*e2
	e23= e2*e3
	e33= e3*e3
c  Calculate rotation matrix.
	rotmatrix(1,1)= e00+e11-e22-e33
	rotmatrix(1,2)= 2.*(e12+e03)
	rotmatrix(1,3)= 2.*(e13-e02)
	rotmatrix(2,1)= 2.*(e12-e03)
	rotmatrix(2,2)= e00-e11+e22-e33
	rotmatrix(2,3)= 2.*(e23+e01)
	rotmatrix(3,1)= 2.*(e13+e02)
	rotmatrix(3,2)= 2.*(e23-e01)
	rotmatrix(3,3)= e00-e11-e22+e33
	return
	end
c
c
	subroutine mult_vec(aa,xx,yy)
c  Multiply vector xx by matrix aa, store in yy.
	implicit real (A-H,O-Z)
	real aa(3,3), xx(3), yy(3)
c
	do i= 1, 3
	   yy(i)= 0
	enddo
	do i= 1, 3
	   do j= 1, 3
	      yy(i)= yy(i)+aa(i,j)*xx(j)
	   enddo
	enddo
	return
	end
c
c
	subroutine unit_disp(aa,bb,cc)
c  Let cc= unit vector of displacement from aa to bb.
	implicit real (A-H,O-Z)
	real aa(3), bb(3), cc(3)
c
	do i= 1, 3
	   cc(i)= bb(i)-aa(i)
	enddo
	r= sqrt(cc(1)**2+cc(2)**2+cc(3)**2)
	if (r .gt. 0.) then
	   do i= 1, 3
	      cc(i)= cc(i)/r
	   enddo
	endif
	return
	end
c
c
	subroutine unit_vec(aa)
c  Replace vector aa with unit vector.
	implicit real (A-H,O-Z)
	real aa(3)
c
	r= sqrt(aa(1)**2+aa(2)**2+aa(3)**2)
	if (r .gt. 0.) then
	   do i= 1, 3
	      aa(i)= aa(i)/r
	   enddo
	endif
	return
	end
c
c
	subroutine cross_prod(aa,bb,cc)
c  Let cc= cross product of vectors aa, bb.
	implicit real (A-H,O-Z)
	real aa(3), bb(3), cc(3)
c
	cc(1)= aa(2)*bb(3)-bb(2)*aa(3)
	cc(2)= -aa(1)*bb(3)+bb(1)*aa(3)
	cc(3)= aa(1)*bb(2)-bb(1)*aa(2)
	return
	end
c
c
	subroutine open_file(iunit,filename)
c  Open a new file with the given unit number.  If the
c  file already exists, delete it first.
	character*(*) filename
	logical file_exists
	inquire (file= filename, exist= file_exists)
	if (file_exists) then
	    open(unit= iunit, file= filename, status='old',
     1	      form= 'formatted')
     	    close(unit= iunit, status= 'delete')
     	endif
	open(unit= iunit, file= filename, status='new',
     1	  form= 'formatted')
     	return
     	end
c
c
	subroutine Alanine(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real uu_CH1(3),uu_CH2(3),uu_CH3(3),xx_HB1(3),xx_HB2(3),xx_HB3(3)
	integer seqno,serno,n_inres
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
c  Calculate CB->HB unit vectors.
	call calc_tetra3(xx_N,xx_CA,xx_CB,uu_CH1,uu_CH2,uu_CH3,r_CH)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CH1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CH2(i)+xx_CB(i)
	   xx_HB3(i)= r_CH*uu_CH3(i)+xx_CB(i)
	enddo
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,'3HB ',
     1	 resname,chain,seqno,(xx_HB3(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+3
	n_inres= n_inres+3
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Valine(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG1(3), xx_CG2(3)
	real uu_CHB(3),xx_HB(3)
	real uu_CHG11(3),uu_CHG12(3),uu_CHG13(3)
	real xx_HG11(3),xx_HG12(3),xx_HG13(3)
	real uu_CHG21(3),uu_CHG22(3),uu_CHG23(3)
	real xx_HG21(3),xx_HG22(3),xx_HG23(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
     	parameter (alpha_tet= 109.471, r_CC= 1.54)
     	common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha= alpha_tet*pi/180.
	r= r_CC
c
c  Construct the coordinates of atom CG1.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG1, 
     1	  r, alpha, chi)
c  Construct the coordinates of atom CG2.
	chi= (x_chi(1)+120.)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG2, 
     1	  r, alpha, chi)
c
c  Calculate CB->HB unit vector.
	call calc_tetra1(xx_CG1,xx_CG2,xx_CA,xx_CB,uu_CHB)
	do i= 1, 3
	   xx_HB(i)= r_CH*uu_CHB(i)+xx_CB(i)
	enddo
c  Calculate CG1->HG1 unit vectors.
	call calc_tetra3(xx_CA,xx_CB,xx_CG1,uu_CHG11,
     1	uu_CHG12,uu_CHG13,r_CH)
	do i= 1, 3
	   xx_HG11(i)= r_CH*uu_CHG11(i)+xx_CG1(i)
	   xx_HG12(i)= r_CH*uu_CHG12(i)+xx_CG1(i)
	   xx_HG13(i)= r_CH*uu_CHG13(i)+xx_CG1(i)
	enddo
c  Calculate CG2->HG2 unit vectors.
	call calc_tetra3(xx_CA,xx_CB,xx_CG2,uu_CHG21,
     1	uu_CHG22,uu_CHG23,r_CH)
	do i= 1, 3
	   xx_HG21(i)= r_CH*uu_CHG21(i)+xx_CG2(i)
	   xx_HG22(i)= r_CH*uu_CHG22(i)+xx_CG2(i)
	   xx_HG23(i)= r_CH*uu_CHG23(i)+xx_CG2(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG1',
     1	  resname,chain,seqno,(xx_CG1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' CG2',
     1	  resname,chain,seqno,(xx_CG2(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+3),990) rectype,serno+3,' HB ',
     1	 resname,chain,seqno,(xx_HB(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,'1HG1',
     1	 resname,chain,seqno,(xx_HG11(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,'2HG1',
     1	 resname,chain,seqno,(xx_HG12(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,'3HG1',
     1	 resname,chain,seqno,(xx_HG13(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,'1HG2',
     1	 resname,chain,seqno,(xx_HG21(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+8),990) rectype,serno+8,'2HG2',
     1	 resname,chain,seqno,(xx_HG22(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+9),990) rectype,serno+9,'3HG2',
     1	 resname,chain,seqno,(xx_HG23(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+9
	n_inres= n_inres+9
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Isoleucine(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG1(3),xx_CG2(3),xx_CD(3)
	real uu_CHB(3),xx_HB(3)
	real uu_CHG1(3),xx_HG11(3),uu_CHG2(3),xx_HG12(3)
	real uu_CHG3(3),xx_HG21(3),xx_HG22(3),xx_HG23(3)
	real uu_CHD1(3),uu_CHD2(3),uu_CHD3(3)
	real xx_HD1(3),xx_HD2(3),xx_HD3(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
     	parameter (alpha_tet= 109.471, r_CC= 1.54)
     	common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha= alpha_tet*pi/180.
	r= r_CC
c  Construct the coordinates of atom CG1.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG1, 
     1	  r, alpha, chi)
c  Construct the coordinates of atom CG2.
	chi= (x_chi(1)+120.)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG2, 
     1	  r, alpha, chi)
c  Construct the coordinates of atom CD.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG1, xx_CD, 
     1	  r, alpha, chi)
c
c  Calculate CB->HB unit vector.
	call calc_tetra1(xx_CG1,xx_CG2,xx_CA,xx_CB,uu_CHB)
	do i= 1, 3
	   xx_HB(i)= r_CH*uu_CHB(i)+xx_CB(i)
	enddo
c  Calculate CG1->HG1 unit vectors.
	call calc_tetra2(xx_CB,xx_CD,xx_CG1,uu_CHG1,uu_CHG2)
	do i= 1, 3
	   xx_HG11(i)= r_CH*uu_CHG1(i)+xx_CG1(i)
	   xx_HG12(i)= r_CH*uu_CHG2(i)+xx_CG1(i)
	enddo
c  Calculate CG2->HG2 unit vectors.
	call calc_tetra3(xx_CA,xx_CB,xx_CG2,uu_CHG1,
     1	  uu_CHG2,uu_CHG3,r_CH)
	do i= 1, 3
	   xx_HG21(i)= r_CH*uu_CHG1(i)+xx_CG2(i)
	   xx_HG22(i)= r_CH*uu_CHG2(i)+xx_CG2(i)
	   xx_HG23(i)= r_CH*uu_CHG3(i)+xx_CG2(i)
	enddo
c  Calculate CD->HD unit vectors.
	call calc_tetra3(xx_CB,xx_CG1,xx_CD,uu_CHD1,
     1	  uu_CHD2,uu_CHD3,r_CH)
	do i= 1, 3
	   xx_HD1(i)= r_CH*uu_CHD1(i)+xx_CD(i)
	   xx_HD2(i)= r_CH*uu_CHD2(i)+xx_CD(i)
	   xx_HD3(i)= r_CH*uu_CHD3(i)+xx_CD(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG1',
     1	  resname,chain,seqno,(xx_CG1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' CG2',
     1	  resname,chain,seqno,(xx_CG2(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' CD1',
     1	  resname,chain,seqno,(xx_CD(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+4),990) rectype,serno+4,' HB ',
     1	 resname,chain,seqno,(xx_HB(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,'1HG1',
     1	 resname,chain,seqno,(xx_HG11(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,'2HG1',
     1	 resname,chain,seqno,(xx_HG12(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,'1HG2',
     1	 resname,chain,seqno,(xx_HG21(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+8),990) rectype,serno+8,'2HG2',
     1	 resname,chain,seqno,(xx_HG22(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+9),990) rectype,serno+9,'3HG2',
     1	 resname,chain,seqno,(xx_HG23(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+10),990) rectype,serno+10,'1HD1',
     1	 resname,chain,seqno,(xx_HD1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+11),990) rectype,serno+11,'2HD1',
     1	 resname,chain,seqno,(xx_HD2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+12),990) rectype,serno+12,'3HD1',
     1	 resname,chain,seqno,(xx_HD3(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+12
	n_inres= n_inres+12
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Leucine(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_CD1(3),xx_CD2(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_CHG(3),xx_HG(3)
	real uu_CHD1(3),uu_CHD2(3),uu_CHD3(3)
	real xx_HD11(3),xx_HD12(3),xx_HD13(3)
	real xx_HD21(3),xx_HD22(3),xx_HD23(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
     	parameter (alpha_tet= 109.471, r_CC= 1.54)
     	common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha= alpha_tet*pi/180.
	r= r_CC
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r, alpha, chi)
c  Construct the coordinates of atom CD1.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD1, 
     1	  r, alpha, chi)
c  Construct the coordinates of atom CD2.
	chi= (x_chi(2)+120.)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD2, 
     1	  r, alpha, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Calculate CG->HG unit vector.
	call calc_tetra1(xx_CB,xx_CD1,xx_CD2,xx_CG,uu_CHG)
	do i= 1, 3
	   xx_HG(i)= r_CH*uu_CHG(i)+xx_CG(i)
	enddo
c  Calculate CD1->HD1 unit vectors.
	call calc_tetra3(xx_CB,xx_CG,xx_CD1,uu_CHD1,
     1	      uu_CHD2,uu_CHD3,r_CH)
	do i= 1, 3
	   xx_HD11(i)= r_CH*uu_CHD1(i)+xx_CD1(i)
	   xx_HD12(i)= r_CH*uu_CHD2(i)+xx_CD1(i)
	   xx_HD13(i)= r_CH*uu_CHD3(i)+xx_CD1(i)
	enddo
c  Calculate CD2->HD2 unit vectors.
	call calc_tetra3(xx_CB,xx_CG,xx_CD2,uu_CHD1,
     1	      uu_CHD2,uu_CHD3,r_CH)
	do i= 1, 3
	   xx_HD21(i)= r_CH*uu_CHD1(i)+xx_CD2(i)
	   xx_HD22(i)= r_CH*uu_CHD2(i)+xx_CD2(i)
	   xx_HD23(i)= r_CH*uu_CHD3(i)+xx_CD2(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' CD1',
     1	  resname,chain,seqno,(xx_CD1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' CD2',
     1	  resname,chain,seqno,(xx_CD2(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+4),990) rectype,serno+4,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,' HG ',
     1	 resname,chain,seqno,(xx_HG(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,'1HD1',
     1	 resname,chain,seqno,(xx_HD11(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+8),990) rectype,serno+8,'2HD1',
     1	 resname,chain,seqno,(xx_HD12(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+9),990) rectype,serno+9,'3HD1',
     1	 resname,chain,seqno,(xx_HD13(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+10),990) rectype,serno+10,'1HD2',
     1	 resname,chain,seqno,(xx_HD21(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+11),990) rectype,serno+11,'2HD2',
     1	 resname,chain,seqno,(xx_HD22(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+12),990) rectype,serno+12,'3HD2',
     1	 resname,chain,seqno,(xx_HD23(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+12
	n_inres= n_inres+12
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Glutamate(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_CD(3),xx_OE1(3),xx_OE2(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_CHG1(3),uu_CHG2(3),xx_HG1(3),xx_HG2(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
     	parameter (alpha_tet= 109.471, alpha_CCO= 120.0, 
     1	  r_CC= 1.54, r_CO= 1.26)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha1= alpha_tet*pi/180.
	alpha2= alpha_CCO*pi/180.
	r1= r_CC
	r2= r_CO
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r1, alpha1, chi)
c  Construct the coordinates of atom CD.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD, 
     1	  r1, alpha1, chi)
c  Construct the coordinates of atom OE1.
	chi= x_chi(3)*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD, xx_OE1, 
     1	  r2, alpha2, chi)
c  Construct the coordinates of atom OE2.
	chi= (x_chi(3)+180.)*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD, xx_OE2, 
     1	  r2, alpha2, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Calculate CG->HG unit vectors.
	call calc_tetra2(xx_CB,xx_CD,xx_CG,uu_CHG1,uu_CHG2)
	do i= 1, 3
	   xx_HG1(i)= r_CH*uu_CHG1(i)+xx_CG(i)
	   xx_HG2(i)= r_CH*uu_CHG2(i)+xx_CG(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' CD ',
     1	  resname,chain,seqno,(xx_CD(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' OE1',
     1	  resname,chain,seqno,(xx_OE1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,' OE2',
     1	  resname,chain,seqno,(xx_OE2(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+5),990) rectype,serno+5,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,'1HG ',
     1	 resname,chain,seqno,(xx_HG1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+8),990) rectype,serno+8,'2HG ',
     1	 resname,chain,seqno,(xx_HG2(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+8
	n_inres= n_inres+8
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Aspartate(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_OD1(3),xx_OD2(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
     	parameter (alpha_tet= 109.471, alpha_CCO= 120.0, 
     1	  r_CC= 1.54, r_CO= 1.26)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha1= alpha_tet*pi/180.
	alpha2= alpha_CCO*pi/180.
	r1= r_CC
	r2= r_CO
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r1, alpha1, chi)
c  Construct the coordinates of atom OD1.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_OD1, 
     1	  r2, alpha2, chi)
c  Construct the coordinates of atom OE2.
	chi= (x_chi(2)+180.)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_OD2, 
     1	  r2, alpha2, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' OD1',
     1	  resname,chain,seqno,(xx_OD1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' OD2',
     1	  resname,chain,seqno,(xx_OD2(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+4),990) rectype,serno+4,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+5
	n_inres= n_inres+5
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Asparagine(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH,r_NH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_OD1(3),xx_ND2(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_NHD1(3),uu_NHD2(3),xx_HD1(3),xx_HD2(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha_tet= 109.471*pi/180.
	alpha_CCN= 114.0*pi/180.
	alpha_CCO= 122.0*pi/180.
	r_CC= 1.54
	r_CO= 1.22
	r_CN= 1.33
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r_CC, alpha_tet, chi)
c  Construct the coordinates of atom OD1.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_OD1, 
     1	  r_CO, alpha_CCO, chi)
c  Construct the coordinates of atom ND2.
	chi= (x_chi(2)+180.)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_ND2, 
     1	  r_CN, alpha_CCN, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Calculate ND2->HD unit vectors.
	call calc_planar2(xx_OD1,xx_CB,xx_CG,uu_NHD1,uu_NHD2)
	do i= 1, 3
	   xx_HD1(i)= r_NH*uu_NHD1(i)+xx_ND2(i)
	   xx_HD2(i)= r_NH*uu_NHD2(i)+xx_ND2(i)
	enddo

c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' OD1',
     1	  resname,chain,seqno,(xx_OD1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' ND2',
     1	  resname,chain,seqno,(xx_ND2(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+4),990) rectype,serno+4,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,'1HD2',
     1	 resname,chain,seqno,(xx_HD1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,'2HD2',
     1	 resname,chain,seqno,(xx_HD2(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+7
	n_inres= n_inres+7
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Glutamine(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH,r_NH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_CD(3),xx_OE1(3),xx_NE2(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_CHG1(3),uu_CHG2(3),xx_HG1(3),xx_HG2(3)
	real uu_NHE1(3),uu_NHE2(3),xx_HE1(3),xx_HE2(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha_tet= 109.471*pi/180.
	alpha_CCN= 114.0*pi/180.
	alpha_CCO= 122.0*pi/180.
	r_CC= 1.54
	r_CO= 1.22
	r_CN= 1.33
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r_CC, alpha_tet, chi)
c  Construct the coordinates of atom CD.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD, 
     1	  r_CC, alpha_tet, chi)
c  Construct the coordinates of atom OE1.
	chi= x_chi(3)*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD, xx_OE1, 
     1	  r_CO, alpha_CCO, chi)
c  Construct the coordinates of atom NE2.
	chi= (x_chi(3)+180.)*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD, xx_NE2, 
     1	  r_CN, alpha_CCN, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Calculate CG->HG unit vectors.
	call calc_tetra2(xx_CB,xx_CD,xx_CG,uu_CHG1,uu_CHG2)
	do i= 1, 3
	   xx_HG1(i)= r_CH*uu_CHG1(i)+xx_CG(i)
	   xx_HG2(i)= r_CH*uu_CHG2(i)+xx_CG(i)
	enddo
c  Calculate NE2->HE unit vectors.
	call calc_planar2(xx_OE1,xx_CG,xx_CD,uu_NHE1,uu_NHE2)
	do i= 1, 3
	   xx_HE1(i)= r_NH*uu_NHE1(i)+xx_NE2(i)
	   xx_HE2(i)= r_NH*uu_NHE2(i)+xx_NE2(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' CD ',
     1	  resname,chain,seqno,(xx_CD(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' OE1',
     1	  resname,chain,seqno,(xx_OE1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,' NE2',
     1	  resname,chain,seqno,(xx_NE2(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+5),990) rectype,serno+5,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,'1HG ',
     1	 resname,chain,seqno,(xx_HG1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+8),990) rectype,serno+8,'2HG ',
     1	 resname,chain,seqno,(xx_HG2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+9),990) rectype,serno+9,'1HE2',
     1	 resname,chain,seqno,(xx_HE1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+10),990) rectype,serno+10,'2HE2',
     1	 resname,chain,seqno,(xx_HE2(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+10
	n_inres= n_inres+10
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Methionine(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_SD(3),xx_CE(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_CHG1(3),uu_CHG2(3),xx_HG1(3),xx_HG2(3)
	real uu_CHE1(3),uu_CHE2(3),uu_CHE3(3)
	real xx_HE1(3),xx_HE2(3),xx_HE3(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
     	parameter (alpha_tet= 109.471, alpha_CSC= 100.0, 
     1	  r_CS= 1.785, r_CC= 1.54)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha1= alpha_tet*pi/180.
	r1= r_CC
	alpha2= alpha_CSC*pi/180.
	r2= r_CS
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r1, alpha1, chi)
c  Construct the coordinates of atom SD.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_SD, 
     1	  r2, alpha2, chi)
c  Construct the coordinates of atom CE.
	chi= x_chi(3)*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_SD, xx_CE, 
     1	  r2, alpha2, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Calculate CG->HG unit vectors.
	call calc_tetra2(xx_CB,xx_SD,xx_CG,uu_CHG1,uu_CHG2)
	do i= 1, 3
	   xx_HG1(i)= r_CH*uu_CHG1(i)+xx_CG(i)
	   xx_HG2(i)= r_CH*uu_CHG2(i)+xx_CG(i)
	enddo
c  Calculate CE->HE unit vectors.
	call calc_tetra4(xx_CG,xx_SD,xx_CE,uu_CHE1,uu_CHE2,
     1	      uu_CHE3,r_CH)
	do i= 1, 3
	   xx_HE1(i)= r_CH*uu_CHE1(i)+xx_CE(i)
	   xx_HE2(i)= r_CH*uu_CHE2(i)+xx_CE(i)
	   xx_HE3(i)= r_CH*uu_CHE3(i)+xx_CE(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' SD ',
     1	  resname,chain,seqno,(xx_SD(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' CE ',
     1	  resname,chain,seqno,(xx_CE(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+4),990) rectype,serno+4,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,'1HG ',
     1	 resname,chain,seqno,(xx_HG1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,'2HG ',
     1	 resname,chain,seqno,(xx_HG2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+8),990) rectype,serno+8,'1HE ',
     1	 resname,chain,seqno,(xx_HE1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+9),990) rectype,serno+9,'2HE ',
     1	 resname,chain,seqno,(xx_HE2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+10),990) rectype,serno+10,'3HE ',
     1	 resname,chain,seqno,(xx_HE3(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+10
	n_inres= n_inres+10
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Lysine(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH,r_NH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_CD(3),xx_CE(3),xx_NZ(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_CHG1(3),uu_CHG2(3),xx_HG1(3),xx_HG2(3)
	real uu_CHD1(3),uu_CHD2(3),xx_HD1(3),xx_HD2(3)
	real uu_CHE1(3),uu_CHE2(3),xx_HE1(3),xx_HE2(3)
	real uu_NHZ1(3),uu_NHZ2(3),uu_NHZ3(3)
	real xx_HZ1(3),xx_HZ2(3),xx_HZ3(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
     	parameter (alpha_tet= 109.471, alpha_CCN= 110.5, 
     1	  r_CN= 1.48, r_CC= 1.54)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha1= alpha_tet*pi/180.
	r1= r_CC
	alpha2= alpha_CCN*pi/180.
	r2= r_CN
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r1, alpha1, chi)
c  Construct the coordinates of atom CD.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD, 
     1	  r1, alpha1, chi)
c  Construct the coordinates of atom CE.
	chi= x_chi(3)*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD, xx_CE, 
     1	  r1, alpha1, chi)
c  Construct the coordinates of atom NZ.
	chi= x_chi(4)*pi/180.
	call construct_atom(xx_CG, xx_CD, xx_CE, xx_NZ, 
     1	  r2, alpha2, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Calculate CG->HG unit vectors.
	call calc_tetra2(xx_CB,xx_CD,xx_CG,uu_CHG1,uu_CHG2)
	do i= 1, 3
	   xx_HG1(i)= r_CH*uu_CHG1(i)+xx_CG(i)
	   xx_HG2(i)= r_CH*uu_CHG2(i)+xx_CG(i)
	enddo
c  Calculate CD->HD unit vectors.
	call calc_tetra2(xx_CG,xx_CE,xx_CD,uu_CHD1,uu_CHD2)
	do i= 1, 3
	   xx_HD1(i)= r_CH*uu_CHD1(i)+xx_CD(i)
	   xx_HD2(i)= r_CH*uu_CHD2(i)+xx_CD(i)
	enddo
c  Calculate CE->HE unit vectors.
	call calc_tetra2(xx_CD,xx_NZ,xx_CE,uu_CHE1,uu_CHE2)
	do i= 1, 3
	   xx_HE1(i)= r_CH*uu_CHE1(i)+xx_CE(i)
	   xx_HE2(i)= r_CH*uu_CHE2(i)+xx_CE(i)
	enddo
c  Add zeta protons.
c  Calculate NZ->HZ unit vectors.
	call calc_tetra3(xx_CD,xx_CE,xx_NZ,uu_NHZ1,
     1	uu_NHZ2,uu_NHZ3,r_NH)
	do i= 1, 3
	   xx_HZ1(i)= r_NH*uu_NHZ1(i)+xx_NZ(i)
	   xx_HZ2(i)= r_NH*uu_NHZ2(i)+xx_NZ(i)
	   xx_HZ3(i)= r_NH*uu_NHZ3(i)+xx_NZ(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' CD ',
     1	  resname,chain,seqno,(xx_CD(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' CE ',
     1	  resname,chain,seqno,(xx_CE(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,' NZ ',
     1	  resname,chain,seqno,(xx_NZ(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+5),990) rectype,serno+5,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,'1HG ',
     1	 resname,chain,seqno,(xx_HG1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+8),990) rectype,serno+8,'2HG ',
     1	 resname,chain,seqno,(xx_HG2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+9),990) rectype,serno+9,'1HD ',
     1	 resname,chain,seqno,(xx_HD1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+10),990) rectype,serno+10,'2HD ',
     1	 resname,chain,seqno,(xx_HD2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+11),990) rectype,serno+11,'1HE ',
     1	 resname,chain,seqno,(xx_HE1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+12),990) rectype,serno+12,'2HE ',
     1	 resname,chain,seqno,(xx_HE2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+13),990) rectype,serno+13,'1HZ ',
     1	 resname,chain,seqno,(xx_HZ1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+14),990) rectype,serno+14,'2HZ ',
     1	 resname,chain,seqno,(xx_HZ2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+15),990) rectype,serno+15,'3HZ ',
     1	 resname,chain,seqno,(xx_HZ3(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+15
	n_inres= n_inres+15
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Arginine(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH,r_NH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_CD(3),xx_NE(3),xx_CZ(3),xx_NH1(3),xx_NH2(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_CHG1(3),uu_CHG2(3),xx_HG1(3),xx_HG2(3)
	real uu_CHD1(3),uu_CHD2(3),xx_HD1(3),xx_HD2(3)
	real uu_NHE(3),xx_HE(3)
	real uu_NHH11(3),uu_NHH12(3),xx_HH11(3),xx_HH12(3)
	real uu_NHH21(3),uu_NHH22(3),xx_HH21(3),xx_HH22(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
     	parameter (alpha_tet= 109.471, r_CN= 1.35, r_NC= 1.35, 
     1	  r_CC= 1.54)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha1= alpha_tet*pi/180.
	r1= r_CC
	r2= r_CN
	r3= r_NC
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r1, alpha1, chi)
c  Construct the coordinates of atom CD.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD, 
     1	  r1, alpha1, chi)
c  Construct the coordinates of atom NE.
	chi= x_chi(3)*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD, xx_NE, 
     1	  r2, alpha1, chi)
c  Construct the coordinates of atom CZ.
	chi= x_chi(4)*pi/180.
	call construct_atom(xx_CG, xx_CD, xx_NE, xx_CZ, 
     1	  r2, alpha1, chi)
c  Construct the coordinates of atom NH1.
	chi= x_chi(5)*pi/180.
	call construct_atom(xx_CD, xx_NE, xx_CZ, xx_NH1,
     1	  r3, alpha1, chi)
c  Construct the coordinates of atom NH2.
	chi= (x_chi(5)+180.)*pi/180.
	call construct_atom(xx_CD, xx_NE, xx_CZ, xx_NH2, 
     1	  r3, alpha1, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Calculate CG->HG unit vectors.
	call calc_tetra2(xx_CB,xx_CD,xx_CG,uu_CHG1,uu_CHG2)
	do i= 1, 3
	   xx_HG1(i)= r_CH*uu_CHG1(i)+xx_CG(i)
	   xx_HG2(i)= r_CH*uu_CHG2(i)+xx_CG(i)
	enddo
c  Calculate CD->HD unit vectors.
	call calc_tetra2(xx_CG,xx_NE,xx_CD,uu_CHD1,uu_CHD2)
	do i= 1, 3
	   xx_HD1(i)= r_CH*uu_CHD1(i)+xx_CD(i)
	   xx_HD2(i)= r_CH*uu_CHD2(i)+xx_CD(i)
	enddo
c  Calculate NE->HE unit vector.
	call calc_planar1(xx_CD,xx_CZ,xx_NE,uu_NHE)
	do i= 1, 3
	   xx_HE(i)= r_NH*uu_NHE(i)+xx_NE(i)
	enddo
c  Add eta 1 protons.
c  Calculate NH1->HH1 unit vectors.
	call calc_planar2(xx_NE,xx_NH2,xx_CZ,uu_NHH11,
     1	uu_NHH12)
	do i= 1, 3
	   xx_HH11(i)= r_NH*uu_NHH11(i)+xx_NH1(i)
	   xx_HH12(i)= r_NH*uu_NHH12(i)+xx_NH1(i)
	enddo
c  Add eta 2 protons.
c  Calculate NH2->HH2 unit vectors.
	call calc_planar2(xx_NE,xx_NH1,xx_CZ,uu_NHH21,
     1	uu_NHH22)
	do i= 1, 3
	   xx_HH21(i)= r_NH*uu_NHH21(i)+xx_NH2(i)
	   xx_HH22(i)= r_NH*uu_NHH22(i)+xx_NH2(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' CD ',
     1	  resname,chain,seqno,(xx_CD(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' NE ',
     1	  resname,chain,seqno,(xx_NE(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,' CZ ',
     1	  resname,chain,seqno,(xx_CZ(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,' NH1',
     1	  resname,chain,seqno,(xx_NH1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,' NH2',
     1	  resname,chain,seqno,(xx_NH2(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+7),990) rectype,serno+7,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+8),990) rectype,serno+8,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+9),990) rectype,serno+9,'1HG ',
     1	 resname,chain,seqno,(xx_HG1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+10),990) rectype,serno+10,'2HG ',
     1	 resname,chain,seqno,(xx_HG2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+11),990) rectype,serno+11,'1HD ',
     1	 resname,chain,seqno,(xx_HD1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+12),990) rectype,serno+12,'2HD ',
     1	 resname,chain,seqno,(xx_HD2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+13),990) rectype,serno+13,' HE ',
     1	 resname,chain,seqno,(xx_HE(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+14),990) rectype,serno+14,'1HH1',
     1	 resname,chain,seqno,(xx_HH11(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+15),990) rectype,serno+15,'2HH1',
     1	 resname,chain,seqno,(xx_HH12(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+16),990) rectype,serno+16,'1HH2',
     1	 resname,chain,seqno,(xx_HH21(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+17),990) rectype,serno+17,'2HH2',
     1	 resname,chain,seqno,(xx_HH22(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+17
	n_inres= n_inres+17
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Threonine(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH,r_OH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_OG1(3),xx_CG2(3)
	real uu_CHB(3),xx_HB(3)
	real uu_OHG(3)
	real uu_CHG1(3),uu_CHG2(3),uu_CHG3(3)
	real xx_HG11(3),xx_HG21(3),xx_HG22(3),xx_HG23(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
     	alpha_tet= 109.471*pi/180.
     	alpha_CCO= 104.1*pi/180.
     	r_CC= 1.54
     	r_CO= 1.425
c
c  Construct the coordinates of atom OG1.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_OG1, 
     1	  r_CO, alpha_CCO, chi)
c  Construct the coordinates of atom CG2.
	chi= (x_chi(1)-120.)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG2, 
     1	  r_CC, alpha_tet, chi)
c
c  Calculate CB->HB unit vector.
	call calc_tetra1(xx_OG1,xx_CG2,xx_CA,xx_CB,uu_CHB)
	do i= 1, 3
	   xx_HB(i)= r_CH*uu_CHB(i)+xx_CB(i)
	enddo
c  Add gamma1 proton.
c  Assume vector from OG1 to HG2 is parallel to vector from 
c  CA to CB. 
	call unit_disp(xx_CA,xx_CB,uu_OHG)
c  Calculate CG1->HG1 unit vector.
	do i= 1, 3
	   xx_HG11(i)= r_OH*uu_OHG(i)+xx_OG1(i)
	enddo
c  Add gamma2 protons.
c  Calculate CG2->HG2 unit vectors.
	call calc_tetra3(xx_CA,xx_CB,xx_CG2,uu_CHG1,
     1    uu_CHG2,uu_CHG3,r_CH)
	do i= 1, 3
	   xx_HG21(i)= r_CH*uu_CHG1(i)+xx_CG2(i)
	   xx_HG22(i)= r_CH*uu_CHG2(i)+xx_CG2(i)
	   xx_HG23(i)= r_CH*uu_CHG3(i)+xx_CG2(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' OG1',
     1	  resname,chain,seqno,(xx_OG1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' CG2',
     1	  resname,chain,seqno,(xx_CG2(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+3),990) rectype,serno+3,' HB ',
     1	 resname,chain,seqno,(xx_HB(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,' HG1',
     1	 resname,chain,seqno,(xx_HG11(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,'1HG2',
     1	 resname,chain,seqno,(xx_HG21(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,'2HG2',
     1	 resname,chain,seqno,(xx_HG22(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,'3HG2',
     1	 resname,chain,seqno,(xx_HG23(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+7
	n_inres= n_inres+7
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Serine(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH,r_OH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_OG(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_OHG(3),xx_HG(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
     	parameter (alpha_CCO= 112.0, r_CO= 1.425)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha= alpha_CCO*pi/180.
	r= r_CO
c  Construct the coordinates of atom OG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_OG, 
     1	  r, alpha, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_OG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Add gamma proton.
c  Assume vector from OG1 to HG2 is parallel to vector from 
c  CA to CB. 
	call unit_disp(xx_CA,xx_CB,uu_OHG)
c  Calculate CG1->HG1 unit vectors.
	do i= 1, 3
	   xx_HG(i)= r_OH*uu_OHG(i)+xx_OG(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' OG ',
     1	  resname,chain,seqno,(xx_OG(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+2),990) rectype,serno+2,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,' HG ',
     1	 resname,chain,seqno,(xx_HG(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+4
	n_inres= n_inres+4
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Cysteine(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH,r_SH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_SG(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_SHG(3),xx_HG(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
     	parameter (alpha_CCS= 110.0, r_CS= 1.83)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha= alpha_CCS*pi/180.
	r= r_CS
c  Construct the coordinates of atom SG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_SG, 
     1	  r, alpha, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_SG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Add gamma proton.
c  Assume vector from SG1 to HG is parallel to vector from 
c  CA to CB. 
	call unit_disp(xx_CA,xx_CB,uu_SHG)
c  Calculate SG1->HG1 unit vectors.
	do i= 1, 3
	   xx_HG(i)= r_SH*uu_SHG(i)+xx_SG(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' SG ',
     1	  resname,chain,seqno,(xx_SG(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+2),990) rectype,serno+2,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,' HG ',
     1	 resname,chain,seqno,(xx_HG(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+4
	n_inres= n_inres+4
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Phenylalanine(resname,n_inres,res_ln,seqno,
     1    serno,xx_N,xx_CA,xx_CB,r_CH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_CD1(3),xx_CD2(3),xx_CE1(3),xx_CE2(3),
     1   xx_CZ(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_CHD1(3),uu_CHD2(3),xx_HD1(3),xx_HD2(3)
	real uu_CHE1(3),uu_CHE2(3),xx_HE1(3),xx_HE2(3)
	real uu_CHZ(3),xx_HZ(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha_tet= 109.471*pi/180.
	alpha_CCC= 120.0*pi/180.
	r_CC= 1.54
	r_CC2= 1.39
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r_CC, alpha_tet, chi)
c  Construct the coordinates of atom CD1.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD1, 
     1	  r_CC2, alpha_CCC, chi)
c  Construct the coordinates of atom CD2.
	chi= (x_chi(2)+180.)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD2, 
     1	  r_CC2, alpha_CCC, chi)
c  Construct the coordinates of atom CE1.
	chi= 180.*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD1, xx_CE1, 
     1	  r_CC2, alpha_CCC, chi)
c  Construct the coordinates of atom CE2.
	chi= 180.*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD2, xx_CE2, 
     1	  r_CC2, alpha_CCC, chi)
c  Construct the coordinates of atom CZ.
	chi= 0.*pi/180.
	call construct_atom(xx_CG, xx_CD1, xx_CE1, xx_CZ, 
     1	  r_CC2, alpha_CCC, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Add delta protons.
c  Calculate CD1->HD1 unit vector.
	call calc_planar1(xx_CG,xx_CE1,xx_CD1,uu_CHD1)
	do i= 1, 3
	   xx_HD1(i)= r_CH*uu_CHD1(i)+xx_CD1(i)
	enddo
c  Calculate CD2->HD2 unit vector.
	call calc_planar1(xx_CG,xx_CE2,xx_CD2,uu_CHD2)
	do i= 1, 3
	   xx_HD2(i)= r_CH*uu_CHD2(i)+xx_CD2(i)
	enddo
c  Add epsilon protons.
c  Calculate CE1->HE1 unit vector.
	call calc_planar1(xx_CD1,xx_CZ,xx_CE1,uu_CHE1)
	do i= 1, 3
	   xx_HE1(i)= r_CH*uu_CHE1(i)+xx_CE1(i)
	enddo
c  Calculate CE2->HE2 unit vector.
	call calc_planar1(xx_CD2,xx_CZ,xx_CE2,uu_CHE2)
	do i= 1, 3
	   xx_HE2(i)= r_CH*uu_CHE2(i)+xx_CE2(i)
	enddo
c  Add zeta proton.
c  Calculate CZ->HZ unit vector.
	call calc_planar1(xx_CE1,xx_CE2,xx_CZ,uu_CHZ)
	do i= 1, 3
	   xx_HZ(i)= r_CH*uu_CHZ(i)+xx_CZ(i)
	enddo

c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' CD1',
     1	  resname,chain,seqno,(xx_CD1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' CD2',
     1	  resname,chain,seqno,(xx_CD2(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,' CE1',
     1	  resname,chain,seqno,(xx_CE1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,' CE2',
     1	  resname,chain,seqno,(xx_CE2(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,' CZ ',
     1	  resname,chain,seqno,(xx_CZ(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+7),990) rectype,serno+7,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+8),990) rectype,serno+8,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+9),990) rectype,serno+9,'1HD ',
     1	 resname,chain,seqno,(xx_HD1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+10),990) rectype,serno+10,'2HD ',
     1	 resname,chain,seqno,(xx_HD2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+11),990) rectype,serno+11,'1HE ',
     1	 resname,chain,seqno,(xx_HE1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+12),990) rectype,serno+12,'2HE ',
     1	 resname,chain,seqno,(xx_HE2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+13),990) rectype,serno+13,' HZ ',
     1	 resname,chain,seqno,(xx_HZ(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+13
	n_inres= n_inres+13
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Tyrosine(resname,n_inres,res_ln,seqno,
     1    serno,xx_N,xx_CA,xx_CB,r_CH,r_OH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_CD1(3),xx_CD2(3),xx_CE1(3),xx_CE2(3),
     1   xx_CZ(3),xx_OH(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_CHD1(3),uu_CHD2(3),xx_HD1(3),xx_HD2(3)
	real uu_CHE1(3),uu_CHE2(3),xx_HE1(3),xx_HE2(3)
	real uu_OHH(3),xx_HH(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha_tet= 109.471*pi/180.
	alpha_CCC= 120.0*pi/180.
	r_CC= 1.54
	r_CC2= 1.39
	r_CO= 1.36
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r_CC, alpha_tet, chi)
c  Construct the coordinates of atom CD1.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD1, 
     1	  r_CC2, alpha_CCC, chi)
c  Construct the coordinates of atom CD2.
	chi= (x_chi(2)+180.)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD2, 
     1	  r_CC2, alpha_CCC, chi)
c  Construct the coordinates of atom CE1.
	chi= 180.*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD1, xx_CE1, 
     1	  r_CC2, alpha_CCC, chi)
c  Construct the coordinates of atom CE2.
	chi= 180.*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD2, xx_CE2, 
     1	  r_CC2, alpha_CCC, chi)
c  Construct the coordinates of atom CZ.
	chi= 0.*pi/180.
	call construct_atom(xx_CG, xx_CD1, xx_CE1, xx_CZ, 
     1	  r_CC2, alpha_CCC, chi)
c  Construct the coordinates of atom OH.
	chi= 180.*pi/180.
	call construct_atom(xx_CD1, xx_CE1, xx_CZ, xx_OH, 
     1	  r_CO, alpha_CCC, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Add delta protons.
c  Calculate CD1->HD1 unit vector.
	call calc_planar1(xx_CG,xx_CE1,xx_CD1,uu_CHD1)
	do i= 1, 3
	   xx_HD1(i)= r_CH*uu_CHD1(i)+xx_CD1(i)
	enddo
c  Calculate CD2->HD2 unit vector.
	call calc_planar1(xx_CG,xx_CE2,xx_CD2,uu_CHD2)
	do i= 1, 3
	   xx_HD2(i)= r_CH*uu_CHD2(i)+xx_CD2(i)
	enddo
c  Add epsilon protons.
c  Calculate CE1->HE1 unit vector.
	call calc_planar1(xx_CD1,xx_CZ,xx_CE1,uu_CHE1)
	do i= 1, 3
	   xx_HE1(i)= r_CH*uu_CHE1(i)+xx_CE1(i)
	enddo
c  Calculate CE2->HE2 unit vector.
	call calc_planar1(xx_CD2,xx_CZ,xx_CE2,uu_CHE2)
	do i= 1, 3
	   xx_HE2(i)= r_CH*uu_CHE2(i)+xx_CE2(i)
	enddo
c  Add eta proton.  Assume OH->HH vector parallel to CE2->HE2.
	do i= 1, 3
	   uu_OHH(i)= uu_CHE2(i)
	   xx_HH(i)= r_OH*uu_OHH(i)+xx_OH(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' CD1',
     1	  resname,chain,seqno,(xx_CD1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' CD2',
     1	  resname,chain,seqno,(xx_CD2(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,' CE1',
     1	  resname,chain,seqno,(xx_CE1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,' CE2',
     1	  resname,chain,seqno,(xx_CE2(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,' CZ ',
     1	  resname,chain,seqno,(xx_CZ(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,' OH ',
     1	  resname,chain,seqno,(xx_OH(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+8),990) rectype,serno+8,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+9),990) rectype,serno+9,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+10),990) rectype,serno+10,'1HD ',
     1	 resname,chain,seqno,(xx_HD1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+11),990) rectype,serno+11,'2HD ',
     1	 resname,chain,seqno,(xx_HD2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+12),990) rectype,serno+12,'1HE ',
     1	 resname,chain,seqno,(xx_HE1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+13),990) rectype,serno+13,'2HE ',
     1	 resname,chain,seqno,(xx_HE2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+14),990) rectype,serno+14,' HH ',
     1	 resname,chain,seqno,(xx_HH(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+14
	n_inres= n_inres+14
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Histidine(resname,n_inres,res_ln,seqno,
     1    serno,xx_N,xx_CA,xx_CB,r_CH,r_NH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_ND1(3),xx_CD2(3),xx_NE2(3),xx_CE1(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_NHD1(3),uu_CHD2(3),xx_HD1(3),xx_HD2(3)
	real uu_CHE1(3),uu_NHE2(3),xx_HE1(3),xx_HE2(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha_tet= 109.471*pi/180.
	alpha_CCC= 120.0*pi/180.
	alpha_abg= 114.*pi/180.
	alpha_bgd= 123.*pi/180.
	alpha_pent= 108.*pi/180.
	r_CC= 1.52
	r_CN= 1.35
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r_CC, alpha_tet, chi)
c  Construct the coordinates of atom ND1.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_ND1, 
     1	  r_CN, alpha_bgd, chi)
c  Construct the coordinates of atom CE1.
	chi= 180.*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_ND1, xx_CE1, 
     1	  r_CN, alpha_pent, chi)
c  Construct the coordinates of atom NE2.
	chi= 0.*pi/180.
	call construct_atom(xx_CG, xx_ND1, xx_CE1, xx_NE2, 
     1	  r_CN, alpha_pent, chi)
c  Construct the coordinates of atom CD2.
	chi= 0.*pi/180.
	call construct_atom(xx_ND1, xx_CE1, xx_NE2, xx_CD2, 
     1	  r_CN, alpha_pent, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Add delta 1 proton.
c  Calculate ND1->HD1 unit vector.
	call calc_planar1(xx_CG,xx_CE1,xx_ND1,uu_NHD1)
	do i= 1, 3
	   xx_HD1(i)= r_NH*uu_NHD1(i)+xx_ND1(i)
	enddo
c  Add delta 2 proton.
c  Calculate CD2->HD2 unit vector.
	call calc_planar1(xx_CG,xx_NE2,xx_CD2,uu_CHD2)
	do i= 1, 3
	   xx_HD2(i)= r_CH*uu_CHD2(i)+xx_CD2(i)
	enddo
c  Add epsilon 1 proton.
c  Calculate CE1->HE1 unit vector.
	call calc_planar1(xx_ND1,xx_NE2,xx_CE1,uu_CHE1)
	do i= 1, 3
	   xx_HE1(i)= r_CH*uu_CHE1(i)+xx_CE1(i)
	enddo
c  Add epsilon 2 proton.
c  Calculate NE2->HE2 unit vector.
	call calc_planar1(xx_CD2,xx_CE1,xx_NE2,uu_NHE2)
	do i= 1, 3
	   xx_HE2(i)= r_NH*uu_NHE2(i)+xx_NE2(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' ND1',
     1	  resname,chain,seqno,(xx_ND1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' CD2',
     1	  resname,chain,seqno,(xx_CD2(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,' CE1',
     1	  resname,chain,seqno,(xx_CE1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,' NE2',
     1	  resname,chain,seqno,(xx_NE2(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+6),990) rectype,serno+6,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+8),990) rectype,serno+8,' HD1',
     1	 resname,chain,seqno,(xx_HD1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+9),990) rectype,serno+9,' HD2',
     1	 resname,chain,seqno,(xx_HD2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+10),990) rectype,serno+10,' HE1',
     1	 resname,chain,seqno,(xx_HE1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+11),990) rectype,serno+11,' HE2',
     1	 resname,chain,seqno,(xx_HE2(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+11
	n_inres= n_inres+11
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Tryptophan(resname,n_inres,res_ln,seqno,
     1    serno,xx_N,xx_CA,xx_CB,r_CH,r_NH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_CD1(3),xx_CD2(3),xx_NE1(3),xx_CE2(3)
	real xx_CE3(3),xx_CZ2(3),xx_CZ3(3),xx_CH2(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_CHD1(3),uu_NHE1(3),xx_HD1(3),xx_HE1(3)
	real uu_CHE3(3),uu_CHZ2(3),xx_HE3(3),xx_HZ2(3)
	real uu_CHZ3(3),uu_CHH2(3),xx_HZ3(3),xx_HH2(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha_abg=  114.0*pi/180.
	alpha_bgd1= 128.0*pi/180.
	alpha_bgd2= 126.6*pi/180.
	alpha_gde1= 111.5*pi/180.
	alpha_gde2= 108.3*pi/180.
	alpha_dez2= 123.2*pi/180.
	alpha_gde3= 130.3*pi/180.
	alpha_ezh2= 116.4*pi/180.
	alpha_dez3= 115.0*pi/180.
	r_bg= 1.53
	r_gd1= 1.34
	r_gd2= 1.44
	r_de1= 1.38
	r_ee2= 1.40
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r_bg, alpha_abg, chi)
c  Construct the coordinates of atom CD1.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD1, 
     1	  r_gd1, alpha_bgd1, chi)
c  Construct the coordinates of atom CD2.
	chi= (x_chi(2)+180.)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD2, 
     1	  r_gd2, alpha_bgd2, chi)
c  Construct the coordinates of atom NE1.
	chi= 180.*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD1, xx_NE1, 
     1	  r_de1, alpha_gde1, chi)
c  Construct the coordinates of atom CE2.
	chi= 180.*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD2, xx_CE2, 
     1	  r_de1, alpha_gde2, chi)
c  Construct the coordinates of atom CE3.
	chi= 0.*pi/180.
	call construct_atom(xx_CB, xx_CG, xx_CD2, xx_CE3, 
     1	  r_ee2, alpha_gde3, chi)
c  Construct the coordinates of atom CZ2.
	chi= 180.*pi/180.
	call construct_atom(xx_CG, xx_CD2, xx_CE2, xx_CZ2, 
     1	  r_ee2, alpha_dez2, chi)
c  Construct the coordinates of atom CZ3.
	chi= 180.*pi/180.
	call construct_atom(xx_Cg, xx_CD2, xx_CE3, xx_CZ3, 
     1	  r_ee2, alpha_dez3, chi)
c  Construct the coordinates of atom CH2.
	chi= 180.*pi/180.
	call construct_atom(xx_NE1, xx_CE2, xx_CZ2, xx_CH2, 
     1	  r_ee2, alpha_ezh2, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Add delta 1 proton.
c  Calculate CD1->HD1 unit vector.
	call calc_planar1(xx_CG,xx_NE1,xx_CD1,uu_CHD1)
	do i= 1, 3
	   xx_HD1(i)= r_CH*uu_CHD1(i)+xx_CD1(i)
	enddo
c  Add epsilon 1 proton.
c  Calculate NE1->HE1 unit vector.
	call calc_planar1(xx_CD1,xx_CE2,xx_NE1,uu_NHE1)
	do i= 1, 3
	   xx_HE1(i)= r_NH*uu_NHE1(i)+xx_NE1(i)
	enddo
c  Add epsilon 3 proton.
c  Calculate CE3->HE3 unit vector.
	call calc_planar1(xx_CD2,xx_CZ3,xx_CE3,uu_CHE3)
	do i= 1, 3
	   xx_HE3(i)= r_CH*uu_CHE3(i)+xx_CE3(i)
	enddo
c  Add zeta 2 proton.
c  Calculate CZ2->HZ2 unit vector.
	call calc_planar1(xx_CE2,xx_CH2,xx_CZ2,uu_CHZ2)
	do i= 1, 3
	   xx_HZ2(i)= r_CH*uu_CHZ2(i)+xx_CZ2(i)
	enddo
c  Add zeta 3 proton.
c  Calculate CZ3->HZ3 unit vector.
	call calc_planar1(xx_CE3,xx_CH2,xx_CZ3,uu_CHZ3)
	do i= 1, 3
	   xx_HZ3(i)= r_CH*uu_CHZ3(i)+xx_CZ3(i)
	enddo
c  Add eta 2 proton.
c  Calculate CH2->HH2 unit vector.
	call calc_planar1(xx_CZ2,xx_CZ3,xx_CH2,uu_CHH2)
	do i= 1, 3
	   xx_HH2(i)= r_CH*uu_CHH2(i)+xx_CH2(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' CD1',
     1	  resname,chain,seqno,(xx_CD1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+3),990) rectype,serno+3,' CD2',
     1	  resname,chain,seqno,(xx_CD2(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,' NE1',
     1	  resname,chain,seqno,(xx_NE1(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,' CE2',
     1	  resname,chain,seqno,(xx_CE2(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,' CE3',
     1	  resname,chain,seqno,(xx_CE3(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,' CZ2',
     1	  resname,chain,seqno,(xx_CZ2(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+8),990) rectype,serno+8,' CZ3',
     1	  resname,chain,seqno,(xx_CZ3(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+9),990) rectype,serno+9,' CH2',
     1	  resname,chain,seqno,(xx_CH2(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+10),990) rectype,serno+10,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+11),990) rectype,serno+11,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+12),990) rectype,serno+12,' HD1',
     1	 resname,chain,seqno,(xx_HD1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+13),990) rectype,serno+13,' HE1',
     1	 resname,chain,seqno,(xx_HE1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+14),990) rectype,serno+14,' HE3',
     1	 resname,chain,seqno,(xx_HE3(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+15),990) rectype,serno+15,' HZ2',
     1	 resname,chain,seqno,(xx_HZ2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+16),990) rectype,serno+16,' HZ3',
     1	 resname,chain,seqno,(xx_HZ3(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+17),990) rectype,serno+17,' HH2',
     1	 resname,chain,seqno,(xx_HH2(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+17
	n_inres= n_inres+17
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c
	subroutine Proline(resname,n_inres,res_ln,seqno,serno,
     1    xx_N,xx_CA,xx_CB,r_CH)
	character*80 res_ln(30)
	character rectype*6,end_rec*8,resname*3,chain*1
	real xx_N(3),xx_CA(3),xx_CB(3)
	real xx_CG(3),xx_CD(3)
	real uu_CHB1(3),uu_CHB2(3),xx_HB1(3),xx_HB2(3)
	real uu_CHG1(3),uu_CHG2(3),xx_HG1(3),xx_HG2(3)
	real uu_CHD1(3),uu_CHD2(3),xx_HD1(3),xx_HD2(3)
	real x_chi(6)
	integer seqno,serno,n_inres
     	parameter (pi= 3.14159)
        common /chi_angles/ x_chi
c
	rectype= 'ATOM  '
	chain= ' '
	end_rec= ' '
	occ= 1.0
	bfact= 0.0
	alpha_abg= 103.2*pi/180.
	alpha_bgd= 102.4*pi/180.
	r_CC= 1.53
c  Construct the coordinates of atom CG.
	chi= x_chi(1)*pi/180.
	call construct_atom(xx_N, xx_CA, xx_CB, xx_CG, 
     1	  r_CC, alpha_abg, chi)
c  Construct the coordinates of atom CD.
	chi= x_chi(2)*pi/180.
	call construct_atom(xx_CA, xx_CB, xx_CG, xx_CD, 
     1	  r_CC, alpha_bgd, chi)
c
c  Calculate CB->HB unit vectors.
	call calc_tetra2(xx_CA,xx_CG,xx_CB,uu_CHB1,uu_CHB2)
	do i= 1, 3
	   xx_HB1(i)= r_CH*uu_CHB1(i)+xx_CB(i)
	   xx_HB2(i)= r_CH*uu_CHB2(i)+xx_CB(i)
	enddo
c  Calculate CG->HG unit vectors.
	call calc_tetra2(xx_CB,xx_CD,xx_CG,uu_CHG1,uu_CHG2)
	do i= 1, 3
	   xx_HG1(i)= r_CH*uu_CHG1(i)+xx_CG(i)
	   xx_HG2(i)= r_CH*uu_CHG2(i)+xx_CG(i)
	enddo
c  Calculate CD->HD unit vectors.
	call calc_tetra2(xx_CG,xx_N,xx_CD,uu_CHD1,uu_CHD2)
	do i= 1, 3
	   xx_HD1(i)= r_CH*uu_CHD1(i)+xx_CD(i)
	   xx_HD2(i)= r_CH*uu_CHD2(i)+xx_CD(i)
	enddo
c  Add heavy atom coordinates to list of atoms in residue.
	write(res_ln(n_inres+1),990) rectype,serno+1,' CG ',
     1	  resname,chain,seqno,(xx_CG(i), i=1,3),occ,bfact,
     2	  end_rec
	write(res_ln(n_inres+2),990) rectype,serno+2,' CD ',
     1	  resname,chain,seqno,(xx_CD(i), i=1,3),occ,bfact,
     2	  end_rec
c  Add proton coordinates to list of atoms in residue.
	write(res_ln(n_inres+3),990) rectype,serno+3,'1HB ',
     1	 resname,chain,seqno,(xx_HB1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+4),990) rectype,serno+4,'2HB ',
     1	 resname,chain,seqno,(xx_HB2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+5),990) rectype,serno+5,'1HG ',
     1	 resname,chain,seqno,(xx_HG1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+6),990) rectype,serno+6,'2HG ',
     1	 resname,chain,seqno,(xx_HG2(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+7),990) rectype,serno+7,'1HD ',
     1	 resname,chain,seqno,(xx_HD1(i), i=1,3),occ,bfact,
     2	 end_rec
	write(res_ln(n_inres+8),990) rectype,serno+8,'2HD ',
     1	 resname,chain,seqno,(xx_HD2(i), i=1,3),occ,bfact,
     2	 end_rec
	serno= serno+8
	n_inres= n_inres+8
c
 990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
	return
	end
c
c

	Subroutine WRITE_PS(klp,file,len,nres,npeaks,nsft,peakmax,
     +  	HAswap,HA1,HA2,COHA1,COHA2,HBswap,HB1,HB2,COHB1,COHB2,
     +          nsl_lkup,csl_lkup)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c This routine generates a postscript file
c Adapted from Kevin's WRITE_HTML by Gordon
c This routine calls PS_INDEX to evaluate page position of char
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer peakmax(500),nres,peak_inp,nsft
	integer atmnum(500),rtype(500)
	integer klp,len,s(500,20),assn(500)
	integer peak_array(50,500),e_max(50)
	integer ichange,change(500)
	Integer j_mat(20,3),nmatch
	integer more,noemax,noe_num
	integer dmap(500,500),hn_map(500,0:20),hn_noelk(500,500)
	integer hn_noe(500,0:10,2)
	integer iwrite
	integer HA1,HA2,COHA1,COHA2,HB1,HB2,COHB1,COHB2
	integer ha_stack(4),hb_stack(4)
	integer sscode(500),nsl_lkup(500,20),csl_lkup(500,20)
	real st(20),pin(500),chk,chk1,chk2
	real x(500),y(500),z(500)
	real hntol,ntol,cotol,catol,cbtol,cgtol,hatol,hbtol,hgtol
	real tol
	character*1 pdiff(50),one(20)
	character*3 rname(500),three(20)
	character*5 colhead(20)
	character*60 file,outfile,date_time
	logical noe_ps,hnnoe(500),HAswap,HBswap,found,ssfile,noe_exp
	integer path_len,rtnum(20)
	character*100 path,fname
	integer len_ps,row,col,x_start,y_start,x_step,y_step,x_current,y_current,y_top
	integer x1,x2,y1,y2,y_off(500)
	character*2 ps_label
	Integer peak_stat(50,500),score_stat(50),num_stat,SL
	integer idy
	real xtemp

	Common /path/ path,path_len
	Common /pdb/ atmnum, rname, rtype, x, y, z
	Common /jcoup/ pin,assn,peak_inp
	Common /jcoups/ s
	Common /e_max/ peak_array,e_max
	Common /match/ j_mat,nmatch
	Common /tolerence/ hntol,ntol,catol,cbtol,cotol,hatol,hbtol,cgtol
	Common /dist/ dmap,hn_map
	Common /hn_noelk/ hn_noelk,hnnoe
	Common /header/ colhead
	Common /hn_noe/ hn_noe
	Common /postscript/ len_ps,noe_ps,scale_ps
	Common /aa/ rtnum,one,three
	Common /ss/ sscode
	Common /statistics/ peak_stat,score_stat,num_stat,SL


ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c    open file and write header and macros                        c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	outfile= file(1:len)//'_out.ps'
c	write(6,*) outfile
	fname=path(1:path_len)//outfile
	open(unit=10,file=fname,status='unknown')

	Write(10,'(a30)')'%!Postscript file - FullMonte v1.0'
	Write(10,'(a18)')'%%Character macros'
	write(10,'(a6)')'/fh {'
	write(10,*)'/Helvetica findfont exch'
	Write(10,*)'scalefont setfont'
	Write(10,*)'} bind def'
	Write(10,'(a29)')'/stc { gsave translate rotate'
	Write(10,*)'dup stringwidth pop 2'
	Write(10,*)'div neg 0 moveto show grestore'
	Write(10,*)'} bind def'

c Helix using smooth curves:
	Write(10,'(a23)') '/helix { newpath moveto'
	Write(10,*) ' 0 -12 rmoveto'
	Write(10,*) '-5 0 rmoveto'
	Write(10,*) '8 0 8 8 5 8 rcurveto'
	Write(10,*) '-5 0 -5 -8 5 -8 rcurveto'
	Write(10,*) ' stroke'
	Write(10,*) ' } bind def'
c
	Write(10,'(a17)')'/sheet1 { newpath'
	Write(10,*)'moveto'
	Write(10,*)'5 -12 rmoveto'
	Write(10,*)'-9 0 rlineto'
	Write(10,*)'0  4 rlineto'
	Write(10,*)'9  0 rlineto'
	Write(10,*)'1 setlinejoin'
	Write(10,*)'stroke'
	Write(10,*)'} bind def'
	Write(10,'(a17)')'/sheet2 { newpath'
	Write(10,*)'moveto'
	Write(10,*)'5 -12 rmoveto'
	Write(10,*)'-9 0 rlineto'
	Write(10,*)'0  4 rmoveto'
	Write(10,*)'9  0 rlineto'
	Write(10,*)'1 setlinejoin'
	Write(10,*)'stroke'
	Write(10,*)'} bind def'
	Write(10,'(a17)')'/sheet3 { newpath'
	Write(10,*)'moveto'
	Write(10,*)'-4 -12 rmoveto'
	Write(10,*)'2 0 rlineto'
	Write(10,*)'0 -2 rlineto'
	Write(10,*)'4 4 rlineto'
	Write(10,*)'-4 4 rlineto'
	Write(10,*)'0 -2 rlineto'
	Write(10,*)'-2 0 rlineto'
	Write(10,*)'1 setlinejoin'
	Write(10,*)'stroke'
	Write(10,*)'} bind def'

	Write(10,'(a11)')'%%EndProlog'

	call fdate(date_time)
	write(10,*) '10 fh'
	write(10,310) '(',date_time,') 0.0 520 773 stc'
310	format(a1,a28,a17)



c	SCALE POSTSCRIPT
	write(10,*)scale_ps*0.9,scale_ps*0.9,' scale'
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c  Determine number of connectivity lines required: nconkt        c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	nconkt=nmatch
	if(HAswap)nconkt=nconkt+1
	if(HBswap)nconkt=nconkt+1
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                                                                 c
c	General spacing
c		y_top: top of page (800 = 1in with scale=0.9)
c		y_step: spacing between global blocks
c		x_start: side of page for seq, not labels (90=1.2in)
c		x_step: spacing between residues
c		y_seq_skip: spacing for sequence & number
c		y_slab_skip: spacing for specific labeling
c		y_ss_skip: spacing for secondary structure
c		y_con_skip: spacing between each connectivity line
c		noe_depth: number of noe types (1-5)
c		y_noe_skip: spacing between each NOE line
c		y_noe_buff: spacing between connectivity and noes
c		y_nsol_skip: space required for # of solutions
c		y_sep_buff: separation buffer between global blocks
c		nconkt: number of connectivities expected
	
	y_top=840/scale_ps
	x_start=90/scale_ps
	x_step=8
	y_seq_skip=16
	y_ss_skip=6
	y_slab_skip=6
	y_con_skip=13
	y_noe_skip=8
	noe_depth=5
	y_noe_buff=8
	y_nsol_skip=12
	y_sep_buff=25


	y_step=y_seq_skip
	y_step=y_step+y_ss_skip
	y_step=y_step+y_slab_skip
	y_step=y_step+nconkt*y_con_skip+y_noe_buff
	if(noe_ps)y_step=y_step+noe_depth*y_noe_skip
	y_step=y_step+y_nsol_skip
	y_step=y_step+y_sep_buff
	
c	write(6,*)'y_step',y_step

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c  Write out peptide sequence with numbering                      c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	write(10,'(a15)')'%%Seq Numbering'
	do i=10,nres,10
		CALL PS_INDEX(i,row,col)
		y_current=y_top-1*row*y_step
		x_current=x_start+x_step*col
		write(10,*)'9 fh'
		write(10,'(a1,i3,a6,i5,i5,1x,a4)')'(',i,') 0.0 ',x_current,y_current,' stc'
		enddo

	if(nres-(10*(nres/10)).gt.4)then
		CALL PS_INDEX(nres,row,col)
		y_current=y_top-1*row*y_step
		x_current=x_start+x_step*col
		write(10,*)'9 fh'
		write(10,'(a1,i3,a6,i5,i5,1x,a4)')'(',nres,') 0.0 ',x_current,y_current,' stc'
		endif

	write(10,'(a5)')'%%Seq'
	do i=1,nres
		CALL PS_INDEX(i,row,col)
		y_current=y_top-1*row*y_step-10
		x_current=x_start+x_step*col
		write(10,*)'9 fh'
		write(10,*)'(',one(rtype(i)),') 0.0 ',x_current,y_current,' stc'
		enddo
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c  Write out specific labeling information                        c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	y_start=y_top-y_seq_skip+y_ss_skip
	
	do i=2,nres
		CALL PS_INDEX(i,row,col)
		y_current=y_start-1*row*y_step
		x_current=x_start+x_step*col
		idx=peakmax(i)
		if(rtype(i).lt.20)then
			if(nsl_lkup(idx,rtype(i)).gt.60)then
				write(10,*)'newpath',int(x_current-(x_step/2.0)),y_current-1,' moveto',x_step-1,0,' rlineto stroke'
				endif
			if(csl_lkup(idx,rtype(i-1)).gt.60)then
				write(10,*)'newpath',int(x_current-(x_step/2.0)),y_current-2,3,0,180,' arcn stroke'
				endif
			endif
		enddo	
cccccccccccccccccccccccccccccccccccccccccccccccccc
c	Now do secondary Structure               c
cccccccccccccccccccccccccccccccccccccccccccccccccc
	y_start=y_top-y_seq_skip+y_ss_skip-y_slab_skip
c helix first
	do i=1,nres
		if(sscode(i).eq.3)then
		CALL PS_INDEX(i,row,col)
		x_current=x_start+x_step*col
		y_current=y_start-row*y_step
		write(10,*)x_current,y_current,' helix'
		endif
	enddo
c sheet now
	flg_s=0
	do i=1,nres-1
		CALL PS_INDEX(i,row,col)
		x_current=x_start+x_step*col
		y_current=y_start-row*y_step
		if((sscode(i).eq.2) .and. (flg_s.eq.0))then
			write(10,*)x_current,y_current,' sheet1'
			flg_s=1
			endif
		if((sscode(i).eq.2) .and. (flg_s.eq.1) .and. (sscode(i+1).eq.2))then
			write(10,*)x_current,y_current,' sheet2'
			endif
		if((sscode(i).eq.2) .and. (flg_s.eq.1) .and. (sscode(i+1).ne.2))then
			flg_s=0
			write(10,*)x_current,y_current,' sheet3'
			endif
	enddo
	if(sscode(nres).eq.2)then
		CALL PS_INDEX(nres,row,col)
		x_current=x_start+x_step*col
		y_current=y_start-row*y_step
		write(10,*)x_current,y_current,' sheet3'
		endif

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c  Do connectivity, start with top of stack, do HA,HB at the end  c
c  as special case. Note that s(i,k) is used for shifts (x100)    c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	
ccc
c		j_mat(nmatch*3) (inter index, intra index, pair type)
c				match (i)   to   (i-1) , type
c		nmatch = number of rows in matrix	
c	CO=1,CA=2,HA=3,CB=4,HB=5,CG=6,NNn=7,NNc=8,HH=9
ccc	

	do k=1,nmatch
c	write(6,*)k,(j_mat(k,l9),l9=1,3)
	y_start=y_top-y_seq_skip-y_ss_skip-y_slab_skip-y_con_skip*k
		if (j_mat(k,3).eq.1)then
			tol=100*cotol
			ps_label='CO'
			endif
		if (j_mat(k,3).eq.2)then
			tol=100*catol
			ps_label='CA'
			endif
		if (j_mat(k,3).eq.3)then
			tol=100*hatol
			ps_label='HA'
			endif
		if (j_mat(k,3).eq.4)then
			tol=100*cbtol
			ps_label='CB'
			endif
		if (j_mat(k,3).eq.5)then
			tol=100*hbtol
			ps_label='HB'
			endif
		if (j_mat(k,3).eq.6)then
			tol=100*cgtol
			ps_label='CG'
			endif
		if (j_mat(k,3).eq.7)then
			tol=100*ntol
			ps_label='Nn'
			endif	
		if (j_mat(k,3).eq.8)then
			tol=100*ntol
			ps_label='Nc'
			endif	
c	Write labels
		CALL PS_INDEX(nres,row,col)
		do k1=0,row
			x_current=x_start-20
			y_current=y_start-k1*y_step
			write(10,*)'11 fh'
			write(10,'(a8,i5,i5,1x,a4)')'(J) 0.0 ',x_current,y_current,' stc'
			x_current=x_start-9
			y_current=y_start-k1*y_step-5
			write(10,*)'9 fh'
			write(10,'(a1,a2,a6,i5,i5,1x,a4)')'(',ps_label,') 0.0 ',x_current,y_current,' stc'
			enddo
			
c	Now loop over each residue, type=8 is done separately since it looks forward 
		if(j_mat(k,3).eq.8)goto 60

		do i=2,nres
			if(s(peakmax(i),j_mat(k,1))*s(peakmax(i-1),j_mat(k,2)).ne.0)then

			chk=abs(s(peakmax(i),j_mat(k,1)) - s(peakmax(i-1),j_mat(k,2)))
			if (chk.le.tol)linew=3
			if (chk.gt.tol)linew=2
			if (chk.gt.tol*2)linew=1
			if(chk.le.tol*3)then
				CALL PS_INDEX(i,row,col)
				x_current=x_start+x_step*col
				y_current=y_start-row*y_step
				write(10,*)'newpath'
				write(10,'(2i7,1x,a6)')x_current,y_current,'moveto'
				write(10,'(2i7,1x,a6)')x_current-x_step,y_current,'lineto'
				write(10,*)linew,' setlinewidth'
				write(10,*)'stroke'
				endif
			endif
		enddo
		goto 80

60		do i=2,nres-1
			if(s(peakmax(i),j_mat(k,2))*s(peakmax(i+1),j_mat(k,1)).ne.0)then

			chk=abs(s(peakmax(i),j_mat(k,2)) - s(peakmax(i+1),j_mat(k,1)))
			if (chk.le.tol)linew=3
			if (chk.gt.tol)linew=2
			if (chk.gt.tol*2)linew=1
			if (chk.le.tol*3)then
				CALL PS_INDEX(i,row,col)
				x_current=x_start+x_step*col
				y_current=y_start-row*y_step
				write(10,*)'newpath'
				write(10,'(2i7,1x,a6)')x_current,y_current,'moveto'
				write(10,'(2i7,1x,a6)')x_current+x_step,y_current,'lineto'
				write(10,*)linew,' setlinewidth'
				write(10,*)'stroke'
				endif
			endif
		enddo
	
80	continue
	enddo
cccccccccccccccccccccccccccccccccccccccccccccccccc
c  Do HA connectivity if not present above       c
cccccccccccccccccccccccccccccccccccccccccccccccccc
	if (.not.HAswap) goto 90
		tol=hatol*100
		CALL PS_INDEX(nres,row,col)
		y_start=y_top-y_seq_skip-y_ss_skip-y_slab_skip-y_con_skip*nmatch-y_con_skip
		do k1=0,row
			x_current=x_start-20
			y_current=y_start-k1*y_step
			write(10,*)'11 fh'
			write(10,'(a8,i5,i5,1x,a4)')'(J) 0.0 ',x_current,y_current,' stc'
			x_current=x_start-9
			y_current=y_start-k1*y_step-5
			write(10,*)'9 fh'
			write(10,'(a1,a2,a6,i5,i5,1x,a4)')'(','HA',') 0.0 ',x_current,y_current,' stc'
			enddo
	do i=2,nres
			do j=1,4
			ha_stack(j)=9999
			enddo
		if((s(peakmax(i),COHA1)*s(peakmax(i-1),HA1)).gt.0)ha_stack(1)=abs(s(peakmax(i),COHA1)-s(peakmax(i-1),HA1))
		if((s(peakmax(i),COHA1)*s(peakmax(i-1),HA2)).gt.0)ha_stack(2)=abs(s(peakmax(i),COHA1)-s(peakmax(i-1),HA2))
		if((s(peakmax(i),COHA2)*s(peakmax(i-1),HA1)).gt.0)ha_stack(3)=abs(s(peakmax(i),COHA2)-s(peakmax(i-1),HA1))
		if((s(peakmax(i),COHA2)*s(peakmax(i-1),HA2)).gt.0)ha_stack(4)=abs(s(peakmax(i),COHA2)-s(peakmax(i-1),HA2))
		idx=9999
			do j=1,4
			if(ha_stack(j).lt.idx)idx=ha_stack(j)
			enddo
		if(idx.lt.9999)then
			if (idx.le.tol)linew=3
			if (idx.gt.tol)linew=2
			if (idx.gt.2*tol)linew=1
			if (idx.le.3*tol)then
				CALL PS_INDEX(i,row,col)
				x_current=x_start+x_step*col
				y_current=y_start-row*y_step
				write(10,*)'newpath'
				write(10,'(2i7,1x,a6)')x_current,y_current,'moveto'
				write(10,'(2i7,1x,a6)')x_current-x_step,y_current,'lineto'
				write(10,*)linew,' setlinewidth'
				write(10,*)'stroke'
				endif
			endif
	enddo
cccccccccccccccccccccccccccccccccccccccccccccccccc
c  Do HB connectivity                            c
cccccccccccccccccccccccccccccccccccccccccccccccccc

90	if (.not. HBswap) goto 95
		tol=hbtol*100
		CALL PS_INDEX(nres,row,col)
		if(HAswap)y_start=y_top-y_seq_skip-y_ss_skip-y_slab_skip-y_con_skip*nmatch-2*y_con_skip
		if(.not.HAswap)y_start=y_top-y_seq_skip-y_ss_skip-slab_skip-y_con_skip*nmatch-y_con_skip
			do k1=0,row
			x_current=x_start-20
			y_current=y_start-k1*y_step
			write(10,*)'11 fh'
			write(10,'(a8,i5,i5,1x,a4)')'(J) 0.0 ',x_current,y_current,' stc'
			x_current=x_start-9
			y_current=y_start-k1*y_step-5
			write(10,*)'9 fh'
			write(10,'(a1,a2,a6,i5,i5,1x,a4)')'(','HB',') 0.0 ',x_current,y_current,' stc'
			enddo
	do i=2,nres
			do j=1,4
			hb_stack(j)=9999
			enddo
		if((s(peakmax(i),COHB1)*s(peakmax(i-1),HB1)).gt.0)hb_stack(1)=abs(s(peakmax(i),COHB1)-s(peakmax(i-1),HB1))
		if((s(peakmax(i),COHB1)*s(peakmax(i-1),HB2)).gt.0)hb_stack(2)=abs(s(peakmax(i),COHB1)-s(peakmax(i-1),HB2))
		if((s(peakmax(i),COHB2)*s(peakmax(i-1),HB1)).gt.0)hb_stack(3)=abs(s(peakmax(i),COHB2)-s(peakmax(i-1),HB1))
		if((s(peakmax(i),COHB2)*s(peakmax(i-1),HB2)).gt.0)hb_stack(4)=abs(s(peakmax(i),COHB2)-s(peakmax(i-1),HB2))
		idx=9999
			do j=1,4
			if(hb_stack(j).lt.idx)idx=hb_stack(j)
			enddo
		if(idx.lt.9999)then
			if (idx.le.tol)linew=3
			if (idx.gt.tol)linew=2
			if (idx.gt.2*tol)linew=1
			if (idx.le.3*tol)then
				CALL PS_INDEX(i,row,col)
				x_current=x_start+x_step*col
				y_current=y_start-row*y_step
				write(10,*)'newpath'
				write(10,'(2i7,1x,a6)')x_current,y_current,'moveto'
				write(10,'(2i7,1x,a6)')x_current-x_step,y_current,'lineto'
				write(10,*)linew,' setlinewidth'
				write(10,*)'stroke'
				endif
			endif
	enddo
95	continue

ccccccccccccccccccccccccccccccccccccccccccccccccccc
c      NOEs                                       c
c      This is done in a straight forward manner  c
c      i,i+1  i,i+2   i,i+3  i,i+4  i,i>5         c
ccccccccccccccccccccccccccccccccccccccccccccccccccc
	if(.not. noe_ps)goto 300
	y_start=y_top-y_seq_skip-y_ss_skip-y_slab_skip-y_con_skip*nconkt-y_noe_buff
	write(10,'(a21)')'%% NOE connectivities'
	write(10,*)1,' setlinewidth'
c
c	labels
c
	CALL PS_INDEX(nres,row,col)
	do k1=0,row
		x_current=x_start-45
		y_current=y_start-k1*y_step-3*y_noe_skip
		write(10,*)'11 fh'
		write(10,'(a10,i5,i5,1x,a4)')'(NOE) 0.0 ',x_current,y_current,' stc'
	do i=1,5
		x_current=x_start-20
		y_current=y_start-k1*y_step-i*y_noe_skip
		write(10,*)'9 fh'
		if(i.lt.5)write(10,'(a5,i1,a6,i5,i5,1x,a4)')'(i,i+',i,') 0.0 ',x_current,y_current,' stc'
		if(i.eq.5)write(10,'(a5,i1,a6,i5,i5,1x,a4)')'(i,i>',4,') 0.0 ',x_current,y_current,' stc'
		enddo
	enddo

	y_start=y_start+4
	do i=1,nres
	y_off(i)=6
	enddo
		do idx=1,5
		do i=1,nres
			do j=1,hn_map(i,0)
			idist=hn_map(i,j)-i
			if(idist.gt.0)then
				noe_exp=.false.
				if(hn_noelk(peakmax(i),peakmax(hn_map(i,j))).gt.20)noe_exp=.true.
				if(hn_noelk(peakmax(hn_map(i,j)),peakmax(i)).gt.20)noe_exp=.true.

				CALL PS_INDEX(i,row,col)
				x1=x_start+x_step*col
				y1=y_start-row*y_step-idx*y_noe_skip

				CALL PS_INDEX(hn_map(i,j),row,col)
				x2=x_start+x_step*col
				y2=y_start-row*y_step-idx*y_noe_skip
				
				if(((idx.le.4).and.(idist.eq.idx)).or.((idx.eq.5).and.(idist.ge.idx)))then
					if(noe_exp)then
						write(10,*)'newpath ',x1,y1,2,0,360,' arc fill stroke'
						if(idx.lt.5)write(10,*)'newpath ',x1+1,y1+1,' moveto 2  2 rlineto stroke'
						if((idx.eq.5).and.(y1.eq.y2))write(10,*)'newpath ',x1+1,y1+1,' moveto 2  2 rlineto stroke'
						if((idx.eq.5).and.(y1.ne.y2))write(10,*)'newpath ',x1,y1,' moveto 0 5 rlineto stroke'

						write(10,*)'newpath ',x2,y2,2,0,360,' arc fill stroke'
						if(idx.lt.5)write(10,*)'newpath ',x2-1,y2+1,' moveto -2 2 rlineto stroke'
						if((idx.eq.5).and.(y1.eq.y2))write(10,*)'newpath ',x2-1,y2+1,' moveto -2 2 rlineto stroke'
						if((idx.eq.5).and.(y1.ne.y2))write(10,*)'newpath ',x2,y2,' moveto 0 5 rlineto stroke'
					else
						write(10,*)'newpath ',x1,y1,1,0,360,' arc stroke'
						write(10,*)'newpath ',x2,y2,1,0,360,' arc stroke'
					endif
				endif

				if((idx.le.4).and.(idist.eq.idx).and.noe_exp)then
					if(idx.eq.1)write(10,*)'newpath ',x1+3,y1+3,' moveto ',x_step-6,' 0 rlineto stroke'
					if(idx.ge.2)write(10,*)'newpath ',x1+3,y1+3,' moveto ',(idx-1)*x_step+2,' 0 rlineto stroke'
					endif

				if((idx.eq.5).and. noe_exp .and. (idist.ge.5) .and. (y1.eq.y2))then
					ll=2+(idist-1)*x_step
					write(10,*)'newpath ',x1+3,y1+3,' moveto',ll,' 0 rlineto stroke'
					endif
c
c long range that break across a block, write up to three residues
c
				if((idx.eq.5).and. noe_exp .and. (idist.ge.5) .and. (y1.ne.y2))then
					if(y_off(i).le.13)then
						write(10,*)'7 fh'
						write(10,'(a1,i3,a5,2i5,a4)')'(',hn_map(i,j),') 0.0',x1,y1+y_off(i),' stc'
						y_off(i)=y_off(i)+7
						endif
					if(y_off(hn_map(i,j)).le.13)then
						write(10,*)'7 fh'
						write(10,'(a1,i3,a5,2i5,a4)')'(',i,') 0.0',x2,y2+y_off(hn_map(i,j)),' stc'
						y_off(hn_map(i,j))=y_off(hn_map(i,j))+7
						endif

				endif
			endif
			enddo
		enddo
	enddo

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c    Now do # of solutions                      		  c
c								  c
c  Count number of changes during highest 50 solutions: change(i) c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
300	continue

	if (SL.le.2) then
	do i=1,nres
		change(i)=1
		do k=1,20
			if((peak_array(k,i).ne.peak_array(k+1,i)).and.(peak_array(k+1,i).ne.0))change(i)=change(i)+1
			enddo
		if(change(i).gt.10)change(i)=10
	enddo

	else
c	
c  FIND highest score solution
c
	idy=1


	emax=score_stat(1)
	do i=1,num_stat
		if (score_stat(i).gt.emax) then
			emax=score_stat(i)
			idy=i
		endif
	enddo

	do i=1,nres

		ichange=0

		do k=1,num_stat
		if( peak_stat(idy,i).ne.peak_stat(k,i) ) ichange=ichange+1
		enddo
	xtemp=(1.0*ichange/num_stat)*10
c	write(6,*) ichange,num_stat,xtemp
	CALL ROUND(xtemp,change(i))
c	write(6,*) change(i)


	enddo

	endif


	
	y_start=y_top-y_seq_skip-y_ss_skip-y_slab_skip-y_con_skip*
     +	       nconkt-y_noe_buff-y_noe_skip*noe_depth-y_nsol_skip
	if(.not. noe_ps)y_start=y_top-y_seq_skip-y_ss_skip-y_slab_skip-y_con_skip*nconkt-y_nsol_skip-y_noe_buff
c
c	label
c
	CALL PS_INDEX(nres,row,col)



	
	if (SL.le.2) then
	do k=0,row
		x1=x_start - 35
		y1=y_start - k*y_step

		write(10,*)'9 fh'
		write(10,*)'(Divergence) 0.0',x1,y1,' stc'
		enddo

	else

	do k=0,row
		x1=x_start - 35
		y1=y_start - k*y_step

		write(10,*)'9 fh'
		write(10,*)'(Uncertainty) 0.0',x1,y1,' stc'
	if(k.eq.0) then
	write(10,*)'9 fh'
	write(10,'(a3,i2,a5,i4,i4,a4)')'(N=',num_stat,') 0.0',x1,y1-10,' stc'
	endif
		enddo
	endif

	do i=1,nres
		CALL PS_INDEX(i,row,col)

		y1=y_start - row*y_step
		x1=x_start+col*x_step-x_step*0.5+2

	if (rtype(i).eq.20) then

c
c	if proline draw on open box
c

		write(10,*)'newpath',x1,y1,' moveto'
		write(10,*)x_step-3,0,' rlineto'
		write(10,*)0,8,' rlineto'
		write(10,*)-1*(x_step-3),0,' rlineto'
		write(10,*)'closepath stroke'
	else
		write(10,*)'newpath',x1,y1,' moveto'
		write(10,*)x_step-3,0,' rlineto'
		write(10,*)0,int(change(i)),' rlineto'
		write(10,*)-1*(x_step-3),0,' rlineto'
		write(10,*)'closepath fill'

	endif

		enddo	
	
	

963	write(10,'(a8)')'showpage'
	close(10)
	return
	end

	SUBROUTINE PS_INDEX(i,row,col)
cccccccccccccccccccccccccccccccccccccccccccccccccc
c  This routine is used by WRITE_PS to find row  c
c  and column for pen position in postscript     c
cccccccccccccccccccccccccccccccccccccccccccccccccc
	integer row,col,len_ps
	logical noe_ps
	common /postscript/ len_ps,noe_ps,scale_ps
	
	itemp=i
	row=0
5	if((itemp-len_ps).le.0)goto 10
	row=row+1
	itemp=itemp-len_ps
	goto 5
10	col=i-row*len_ps
	return
	end	


	Subroutine WRITE_FINAL(file,len,nres,npeaks,nsft)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	integer peakmax(500),nres,peak_inp,nsft
	integer atmnum(500),rtype(500)
	integer len,s(500,20),assn(500)
	integer peak_array(50,500),e_max(50)
	integer ichange,change(500)
	real st(20),pin(500)
	real x(500),y(500),z(500)
	character*1 pdiff(50),good
	character*2 fnum(0:50)
	character*3 rname(500)
	character*60 file
	character*100 outfile,date_time
	integer path_len
	character*100 path,fname
	
	Integer peak_stat(50,500),score_stat(50),num_stat,SL
	integer emax

	
	Common /path/ path,path_len
	
	Common	Common /pdb/ atmnum, rname, rtype, x, y, z
	Common /jcoup/ pin,assn,peak_inp
	Common /jcoups/ s
	Common /e_max/ peak_array,e_max
	Common /statistics/ peak_stat,score_stat,num_stat,SL
	Common /extension/ fnum



	outfile= path(1:path_len)//file(1:len)//'_final'

	open(unit=10,file=outfile,status='unknown')
	call fdate(date_time)
	write(10,50)'%%',date_time

50	format(a2,48x,a28)


c
c  FIND highest score solution
c


	idx=1
	emax=score_stat(1)
	do i=1,num_stat
		if (score_stat(i).gt.emax) then
c	write(6,*) i,score_stat(i)
			emax=score_stat(i)
			idx=i
		endif
	enddo

	do i=1,nres


		ichange=0
		do k=1,num_stat
		if( peak_stat(idx,i).ne.peak_stat(k,i) ) ichange=ichange+1
		enddo

	change(i)=ichange

	enddo

 	do i=1,nres
	peakmax(i)=peak_stat(idx,i)
			l=peakmax(i)
			do m=1,nsft
			st(m)=s(l,m)/100.00
			enddo		
	good=' '
	if ((change(i).eq.0).and.(peakmax(i).ne.500)) good='+'


	Write(10,100)i,good,rname(i),pin(peakmax(i)),assn(peakmax(i)),(st(m),m=1,nsft)


100 	FORMAT(i3,a1,1x,a3,1x,f5.1,i4,20f7.2:)


 	enddo

	Write(10,'(a2)') '%%'
	write(10,'(a2)') '%%'
	Write(10,'(a25)') '%%  Spin Systems not used'
	do i=nres+1,npeaks
	peakmax(i)=peak_stat(idx,i)
			l=peakmax(i)
			do m=1,nsft
			st(m)=s(l,m)/100.00
			enddo		
  	if (pin(peakmax(i)).ne.0.0) then 
	Write(10,101)'%%',rname(i),pin(peakmax(i)),assn(peakmax(i)),(st(m),m=1,nsft)
  	endif

	enddo
101 	FORMAT(a2,2x,1x,a3,1x,f5.1,i4,20f7.2:)

	close(10)
	return
	end


cccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	Subroutine to make solutions directory
c       if not already there.
c
c       If already there, remove it a recreate it.
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccc
	Subroutine MAKE_DIRECTORY(path,path_len)

	integer access,ierr
	integer path_len
	character*100 path,dir

	dir=path(1:path_len)//'solutions'
	ierr=access(dir,' ')

	if (ierr.eq.0)	then
		call system('rm '//dir(1:path_len+9)//'/*.soln')
		jerr=access(path(1:path_len)//'solutions/corr.ps',' ')
		if (jerr.eq.0) call system('rm '//dir(1:path_len+9)//'/*.ps')
			endif
	if (ierr.ne.0) call system('mkdir '//dir(1:path_len+9))

	return
	end

	Subroutine WRITE_CORRELATION(file,len,nres,peakmax)

	integer peakmax(500),nres,peak_inp
	integer len,rtnum(20)
	integer sscode(500),assn(500)
	real pin(500)
	character*1 one(20)
	character*3 three(20)
	character*60 file,outfile,date_time
	character*100 path,fname
	integer path_len
	Integer peak_stat(50,500),score_stat(50),num_stat,SL

	integer ps_mat(500,500)
	integer chk
	logical found
	
	integer xorigin,yorigin
	integer xstart,ystart,x,y
	integer xstep,ystep
	integer spc
	real scale
	real gray

	Common /jcoup/ pin,assn,peak_inp
	Common /path/ path,path_len
	Common /aa/ rtnum,one,three
	Common /ss/ sscode
	Common /statistics/ peak_stat,score_stat,num_stat,SL



c
c  Zero matrix
c
	do i=1,500
	do j=1,500
		ps_mat(i,j)=0

	enddo
	enddo

	do 300 i=1,nres
	do 200 j=1,num_stat

	chk=peakmax(i)
		if (chk.eq.500) found=.true.
		if (chk.gt.peak_inp) goto 110

	found=.false.

	do 100 k=1,nres
		if (chk.eq.peak_stat(j,k)) then
		ps_mat(k,i)=ps_mat(k,i)+1
		found=.true.
		endif

100 	continue

110		if (.not.found) ps_mat(i,500)=ps_mat(i,500)+1
200	continue

300 	continue


c	do i=1,nres
c	write(6,'(i4,300i2:)') i,(ps_mat(i,k),k=1,nres),ps_mat(i,500)
c	enddo


	fname=path(1:path_len)//'solutions/corr.ps'
	open(unit=10,file=fname,status='unknown')

	Write(10,'(a30)')'%!Postscript file - FullMonte v1.0'
	Write(10,'(a18)')'%%Character macros'
	write(10,'(a6)')'/fh {'
	write(10,*)'/Helvetica findfont exch'
	Write(10,*)'scalefont setfont'
	Write(10,*)'} bind def'
	Write(10,'(a29)')'/stc { gsave translate rotate'
	Write(10,*)'dup stringwidth pop 2'
	Write(10,*)'div neg 0 moveto show grestore'
	Write(10,*)'} bind def'

	Write(10,'(a11)')'%%EndProlog'



c
c  calculate how many dots across
c

	spc=3

	
	j=spc*nres
	scale = 72*7.0/j
 	if (scale.gt.1.0) scale=1.0


c	xstart = int(((612-j)*scale)*2/3)
c	ystart= int((792-2*72)/scale)



	if (scale.eq.1.0) then
		xstart = int(((612/scale)-(j))/2)
	else
	xstart = int(((612/scale)-(j))*2/3)
	endif
	ystart = int((792/scale)-(72*2/scale))

c	write(6,*) 'scale: ',scale
c	write(6,*) 'xstart ', xstart
c	write(6,*)'ystart ', ystart

	call fdate(date_time)
	write(10,*) '10 fh'
	write(10,301) '(',date_time,') 0.0 520 770 stc'
301	format(a1,a28,a17)

c	SCALE POSTSCRIPT
	write(10,'(f5.3,a1,f5.3,a6)')scale,' ',scale,' scale'

	xstep= int(10*spc)
	ystep= int(10*spc)

c  number x-axis
c

	x=xstart
	y=ystart+2*spc
	x=x+xstep
	do 320 i=2, nres


	if ((MOD(i,10)).eq.0) then

	write(10,*) '12 fh'
	write(10,310) '(',i,') 0.0 ',x,' ',y,' stc'
310	format(a,i3,a6,i7,a,i7,a4)

	x=x+xstep

	endif


320 	continue

	x=xstart-6*spc
	y=ystart-ystep

	do 340 i=2, nres
	if ((MOD(i,10)).eq.0) then
	write(10,*) '12 fh'
	write(10,310) '(',i,') 0.0 ',x,' ',y,' stc'

	y=y-ystep

	endif


340 	continue





	write(10,*) '0.9 setgray'
	write(10,*) '[3] 0 setdash'
	xstep= int(10*spc)
	ystep= int(10*spc)
	x=xstart
	y=ystart

	x=x+xstep
	do 400 i=2, int(1.0*nres/10*spc)
	if (x.gt.xstart-spc+(nres*spc)+spc) goto 400
	write(10,*) 'newpath'	
	write(10,*) x-spc,ystart+spc,' moveto'
	write(10,*) x-spc,ystart-(spc*nres)-6*spc,' lineto'
	write(10,*) 'stroke'
	x=x+xstep
400 	continue

	y=y-ystep

	do 500 i=2, int(1.0*nres/10*spc)
 	if (y.lt.ystart+spc-(spc*nres)-spc) goto 500
	write(10,*) 'newpath'	
	write(10,*) xstart-spc,y+spc,' moveto'
	write(10,*) xstart+(nres*spc)+spc,y+spc,' lineto'
	write(10,*) 'stroke'
	y=y-ystep
500 	continue

c  draw a box	


	write(10,*) '0 setgray'
	write(10,*) '[] 0 setdash'
	write(10,*) 'newpath'
	write(10,*) xstart-spc,ystart+spc,' moveto'
	write(10,*) xstart+(nres*spc)+spc,ystart+spc,' lineto'	
	write(10,*) xstart+(nres*spc)+spc,ystart-(spc*nres)-6*spc,' lineto'	
	write(10,*) xstart-spc,ystart-(spc*nres)-6*spc,' lineto'	
	write(10,*) xstart-spc,ystart+spc,' lineto'
	write(10,*) xstart+(nres*spc)+spc,ystart-(spc*nres)-spc,' moveto'
	write(10,*) xstart-spc,ystart-(spc*nres)-spc,' lineto'	
	write(10,*) 'stroke'

c  label axis
	write(10,*) '20 fh'
	write(10,*) '(Residue) 0.0',xstart+(nres*spc/2),ystart+9*spc,' stc'

	write(10,*) '20 fh'
	write(10,*) '(Alternate Assignment) 90.0',xstart-11*spc,ystart-(nres*spc/2),' stc'


c  put in correlation dots

	y=ystart+spc
c	write(10,*) '0 setgray'
	do i=1,nres
	x=xstart
	y=y-spc
	do j=1,nres
	if (ps_mat(i,j).ne.0) then
		gray= 1.0 - ((1.0*ps_mat(i,j)/num_stat)*0.8+0.2)
		write(10,'(f4.2,a8)') gray,' setgray'
		write(10,*)'newpath ',x,y,1.5,0,360,' arc fill stroke'
		endif
	x=x+spc
	enddo
	enddo

c  go through spin systems not used

	x=xstart
	y=y-4*spc
	j=500
	do i=1,nres
	if (ps_mat(i,j).ne.0) then
		gray= 1.0 - ((1.0*ps_mat(i,j)/num_stat)*0.8+0.2)
		write(10,'(f4.2,a8)') gray,' setgray'
		write(10,*)'newpath ',x,y,1.5,0,360,' arc fill stroke'
		endif
	x=x+spc
	enddo


	write(10,*)'showpage'
	close(10)

	return
	end




	Subroutine ADD_AMIDE(file,len)

c  Add amide proton coordinates to PDB file.
c
c  Reads names of input and output PDB files from a file 
c    add_amide.in
c  Writes coordinates of atoms (including protons) to 
c  the specified output file.
	character*80 file_in, file_out
     	character*6 rectype 
	character*4 atmname
	character*1 chain
	character*3 resname

	character*69 rest_rec
	character*8 end_rec
	character*7 fmt
	character*80 line, cur_ln(0:29), last_ln(0:29), 
     1	  pre_ln(0:29)
	integer serno, seqno, atm_incur
	logical pending
	character*60 file,pdbfile
	integer path_len,len
	character*100 path,fname

	Common /path/ path,path_len
	common /block1/ iserno
	common /bond_len/ r_NH, r_CH, r_OH
		
	do i=0,29
	cur_ln(i)='NULL      0  X   XXX     0       0.000   0.000   0.000'
       	last_ln(i)= cur_ln(i)
  	pre_ln(i) =cur_ln(i)
	enddo

	n_inlast = 0
	n_inpre = 0 
	atm_incur = 0
	iseqno =-10


c
	pending= .TRUE.
c
c  Variables:
c  atm_incur   current number of atoms in residue.
c  cur_ln      array of lines in current residue.
c  last_ln     array of lines in last completed residue.
c  n_inlast    total number of atoms in last completed residue.
c  pre_ln      array of lines in preceding residue.
c  n_inpre     total number of atoms in preceding residue.
c  
c  Proton-nitrogen, proton-carbon and proton-oxygen distances.
	r_NH= 1.00
	r_CH= 1.09
	r_OH= 0.96




	file_in=path(1:path_len)//file(1:len)//'.pdb'
     	file_out=path(1:path_len)//'temp.pdb'

c  Check whether records in PDB file begin with blank
c  spaces; set format accordingly.

	call check_PDB(file_in,fmt)

c  Open PDB file, and output file.
	open(unit=11,file=file_in,status='old',form='formatted')
	open(unit=12,file=file_out,status='unknown')

c  Initialize serial number of atom.
	iserno= 0
10	continue
	    read(11,fmt,end=100) line
	    if ((line(1:4) .eq. 'ATOM').and.(line(14:14).ne.'H')) then
		pending= .TRUE.
	    	read(line,988) rectype,serno,atmname,resname,
     1	          chain,seqno,x,y,z
     	    	if (seqno .eq. iseqno) then
c  This line belongs to the same residue.
		    atm_incur= atm_incur+1
		    cur_ln(atm_incur)= line
	    	else
c  The last residue is complete.  Add coordinates of hydrogen
c  atoms.
		    call complete_res(n_inpre,n_inlast,atm_incur,
     1		      pre_ln,last_ln,cur_ln)
c  Write to log file.
cc		    call write_log(n_inpre,n_inlast,pre_ln,last_ln)
c  This line starts a new residue.
	    	    atm_incur= 1
	    	    iseqno= seqno
		    cur_ln(atm_incur)= line
	    	endif
	    else if (line(1:3) .eq. 'TER') then
c  The last residue is complete.  Add coordinates of hydrogen
c  atoms.
		if (pending)
     1		  call complete_res(n_inpre,n_inlast,atm_incur,
     2		  pre_ln,last_ln,cur_ln)
		pending= .FALSE.
c  Write to log file.
cc		call write_log(n_inpre,n_inlast,pre_ln,last_ln)
c  Write TER line, with updated serial number.
		iserno= iserno+1
		read(line,992) rectype,serno,rest_rec
		write(line,992) rectype,iserno,rest_rec
		write(12,991) line
c  Flush arrays, to prepare for next chain.
 		call flush_res(cur_ln,last_ln,pre_ln, 
     1	  	  n_inlast,n_inpre,atm_incur,iseqno)
	    else if (line(1:6) .eq. 'HETATM') then
c  Write HETATM line, with updated serial number.
	    	read(line,990) rectype,serno,atmname,resname,
     1		  chain,seqno,x,y,z,occ,tfact,end_rec
     	    	if (seqno .ne. iseqno) then
		    if (pending)
     1		      call complete_res(n_inpre,n_inlast,
     2		      atm_incur,pre_ln,last_ln,cur_ln)
		    pending= .FALSE.
		endif
		iserno= iserno+1
		iseqno= seqno
 	    	write(line,990) rectype,iserno,atmname,resname,
     1		  chain,seqno,x,y,z,occ,tfact,end_rec
		write(12,991) line
    	    else
c  Write line, if it is not a CONECT record.
		if ((line(1:4) .eq. 'ATOM').and.(line(14:14).eq.'H')) then
		   continue
		else if (line(1:6) .ne. 'CONECT') then
		   write(12,991) line
		else
		   continue
		endif
	    endif
	    goto 10
100	continue	

	close(unit=11)
	close(unit=12)
c  Format for ATOM or HETATM records.
988	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3)
990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
991	format(A)
992	format(A6,I5,A69)
	end
c
c
	Subroutine complete_res(n_inpre, n_inlast, atm_incur,
     1	  pre_ln, last_ln, cur_ln)
c  The last residue is complete.
	character*80 cur_ln(0:29), last_ln(0:29), pre_ln(0:29),
     1	  line
	character rectype*6, atmname*4, chain*1, resname*3,
     1	  end_rec*8
	integer serno, seqno, atm_incur
	common /block1/ iserno
c  The last completed residue becomes the preceding residue.
	n_inpre= n_inlast
	do 20 i_inpre= 1, n_inpre
	    pre_ln(i_inpre)= last_ln(i_inpre)
20	continue
c  The current residue becomes the last completed residue.
	n_inlast= atm_incur
	do 30 i_inlast= 1, n_inlast
	    last_ln(i_inlast)= cur_ln(i_inlast)
30	continue
c  If the last completed residue is not empty, add hydrogen
c  coordinates.
	if (n_inlast .gt. 0) call add_protons(n_inpre,n_inlast,
     1	  pre_ln,last_ln)
c
	do 40 i= 1, n_inlast
c  Write ATOM lines with updated serial numbers.
	    iserno= iserno+1
	    line= last_ln(i)
	    read(line,990) rectype,serno,atmname,resname,
     1	      chain,seqno,x,y,z,occ,tfact,end_rec
	    write(line,990) rectype,iserno,atmname,resname,
     1	      chain,seqno,x,y,z,occ,tfact,end_rec
	    last_ln(i)= line
	    write(12,991) last_ln(i)
40	continue
c
990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
991	format(A)
	return
	end
c
c
	subroutine write_log(n_inpre,n_inlast,pre_ln, last_ln)
	character rectype*6, atmname*4, chain*1, resname*3
	character*80 last_ln(0:29), pre_ln(0:29)
	integer serno, seqno
c  Write to log file.
	write(13,*)
	read(pre_ln(n_inpre),988) rectype,serno,
     1	  atmname,resname,chain,seqno,x,y,z
     	write(13,31) resname, chain, seqno, n_inpre
31	format(2X,'preceding residue ',A3,1X,A1,1X,I4,' has ',
     1	  I3,' atoms.')
     	do 40 i_inpre= 1, n_inpre
     	    write(13,'(A)') pre_ln(i_inpre)(1:54)
40	continue
	read(last_ln(n_inlast),988) rectype,serno,
     1	  atmname,resname,chain,seqno,x,y,z
     	write(13,41) resname, chain, seqno, n_inlast
41	format(2X,'last residue ',A3,1X,A1,1X,I4,' has ',
     1	  I3,' atoms.')
     	do 50 i_inlast= 1, n_inlast
     	    write(13,'(A)') last_ln(i_inlast)(1:54)
50	continue
988	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3)
	return
	end
c
c
	subroutine flush_res(cur_ln, last_ln, pre_ln, 
     1	  n_inlast, n_inpre, atm_incur, iseqno)
c  Flush lists of atoms.
	character*80 cur_ln(0:29), last_ln(0:29), pre_ln(0:29),
     1	  nul_line
	integer atm_incur
	parameter(nul_line= 
     1	'NULL      0  X   XXX     0       0.000   0.000   0.000'
     2	)
c
	do 10 i= 0, 29
	    cur_ln(i)= nul_line
	    last_ln(i)= nul_line
	    pre_ln(i)= nul_line
10	continue
c
	n_inlast= 0
	n_inpre= 0
	atm_incur= 0
	iseqno= -10
c
	return
	end
c
c
	subroutine check_PDB(fln,fmt)
c  Check whether records in PDB file begin with blank
c  spaces; set format accordingly.
	character*(*) fln, fmt
	character line*80
	open(unit=11,file=fln,status='old',form='formatted')
c  Look for first column in which 'ATOM' appears.
	i_min= 100
10	continue
	    read(11,'(A80)',end=20) line
	    i= index(line,'ATOM')
	    if ((i.lt.i_min) .and. (i.gt.0)) i_min= i
	goto 10
20	continue
	if (i_min .eq. 1) then
	    fmt= '(A)'
	else if (i_min .eq. 2) then
	    fmt= '(1X,A)'
	else if (i_min.eq. 3) then
	    fmt= '(2X,A)'
	else
	    pause 'error in check_PDB'
	endif
	close(unit=11)
	return
	end
c
c
	subroutine add_protons(n_inpre,n_inres,pre_ln,res_ln)
c  Add proton coordinates to last completed residue.
	character*80 res_ln(0:29), pre_ln(0:29)
	character rectype*6, atmname*4, chain*1, resname*3,
     1	  resname_pre*3
	integer serno, seqno_res, seqno_pre
c
	read(res_ln(1),988) rectype,serno,atmname,resname,
     1	  chain,seqno_res,x,y,z
c  If preceding amino acid is available, and if amino
c  acid is not Proline, add backbone amide proton . 
	if (n_inpre .gt. 0) then
	    read(pre_ln(1),988) rectype,serno,atmname,
     1	      resname_pre,chain,seqno_pre,x,y,z
     	    if ((seqno_res .eq. seqno_pre+1) .and.
     1	        (resname .ne. 'PRO')) call 
     2	      add_NH(n_inpre,n_inres,pre_ln,res_ln)
     	endif
c
988	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3)
	return
	end
c
c
	subroutine add_NH(n_inpre,n_inres,pre_ln,res_ln)
c  Add backbone amide proton coordinates.
	character*80 res_ln(0:29), pre_ln(0:29), line
	character rectype*6, atmname*4, chain*1, resname*3,
     1	  end_rec*8
	integer serno, seqno
	real xx_CO(3),xx_N(3),xx_CA(3),xx_NH(3),uu_NH(3)
	common /bond_len/ r_NH, r_CH, r_OH
c
c  Search for Carbonyl of preceding residue.
	call find_atom(n_inpre,pre_ln,' C  ',line_no,xx_CO)
	if (line_no .eq. 0) goto 1000
c
c  Search for backbone Nitrogen of current residue.
	call find_atom(n_inres,res_ln,' N  ',line_no,xx_N)
	if (line_no .eq. 0) goto 1000
	line_no_N= line_no
c
c  Search for alpha Carbon of current residue.
	call find_atom(n_inres,res_ln,' CA ',line_no,xx_CA)
	if (line_no .eq. 0) goto 1000
c
c  Calculate amide N->H unit vector.
	call calc_plan1(xx_CO,xx_CA,xx_N,uu_NH)
	do 60 i= 1, 3
	    xx_NH(i)= r_NH*uu_NH(i)+xx_N(i)
60	continue
c  Add new line to list of atoms in residue.
	line= res_ln(line_no_N)
	read(line,990) rectype,serno,atmname,resname,
     1	      chain,seqno,x,y,z,occ,tfact,end_rec
	atmname= ' H  '
     	n_inres= n_inres+1
	write(res_ln(n_inres),990) rectype,serno,atmname,
     1	  resname,chain,seqno,(xx_NH(i), i=1,3),occ,tfact,
     2	  end_rec
c
990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
1000	return
	end
c
c
	subroutine find_atom(n_inres,res_ln,atom,line_no,xx)
c  Search for a particular atom in a residue. line_no= 0 if
c  the atom is not found.  Otherwise, line_no is the line #
c  containing the desired atom, and xx is an array giving its
c  coordinates.
	character*80 res_ln(0:29), line
	character rectype*6, atmname*4, atom*4, chain*1, 
     1	  resname*3, end_rec*8
	integer serno, seqno
	real xx(3)
c
	do 20 i= 1, n_inres
	    line= res_ln(i)
	    read(line,990) rectype,serno,atmname,resname,
     1	      chain,seqno,x,y,z,occ,tfact,end_rec
     	    if (atmname .eq. atom) goto 25
20	continue
c  Atom not found!
	line_no= 0
	goto 1000
25	continue
	line_no= i
	xx(1)= x
	xx(2)= y
	xx(3)= z
990	format(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A8)
1000	return
	end
c
c
	subroutine calc_plan1(xx_CO,xx_CA,xx_N,uu_NH)
c  Calculate amide N->H unit vector, given coordinates of
c  CO of preceding amino acid, and CA and N of this amino
c  acid.
	real xx_CO(3),xx_N(3),xx_CA(3),uu_NCO(3),uu_NCA(3),
     1	  uu_NH(3)
	call unit_disp(xx_N,xx_CO,uu_NCO)
	call unit_disp(xx_N,xx_CA,uu_NCA)
	do 50 i= 1, 3
	    uu_NH(i)= -(uu_NCO(i)+uu_NCA(i))
50	continue
	call unit_vec(uu_NH)
	return
	end
c
c
	subroutine calc_plan2(xx_OD,xx_CB,xx_CG,uu_NH1,uu_NH2)
c  Calculate NH2 N->H unit vectors for Asn side-chain, given 
c  coordinates of OD1, CB, and CG.
	real xx_OD(3),xx_CB(3),xx_CG(3),uu_NH1(3),uu_NH2(3),
     1	  uu_ODCG(3),uu_CBCG(3)
	call unit_disp(xx_OD,xx_CG,uu_ODCG)
	call unit_disp(xx_CB,xx_CG,uu_CBCG)
	do 50 i= 1, 3
	    uu_NH1(i)= uu_ODCG(i)
	    uu_NH2(i)= uu_CBCG(i)
50	continue
	return
	end
c
c
	subroutine calc_tet1(xx_CO,xx_N,xx_CB,xx_CA,uu_CH)
c  Calculate CA->HA unit vector, given coordinates of
c  CO, CB, CA, and N of this amino acid.
	real xx_CO(3),xx_N(3),xx_CA(3),xx_CB(3),uu_CACO(3),
     1	  uu_CAN(3),uu_CACB(3),uu_CH(3)
	call unit_disp(xx_CA,xx_CO,uu_CACO)
	call unit_disp(xx_CA,xx_N,uu_CAN)
	call unit_disp(xx_CA,xx_CB,uu_CACB)
	do 50 i= 1, 3
	    uu_CH(i)= -(uu_CACO(i)+uu_CAN(i)+uu_CACB(i))
50	continue
	call unit_vec(uu_CH)
	return
	end
c
c
	subroutine calc_tet2(xx_CO,xx_N,xx_CA,uu_CH1,uu_CH2)
c  Calculate CA->HA unit vectors for Gly, given coordinates of
c  CO, CA, and N of this amino acid.
	real xx_CO(3),xx_N(3),xx_CA(3),uu_CACO(3),uu_CAN(3),
     1	  uu_CH1(3),uu_CH2(3),cc(3)
     	parameter(a= 0.86603)
	call unit_disp(xx_CA,xx_CO,uu_CACO)
	call unit_disp(xx_CA,xx_N,uu_CAN)
	call cross_prod(uu_CACO,uu_CAN,cc)
	do 20 i= 1, 3
	    uu_CH1(i)=  a*cc(i)-0.5*(uu_CACO(i)+uu_CAN(i))
	    uu_CH2(i)= -a*cc(i)-0.5*(uu_CACO(i)+uu_CAN(i))
20	continue
	call unit_vec(uu_CH1)
	call unit_vec(uu_CH2)
	return
	end
c
c
	subroutine calc_tet3(xx_N,xx_CA,xx_CB,uu_CH1,uu_CH2,
     1	  uu_CH3)
c  Calculate CB->HB unit vectors for Ala, given coordinates of
c  N, CA, and CB of this amino acid.
	real xx_CA(3),xx_CB(3),xx_N(3),uu_CAN(3),
     1	  uu_CH1(3),uu_CH2(3),uu_CH3(3),xx_CH1(3)
	common /bond_len/ r_NH, r_CH, r_OH
c  Unit vector Cb->Hb1 = -(unit vector Ca->N)
     	call unit_disp(xx_CA,xx_N,uu_CAN)
     	do 10 i= 1, 3
     	    uu_CH1(i)= -uu_CAN(i)
     	    xx_CH1(i)= r_CH*uu_CH1(i)+xx_CB(i)
10	continue
c  Now we have positions of CA, HB1, and CB.  Calculate
c  unit vectors CB->CH2 and CB->CH3
	call calc_tet2(xx_CA,xx_CH1,xx_CB,uu_CH2,uu_CH3)
	return
	end
c
c
	subroutine calc_tet4(xx_CG,xx_SD,xx_CE,uu_CHE1,uu_CHE2,
     1	      uu_CHE3)
c  Calculate CE->HE unit vectors for Met, given coordinates of
c  CG, SD, and CE of this amino acid.
	real xx_CG(3),xx_SD(3),xx_CE(3),uu_GD(3),uu_DE(3),
     1	  xx_CHE1(3),uu_CHE1(3),uu_CHE2(3),uu_CHE3(3)
	common /bond_len/ r_NH, r_CH, r_OH
c  Atoms 1HE, CE, SD, and CG are coplanar.
	call unit_disp(xx_CG,xx_SD,uu_GD)
	call unit_disp(xx_SD,xx_CE,uu_DE)
	cos_theta= -uu_GD(1)*uu_DE(1)-uu_GD(2)*uu_DE(2)
     1	  -uu_GD(3)*uu_DE(3)
     	sin_theta= sqrt(1.00001-cos_theta**2.)
     	b= (sqrt(8.)*cos_theta/sin_theta+1.)/3.
     	a= (sqrt(8.)*sin_theta-cos_theta)/3.+cos_theta*b
	do 10 i= 1, 3
	    uu_CHE1(i)= a*uu_GD(i)+b*uu_DE(i)
	    xx_CHE1(i)= r_CH*uu_CHE1(i)+xx_CE(i)
10	continue
c  Now we have positions of SD, CHE1, and CE.  Calculate
c  unit vectors CE->CHE2 and CE->CHE3
	call calc_tet2(xx_SD,xx_CHE1,xx_CE,uu_CHE2,uu_CHE3)
	return
	end



	SUBROUTINE CALC_SEC_STRUCTURE(nres)
c2345678901234567890123456789012345678901234567890123456789012345
c        1         2         3         4         5         6
c  Read name of PDB file from "calc_secstruct.in".
c  Read atom coordinates and calculate backbone torsion angles.
c  Based on phi and psi, decide whether each residue is in an
c  alpha helix ("a"), beta sheet ("b") or coil ("c").
c  Writes to filename.sscalc (where filename is the root name
c  of the PDB file):
c  1-letter amino-acid name, sequence #, 1-letter secondary
c  structure code (a, b, or c), phi and psi.
c

	
	integer nres
	real phi(500), psi(500)
	integer rtnum(20)
	character*3 three(20)
	character*1 one(20),res1,sec_type

	real xx(3,500), yy(3,500), zz(3,500)
	integer path_len
	integer sscode(500)
	character*100 path,fname
	character*60 file

	Common /aa/ rtnum,one,three
	common /coords /xx, yy, zz
	Common /ss/ sscode
	Common /path/ path,path_len




c  Regions in ramachandran plot for helix and sheet have
c  r_helix(phi,psi)<1 and r_sheet(phi,psi)<1, respectively.
       r_helix(x,y)= ((x-y+46.3)/61.9)**2 + 
     1                ((x+y+103.1)/29.7)**2
	r_sheet(x,y)= ((x+114.8)/66.1)**2 + 
     1                ((y-141.5)/45.6)**2


c  Calculate phi and psi.
	

	do i= 2 , (nres-1)
          iprev=i-1
	  inext=i+1
	   phi(i)= angle(iprev,3,i,1,i,2,i,3)
	   psi(i)= angle(i,1,i,2,i,3,inext,1)

	write(6,*) i,phi(i),psi(i)

	enddo


	
	do i_seq= 2, nres

	      x= phi(i_seq)
	      y= psi(i_seq)

c Shift angles to range [-360,0]x[-90,270]
	      if ((x.gt.0.).and.(x.le.180)) x= x-360.
	      if ((y.ge.-180.).and.(y.lt.-90.)) y= y+360
	      if (r_helix(x,y).le.1.) then
c		 sec_type= 'a'
		 sscode(i_seq)=3
	      else if (r_sheet(x,y).le.1.) then
c		 sec_type= 'b'
		 sscode(i_seq)=2
	      else
c		 sec_type= 'c'
		 sscode(i_seq)=1
	      endif
		
	enddo

	end

c
c
        function angle(i1,a1,i2,a2,i3,a3,i4,a4)

c
c    i ( res num), a, atom type
c
C Calculates torsion angle from coordinates with indices
c  i1,i2,i3,i4.  If any coordinates are missing, returns
c  an angle = -999.

	real xx(3,500), yy(3,500), zz(3,500)
        real v21(3),v23(3),v34(3),v123(3),v234(3),v(3)
	logical missing
	integer i1,i2,i3,i4,a1,a2,a3,a4


        common /coords/ xx,yy,zz
c
        missing= .FALSE.
        if (((i1.eq.0).or.(i2.eq.0)).or.
     1      ((i3.eq.0).or.(i4.eq.0))) then 
           missing= .TRUE.

	

        else

	

           v21(1)=xx(a1,i1)-xx(a2,i2)
           v21(2)=yy(a1,i1)-yy(a2,i2)
           v21(3)=zz(a1,i1)-zz(a2,i2)
           v23(1)=xx(a3,i3)-xx(a2,i2)
           v23(2)=yy(a3,i3)-yy(a2,i2)
           v23(3)=zz(a3,i3)-zz(a2,i2)
           v34(1)=xx(a4,i4)-xx(a3,i3)
           v34(2)=yy(a4,i4)-yy(a3,i3)
           v34(3)=zz(a4,i4)-zz(a3,i3)

           call vprod(v21,v23,v123,r1,st)
           call vprod(v23,v34,v234,r2,st)
           call vscal(v123,v234,scalp,cthet)
           call vprod(v123,v234,v,r3,sthet)
           call vscal(v,v23,scum,chet)

           if(chet.gt.0.0) chet=1.0
           if(chet.lt.0.0) chet=-1.0
           if(chet.eq.0.0) stop 'CHET=0'

           angle=atan2((sthet*chet),cthet)*57.29578
           angle=angle-180.0
           if(angle.lt.-180.0) angle=angle+360.0
           if(angle.gt.180.0) angle=angle-360.0
        endif

        if (missing) angle=-999.0

        return
        end
c
c
        subroutine vprod(A,B,P,R,STHET)
        real A(3),B(3),P(3)
        P(1)=A(2)*B(3)-A(3)*B(2)
        P(2)=A(3)*B(1)-A(1)*B(3)
        P(3)=A(1)*B(2)-A(2)*B(1)
        R=SQRT(P(1)*P(1)+P(2)*P(2)+P(3)*P(3))
        RA=SQRT(A(1)*A(1)+A(2)*A(2)+A(3)*A(3))
        RB=SQRT(B(1)*B(1)+B(2)*B(2)+B(3)*B(3))
        STHET=R/(RA*RB)
        return
        end
c
c
        subroutine vscal(A,B,SC,THET)
        dimension A(3),B(3)
        SC=A(1)*B(1)+A(2)*B(2)+A(3)*B(3)
        RA=SQRT(A(1)*A(1)+A(2)*A(2)+A(3)*A(3))
        RB=SQRT(B(1)*B(1)+B(2)*B(2)+B(3)*B(3))
        THET=SC/(RA*RB)
        return
        end
c
c
