function [q,varq] = generateQandVarqValues(varA,varQ0,Q,Q0)
%%% this function generates values of mean percieved quality and variance ...
%%of quality given varA, varQ, Q, Q0 

global a
% matrix a has the instances of advertisement exposure
T=100;
I=500;

A=Q+sqrt(varA)*randn(T,I);

A=A.*a;



%%% generate quality beliefs and purchases

q(1,1:I)=Q0;
varq(1,1:I)=varQ0;

% q captures the mean of the quality belief
% varq captures the variance of the quality belief
% Choice captures purchase instances
for t=2:1:T
    q(t,:)=(1-a(t-1,:)).*q(t-1,:)...
        + a(t-1,:).*(q(t-1,:)./varq(t-1,:) ...
        + A(t-1,:)/varA).*...
        (1./(1./varq(t-1,:) + 1/varA));
    
    varq(t,:)=(1-a(t-1,:)).*varq(t-1,:)...
        + a(t-1,:).*(1./(1./varq(t-1,:) + 1/varA));
    
end
