function [Choice, q,varq,a,A,price]=genbayeslearndata
% this function will gnerate bayesian learning data
Q0= 3;
varQ0=3;
% Q0 is the prior mean and varQ0 is the prior variance
Q=6;
% Q is the true quality
varA=2;
%varA is the variance of advertisement
alpha=2;
beta=-1.5;
% alpha is quality sensitivity and beta is price sensitivity
I=500; % individuals
T=100; % time priords

%%% generate avertisement signals
a=rand(100,500);
a(a>.7)=1;
a(a<1)=0;
% matrix a has the instances of advertisement exposure
A=Q+sqrt(varA)*randn(T,I);

A=A.*a;

%%% generate price
price = 7+0.5*randn(T,1);
price = repmat(price,1,I);

%%% generate quality beliefs and purchases

q(1,1:I)=Q0;
varq(1,1:I)=varQ0;

% q captures the mean of the quality belief
% varq captures the variance of the quality belief

U=alpha*Q0 + beta*price(1,:);
% U is the utility

Pr=exp(U)./(1+exp(U));

D=rand(1,I);
D(D>Pr)=0;
D(D>0)=1;
Choice=D;
% Choice captures purchase instances
for t=2:1:T
    q(t,:)=(1-a(t-1,:)).*q(t-1,:)...
        + a(t-1,:).*(q(t-1,:)./varq(t-1,:) ...
        + A(t-1,:)/varA).*...
        (1./(1./varq(t-1,:) + 1/varA));
    
    varq(t,:)=(1-a(t-1,:)).*varq(t-1,:)...
        + a(t-1,:).*(1./(1./varq(t-1,:) + 1/varA));
    
    U=alpha*q(t,:) + beta*price(t,:);
    Pr=exp(U)./(1+exp(U));
    D=rand(1,I);
    D(D>Pr)=0;
    D(D>0)=1;
    Choice(t,:)=D;
end

    
    
    




