function [llik]=bayeslearn_llik_obsadsignal(b)
% this function would create likelihood values for bayesian learning model
% when advertisement signals are observed
% b is the set of parameters we want to estimate
Q0=b(1);
varQ0= 3;
alpha = b(3);
beta=b(4);
varA=exp(b(2));
Q=6;

%%% call global variables
global Choice a A price;
I=500;
T=100;
%%% generate quality beliefs and purchases

q(1,1:I)=Q0;
varq(1,1:I)=varQ0;

% q captures the mean of the quality belief
% varq captures the variance of the quality belief

U=alpha*Q0 + beta*price(1,:);
% U is the utility

Pr=exp(U)./(1+exp(U));

lik = Choice(1,:).*Pr + (1-Choice(1,:)).*(1-Pr);
% lik is the likelihood value

% Choice captures purchase instances
for t=2:1:T
    q(t,:)=(1-a(t-1,:)).*q(t-1,:)...
        + a(t-1,:).*(q(t-1,:)./varq(t-1,:) ...
        + A(t-1,:)/varA).*...
        (1./(1./varq(t-1,:) + 1/varA));
    
    varq(t,:)=(1-a(t-1,:)).*varq(t-1,:)...
        + a(t-1,:).*(1./(1./varq(t-1,:) + 1/varA));
    
    U=alpha*q(t,:) + beta*price(t,:);
    Pr=exp(U)./(1+exp(U));
lik(t,:) = Choice(t,:).*Pr + (1-Choice(t,:)).*(1-Pr);
end
llik = -sum(log(prod(lik)));

    
    
    



