function  [llik]=bayeslean_llik(b)
%%% this function calculates likelihood value for bayesian learning model ....
%%when advertisement signals are not observed
%%% this model only needs choice data, data on whether a user was exposed to advertisement...
%%% and the data on price.
%%% this model uses simulated maximum likelihood procedure.
%%% it will simulate the values of the advertisement signals. 



% b is the set of parameters we want to estimate
Q0=b(1);
varQ0= 3;
alpha = b(3);
beta=b(4);
varA=exp(b(2));
Q=6;

%%% call global variables
global Choice a price s;
I=500;
T=100;
% fix the initial seed
rng(s);

%%% generate quality beliefs and purchases

for sim=1:1:100
[q,varq] = generateQandVarqValues(varA,varQ0,Q,Q0);


% q captures the mean of the quality belief
% varq captures the variance of the quality belief

U=alpha*Q0 + beta*price(1,:);
% U is the utility

Pr=exp(U)./(1+exp(U));

lik = Choice(1,:).*Pr + (1-Choice(1,:)).*(1-Pr);
% lik is the likelihood value

% Choice captures purchase instances
for t=2:1:T
      U=alpha*q(t,:) + beta*price(t,:);
    Pr=exp(U)./(1+exp(U));
lik(t,:) = Choice(t,:).*Pr + (1-Choice(t,:)).*(1-Pr);
end
 if sim==1
     slik = prod(lik);
     
 else
     slik=slik + prod(lik);
 end


end
llik = -sum(log(slik/100));

    
    
    



