IPM = {

    oxygenEndpoint: function () {
        var oxygenServer = 'https://accounts.autodesk.com';
        var oxygenEndpoint = window.neutronJavaScriptObject.executeQuery('oxygenEndpoint', '');

        if (oxygenEndpoint == 'STAGING')
            oxygenServer = 'https://accounts-staging.autodesk.com';

        return oxygenServer;
    },

    bootStrap: function () {
        //debugger;
        var target = this;
        if (!jQuery) {
            setTimeout(
                function () {
                    target.bootStrap();
                }
                , 10);
            return;
        }
        console.log("bootStrap");
        //not all browsers support origin property, so need fix it by a combined url in this case.
        if (window.location.origin == undefined)
            window.location.origin = window.location.protocol + "//" + window.location.host;

        var server = window.location.host;
        console.log(server);
        var scripts = document.getElementsByTagName('script');

        jQuery.each(scripts, function (key, value) {
            if (this.src.indexOf('IPM_new.js') != -1) {
                server = this.src;
                var index = server.indexOf('/IPM_new.js');
                server = server.substr(0, index);
            }
        });

        console.log(server);
        target.showIPMOptions(server);
    },

    showIPMOptions: function (server) {
        console.log("showIPMOptions");
		
		if ( typeof neu === 'undefined')
			neu = {};
		
		if ( typeof neu.utils === 'undefined') {
			neu.utils = {};
			
			neu.utils.loadStyleSheet = function(cssPath) {
				// load css
				if (document.createStyleSheet) {// for IE
					document.createStyleSheet(cssPath);
				} else {
					jQuery('<link>').attr({
										  rel : "stylesheet",
										  type : "text/css",
										  href : cssPath
										  }).appendTo('head');
				}
			};

			neu.utils.resourceManager = {};
			
			neu.utils.resourceManager.loadResource = function (resFiles, callback) {
				var language = '';
				
				if (typeof resFile == 'string')
					resFiles = [resFile];
				
				// For testing purpose, use Neutron user language. Ideally we should use the language on Qontext page
				//
				if (window.neutronJavaScriptObject)
					language = window.neutronJavaScriptObject.executeQuery('GetUserLanguage', '');
			};
		}
		
        neu.locStrings = window.neutronJavaScriptObject.executeQuery('getLocStrings2', '');
		console.log(neu.locStrings);
        if (neu.locStrings) {
            neu.locStrings = JSON.parse(neu.locStrings);
        }
		
        var self = this;
        if (!neu || !neu.locStrings) {
            setTimeout(function ()
            { self.showIPMOptions(server); }
                , 10);
            return;
        }
        neu.utils.loadStyleSheet(server + "/common_new.css");
        var items = [];
        var applications = [
            {
                appId: 'Fusion360',
                descriptionTrialExpiring: neu.locStrings.fusionTrialAboutToExpire,
                descriptionTrialEntitlemet: neu.locStrings.fusionTrialEntitlementDescription,
                descriptionTrialExpired: neu.locStrings.fusionTrialExpired,
                descriptionEntitlemet: neu.locStrings.fusionEntitlementDescription,
                descriptionExpired: neu.locStrings.fusionExpired,
                banner: server + '/myimages/Fusion360_purchase_banner.png',
				closeIcon: server + '/myimages/close.png',
				closeButton: neu.locStrings.trialCloseAction,
				primarilyusefor: neu.locStrings.primarilyusefor,
				modeling3d: neu.locStrings.modeling3d,
				productdesign: neu.locStrings.productdesign,
				toolpathmachining: neu.locStrings.toolpathmachining,
				drawings: neu.locStrings.drawings,
				simulation: neu.locStrings.simulation,
				otheroption: neu.locStrings.otheroption,
				btncontinue: neu.locStrings.btncontinue,
				btnBuyNow: neu.locStrings.btnBuyNow,
				qualifyForFreeUse: neu.locStrings.qualifyForFreeUse,
				seeIfQualified: neu.locStrings.seeIfQualified,
				trialGroup: 'fusion360trial',
				allSetBanner: server + '/myimages/all_set.png'
            }
        ];

        var now = new Date();
        var args = {};
        for (var i = 0; i < applications.length; ++i) {
            args.appId = applications[i].appId;
            var entitlement = JSON.parse(window.neutronJavaScriptObject.executeQuery('EntitlementDetails', JSON.stringify(args)));
            var item = {};
            item.appId = applications[i].appId;
            item.banner = applications[i].banner;
			item.closeIcon = server + '/myimages/close.png';
			item.closeButton = neu.locStrings.trialCloseAction;
			
			item.primarilyusefor = applications[i].primarilyusefor;
			item.modeling3d = applications[i].modeling3d;
			item.productdesign = applications[i].productdesign;
			item.toolpathmachining = applications[i].toolpathmachining;
			item.drawings = applications[i].drawings;
			item.simulation = applications[i].simulation;
			item.otheroption = applications[i].otheroption;
			item.otherInputErrInfo = neu.locStrings.otherInputErrInfo;
			item.btncontinue = applications[i].btncontinue;
			
			item.btnBuyNow = applications[i].btnBuyNow;
			item.qualifyForFreeUse = applications[i].qualifyForFreeUse;
			item.seeIfQualified = applications[i].seeIfQualified;
            item.contactForHelp = neu.locStrings.contactForHelp;
            item.hrefContactForHelp = neu.locStrings.hrefContactForHelp;
			
			item.link = neu.locStrings.fusionPurchaseLink;
			item.trialGroup = applications[i].trialGroup;
			
			item.useFusionSolelyAs = neu.locStrings.useFusionSolelyAs;
			item.personalProjects = neu.locStrings.personalProjects;
			item.startupCompany = neu.locStrings.startupCompany;
			item.eduStudent = neu.locStrings.eduStudent;
			item.directbuynow = neu.locStrings.directbuynow;
			item.readmoreLicenseInfo = neu.locStrings.readmoreLicenseInfo;
			item.hrefReadLicense = neu.locStrings.hrefReadLicense;
			item.btnDirectBuyNow = neu.locStrings.btnDirectBuyNow;
			item.fusionRegEduLink = neu.locStrings.fusionRegEduLink;
			
			item.oneMoreStep = neu.locStrings.oneMoreStep;
			item.personalPlanUseFusion = neu.locStrings.personalPlanUseFusion;
			item.licenseCertityInfo = neu.locStrings.licenseCertityInfo;
			item.personalCheckOneDescribe = neu.locStrings.personalCheckOneDescribe;
			item.personalCheckTwoDescribe = neu.locStrings.personalCheckTwoDescribe;
			item.personalConfirmStatement = neu.locStrings.personalConfirmStatement;
            item.hrefPricingOptions = neu.locStrings.fusionPurchaseLink;
			item.personalCompleteRegistration = neu.locStrings.personalCompleteRegistration;
			item.personalBuyNow = neu.locStrings.personalBuyNow;
			item.returnBack = neu.locStrings.returnBack;
			
			item.startupPlanUseFusion = neu.locStrings.startupPlanUseFusion;
			item.startupCompanyInfo = neu.locStrings.startupCompanyInfo;
			item.startupWebsiteInfo = neu.locStrings.startupWebsiteInfo;
			item.startupCertityInfo = neu.locStrings.startupCertityInfo;
			item.startupCheckOneDescribe = neu.locStrings.startupCheckOneDescribe;
			item.startupCompanyEmptyErr = neu.locStrings.startupCompanyEmptyErr;
			item.startupwebsiteEmptyErr = neu.locStrings.startupwebsiteEmptyErr;
			
			item.allSetBanner = applications[i].allSetBanner;
			item.accountAllSetInfo = neu.locStrings.accountAllSetInfo;
			item.accountAllSetDetail = neu.locStrings.accountAllSetDetail;
			item.startupAllSetDetail = neu.locStrings.startupAllSetDetail;
			item.startUsingFusion = neu.locStrings.startUsingFusion;
			
			item.purchaseCartPic = server + '/myimages/cart.png';
			item.eduRegCartPic = server + '/myimages/education.png';
			item.validateWaitBanner = server + '/myimages/spinner.gif';
			item.notFoundBanner = server + '/myimages/warning.png';
			item.copyButtonImg = server + '/myimages/CopyToClipboard.png';
			item.processingBanner = server + '/myimages/processingarrow.png';
			item.helpBuyLink = 'https://help.autodesk.com/view/STORE/ENU';
			item.helpEduLink = 'https://help.autodesk.com/view/fusion360/ENU/?page=support';
			
			item.languageCode = neu.locStrings.languageCode;
			item.previousPrimarySelection = neu.locStrings.previousPrimarySelection;
			
            if (entitlement.isnull === false) {
                item.trial = (entitlement.trial === true);
                if (item.trial) {
                    // the expiry date should be in ISO-8601 and therefore correctly be parsed as UTC
                    var expiry = new Date(entitlement.expires || '');
                    var days = -1;
                    if (!isNaN(expiry.getTime()))
                        days = (expiry.getTime() - now.getTime()) / (1000 * 60 * 60 * 24);
                    if (days >= 0)
                        days = Math.floor(days + 0.5);
                    item.expiryDescription = applications[i].descriptionTrialEntitlemet.replace(/\{0\}/g, days);
                } else if (entitlement.entitled === false) {
                    item.expiryDescription = applications[i].descriptionTrialExpired;
                    item.icon = server + '/myimages/expired.png';
                    item.expired = true;
                }
            }
            else {
                item.expiryDescription = applications[i].descriptionExpired;
                item.icon = server + '/myimages/expired.png';
                item.expired = true;
            }
            var customerTypes = [];
            item.customerTypes = customerTypes;
            items.push(item);
        }

        if (!items.length)
            return; // nothing to show, leave the tile hidden

        var item = items[0];
        var target = this;
       // jQuery.getScript(server + '/TryToBuy/myscripts/trialexpiryview.js', function (data, textStatus, jqxhr) {
            			
			jQuery('#banner').attr('src', item.banner);
            jQuery('#closeIcon').attr('src',item.closeIcon);
			jQuery('#closeButton').text(item.closeButton);
			// for PrimarilyWorksOn
            jQuery('#expiryDescription').html(item.expiryDescription);
			jQuery('#primarilyusefor').html(item.primarilyusefor);
			jQuery('#des_modeling3d').html(item.modeling3d);
			jQuery('#des_productdesign').html(item.productdesign);
			jQuery('#des_toolpathmachining').html(item.toolpathmachining);
			jQuery('#des_drawings').html(item.drawings);
			jQuery('#des_simulation').html(item.simulation);
			jQuery('#des_otheroption').html(item.otheroption);
			jQuery('#otherInputErrInfo').html(item.otherInputErrInfo);
			jQuery('#btncontinue_0').val(item.btncontinue);
			// for BuyFusionNow
			jQuery('#expiryBuyDescription').html(item.expiryDescription);
			jQuery('#btnBuyNow_0').val(item.btnBuyNow);
			jQuery('#contactForHelp').html(item.contactForHelp);
			jQuery('#qualifyForFreeUse').html(item.qualifyForFreeUse);
			jQuery('#seeIfQualified').html(item.seeIfQualified);
			// for FreeUseOptoins
			jQuery('#freeUseOptionDescription').html(item.expiryDescription);
			jQuery('#useFusionSolelyAs').html(item.useFusionSolelyAs);
			jQuery('#personalProjects').html(item.personalProjects);
			jQuery('#startupCompany').html(item.startupCompany);
			jQuery('#eduStudent').html(item.eduStudent);
			jQuery('#btnDirectBuyNow_0').val(item.btnDirectBuyNow);
			jQuery('#readmoreLicenseInfo').html(item.readmoreLicenseInfo);
			//jQuery('#hrefReadLicense').attr('href',item.hrefReadLicense);
			// for FreePersonalLicense
			jQuery('#personalOneMoreStep').html(item.oneMoreStep);
			jQuery('#personalPlanUseFusion').html(item.personalPlanUseFusion);
            jQuery('#licenseCertityInfo').html(item.licenseCertityInfo);
            jQuery('#licenseCertityInfoComplete').html(item.licenseCertityInfo);
			jQuery('#personalCheckOneDescribe').html(item.personalCheckOneDescribe);
			jQuery('#personalCheckTwoDescribe').html(item.personalCheckTwoDescribe);
			jQuery('#personalConfirmStatement').html(item.personalConfirmStatement);
			jQuery('#personalLicenseContinue').val(item.btncontinue);
			jQuery('#personalCompleteRegistration').val(item.personalCompleteRegistration);
			jQuery('#btnPersonalBuyNow').val(item.personalBuyNow);
			jQuery('#btnPersonalBuyNowComplete').val(item.personalBuyNow);
			jQuery('#personlReadLicenseInfo').html(item.readmoreLicenseInfo);
			jQuery('#personlReadLicenseInfoComplete').html(item.readmoreLicenseInfo);
			jQuery('#personalReturnBack').html(item.returnBack);
			jQuery('#personalReturnBackComplete').html(item.returnBack);
			jQuery('#personalWaitBanner').attr('src', item.validateWaitBanner);
			jQuery('#validatePersonalInfo').html(neu.locStrings.validatePersonalInfo);
			// for FreePersonalTryAgain
			jQuery('#personalTryBanner').attr('src', item.notFoundBanner);
			jQuery('#notFoundInfoPersonal').html(neu.locStrings.notFoundInfoPersonal);
			jQuery('#btnTryItAgainPersonal').val(neu.locStrings.tryItAgain);
			jQuery('#notFoundBackPersonal').html(neu.locStrings.returnBack);
			// for FreeStartupLicense
			jQuery('#startupOneMoreStep').html(item.oneMoreStep);
			jQuery('#startupPlanUseFusion').html(item.startupPlanUseFusion);
			jQuery('#startupCompanyInfo').html(item.startupCompanyInfo);
			jQuery('#startupWebsiteInfo').html(item.startupWebsiteInfo);
			jQuery('#startupCertityInfo').html(item.startupCertityInfo);
			jQuery('#startupCheckOneDescribe').html(item.startupCheckOneDescribe);
			jQuery('#startupCheckTwoDescribe').html(item.personalCheckTwoDescribe);
			jQuery('#startupLicenseContinue').val(item.btncontinue);
			jQuery('#btnStartupBuyNow').val(item.btnDirectBuyNow);
			jQuery('#startupReadLicenseInfo').html(item.readmoreLicenseInfo);
			jQuery('#startupReturnBack').html(item.returnBack);
			jQuery('#startupCompanyEmptyErr').html(item.startupCompanyEmptyErr);
			jQuery('#startupwebsiteEmptyErr').html(item.startupwebsiteEmptyErr);
			jQuery('#startupWaitBanner').attr('src', item.validateWaitBanner);
			jQuery('#validateStartupInfo').html(neu.locStrings.validateStartupInfo);
			// for FreeStartupTryAgain
			jQuery('#startupTryBanner').attr('src', item.notFoundBanner);
			jQuery('#notFoundInfoStartup').html(neu.locStrings.notFoundInfoStartup);
			jQuery('#btnTryItAgainStartup').val(neu.locStrings.tryItAgain);
			jQuery('#notFoundBackStartup').html(neu.locStrings.returnBack);
			
			// for EduRegProcessing
			jQuery('#eduRegTipInfo').html(neu.locStrings.eduRegTipInfo);
			jQuery('#finishedEduReg').html(neu.locStrings.finishedPurchase);
			jQuery('#finishedEduContinue').html(neu.locStrings.btncontinue);
			jQuery('#browserNotOpenEdu').html(neu.locStrings.browserNotOpen);
			jQuery('#browserUrlCopyEduDes').html(neu.locStrings.browserUrlCopyDes);
			jQuery('#browserUrlCopyEdu').val(neu.locStrings.fusionRegEduLink);
			jQuery('#copyButtonImgEdu').attr('src', item.copyButtonImg);
			jQuery('#eduRegProcessBack').html(neu.locStrings.returnBack);
			jQuery('#eduRegCartPic').attr('src', item.eduRegCartPic);
			jQuery('#validateEduInfo').html(neu.locStrings.validateEduInfo);
			jQuery('#validateWaitBannerEdu').attr('src', item.validateWaitBanner);
			
			jQuery('#notFoundBannerEdu').attr('src', item.processingBanner);
			jQuery('#notFoundInfoEdu').html(neu.locStrings.notFoundInfoEdu);
			jQuery('#processingCommentsEdu').html(neu.locStrings.processingComments);
			jQuery('#btnTryItAgainEdu').val(neu.locStrings.tryItAgain);
			jQuery('#processingTipsEdu').html(neu.locStrings.processingTips);
			jQuery('#getHelpHereEdu').html(neu.locStrings.getHelpHere);
			jQuery('#notFoundBackEdu').html(neu.locStrings.returnBack);
			
			// PurchaseProcessing
			jQuery('#purchaseTipInfo').html(neu.locStrings.purchaseTipInfo);
			jQuery('#finishedPurchase').html(neu.locStrings.finishedPurchase);
			jQuery('#finishedBuyContinue').html(neu.locStrings.btncontinue);
			jQuery('#purchaseCartPic').attr('src', item.purchaseCartPic);
			jQuery('#browserNotOpen').html(neu.locStrings.browserNotOpen);
			jQuery('#browserUrlCopyDes').html(neu.locStrings.browserUrlCopyDes);
			jQuery('#browserUrlCopy').val(neu.locStrings.fusionPurchaseLink);
			jQuery('#copyButtonImg').attr('src', item.copyButtonImg);
			jQuery('#purchaseProcessBack').html(neu.locStrings.returnBack);
			jQuery('#validateBuyInfo').html(neu.locStrings.validateBuyInfo);
			jQuery('#validateWaitBanner').attr('src', item.validateWaitBanner);
			
			jQuery('#processingBanner').attr('src', item.processingBanner);
			jQuery('#processingInfo').html(neu.locStrings.processingInfo);
			jQuery('#processingComments').html(neu.locStrings.processingComments);
			jQuery('#btnTryItAgain').val(neu.locStrings.tryItAgain);
			jQuery('#processingTips').html(neu.locStrings.processingTips);
			jQuery('#getHelpHere').html(neu.locStrings.getHelpHere);
			jQuery('#buyProcessingBack').html(neu.locStrings.returnBack);
			// for YouAreAllSet
			jQuery('#allSetBanner').attr('src', item.allSetBanner);
			jQuery('#accountAllSetInfo').html(item.accountAllSetInfo);
			jQuery('#accountAllSetDetail').html(item.accountAllSetDetail);
			jQuery('#btnStartUsingFusion_0').val(item.startUsingFusion);
			
			var context = {};  // runtime config context varialble
			context.licenseStatus = '';
			context.selectedOption = '';
			context.companyName = '';
			context.websiteName = '';
			context.returnFlag = '';

			var userAgent = window.navigator.userAgent.toLowerCase();
			var isLanguageSettingDone = false;
			console.log("the language code is " + item.languageCode);
			var doLanguageSpecificSetting = function () {
				// if (item.languageCode === 'ja-JP') {
				// 	$('.processing-comments').css({'height':'75px'});
				// 	$('.processing-tips').css({'padding':'105px 105px 0 105px'});
					
				// 	if (userAgent.indexOf('chrome') == -1) {
				// 		//This is the Safari browser;  
				// 		$('.direct-buy-now').css({'padding':'2px 0px 0px 0px'});
				// 	}
				// 	else {
				// 		//This is the Chrome browser
				// 		$('.direct-buy-now').css({'padding':'0px 0px 0px 0px'});
				// 	}
				// 	$('.btnDirectBuyNow').css({'margin':'0px 0px 6px 0px'});
				// 	$('.btnDirectBuyNow').css({'padding':'3px 30px 3px 30px'});
				// 	$('.btnDirectBuyNow').css({'font-size':'20px'});
					
				// 	$('.personal-buy-now').css({'padding':'36px 0px 0px 0px'});
				// 	$('.btnPersonalBuyNow').css({'margin':'0px 0px 0px 0px'});
				// 	$('.btnPersonalBuyNow').css({'padding':'0px 30px 0px 30px'});
				// 	$('.btnPersonalBuyNow').css({'font-size':'20px'});
					
				// 	$('.startup-buy-now').css({'padding':'36px 0px 0px 0px'});
				// 	$('.btnStartupBuyNow').css({'margin':'0px 0px 0px 0px'});
				// 	$('.btnStartupBuyNow').css({'padding':'0px 30px 0px 30px'});
				// 	$('.btnStartupBuyNow').css({'font-size':'20px'});
				// } else if (item.languageCode === 'zh-CN') {
				// 	$('.direct-buy-now').css({'padding':'3px 50px 0px 50px'});
				// } else if (item.languageCode === 'de-DE') { 
				// 	$('.direct-buy-now').css({'padding':'6px 0px 0px 0px'});
				// 	$('.personal-buy-now').css({'padding':'36px 0px 0px 0px'});
				// 	$('.startup-buy-now').css({'padding':'36px 0px 0px 0px'});
				// }
			};

			var hasPrimaryUsageSet = false;
			if (item.previousPrimarySelection && (typeof item.previousPrimarySelection === "string")) {
				try {
					console.log(item.previousPrimarySelection);
					var selectionArgs = JSON.parse(item.previousPrimarySelection);
					context.modeling3d = selectionArgs.threedmodeling;
					context.productdesign = selectionArgs.industrialdesign;
					context.toolpathmachining = selectionArgs.cam;
					context.drawings = selectionArgs.drawings;
					context.simulation = selectionArgs.simulation;
					context.otheroption = selectionArgs.otheroption;
					context.otherValue = selectionArgs.otherValue;
					hasPrimaryUsageSet = true;
				} catch (err) {
					hasPrimaryUsageSet = false;
					console.log(err);
				}
			}
						
			var is_showing_other_input_errror = false;
			var btncontinue_activate = function (btnId, bActive) {
				jQuery(btnId).attr("disabled", !bActive);
			};
			var workOnCheckbox_click = function () {
				var is_there_checked_option = false;
				if (jQuery('#modeling3d_0').is(':checked')) {
					is_there_checked_option = true;
					context.modeling3d = true;
				}
				else {
					context.modeling3d = false;
				}
				
				if (jQuery('#productdesign_0').is(':checked')) {
					is_there_checked_option = true;
					context.productdesign = true;
				}
				else {
					context.productdesign = false;
				}
				
				if (jQuery('#toolpathmachining_0').is(':checked')) {
					is_there_checked_option = true;
					context.toolpathmachining = true;
				}
				else {
					context.toolpathmachining = false;
				}
				
				if (jQuery('#drawings_0').is(':checked')) {
					is_there_checked_option = true;
					context.drawings = true;
				}
				else {
					context.drawings = false;
				}
				
				if (jQuery('#simulation_0').is(':checked')) {
					is_there_checked_option = true;
					context.simulation = true;
				}
				else {
					context.simulation = false;
				}
				
				if (jQuery('#otheroption_0').is(':checked')) {
					context.otheroption = true;
					jQuery('.txt_other').attr("disabled", false);
					is_there_checked_option = true;
				}
				else {
					context.otheroption = false;
					jQuery('.txt_other').attr("disabled", true);
					context.otherValue = '';
				}
				
				if (is_there_checked_option === false) {
					btncontinue_activate('#btncontinue_0', false);
				}
				else {
					btncontinue_activate('#btncontinue_0', true);
				}
				
				if (!isLanguageSettingDone) {
					doLanguageSpecificSetting();
					isLanguageSettingDone = true;
				}
			};
			
			jQuery('#modeling3d_0').click(function (event) {
				workOnCheckbox_click();
			});
			
			jQuery('#productdesign_0').click(function (event) {
				workOnCheckbox_click();
			});
			
			jQuery('#toolpathmachining_0').click(function (event) {
				workOnCheckbox_click();
			});
			
			jQuery('#drawings_0').click(function (event) {
				workOnCheckbox_click();
			});
			
			jQuery('#simulation_0').click(function (event) {
				workOnCheckbox_click();
			});
			
			jQuery('#otheroption_0').click(function (event) {
				workOnCheckbox_click();
				if (!jQuery('#otheroption_0').is(':checked')) {
					otherInputDataValidate();
				}
			});
			
			jQuery('.txt_other').blur(function() {
				var strOtherInfo = jQuery(this).val();
				strOtherInfo = jQuery.trim(strOtherInfo);
				if ((typeof(strOtherInfo) == "string") && strOtherInfo != '') {
					btncontinue_activate('#btncontinue_0', true);
					context.otherValue = strOtherInfo;
				} else {
					context.otherValue = '';
				}
				otherInputDataValidate();
			});
			
			var otherInputDataValidate = function () {
				if (jQuery('#otheroption_0').is(':checked')) {
					var strOtherInfo = jQuery('.txt_other').val();
					if ((typeof(strOtherInfo) == "string") && strOtherInfo === '') {
						is_showing_other_input_errror = true;
						jQuery('.other-input-error').show();
						jQuery('.txt_other').removeClass("txt_other_good");
						jQuery('.txt_other').addClass("txt_other_empty");
						btncontinue_activate('#btncontinue_0', false);
						return false;
					}
					else if (is_showing_other_input_errror == true) {
						jQuery('.other-input-error').hide();
						jQuery('.txt_other').removeClass("txt_other_empty");
						jQuery('.txt_other').addClass("txt_other_good");
					}
				}
				else if (is_showing_other_input_errror == true) {
					jQuery('.other-input-error').hide();
					jQuery('.txt_other').removeClass("txt_other_empty");
					jQuery('.txt_other').addClass("txt_other_good");
				}
				
				return true;
			};
			
			var cachePrimaryUsageSelection = function () {
				if (context.productdesign != undefined) {
					var args = {
						threedmodeling: context.modeling3d,
						industrialdesign: context.productdesign,
						cam: context.toolpathmachining,
						drawings: context.drawings,
						simulation: context.simulation,
						otheroption: context.otheroption,
						otherValue: context.otherValue
					};
					
					var response = JSON.parse(window.neutronJavaScriptObject.executeQuery('cachePrimaryUsageSelection', JSON.stringify(args)));
					return response.success;
				}
			};
			
			jQuery('#btncontinue_0').click(function (event) {
                event.preventDefault();
				var ret = otherInputDataValidate();
				if (ret === false)
					return;
				
				workOnCheckbox_click();
				// added the cache selection usage here
				cachePrimaryUsageSelection();
				
                jQuery('#PrimarilyWorksOn').hide();
				jQuery('#BuyFusionNow').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#BuyFusionNow').addClass("display_block");
                
            });
			
			// for buy now dialog
			var trialExpiryBuyNow_click = function () {
				context.selectedOption = 'Buy';
				var isMacAppStoreBuild = window.neutronJavaScriptObject.executeQuery('isMacAppStoreBuild', '');
				if(isMacAppStoreBuild === 'true')
				{
						window.open('', '_self', '');
						window.close();
                        window.neutronJavaScriptObject.executeQuery("closeTryToBuyWidget", "");
						window.neutronJavaScriptObject.executeQuery('showMASInAppPurchase', '');
				}
				else
				{
					window.neutronJavaScriptObject.executeQuery("linkClicked", item.link);  //comment out for test
					
					//grant user 24hr local entitlements using registeredAsStudent when user clicks on "Buy Fusion 360" link
					//var appIdJson = {};
					//appIdJson.appId = item.appId;
					//window.neutronJavaScriptObject.executeQuery('registeredAsStudent', JSON.stringify(appIdJson));
					//window.neutronJavaScriptObject.executeQuery('refreshEntitlements', ''); 
					
					jQuery('#PurchaseProcessing').show();
					var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
					window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
					jQuery('#PurchaseProcessing').addClass("display_block");
				}
			};
			
			jQuery('#btnBuyNow_0').click(function (event) {
				event.preventDefault();
				jQuery('#BuyFusionNow').hide();
				trialExpiryBuyNow_click();
				context.returnFlag = 'BuyFusionNow';
            });

            jQuery('#contactForHelp').click(function (event) {
                event.preventDefault();
                window.neutronJavaScriptObject.executeQuery("linkClicked", item.hrefContactForHelp);
            });
			
			jQuery('#seeIfQualified').click(function (event) {
                event.preventDefault();
                jQuery('#BuyFusionNow').hide();
				jQuery('#FreeUseOptoins').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#FreeUseOptoins').addClass("display_block");
            });
			
            jQuery('#hrefPricingOptions').click(function (event) {
                event.preventDefault();
                window.neutronJavaScriptObject.executeQuery("linkClicked", item.hrefPricingOptions);
            });
			
			// PurchaseProcessing
			var clipboard = new Clipboard('.copy-button');
			clipboard.on('success', function(e) {
				console.log(e);
			});

			clipboard.on('error', function(e) {
				console.log(e);
			});
			
			var showNosubscriptionFound = function () {
				jQuery('#ValidateSubscription').hide();
				jQuery('#NoSubscriptionFound').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#NoSubscriptionFound').addClass("display_block");
			};
			
			var triggerDoValidateProcess = function () {
				context.isNeedingValidate = true;
				context.timeoutID = window.setTimeout(doValidateSubscription, 100);
			};
			
			jQuery('#finishedBuyContinue').click(function (event) {
                event.preventDefault();
				jQuery('#PurchaseProcessing').hide();
                jQuery('#ValidateSubscription').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#ValidateSubscription').addClass("display_block");
				triggerDoValidateProcess();
            });
			
			var buyReturnBackProcess = function(hideDivId){
				if (context.returnFlag === 'BuyFusionNow') {
					context.returnFlag = '';
					jQuery(hideDivId).hide();
					jQuery('#BuyFusionNow').show();
					var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
					window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
					//jQuery('#BuyFusionNow').addClass("display_block");
				}
				else {
					jQuery(hideDivId).hide();
					jQuery('#FreeUseOptoins').show();
					var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
					window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
					//jQuery('#FreeUseOptoins').addClass("display_block");
				}
			};
			
			jQuery('#purchaseProcessBack').click(function (event) {
                event.preventDefault();
				buyReturnBackProcess('#PurchaseProcessing');
			});
			
			jQuery('#getHelpHere').click(function (event) {
                event.preventDefault();
				window.neutronJavaScriptObject.executeQuery("linkClicked", item.helpBuyLink);
            });
			
			// ValidateSubscription
			var doValidateSubscription = function(){
				// adding the buy subscription check here
				if (context.isNeedingValidate === true) {
					context.isNeedingValidate = false;
					window.clearTimeout(context.timeoutID);
					
					window.neutronJavaScriptObject.executeQuery('refreshEntitlements', '');
					var argData = {};
					argData.appId = item.appId;
					var ent = JSON.parse(window.neutronJavaScriptObject.executeQuery('EntitlementDetails', JSON.stringify(argData)));
					if (ent.isnull === false) {
						if ((ent.trial === true) || (entitlement.enthusiast === true) || (ent.student === true) || (ent.entitled === false)) {
							showNosubscriptionFound();
						}
						else {
							context.licenseStatus = "SubscribeLicense";
							jQuery('#ValidateSubscription').hide();
							jQuery('#YouAreAllSet').show();
							jQuery('#accountAllSetDetail').html(neu.locStrings.buyAllSetDetail);
							var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
							window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
							jQuery('#YouAreAllSet').addClass("display_block");
						}
					}
					else {
						showNosubscriptionFound();
					}
				}
			};
			
			// test purpose for exception or not buying check
			jQuery('#validateWaitBanner').click(function (event) {
                event.preventDefault();
				jQuery('#ValidateSubscription').hide();
                jQuery('#NoSubscriptionFound').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#NoSubscriptionFound').addClass("display_block");
            });
			
			// test purpose for all done
			jQuery('#validateBuyInfo').click(function (event) {
                event.preventDefault();
				jQuery('#ValidateSubscription').hide();
                jQuery('#YouAreAllSet').show();
				jQuery('#accountAllSetDetail').html(neu.locStrings.buyAllSetDetail);
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#YouAreAllSet').addClass("display_block");
            });
			
			// NoSubscriptionFound
			jQuery('#btnTryItAgain').click(function (event) {
                event.preventDefault();
				jQuery('#NoSubscriptionFound').hide();
                jQuery('#ValidateSubscription').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#ValidateSubscription').addClass("display_block");
				triggerDoValidateProcess();
            });
			
			jQuery('#buyProcessingBack').click(function (event) {
                event.preventDefault();
				buyReturnBackProcess('#NoSubscriptionFound');
            });
			
			// for free use options
			jQuery('#btnDirectBuyNow_0').click(function (event) {
                event.preventDefault();
				jQuery('#FreeUseOptoins').hide();
                trialExpiryBuyNow_click();
            });
			
			jQuery('#optFreePersonal').click(function (event) {
				context.selectedOption = 'Personal'; // for personal option selection
				jQuery('#FreeUseOptoins').hide();
				jQuery('#FreePersonalLicense').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#FreePersonalLicense').addClass("display_block");
            });
			
			jQuery('#optFreeCompany').click(function (event) {
				context.selectedOption = 'Startup'; // for startup company option selection
				jQuery('#FreeUseOptoins').hide();
				jQuery('#FreeStartupLicense').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#FreeStartupLicense').addClass("display_block");
				var retJson = window.neutronJavaScriptObject.executeQuery("getCompanyAndWebsite", '');
				if (retJson) {
					retJson = JSON.parse(retJson);
				}
				if (typeof(retJson.companyName) == "string")
					context.companyName = retJson.companyName;
				if (context.companyName != "") {
					$('#txtCompanyName').val(context.companyName);
				}
				if (typeof(retJson.websiteName) == "string")
					context.websiteName = retJson.websiteName;
				if (context.websiteName != "") {
					$('#txtWebsiteName').val(context.websiteName);
				}
            });
			
			jQuery('#optFreeEduStudent').click(function (event) {
				context.selectedOption = 'Education'; // for edu student option selection
				window.neutronJavaScriptObject.executeQuery("linkClicked", item.fusionRegEduLink);
				// edu confirm dialog showing here  
				jQuery('#FreeUseOptoins').hide();
				jQuery('#EduRegProcessing').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#EduRegProcessing').addClass("display_block");
            });
			
			jQuery('#readmoreLicenseInfo').click(function (event) {
                event.preventDefault();
                window.neutronJavaScriptObject.executeQuery("linkClicked", item.hrefReadLicense);
            });
			
			var personalLicenseSubmit = function () {
				var args = {};
				args.appId = 'Fusion360';
				var entitlement = JSON.parse(window.neutronJavaScriptObject.executeQuery('EntitlementDetails', JSON.stringify(args)));
				var userId = window.neutronJavaScriptObject.executeQuery('GetUserId', JSON.stringify(args));
				var register = '/api/trial/v1/user/'+userId+'/usertype/enthusiast?format=json';
				var extend = '/api/trial/v1/user/'+userId+'/service/fusion360trial?noOfDays=365';
				var url;
				if(entitlement.isnull === true  || entitlement.enthusiast === true)
					url = target.oxygenEndpoint() + extend;
				else
					url = target.oxygenEndpoint() + register;
				var args = {
					url: url,
					method: 'PUT',
					data: JSON.stringify({ trial: { name: item.trialGroup } }),
					headers: { 'Content-Type': 'application/json' }
				};
				
				//return false; // for test purpose
				var response = JSON.parse(window.neutronJavaScriptObject.executeQuery('executeRequest', JSON.stringify(args)));
				if (response.success && response.code < 400 ) {
					return true;
				}
				else
				{
					return false;
				}
			};
			
			var sendTry2BuyOptions = function () {
				if (context.productdesign != undefined) {
					var args = {
						threedmodeling: context.modeling3d,
						industrialdesign: context.productdesign,
						cam: context.toolpathmachining,
						drawings: context.drawings,
						simulation: context.simulation,
						otheroption: context.otheroption,
						otherValue: context.otherValue,
						licenseStatus: context.licenseStatus,
						selectedOption: context.selectedOption
					};
					if (context.companyName != "") {
						args.companyName = context.companyName;
					}
					if (context.websiteName != "") {
						args.websiteName = context.websiteName;
					}
					
					var response = JSON.parse(window.neutronJavaScriptObject.executeQuery('sendSelectedOptions', JSON.stringify(args)));
					return response.success;
				}
			};
			
			var closeTryToBuyWindow = function (licenseStatus) {
				if (licenseStatus == "PersonalLicense") {
					window.neutronJavaScriptObject.executeQuery("changeLicenseStatus", "PersonalLicense");
					window.neutronJavaScriptObject.executeQuery('refreshEntitlements', '');
				}
				else if (licenseStatus == "StartupLicense") {
					window.neutronJavaScriptObject.executeQuery("changeLicenseStatus", "StartupLicense");
					window.neutronJavaScriptObject.executeQuery('refreshEntitlements', '');
				}
				else if (licenseStatus == "EduLicense") {
					window.neutronJavaScriptObject.executeQuery("changeLicenseStatus", "EduLicense");
				}
				else if (licenseStatus == "SubscribeLicense") {
					//window.neutronJavaScriptObject.executeQuery('refreshEntitlements', '');
				}
				
				sendTry2BuyOptions();
				jQuery('#try2buyDialog').hide();
				window.open('', '_self', '');
				window.close();
				window.neutronJavaScriptObject.executeQuery("closeTryToBuyWidget", "");
			};
			
			// for Personal
			var showPersonalTryAgain = function () {
				jQuery('#ValidatePersonalLicense').hide();
				jQuery('#FreePersonalTryAgain').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#FreePersonalTryAgain').addClass("display_block");
			};
			
			var triggerDoValidatePersonal = function () {
				context.isNeedingValidate = true;
				context.timeoutID = window.setTimeout(doValidatePersonalLicense, 100);
			};
			
			var doValidatePersonalLicense = function(){
				if (context.isNeedingValidate === true) {
					context.isNeedingValidate = false;
					window.clearTimeout(context.timeoutID);
					
					var ret = personalLicenseSubmit();
					if (ret) {
						jQuery('#ValidatePersonalLicense').hide();
						jQuery('#YouAreAllSet').show();
						context.licenseStatus = "PersonalLicense";	
						var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
						window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
						jQuery('#YouAreAllSet').addClass("display_block");
					}
					else { // error handling process
						showPersonalTryAgain();
					}
				}
			};
			
			jQuery('#personalLicenseContinue').click(function (event) {
                event.preventDefault();
				jQuery('#FreePersonalLicense').hide();
                jQuery('#PersonalCompletePage').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
			});

			jQuery('#personalCompleteRegistration').click(function (event) {
                event.preventDefault();
				jQuery('#PersonalCompletePage').hide();
                jQuery('#ValidatePersonalLicense').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
                jQuery('#ValidatePersonalLicense').addClass("display_block");
				triggerDoValidatePersonal();
            });
			
			jQuery('#btnPersonalBuyNow').click(function (event) {
                event.preventDefault();
				jQuery('#FreePersonalLicense').hide();
                trialExpiryBuyNow_click();
			});

			jQuery('#btnPersonalBuyNowComplete').click(function (event) {
                event.preventDefault();
				jQuery('#PersonalCompletePage').hide();
                trialExpiryBuyNow_click();
            });
			
			jQuery('#personlReadLicenseInfo').click(function (event) {
                event.preventDefault();
                window.neutronJavaScriptObject.executeQuery("linkClicked", item.hrefReadLicense);
            });
			
			jQuery('#personlReadLicenseInfoComplete').click(function (event) {
                event.preventDefault();
                window.neutronJavaScriptObject.executeQuery("linkClicked", item.hrefReadLicense);
			});

			var returnOptionsFromPersonalPages = function() {
                jQuery('#FreeUseOptoins').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				if (jQuery('#personalCheckOne').is(':checked')) {
					jQuery('#personalCheckOne').attr("checked", false);
				}
				if (jQuery('#personalCheckTwo').is(':checked')) {
					jQuery('#personalCheckTwo').attr("checked", false);
				}
				personalCheckbox_click();
			};
			
			jQuery('#personalReturnBack').click(function (event) {
                event.preventDefault();
				jQuery('#FreePersonalLicense').hide();
				returnOptionsFromPersonalPages();
            });
			
			jQuery('#personalReturnBackComplete').click(function (event) {
                event.preventDefault();
				jQuery('#PersonalCompletePage').hide();
				returnOptionsFromPersonalPages();
            });
			
			var personalCheckbox_click = function () {
				if (jQuery('#personalCheckOne').is(':checked') && jQuery('#personalCheckTwo').is(':checked')){
					btncontinue_activate('#personalLicenseContinue', true);
				}
				else {
					btncontinue_activate('#personalLicenseContinue', false);
				}
			};
			
			jQuery('#personalCheckOne').click(function (event) {
                personalCheckbox_click();
            });
			
			jQuery('#personalCheckTwo').click(function (event) {
				personalCheckbox_click();
            });
			
			var test_count = 0;
			jQuery('#btnTryItAgainPersonal').click(function (event) {
                event.preventDefault();
				test_count++;
				jQuery('#FreePersonalTryAgain').hide();
                jQuery('#ValidatePersonalLicense').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
                jQuery('#ValidatePersonalLicense').addClass("display_block");
				triggerDoValidatePersonal();
            });
			
			jQuery('#notFoundBackPersonal').click(function (event) {
                event.preventDefault();
				jQuery('#FreePersonalTryAgain').hide();
                jQuery('#FreeUseOptoins').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
                jQuery('#FreeUseOptoins').addClass("display_block");
				// reset the data selection here
				if (jQuery('#personalCheckOne').is(':checked')) {
					jQuery('#personalCheckOne').attr("checked", false);
				}
				if (jQuery('#personalCheckTwo').is(':checked')) {
					jQuery('#personalCheckTwo').attr("checked", false);
				}
				personalCheckbox_click();
            });
			
			// for startup
			var is_company_input_error = false;
			var is_website_input_error = false;
			var startupEmptyInputCheckForTextbox = function (strInput, classDiv, classTextbox, isCompanyData, isInvalidInput) {
				if(strInput == '' || isInvalidInput) {
					jQuery(classDiv).show();
					jQuery(classTextbox).css("border", "2px solid #CB7E7C");
					if (isCompanyData)
						is_company_input_error = true;
					else
						is_website_input_error = true;
				}
				else {
					jQuery(classDiv).hide();
					jQuery(classTextbox).css("border", "2px solid #A9A9A9");
					if (isCompanyData)
						is_company_input_error = false;
					else
						is_website_input_error = false;
				}
				
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
			};
			
			jQuery('#txtCompanyName').blur(function() {
				var strCompanyName = $(this).val();
				strCompanyName = $.trim(strCompanyName);
				startupEmptyInputCheckForTextbox(strCompanyName, '.startup-company-error', '.txt_company', true, false);
			});
			
			var isValidWebUrl = function(str_url) {
				var strRegex = '(([A-Za-z0-9-~]+)\.)+([A-Za-z0-9-~\/])+$';
				var re = new RegExp(strRegex);
				if (re.test(str_url)) {
					return true;
				} else {
					return false;
				}
			};
			
			jQuery('#txtWebsiteName').blur(function() {
				var strWebsiteName = $(this).val();
				strWebsiteName = $.trim(strWebsiteName);
				var isInvalid = !isValidWebUrl(strWebsiteName);
				startupEmptyInputCheckForTextbox(strWebsiteName, '.startup-website-error', '.txt_website', false, isInvalid);
			});
			
			var showStartupTryAgain = function () {
				jQuery('#ValidateStartupLicense').hide();
				jQuery('#FreeStartupTryAgain').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#FreeStartupTryAgain').addClass("display_block");
			};
			
			var triggerDoValidateStartup = function () {
				context.isNeedingValidate = true;
				context.timeoutID = window.setTimeout(doValidateStartupLicense, 100);
			};
			
			var doValidateStartupLicense = function(){
				if (context.isNeedingValidate === true) {
					context.isNeedingValidate = false;
					window.clearTimeout(context.timeoutID);
					
					var jsonArgs = {};
					jsonArgs.companyName = context.companyName;
					jsonArgs.websiteName = context.websiteName;
					var retJson = JSON.parse(window.neutronJavaScriptObject.executeQuery("updateCompanyAndWebsite", JSON.stringify(jsonArgs)));
					if (retJson.success) {
						retJson = JSON.parse(window.neutronJavaScriptObject.executeQuery("getCompanyAndWebsite", ''));
						if (typeof(retJson.companyName) == "string" && retJson.companyName !== "") {
							var ret = personalLicenseSubmit();
							if (ret) {
								jQuery('#ValidateStartupLicense').hide();
								jQuery('#YouAreAllSet').show();
								jQuery('#accountAllSetDetail').html(item.startupAllSetDetail);
								context.licenseStatus = "StartupLicense";
												
								var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
								window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
								jQuery('#YouAreAllSet').addClass("display_block");
							}
							else { // error handling process
								showStartupTryAgain();
							}
						} else {
							showStartupTryAgain();
						}
					}
					else {
						showStartupTryAgain();
					}
				}
			};
			
			jQuery('#startupLicenseContinue').click(function (event) {
                event.preventDefault();
				// check input text not empty first
				var strCompanyName = jQuery.trim(jQuery("#txtCompanyName").val());
				if (strCompanyName == "") {
					is_company_input_error = true;
					startupEmptyInputCheckForTextbox(strCompanyName, '.startup-company-error', '.txt_company', true, false);
				}
				else {
					is_company_input_error = false;
				}
				
				var strWebsiteName = jQuery.trim(jQuery("#txtWebsiteName").val());
				if (strWebsiteName == "") {
					is_website_input_error = true;
					startupEmptyInputCheckForTextbox(strWebsiteName, '.startup-website-error', '.txt_website', false, false);
				}
				else if (!isValidWebUrl(strWebsiteName)) {
					is_website_input_error = true;
					startupEmptyInputCheckForTextbox(strWebsiteName, '.startup-website-error', '.txt_website', false, true);
				}
				else {
					is_website_input_error = false;
				}
				if (is_company_input_error || is_website_input_error)
					return;
				
				// set the startup company and website name
				context.companyName = strCompanyName;
				context.websiteName = strWebsiteName;
				
				jQuery('#FreeStartupLicense').hide();
				jQuery('#ValidateStartupLicense').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#ValidateStartupLicense').addClass("display_block");
				triggerDoValidateStartup();
            });
			
			jQuery('#startupReadLicenseTerms').click(function (event) {
                event.preventDefault();
                window.neutronJavaScriptObject.executeQuery("linkClicked", item.hrefReadLicense);
            });
			
			jQuery('#startupReadLicenseInfo').click(function (event) {
                event.preventDefault();
                window.neutronJavaScriptObject.executeQuery("linkClicked", item.hrefReadLicense);
            });
			
			var startupCheckbox_click = function () {
				if (jQuery('#startupCheckOne').is(':checked') && jQuery('#startupCheckTwo').is(':checked')){
					btncontinue_activate('#startupLicenseContinue', true);
				}
				else {
					btncontinue_activate('#startupLicenseContinue', false);
				}
			};
			
			jQuery('#startupCheckOne').click(function (event) {
                startupCheckbox_click();
            });
			
			jQuery('#startupCheckTwo').click(function (event) {
				startupCheckbox_click();
            });
			
			jQuery('#startupReturnBack').click(function (event) {
                event.preventDefault();
				jQuery('#FreeStartupLicense').hide();
                jQuery('#FreeUseOptoins').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
                jQuery('#FreeUseOptoins').css("display", "block");
				// reset the data selection here
				jQuery('.startup-company-error').hide();
				jQuery('.txt_company').css("border", "2px solid #A9A9A9");
				jQuery('.startup-website-error').hide();
				jQuery('.txt_website').css("border", "2px solid #A9A9A9");
				$('#txtCompanyName').val('');
				$('#txtWebsiteName').val('');
				is_company_input_error = false;
			    is_website_input_error = false;
				if (jQuery('#startupCheckOne').is(':checked')) {
					jQuery('#startupCheckOne').attr("checked", false);
				}
				if (jQuery('#startupCheckTwo').is(':checked')) {
					jQuery('#startupCheckTwo').attr("checked", false);
				}
				startupCheckbox_click();
            });
			
			jQuery('#btnStartupBuyNow').click(function (event) {
                event.preventDefault();
				jQuery('#FreeStartupLicense').hide();
                trialExpiryBuyNow_click();
            });
			
			jQuery('#btnTryItAgainStartup').click(function (event) {
                event.preventDefault();
				test_count++;
				jQuery('#FreeStartupTryAgain').hide();
                jQuery('#ValidateStartupLicense').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
                jQuery('#ValidateStartupLicense').addClass("display_block");
				triggerDoValidateStartup();
            });
			
			jQuery('#notFoundBackStartup').click(function (event) {
                event.preventDefault();
				jQuery('#FreeStartupTryAgain').hide();
                jQuery('#FreeUseOptoins').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
                jQuery('#FreeUseOptoins').css("display", "block");
				// reset the data selection here
				jQuery('.startup-company-error').hide();
				jQuery('.txt_company').css("border", "2px solid #A9A9A9");
				jQuery('.startup-website-error').hide();
				jQuery('.txt_website').css("border", "2px solid #A9A9A9");
				$('#txtCompanyName').val('');
				$('#txtWebsiteName').val('');
				is_company_input_error = false;
			    is_website_input_error = false;
				if (jQuery('#startupCheckOne').is(':checked')) {
					jQuery('#startupCheckOne').attr("checked", false);
				}
				if (jQuery('#startupCheckTwo').is(':checked')) {
					jQuery('#startupCheckTwo').attr("checked", false);
				}
				startupCheckbox_click();
            });
			
			// for EduRegProcessing
			var showNoEduRegistrationFound = function () {
				jQuery('#ValidateEduRegister').hide();
				jQuery('#NoEduRegisterFound').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
				jQuery('#NoEduRegisterFound').addClass("display_block");
			};
			
			var triggerEduRegValidate = function () {
				context.isNeedingValidate = true;
				context.timeoutID = window.setTimeout(doValidateEduRegister, 100);
			};
			
			jQuery('#finishedEduContinue').click(function (event) {
                event.preventDefault();
				jQuery('#EduRegProcessing').hide();
                jQuery('#ValidateEduRegister').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
                jQuery('#ValidateEduRegister').addClass("display_block");
				triggerEduRegValidate();
            });
			
			jQuery('#eduRegProcessBack').click(function (event) {
                event.preventDefault();
				jQuery('#EduRegProcessing').hide();
                jQuery('#FreeUseOptoins').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
                jQuery('#FreeUseOptoins').addClass("display_block");
            });
			
			var doValidateEduRegister = function(){
				if (context.isNeedingValidate === true) {
					context.isNeedingValidate = false;
					window.clearTimeout(context.timeoutID);
					
					window.neutronJavaScriptObject.executeQuery('refreshEntitlements', '');
					var argData = {};
					argData.appId = item.appId;
					var ent = JSON.parse(window.neutronJavaScriptObject.executeQuery('EntitlementDetails', JSON.stringify(argData)));
					if (ent.isnull === false) {
						if ((ent.student === false) || (ent.entitled === false)) {
							showNoEduRegistrationFound();
						}
						else {
							context.licenseStatus = "EduLicense";
							jQuery('#ValidateEduRegister').hide();
							jQuery('#YouAreAllSet').show();
							jQuery('#accountAllSetDetail').html(neu.locStrings.eduRegAllSetDetail);
							var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
							window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
							jQuery('#YouAreAllSet').addClass("display_block");
						}
					}
					else {
						showNoEduRegistrationFound();
					}
				}
			};
			
			// test purpose for exception or not buying check
			jQuery('#validateWaitBannerEdu').click(function (event) {
                event.preventDefault();
				jQuery('#ValidateEduRegister').hide();
                jQuery('#NoEduRegisterFound').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
                jQuery('#NoEduRegisterFound').addClass("display_block");
            });
			
			// test purpose for all done
			jQuery('#validateEduInfo').click(function (event) {
                event.preventDefault();
				jQuery('#ValidateEduRegister').hide();
                jQuery('#YouAreAllSet').show();
				jQuery('#accountAllSetDetail').html(neu.locStrings.eduRegAllSetDetail);
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
                jQuery('#YouAreAllSet').addClass("display_block");
            });
			
			// NoEduRegisterFound
			jQuery('#btnTryItAgainEdu').click(function (event) {
                event.preventDefault();
				jQuery('#NoEduRegisterFound').hide();
                jQuery('#ValidateEduRegister').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
                jQuery('#ValidateEduRegister').addClass("display_block");
				triggerEduRegValidate();
            });
			
			jQuery('#notFoundBackEdu').click(function (event) {
                event.preventDefault();
				jQuery('#NoEduRegisterFound').hide();
                jQuery('#EduRegProcessing').show();
				var divHeight = String(document.getElementById('try2buyDialog').offsetHeight);
				window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", divHeight);
                jQuery('#EduRegProcessing').addClass("display_block");
				window.neutronJavaScriptObject.executeQuery("linkClicked", item.fusionRegEduLink);
			});
			
			jQuery('#getHelpHereEdu').click(function (event) {
                event.preventDefault();
				window.neutronJavaScriptObject.executeQuery("linkClicked", item.helpEduLink);
            });
			
			// for YouAreAllSet
			jQuery('#btnStartUsingFusion_0').click(function (event) {
                event.preventDefault();
				closeTryToBuyWindow(context.licenseStatus);
            });
            
            jQuery('.trialExpiryClose').click(function (event) {
                event.preventDefault();
				closeTryToBuyWindow(context.licenseStatus);
            });

			jQuery('.confirmationClose').click(function (event) {  // not used now
                event.preventDefault();
                closeTryToBuyWindow(context.licenseStatus);
            });
			
            jQuery('.trialexpiry-close-icon').click(function (event) {
                event.preventDefault();
				closeTryToBuyWindow(context.licenseStatus);
            });
			
            jQuery('#divLoading').hide();
			if (hasPrimaryUsageSet) {
				jQuery('#PrimarilyWorksOn').addClass("default-nodisplay");
				jQuery('#BuyFusionNow').addClass("display_block");
				jQuery('#BuyFusionNow').removeClass("default-nodisplay");
				jQuery('#BuyFusionNow').addClass("display_block");
				jQuery('#BuyFusionNow').show();
			}
			jQuery('#try2buyDialog').removeClass("default-nodisplay");
			jQuery('#try2buyDialog').addClass("display_block");  
			jQuery('#try2buyDialog').show();

            //I found the layout of HTML pages could be different between Chrome and Safari
            //even the same CSS styles are appplied; this could be due to the different 
            //rendering of the same fonts between Windows and Mac
            //To fix this, we need to apply different padding-bottom style on different browsers
            var firstPageHeight = '483';
            if (userAgent.indexOf('chrome') == -1) {
                //This is the Safari browser;  
                jQuery('#try2buyDialog').addClass("try2buyDialog-safari-collapse");
                if (hasPrimaryUsageSet) {
                    firstPageHeight = '456';
                }
            }
            else {
                //This is the Chrome browser
				jQuery('#try2buyDialog').addClass("try2buyDialog-chrome");
			}

			window.neutronJavaScriptObject.executeQuery("resizeTryToBuyWindow", firstPageHeight);

        //});
    }
};

IPM.bootStrap();
