/*
 * Decompiled with CFR 0.152.
 */
package kareltherobot;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.util.Observable;
import java.util.Vector;
import kareltherobot.Directions;
import kareltherobot.World;

public class ur_Robot
extends Observable
implements Directions,
Runnable,
Cloneable {
    private Vector senders = new Vector();
    private int nextSender = 0;
    private static final boolean on = true;
    private static final boolean off = false;
    private int[] loc = new int[4];
    private int beepers;
    private int direction;
    private int moves = 0;
    private boolean state = true;
    private int idNumber;
    private static final int threshhold = 10;
    private static int numberOfRobots = 0;
    private StateObject initialState;

    public void turnLeft() {
        if (this.state) {
            --this.direction;
            if (this.direction < 0) {
                this.direction += 4;
            }
            this.direction %= 4;
            StateObject s = new StateObject(1);
            this.setChanged();
            this.notifyObservers(s);
            this.sleep();
        }
    }

    public void move() {
        if (this.state) {
            boolean crashed = false;
            this.normalize();
            switch (this.direction) {
                case 3: {
                    if (!World.checkEWWall(this.loc[3], this.loc[0])) break;
                    crashed = this.crash("Tried to walk through an East West wall");
                    break;
                }
                case 0: {
                    if (!World.checkNSWall(this.loc[3], this.loc[0])) break;
                    crashed = this.crash("Tried to walk through a North South wall");
                    break;
                }
                case 1: {
                    if (!World.checkEWWall(this.loc[3] - 1, this.loc[0])) break;
                    crashed = this.crash("Tried to walk through an East West wall");
                    break;
                }
                case 2: {
                    if (!World.checkNSWall(this.loc[3], this.loc[0] - 1)) break;
                    crashed = this.crash("Tried to walk through a North South wall");
                    break;
                }
            }
            if (!crashed) {
                int n = this.direction;
                this.loc[n] = this.loc[n] + 1;
                ++this.moves;
                if (this.moves > 10) {
                    this.normalize();
                }
                this.validate();
                StateObject s = new StateObject(0);
                this.setChanged();
                this.notifyObservers(s);
                this.sleep();
            }
        }
    }

    public void pickBeeper() {
        if (this.state) {
            this.normalize();
            boolean crashed = false;
            if (!World.checkBeeper(this.loc[3], this.loc[0])) {
                crashed = this.crash("No beepers to pick");
            }
            if (!crashed) {
                if (this.beepers != -1) {
                    ++this.beepers;
                }
                World.placeBeepers(this.loc[3], this.loc[0], -1);
                StateObject s = new StateObject(2);
                this.setChanged();
                this.notifyObservers(s);
                this.sleep();
            }
        }
    }

    public void putBeeper() {
        if (this.state) {
            this.normalize();
            if (this.beepers == 0) {
                this.crash("No beepers to put.");
            }
            if (this.beepers != -1) {
                --this.beepers;
            }
            if (!this.validate()) {
                if (this.beepers != -1) {
                    ++this.beepers;
                }
            } else {
                World.placeBeepers(this.loc[3], this.loc[0], 1);
                StateObject s = new StateObject(3);
                this.setChanged();
                this.notifyObservers(s);
            }
            this.sleep();
        }
    }

    public void turnOff() {
        if (this.state) {
            System.out.println("Robot " + this.idNumber + ": Turning off");
        }
        this.state = false;
        StateObject s = new StateObject(4);
        this.setChanged();
        this.notifyObservers(s);
        this.sleep();
    }

    public Object clone() {
        try {
            ur_Robot result = (ur_Robot)super.clone();
            result.idNumber = ur_Robot.incrementRobots();
            result.loc = new int[4];
            int i = 0;
            while (i < 4) {
                result.loc[i] = this.loc[i];
                ++i;
            }
            World.addRobot(result);
            return result;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getNextCommunication() {
        if (this.senders.size() == 0) {
            return null;
        }
        int count = 0;
        while (count < this.senders.size()) {
            if (this.nextSender >= this.senders.size()) {
                this.nextSender = 0;
            }
            BufferedReader in = (BufferedReader)this.senders.elementAt(this.nextSender);
            try {
                ++this.nextSender;
                if (in.ready()) {
                    return in.readLine();
                }
            }
            catch (IOException iOException) {}
            ++count;
            this.sleep();
        }
        return null;
    }

    public String waitForCommunication() {
        if (this.senders.size() == 0) {
            return null;
        }
        while (true) {
            if (this.nextSender >= this.senders.size()) {
                this.nextSender = 0;
            }
            BufferedReader in = (BufferedReader)this.senders.elementAt(this.nextSender);
            try {
                ++this.nextSender;
                if (in.ready()) {
                    return in.readLine();
                }
            }
            catch (IOException iOException) {}
            this.sleep();
        }
    }

    public String waitForNextCommunication() {
        if (this.senders.size() == 0) {
            return null;
        }
        while (true) {
            if (this.nextSender >= this.senders.size()) {
                this.nextSender = 0;
            }
            BufferedReader in = (BufferedReader)this.senders.elementAt(this.nextSender);
            try {
                ++this.nextSender;
                return in.readLine();
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public BufferedWriter connectTo(ur_Robot other, ConnectStrategy strat) throws IOException {
        PipedOutputStream out = new PipedOutputStream();
        BufferedWriter result = new BufferedWriter(new OutputStreamWriter(out));
        other.acceptConnectionFrom(this, out, strat);
        return result;
    }

    public synchronized void acceptConnectionFrom(ur_Robot sender, PipedOutputStream s, ConnectStrategy strat) throws IOException {
        BufferedReader manager = new BufferedReader(new InputStreamReader(new PipedInputStream(s)));
        if (strat != null) {
            strat.action(sender, this, manager);
        } else {
            this.senders.addElement(manager);
        }
    }

    public synchronized void acceptConnection(PipedOutputStream s, ConnectStrategy strat) throws IOException {
        BufferedReader manager = new BufferedReader(new InputStreamReader(new PipedInputStream(s)));
        if (strat != null) {
            strat.action(null, this, manager);
        } else {
            this.senders.addElement(manager);
        }
    }

    public void send(BufferedWriter other, String s) throws IOException {
        other.write(String.valueOf(s) + '\n');
        other.flush();
    }

    public void run() {
    }

    public ur_Robot(int street, int avenue, int direction, int beepers) {
        this.loc[3] = street;
        this.loc[1] = 0;
        this.loc[0] = avenue;
        this.loc[2] = 0;
        this.direction = direction % 4;
        this.beepers = beepers;
        this.validate();
        this.idNumber = ur_Robot.incrementRobots();
        this.state = true;
        this.initialState = new StateObject(-1);
        World.addRobot(this);
        this.sleep();
    }

    public void restoreInitialState() {
        this.loc[3] = this.initialState.street;
        this.loc[1] = 0;
        this.loc[0] = this.initialState.avenue;
        this.loc[2] = 0;
        this.direction = this.initialState.direction;
        this.beepers = this.initialState.beepers;
        this.state = true;
        this.showState("Restoring ");
        this.setChanged();
        this.notifyObservers(this.initialState);
        this.sleep();
    }

    public final String toString() {
        this.normalize();
        return "RobotID " + this.idNumber + " at (street: " + this.loc[3] + ") (avenue: " + this.loc[0] + ") (beepers: " + (this.beepers >= 0 ? String.valueOf(this.beepers) : "infinite") + ") ( direction: " + this.direction(this.direction) + (this.state ? ") on" : ") off");
    }

    private String direction(int d) {
        switch (d) {
            case 0: {
                return "East";
            }
            case 1: {
                return "South";
            }
            case 2: {
                return "West";
            }
            case 3: {
                return "North";
            }
        }
        return "ERROR";
    }

    protected void sleep() {
        try {
            Thread.sleep(10 * World.delay());
        }
        catch (InterruptedException interruptedException) {}
    }

    public final void showState(String s) {
        this.normalize();
        System.out.println(String.valueOf(s) + this);
    }

    public final boolean areYouHere(int street, int avenue) {
        this.normalize();
        return this.loc[3] == street && this.loc[0] == avenue;
    }

    private boolean validate() {
        this.normalize();
        if (this.beepers < -1) {
            return this.crash("Robot has negative beepers") ^ true;
        }
        if (this.loc[3] < 1) {
            return this.crash("Robot tried to move through South boundary wall") ^ true;
        }
        if (this.loc[0] < 1) {
            return this.crash("Robot tried to move through West boundary wall") ^ true;
        }
        return true;
    }

    private boolean crash(String s) {
        this.state = false;
        this.showState("Error shutoff: ");
        System.out.println(s);
        this.pauseExit();
        return true;
    }

    private void pauseExit() {
        try {
            System.in.read();
        }
        catch (IOException iOException) {}
        System.exit(0);
    }

    private void normalize() {
        this.moves = 0;
        this.loc[3] = this.loc[3] - this.loc[1];
        this.loc[1] = 0;
        this.loc[0] = this.loc[0] - this.loc[2];
        this.loc[2] = 0;
    }

    protected final int beepers() {
        return this.beepers;
    }

    public final int direction() {
        return this.direction;
    }

    public final int street() {
        return this.loc[3] - this.loc[1];
    }

    public final int avenue() {
        return this.loc[0] - this.loc[2];
    }

    public final boolean running() {
        return this.state;
    }

    private static synchronized int incrementRobots() {
        return numberOfRobots++;
    }

    public static interface ConnectStrategy {
        public void action(ur_Robot var1, ur_Robot var2, BufferedReader var3);
    }

    static interface Action {
        public static final int move = 0;
        public static final int turnLeft = 1;
        public static final int pickBeeper = 2;
        public static final int putBeeper = 3;
        public static final int turnOff = 4;
        public static final int initial = -1;
    }

    final class StateObject
    implements Serializable {
        private int street;
        private int avenue;
        private int direction;
        private int beepers;
        private int lastAction;

        public StateObject(int lastAction) {
            this.street = ur_Robot.this.loc[3] - ur_Robot.this.loc[1];
            this.avenue = ur_Robot.this.loc[0] - ur_Robot.this.loc[2];
            this.direction = ur_Robot.this.direction;
            this.beepers = ur_Robot.this.beepers;
            this.lastAction = lastAction;
        }

        public int street() {
            return this.street;
        }

        public int avenue() {
            return this.avenue;
        }

        public int direction() {
            return this.direction;
        }

        public int beepers() {
            return this.beepers;
        }

        public int lastAction() {
            return this.lastAction;
        }
    }
}

