/*
 * Decompiled with CFR 0.152.
 */
package kareltherobot;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import kareltherobot.Directions;
import kareltherobot.RobotVision;
import kareltherobot.ur_Robot;

public class World
implements Directions {
    private static RobotVision view = new RobotVision();
    private static Vector threadVector = new Vector();
    private static Hashtable beepers = new Hashtable();
    private static Hashtable ewWalls = new Hashtable();
    private static Hashtable nsWalls = new Hashtable();
    private static final Integer foo = new Integer(1);
    private static Vector robots = new Vector();
    private static RobotObserver myObserver = new RobotObserver();
    private static int delay = 1;
    private static int streets = 10;
    private static int avenues = 10;
    private static ThreadGroup threads = new ThreadGroup("RobotThread");
    private static boolean tracing = true;
    private static Hashtable checkpointBeepers = null;

    private World() {
    }

    public static synchronized void placeBeepers(int Street, int Avenue, int howMany) {
        IntPair where = new IntPair(Street, Avenue);
        Integer p = (Integer)beepers.get(where);
        if (p == null) {
            if (howMany > 0 || howMany == -1) {
                beepers.put(where, new Integer(howMany));
            }
        } else {
            if (p == -1) {
                return;
            }
            beepers.remove(where);
            int newval = p + howMany;
            if (newval > 0) {
                beepers.put(where, new Integer(newval));
            }
        }
    }

    public static synchronized boolean decreaseBeeperIfPossible(int Street, int Avenue) {
        boolean result = false;
        if (World.checkBeeper(Street, Avenue)) {
            result = true;
            World.placeBeepers(Street, Avenue, -1);
        }
        return result;
    }

    public static synchronized boolean checkBeeper(int Street, int Avenue) {
        IntPair p = new IntPair(Street, Avenue);
        return beepers.get(p) != null;
    }

    public static void addRobot(ur_Robot k) {
        robots.addElement(k);
        k.addObserver(myObserver);
        if (tracing) {
            System.out.println(k);
        }
        view.repaint();
    }

    public static synchronized boolean checkRobot(ur_Robot k, int street, int avenue) {
        Enumeration e = robots.elements();
        while (e.hasMoreElements()) {
            ur_Robot o = (ur_Robot)e.nextElement();
            if (o == k || !o.areYouHere(street, avenue)) continue;
            return true;
        }
        return false;
    }

    public static Enumeration ewWalls() {
        return ewWalls.keys();
    }

    public static Enumeration nsWalls() {
        return nsWalls.keys();
    }

    public static Enumeration robots() {
        return robots.elements();
    }

    public static Enumeration beepers() {
        return new BeeperEnum();
    }

    public static final boolean checkEWWall(int NorthOfStreet, int atAvenue) {
        if (NorthOfStreet == 0) {
            return true;
        }
        IntPair p = new IntPair(NorthOfStreet, atAvenue);
        return ewWalls.get(p) != null;
    }

    public static final boolean checkNSWall(int atStreet, int EastOfAvenue) {
        if (EastOfAvenue == 0) {
            return true;
        }
        IntPair p = new IntPair(atStreet, EastOfAvenue);
        return nsWalls.get(p) != null;
    }

    public static final void placeEWWall(int NorthOfStreet, int atAvenue, int lengthTowardEast) {
        int i = 0;
        while (i < lengthTowardEast) {
            ewWalls.put(new IntPair(NorthOfStreet, atAvenue + i), foo);
            ++i;
        }
    }

    public static final void placeNSWall(int atStreet, int EastOfAvenue, int lengthTowardNorth) {
        int i = 0;
        while (i < lengthTowardNorth) {
            nsWalls.put(new IntPair(atStreet + i, EastOfAvenue), foo);
            ++i;
        }
    }

    public static final void saveWorld(String filename) {
        try {
            IntPair p;
            BufferedWriter w = new BufferedWriter(new FileWriter(filename));
            Enumeration e = beepers.keys();
            while (e.hasMoreElements()) {
                p = (IntPair)e.nextElement();
                w.write("beepers " + p.s + " " + p.a + " " + beepers.get(p));
                w.newLine();
            }
            e = ewWalls.keys();
            while (e.hasMoreElements()) {
                p = (IntPair)e.nextElement();
                w.write("eastwestwalls " + p.s + " " + p.a + " " + p.a);
                w.newLine();
            }
            e = nsWalls.keys();
            while (e.hasMoreElements()) {
                p = (IntPair)e.nextElement();
                w.write("northsouthwalls " + p.a + " " + p.s + " " + p.s);
                w.newLine();
            }
            w.close();
        }
        catch (IOException iOException) {
            System.out.println("Can't save world.");
        }
    }

    public static final void showWorld() {
        IntPair p;
        Enumeration e = beepers.keys();
        System.out.println();
        while (e.hasMoreElements()) {
            p = (IntPair)e.nextElement();
            int b = (Integer)beepers.get(p);
            System.out.println(String.valueOf(b >= 0 ? String.valueOf(b) : "infinite number of") + " beepers at " + p.s + " street and " + p.a + " avenue");
        }
        e = ewWalls.keys();
        while (e.hasMoreElements()) {
            p = (IntPair)e.nextElement();
            System.out.println("east west wall above " + p.s + " street crossing " + p.a + " avenue");
        }
        e = nsWalls.keys();
        while (e.hasMoreElements()) {
            p = (IntPair)e.nextElement();
            System.out.println("north south wall east of " + p.a + " avenue crossing " + p.s + " street");
        }
        System.out.println();
    }

    public static final void readWorld(String filename) {
        try {
            FileInputStream f = new FileInputStream(filename);
            InputStreamReader r = new InputStreamReader(f);
            int size = f.available();
            char[] buf = new char[size];
            r.read(buf, 0, size);
            StringTokenizer t = new StringTokenizer(new String(buf));
            while (t.hasMoreTokens()) {
                int n;
                int a;
                int s;
                String token = t.nextToken();
                if (token.equals("beepers")) {
                    s = Integer.parseInt(t.nextToken());
                    a = Integer.parseInt(t.nextToken());
                    n = Integer.parseInt(t.nextToken());
                    World.placeBeepers(s, a, n);
                    continue;
                }
                if (token.equals("eastwestwalls")) {
                    s = Integer.parseInt(t.nextToken());
                    a = Integer.parseInt(t.nextToken());
                    n = Integer.parseInt(t.nextToken());
                    World.placeEWWall(s, a, n - a + 1);
                    continue;
                }
                if (!token.equals("northsouthwalls")) continue;
                int a2 = Integer.parseInt(t.nextToken());
                int s2 = Integer.parseInt(t.nextToken());
                n = Integer.parseInt(t.nextToken());
                World.placeNSWall(s2, a2, n - s2 + 1);
            }
            r.close();
        }
        catch (IOException iOException) {
            System.out.println("Can't read world.");
        }
    }

    public static final void reset() {
        beepers.clear();
        ewWalls.clear();
        nsWalls.clear();
        Enumeration e = robots.elements();
        while (e.hasMoreElements()) {
            ((ur_Robot)e.nextElement()).deleteObserver(myObserver);
        }
        robots.setSize(0);
    }

    public static final void setDelay(int d) {
        if (d < 0) {
            d = 0;
        }
        delay = d;
    }

    public static final int delay() {
        return delay;
    }

    public static final void resume() {
        threads.resume();
    }

    public static final void stop() {
        threads.suspend();
    }

    public static final void setSize(int numberOfStreets, int numberOfAvenues) {
        streets = numberOfStreets;
        avenues = numberOfAvenues;
    }

    public static final void setTrace(boolean t) {
        tracing = t;
    }

    public static final void setupThread(Runnable r) {
        Thread t = new Thread(threads, r);
        threadVector.addElement(t);
        view.showControl();
    }

    public static final void startThreads() {
        Enumeration e = threadVector.elements();
        while (e.hasMoreElements()) {
            ((Thread)e.nextElement()).start();
        }
    }

    public static final int numberOfStreets() {
        return streets;
    }

    public static final int numberOfAvenues() {
        return avenues;
    }

    static /* synthetic */ Hashtable access$0() {
        return beepers;
    }

    private static class BeeperEnum
    implements Enumeration {
        private Enumeration k = World.access$0().keys();
        private Enumeration v = World.access$0().elements();

        public boolean hasMoreElements() {
            return this.k.hasMoreElements();
        }

        public Object nextElement() {
            IntPair p = (IntPair)this.k.nextElement();
            Integer val = (Integer)this.v.nextElement();
            return new BeeperCell(p.s, p.a, val);
        }

        BeeperEnum() {
        }
    }

    static class BeeperCell {
        private int street;
        private int avenue;
        private int number;

        public BeeperCell(int s, int a, int n) {
            this.street = s;
            this.avenue = a;
            this.number = n;
        }

        public int street() {
            return this.street;
        }

        public int avenue() {
            return this.avenue;
        }

        public int number() {
            return this.number;
        }
    }

    static class IntPair {
        private int s;
        private int a;

        IntPair(int s, int a) {
            this.s = s;
            this.a = a;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntPair)) {
                return false;
            }
            return this.s == ((IntPair)o).s && this.a == ((IntPair)o).a;
        }

        public String toString() {
            return "<" + this.s + "," + this.a + ">";
        }

        public int hashCode() {
            return this.a + 1001 * this.s;
        }

        public int street() {
            return this.s;
        }

        public int avenue() {
            return this.a;
        }
    }

    static class RobotObserver
    implements Observer {
        public synchronized void update(Observable o, Object s) {
            if (tracing) {
                System.out.println(o);
            }
            view.prepareToDraw((ur_Robot.StateObject)s);
        }

        RobotObserver() {
        }
    }
}

