/*
 * Decompiled with CFR 0.152.
 */
package kareltherobot;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import kareltherobot.Directions;
import kareltherobot.World;
import kareltherobot.ur_Robot;

public class RobotVision
extends Frame {
    private Image karelImageN;
    private Image karelImageS;
    private Image karelImageE;
    private Image karelImageW;
    private static int worldHeight = 480;
    private static int worldWidth = 640;
    private static final int leftEdge = 20;
    private static int bottomEdge = worldHeight - 20;
    private static final int wallSize = 4;
    private ViewCanvas worldView = new ViewCanvas();
    private int delay = 100;
    private ControlThread controlThread = new ControlThread();

    public RobotVision() {
        super("Karel J. Robot");
        ((Component)this).setSize(worldWidth, worldHeight + 20);
        this.add("Center", this.worldView);
        this.addWindowListener(new CloseListener());
        ((Component)this).setBackground(Color.white);
        this.repaint();
        ((Component)this).setVisible(true);
        this.controlThread.start();
        this.karelImageN = this.getToolkit().getImage("kareln.gif");
        this.karelImageS = this.getToolkit().getImage("karels.gif");
        this.karelImageE = this.getToolkit().getImage("karele.gif");
        this.karelImageW = this.getToolkit().getImage("karelw.gif");
        MediaTracker track = new MediaTracker(this);
        track.addImage(this.karelImageN, 0);
        track.addImage(this.karelImageS, 1);
        track.addImage(this.karelImageE, 2);
        track.addImage(this.karelImageW, 3);
        try {
            track.waitForID(0);
            track.waitForID(1);
            track.waitForID(2);
            track.waitForID(3);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void showControl() {
        this.controlThread.showControl();
    }

    public void reset() {
        this.controlThread.stop.setLabel("Resume");
        World.stop();
        this.worldView.repaint();
    }

    public synchronized void prepareToDraw(ur_Robot.StateObject so) {
        this.worldView.repaint();
    }

    public synchronized void repaint() {
        this.worldView.repaint();
    }

    class ControlThread
    extends Thread {
        private Dialog frame = new Dialog(new Frame("empty"), "Control");
        private Button stop = new Button("Resume");
        private Panel controls = new Panel();
        private Scrollbar speed = new Scrollbar(0);
        private Button restore = new Button("Restore");
        private boolean started = false;

        public void run() {
            SpeedListener speedListener = new SpeedListener();
            this.speed.addAdjustmentListener(speedListener);
            this.controls.setSize(300, 50);
            this.controls.setLayout(new GridLayout(1, 4));
            this.speed.setValues(0, 0, 0, 101);
            this.speed.setSize(300, this.speed.getSize().height);
            this.speed.setValue(100 - World.delay());
            this.stop.addActionListener(new StopListener());
            this.controls.add(this.stop);
            this.controls.add(new Label("Set Speed", 2));
            this.controls.add(this.speed);
            this.frame.add(this.controls);
            ((Component)this.frame).setLocation(500, 400);
            ((Component)this.frame).setSize(300, 50);
            ((Component)this.frame).setVisible(false);
        }

        public final void doStop() {
            ((Component)this.frame).setVisible(false);
            this.stop();
        }

        public void showControl() {
            ((Component)this.frame).setVisible(true);
        }

        ControlThread() {
        }

        private class SpeedListener
        implements AdjustmentListener {
            public void adjustmentValueChanged(AdjustmentEvent e) {
                RobotVision.this.delay = ControlThread.this.speed.getValue();
                World.setDelay(100 - RobotVision.this.delay);
                RobotVision.this.worldView.repaint();
            }

            SpeedListener() {
            }
        }

        private class StopListener
        implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Stop")) {
                    ControlThread.this.stop.setLabel("Resume");
                    World.stop();
                } else {
                    ControlThread.this.stop.setLabel("Stop");
                    if (ControlThread.this.started) {
                        World.resume();
                    } else {
                        ControlThread.this.started = true;
                        World.startThreads();
                    }
                }
            }

            StopListener() {
            }
        }
    }

    class ViewCanvas
    extends Canvas
    implements Directions {
        private Image offScreen = null;
        private Graphics osg = null;
        private boolean resized = false;
        int scale;

        public synchronized void paint(Graphics g) {
            Object p;
            int streets = World.numberOfStreets();
            int avenues = World.numberOfAvenues();
            this.scale = (worldHeight - 40) / streets;
            this.setBackground(Color.white);
            g.setColor(Color.red);
            int i = 1;
            while (i <= streets) {
                g.drawLine(20 + this.scale / 2, bottomEdge - i * this.scale, 20 + avenues * this.scale, bottomEdge - i * this.scale);
                ++i;
            }
            int i2 = 1;
            while (i2 <= avenues) {
                g.drawLine(20 + i2 * this.scale, bottomEdge - this.scale / 2, 20 + i2 * this.scale, bottomEdge - streets * this.scale);
                ++i2;
            }
            g.setColor(Color.black);
            g.fillRect(20 + this.scale / 2 - 4, bottomEdge - streets * this.scale, 4, streets * this.scale - this.scale / 2);
            g.fillRect(20 + this.scale / 2, bottomEdge - this.scale / 2, avenues * this.scale, 4);
            Enumeration e = World.ewWalls();
            while (e.hasMoreElements()) {
                p = (World.IntPair)e.nextElement();
                this.drawHWall(((World.IntPair)p).street(), ((World.IntPair)p).avenue(), g);
            }
            e = World.nsWalls();
            while (e.hasMoreElements()) {
                p = (World.IntPair)e.nextElement();
                this.drawVWall(((World.IntPair)p).street(), ((World.IntPair)p).avenue(), g);
            }
            e = World.beepers();
            while (e.hasMoreElements()) {
                p = (World.BeeperCell)e.nextElement();
                this.drawBeeper(((World.BeeperCell)p).street(), ((World.BeeperCell)p).avenue(), ((World.BeeperCell)p).number(), g, g.getColor());
            }
            e = World.robots();
            while (e.hasMoreElements()) {
                p = (ur_Robot)e.nextElement();
                this.drawRobot(((ur_Robot)p).street(), ((ur_Robot)p).avenue(), ((ur_Robot)p).direction(), ((ur_Robot)p).running(), g, g.getColor());
            }
        }

        public final synchronized void update(Graphics g) {
            this.setSize(RobotVision.this.getSize());
            int newHeight = this.getSize().height - 20;
            int newWidth = this.getSize().width;
            this.resized = worldHeight != newHeight || worldWidth != newWidth;
            worldHeight = newHeight;
            worldWidth = newWidth;
            bottomEdge = worldHeight - 20;
            if (this.resized) {
                this.offScreen = null;
                this.resized = false;
            }
            if (this.resized || this.offScreen == null) {
                this.offScreen = this.createImage(worldWidth, worldHeight);
                this.resized = false;
            }
            if (this.offScreen != null) {
                if (this.osg != null) {
                    this.osg.dispose();
                }
                this.osg = this.offScreen.getGraphics();
                this.paint(this.osg);
                g.drawImage(this.offScreen, 0, 0, null);
                this.offScreen.flush();
                this.offScreen = null;
            }
        }

        private void drawHWall(int s, int a, Graphics g) {
            g.fillRect(20 + a * this.scale - this.scale / 2, bottomEdge - s * this.scale - this.scale / 2, this.scale, 4);
        }

        private void drawVWall(int s, int a, Graphics g) {
            g.fillRect(20 + a * this.scale + this.scale / 2, bottomEdge - s * this.scale - this.scale / 2, 4, this.scale);
        }

        private synchronized void drawBeeper(int s, int a, int howMany, Graphics g, Color c) {
            Color oldColor = g.getColor();
            g.setColor(c);
            g.fillOval(20 + a * this.scale - this.scale / 4, bottomEdge - s * this.scale - this.scale / 4, this.scale / 2, this.scale / 2);
            g.setColor(Color.white);
            String name = howMany > 0 ? String.valueOf(howMany) : "oo";
            g.drawString(name, 20 + a * this.scale - this.scale / 8, bottomEdge - s * this.scale + this.scale / 8);
            g.setColor(oldColor);
        }

        private synchronized void drawRobot(int s, int a, int facing, boolean running, Graphics g, Color c) {
            switch (facing) {
                case 3: {
                    g.drawImage(RobotVision.this.karelImageN, 20 + a * this.scale - 14, bottomEdge - s * this.scale - 12, null);
                    break;
                }
                case 0: {
                    g.drawImage(RobotVision.this.karelImageE, 20 + a * this.scale - 12, bottomEdge - s * this.scale - 14, null);
                    break;
                }
                case 1: {
                    g.drawImage(RobotVision.this.karelImageS, 20 + a * this.scale - 14, bottomEdge - s * this.scale - 12, null);
                    break;
                }
                case 2: {
                    g.drawImage(RobotVision.this.karelImageW, 20 + a * this.scale - 12, bottomEdge - s * this.scale - 14, null);
                    break;
                }
            }
        }

        ViewCanvas() {
        }
    }

    private class CloseListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            ((Component)e.getWindow()).setVisible(false);
            RobotVision.this.controlThread.doStop();
            World.stop();
            System.exit(0);
        }

        CloseListener() {
        }
    }
}

