from datetime import datetime
from apscheduler.schedulers.blocking import BlockingScheduler	# 引用阻塞式调度器
from apscheduler.triggers.interval import IntervalTrigger

from htmlSpider import htmlSpider

class workThread:
    dataBaseName = None
    tableName = None
    machineCount = 0
    spiderObjectList = []
    scheduler = BlockingScheduler()
    
    def __init__(self,dataBaseName,tableName):
        self.dataBaseName = dataBaseName
        self.tableName = tableName
        self.machineCount = 0

        with open('''init.in''', 'r') as file_to_read:
            while True:
                read_ipId = file_to_read.readline() 
                if not read_ipId:
                    break 
                else:
                    self.machineCount=self.machineCount+1
                read_ipId = [str(i) for i in read_ipId.split(";")]
                read_machineIP = read_ipId[0]
                read_machineName = read_ipId[1]
                print(read_machineIP," ",read_machineName)
                self.spiderObjectList.append(htmlSpider(self.dataBaseName,self.tableName,read_machineIP,read_machineName))
        
    def add(self):
        #print(self.spiderObjectList)
        for spiderObject in self.spiderObjectList:
            trigger = IntervalTrigger(seconds=20)
            self.scheduler.add_job(spiderObject.crawler, trigger, replace_existing = True, id = spiderObject.machineName)
            print('addSchedulerJobSuccessful' + spiderObject.machineName)
        self.scheduler.start()
        
if __name__ == '__main__':
    work= workThread('test_modified','project1')
    work.add()
    
    
    
# =============================================================================
# if __name__ == '__main__':
#     scheduler = BlockingScheduler()
#     scheduler.add_job(my_clock, "interval", seconds=3)
#     scheduler.start()
# =============================================================================

#1. database名称  3. 表格名 tableName 
#每一次： 4.IP + 5. 单个机器名(任务 id) 



