from htmlDownload import htmlDownload
from dataSaver import dataSaver

import schedule
import time
import datetime

from apscheduler.schedulers.blocking import BlockingScheduler	# 引用阻塞式调度器
from apscheduler.triggers.interval import IntervalTrigger

class htmlSpider(object):
    downloader=None
    datasaver=None

    machineIp = None
    machineName = None
    
    def __init__(self,sqlName,tableName,machineIP,machineName):
        self.machineIP = machineIP
        self.machineName = machineName
        self.downloader = htmlDownload(machineIP)
        self.datasaver = dataSaver(sqlName = sqlName,tableName = tableName,machineName = machineName)
        print("机器{machineName} 初始化成功".format(machineName = self.machineName))
    
    def crawler(self):
        print("正在保存{machineName}".format(machineName = self.machineName))
        #print(self.downloader.linkist)
        a = htmlDownload(self.machineIP).download()
        #print(a)
        self.datasaver.saver(a)
    
    def crawl(self):
        schedule.every(20).seconds.do(self.gatherData) 
        while True:
             schedule.run_pending()
             time.sleep(1)

if __name__ == '__main__':
        
    scheduler = BlockingScheduler()
    
    spiderObject = htmlSpider('dataBaseName','tabelName',"http://192.168.1.25/",'machine1')
    scheduler.add_job(spiderObject.crawler, 'interval', seconds = 30, replace_existing = True, id = spiderObject.machineName)  
    print('addSchedulerJobSuccessful' + spiderObject.machineName)
    scheduler.start()
    
    

#1. database名称  3. 表格名 tableName 
#每一次： 4.IP + 5. 单个机器名
