//
//  ReminderTableViewController.swift
//  TinyReminders_Demo
//
//  Created by Michael Gazzola on 9/8/14.
//  Copyright (c) 2014 Michael Gazzola. All rights reserved.
//

import UIKit

protocol ReminderProtocol {
    func receivedNewReminder(reminder: String, timestamp: String)
}

struct Reminder {
    var title: String
    var timestamp: String
}

class ReminderTableViewController: UITableViewController, ReminderProtocol{
    
    var reminders: [Reminder] = [
        Reminder(title:"Call mom", timestamp:"eventually"),
        Reminder(title:"Call sister", timestamp:"never"),
    ]
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.tableView.dataSource = self
        self.tableView.delegate = self
    }

    override func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier("reminder") as? ReminderCellTableViewCell ?? ReminderCellTableViewCell()
        let reminder = self.reminders[indexPath.row]
        
        cell.reminderTitle.text = reminder.title
        cell.reminderDate.text = reminder.timestamp
        
        return cell
    }
    
    override func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return self.reminders.count
    }
    
    func receivedNewReminder(reminder: String, timestamp: String) {
        self.reminders.append(Reminder(title: reminder, timestamp: timestamp))
        self.tableView.reloadData()
    }
    
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        switch segue.identifier! {
        case "tableToDisplay":
            if let secondViewController = segue.destinationViewController as? ReminderDisplayViewController {
                if let cell = sender as? ReminderCellTableViewCell {
                    secondViewController.titleString = cell.reminderTitle.text!
                    secondViewController.dateString = cell.reminderDate.text!
                }
            }
        case "newReminder":
            if let secondViewController = segue.destinationViewController as? NewReminderViewController {
                secondViewController.delegate = self
            }
        default:
            break
        }
        
    }

}
