//
//  NewReminderViewController.swift
//  TinyReminders_Demo
//
//  Created by Sally McNichols on 12/2/15.
//  Copyright © 2015 Michael Gazzola. All rights reserved.
//

import UIKit

class NewReminderViewController: UIViewController {
    
    @IBOutlet var reminderTextField: UITextField!
    var delegate: ReminderProtocol!
    @IBOutlet var dateTextField: UITextField!
    var reminderString: String = ""
    var dateString: String = ""
    var tap = UITapGestureRecognizer()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        tap.addTarget(self, action: "tapped")
        self.view.addGestureRecognizer(tap)
    }

    func tapped() {
        self.view.endEditing(true)
    }
    
    @IBAction func submit(sender: AnyObject) {
        self.view.endEditing(true)
        self.reminderString = self.reminderTextField.text!
        self.dateString = self.dateTextField.text!
        self.delegate.receivedNewReminder(self.reminderString, timestamp: self.dateString)
        self.dismissViewControllerAnimated(true, completion: nil)
    }

    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

}
