/* 
Prepared by John Gruen

This sketch demonstrates a bare bones
version of a double for loop you might use if you want to 
sample only certian pixels of an image or video. 

This technique is the basis for the more complex
examples I've prepared. 

Change the variable ds to change the granularity of the final
*/

import processing.video.*;

Capture v;
int ds = 20;

void setup() {
   size(640,480);
   smooth();
   v = new Capture(this,640,480,30);
   noStroke(); 
}

void draw() {
  background(0);
  v.read(); // read the video 
  v.loadPixels(); // make the picture array accessable;
  //note: make sure you use v.width and v.height
  for(int x = 0; x < v.width; x+= ds) {
    for(int y = 0; y < v.height; y+= ds) {
      int i = v.width*y + x;//this gets index for each x,y positioned pixel
      color target = v.pixels[i];//target stores a particular color
      fill(target); //set the fill
      rect(x,y,ds,ds);//draw a rectangle at x,y     
      
      }
    }   
} 
  
  
  
