/*
this sketch works similarly to v_trace_1 & v_trace_2 but is a little cleaner

controls:
click on the thumbnail image on the corner to select a target color
hold the space bar and move the mouse to spin around the 3d image
press 1,2, or 3 to use image presets
use UP and DOWN keys to change the allowed distance from the target color

this program allows you to select a color from pixels and then filter out
pixels that are a certian distance from that color...
this technique is helpful for simple blob detection, especially with bright colors!

*/

import processing.video.*;

Capture v;
int ds = 5;
color targetColor;
float targetR,targetG,targetB;
color thisPixel;
float targetDistance;
int maxDistance = 100;
int calcQuant, calcSum;
float calcAv;
float mx, my;

void setup() {
  textMode(SCREEN);
  size(1000,1000,P3D);
  v = new Capture(this,640/ds,460/ds,30);
  noStroke();
  textSize(16);
}


void draw() {
     background(0);
     setSampleImage();//sets things up...draws the thumbnail in the corner
     setTargetColor();//get target color when you click on the thumbnail
     displayTargetColor(); //shows hex target color above thumbnail
     changeMaxDistance(); //sets key controls to change max distance from sampled color
     displayMaxDistance(); //shows max dist # in lower left corner
     positionPixels(); // moves big grid to the middle, sets up rotation controls
     motherBrain(); //performs the logic of the function...there's more comments down there
}
  



void setSampleImage() {
  v.read();
  noFill();
  stroke(255);
  image(v,width - v.width*ds/3 - 5, height - v.height*ds/3 - 5,v.width*ds/3,v.height*ds/3);
  rect(width - v.width*ds/3 - 5, height - v.height*ds/3 - 5,v.width*ds/3,v.height*ds/3);
  noStroke();
}

void setTargetColor() {
  if (mouseX > width - v.width*ds/3 - 5 && mouseX < width - 5) {
    if ( mouseY > height - v.height*ds/3 - 5 && mouseY < height - 5) {
       if (mousePressed) {
        targetColor = get(mouseX,mouseY);
        targetR = red(targetColor);
        targetG = green(targetColor);
        targetB = blue(targetColor);
       } 
    }
  }
}

void displayTargetColor() {

  fill(255);
  text("#" + hex(targetColor),width - v.width*ds/3 - 5,height - v.height*ds/3 - 7);
}

void changeMaxDistance() {
   if (keyPressed && keyCode == UP) {
      maxDistance++;
   } else if (keyPressed && keyCode == DOWN) {
      maxDistance--; 
   }
}

void displayMaxDistance() {
    fill(255);
    text(maxDistance,5,height-5);  
}

void positionPixels() {
  translate(width/2,height/2,0); 
  stroke(255);
  noStroke();
  setRotateStates();
  translate(-v.width*ds/2,-v.height*ds/2);
}

void setRotateStates() {
  if (keyPressed && key == ' ') {
    mx = map(mouseY,0,width,PI/2,-PI/2);
    my = map(mouseX,0,width,-PI/2,PI/2); 
  } else if (keyPressed && key == '1') {
    mx = 0;
    my = 0;
  } else if (keyPressed && key == '2') {
    mx = PI/2;
    my = 0;
  } else if (keyPressed && key == '3') {
    mx = 0;
    my = PI/2;
  }
  rotateX(mx);
  rotateY(my);
}

void motherBrain() {
  //same double loop as the previous two examples
    for(int x = 0; x < v.width; x++) {
    for(int y = 0; y < v.height; y ++) {
       int i = v.width*y+x;
       thisPixel = v.pixels[i];
       //get each channel
       float r = red(thisPixel);
       float g = green(thisPixel);
       float b = blue(thisPixel);
       //get distance from target
       targetDistance = dist(r,g,b,targetR,targetG,targetB);
       pushMatrix();
      //if further than max, fill grey
       if (targetDistance > maxDistance) {
         fill(10);
       //else draw a pixel in the appropriate color and translate along z by the average of r,g and b
       } else {
       translate(0,0,(r+g+b)/3);
         fill(thisPixel);
       }
       //draw appropriate rectangle
       rect(ds*x, y*ds, ds,ds);
       popMatrix(); 
    } 
  }
}





