/*

created by john gruen

this file and v_trace1
are just fun examples of the kinds of stuff
you can do with video n' pixels n' stuff
they're not super complex.

controls:
mouseY: translate along y-axis
up and down keys: translate along z-axis
left and right keys: translate along x-axis
WASD: rotate in exciting ways;

feel free to change the ds variable to make
the image more or less grainy.

this program uses a double for loop strucure to downsample
a captured video. 

From this double loop, we get incremented positions horizontally
and vertically within the video. these x and y positions are
then interpolated into an i value which accesses the pixel array
for the captured video. 


for more info about how this code works, plz see my comments
on v_trace1
*/

import processing.video.*;



Capture v;
int ds = 10;
color target;
int hInc, vInc; //for translations
float rX, rZ; //for rotations




void setup() {
  size(1000, 1000, P3D);
  v = new Capture(this, 640, 480, 10);
  stroke(255);
  smooth();
  noFill();
}

void draw() {
  v.read();
  fill(0,100);
  noStroke();
  background(0);
  noFill();
  stroke(255,100);
  pushMatrix();
  translate(hInc, mouseY, vInc);
  rotateX(rX);
  rotateZ(rZ);
  

  
 v.loadPixels();
 for (int x = 0; x < v.width-ds; x+=ds) {
   beginShape();
    for (int y = 0; y < v.height-ds; y+=ds) {
      int i = v.width*y + x;
      //int z
      target = v.pixels[i];
      float rA = red(target); 
      curveVertex(x,y,rA);
      
    }
    endShape();
 }

  popMatrix();
  v.updatePixels();
  keyControls();
}


void keyControls() { 
  {
    if (keyPressed)
      if (keyCode == RIGHT) {
        hInc += 10;
      } 
      else if (keyCode == LEFT) {
        hInc -= 10;
      } 
      else if (keyCode == UP) {
        vInc += 10;
      } 
      else if (keyCode == DOWN) {
        vInc -= 10;
      } 
      else if (key == 'd') {
        rX += PI/100;
      } 
      else if (key == 'a') {
        rX -= PI/100;
      } 
      else if (key == 'w') {
        rZ += PI/100;
      } 
      else if (key == 's') {
        rZ -= PI/100;
      } 
  }
}





