/*

created by john gruen

this file and v_trace2
are just fun examples of the kinds of stuff
you can do with video n' pixels n' stuff
they're not super complex.

controls:
mouseY: translate along y-axis
up and down keys: translate along z-axis
left and right keys: translate along x-axis
WASD: rotate in exciting ways;

feel free to change the ds variable to make
the image more or less grainy.


this program uses a double for loop strucure to downsample
a captured video. 

From this double loop, we get incremented positions horizontally
and vertically within the video. these x and y positions are
then interpolated into an i value which accesses the pixel array
for the captured video. 
*/


import processing.video.*;

Capture v;

int ds = 20; //video downsample, play with this!
int hInc, vInc; //for translations
float rX, rZ; // for rotations
int bounce = 0;


void setup() {
  size(1000, 1000, P3D);
  v = new Capture(this, 640, 480, 30);
  noStroke();
}

/*the contents could, of course, be segregated into functions.
I've left everythng in draw b/c it's a little easier to understand.
See the keyPressed func. below to understand how translations
and rotations are implemented*/


void draw() {
  
  v.read();
  background(0);
  translate(hInc, mouseY, vInc);
  rotateX(rX);
  rotateZ(rZ);
 
  v.loadPixels();
  //the basic idea here is that we're getting the red values of each ds point
  //and then using these values as the z coordinates for a series of quads
  //created with vertex(x,y,z);
  for (int x = 0; x < v.width-ds; x+=ds) {
    for (int y = 0; y < v.height-ds; y+=ds) {
      int i = v.width*y + x; // i gives us the index value at each x,y position in our capture
      color target = v.pixels[i]; //set target to downsampled point i
      float rA = red(target); //rA gets the red value at v.pixels[i]
      i = v.width*y + x + ds; //reset i so that it samples at the position where the next x value is
      target = v.pixels[i]; //get the color at this new position
      float rAx = red(target); // get red value of the new target
      i = v.width*(y+ds) + x; //rest i so that it's at the position immediately below the new i
      target = v.pixels[i]; // get the color for the new i
      float rAy = red(target);  // get red value of the new target
      i = v.width*(y+ds) + x + ds; // reset i so that it's at one over and one down from the original i 
      target = v.pixels[i]; // get the color for the new i
      float rAxy = red(target); // get red value of the new target  
      fill(target);
      //draw the quad
      beginShape();
      vertex(x, y, -rA); 
      vertex(x+ds, y, -rAx);
      vertex(x+ds, y+ds, -rAxy);
      vertex(x, y+ds, -rAy);
      endShape(CLOSE);
    }
  }

  v.updatePixels();
  keyControls();
}



void keyControls() { 
  {
    if (keyPressed)
      if (keyCode == RIGHT) {
        hInc += 10;
      } 
      else if (keyCode == LEFT) {
        hInc -= 10;
      } 
      else if (keyCode == UP) {
        vInc += 10;
      } 
      else if (keyCode == DOWN) {
        vInc -= 10;
      } 
      else if (key == 'd') {
        rX += PI/100;
      } 
      else if (key == 'a') {
        rX -= PI/100;
      } 
      else if (key == 'w') {
        rZ += PI/100;
      } 
      else if (key == 's') {
        rZ -= PI/100;
      } 
      else if (key == ' ') {
        bounce++;
      }
  }
}





