/*

created by john gruen

this works similarly to blob_1 with a few key differences
1: it's not a game
2: it applies one more level of filtering to our video to get a cleaner sampling
of pixels that actually match our target color

controls:
click: select target color
click again: select a new target color

again try sampling a bright color...it'll work better

note: 

try commenting showColorOne and showColorTwo and untargeting showAverage

*/

import processing.video.*;
Capture v; //here's the video!
final int DS = 4; //here's the video downsample
final int WD = 640; //here's width
final int HT = 480; //here's height
final int DSW = WD/DS;//downsampled 'width' for arrays!
final int DSH = HT/DS;//downsampled 'height' for arrays!
final int MAX = DSW * DSH; //obvi WD*HT must be evenly divisible by DS
boolean[] testOne = new boolean[MAX];
boolean[] testTwo = new boolean[MAX];
int distanceThreshold = 50; //initial color distance threshold
color target; //this is the color we're sampling
float targetR,targetG,targetB; //target color
int clickCount; //how many times have I clicked?
boolean showImage = true; //is the image showing
int quant = 0; //collects # of trues in testTwo[]
float xAv, yAv; //holds average x and y values for a color


void setup() {
  size(WD,HT);
  smooth();
  noStroke();
  v = new Capture(this,WD,HT,30);
  
}

void draw() {
  initialize(); //sets everything up
  displayAndSample(); //determines whether or not to display v, gets target color
  showInfo(); //creates inforation display in lower left corner
  colorFilterOne(); //this is the first filter
  showFilterOne(); //show the results of the first filter
  colorFilterTwo(); //second filter
  showFilterTwo(); //show results of the second filter
  collectAverage(); //average positions of all results
  showAverage(); //indicate that position with a little circle
}

//determines wheter to show the average position of all the matching pixels
void showAverage() {
    if ( showImage == false) {
    noFill();
    strokeWeight(2);
    stroke(0);
    ellipse(xAv,yAv,20,20);
    noStroke();
    }
}

//sums and averages of all matching pixels
void collectAverage() {
   quant = 0;
   xAv = 0;
   yAv = 0;
   for (int x = 0; x < width; x+=DS) {
    for (int y = 0; y < height; y+=DS) {
      int littleI = (DSW)*(y/DS) + (x/DS);
         if (testTwo[littleI]) {
           quant++;
           xAv += x;
           yAv += y;
         }
    }
  }
    xAv = xAv/quant;
    yAv = yAv/quant;
}

//shows the results of filter two in the target color
void showFilterTwo() {
 fill(target);
 for (int x = 0; x < width; x+=DS) {
    for (int y = 0; y < height; y+=DS) {
      int littleI = (DSW)*(y/DS) + (x/DS);
         if (testTwo[littleI]) {
           rect(x,y,DS,DS); 
         }
    }
  }
}

//this func looks at testOne and narrows it down more into testTwo
//first it throws out all points at the beginnign and end of the array
//(or the top and the bottom of the image)
//then it looks at all 8 array values immediately arround each array point in testOne
//if and only if all of these values are true, testTwo[i] is declared true
//this works similarly to the creation of quads in v_trace_one!
void colorFilterTwo() {
    for (int littleI = 0; littleI < MAX; littleI++) {
      if (littleI < 2*DSW || littleI > MAX - 2*DSW) {
         testTwo[littleI] = false;
      } else {
         if (testOne[littleI] &&
            testOne[littleI+1] && testOne[littleI-1] && 
            testOne[littleI+DSW] && testOne[littleI-DSW] &&
            testOne[littleI+DSW+1] && testOne[littleI-DSW+1] &&
            testOne[littleI+DSW-1] && testOne[littleI-DSW-1] ){
           testTwo[littleI] = true;
         } else {
           testTwo[littleI] = false; 
         }
      }
  } 
}

void showFilterOne() {
 fill(200);
 for (int x = 0; x < width; x+=DS) {
    for (int y = 0; y < height; y+=DS) {
      int littleI = (DSW)*(y/DS) + (x/DS);
         if (testOne[littleI]) {
           rect(x,y,DS,DS); 
         }
    }
  }
}

/*this thing cycles through the entire pixel array for\
our capture object (v).
Inside the double for loop, i is used to get color values
from v. these values are parsed into RGB and tested
against a maximum color distance.
littleI cycles through a downSampled boolean array
if the test condition evaluates to true, the relevant
littleI value is also true
*/
void colorFilterOne() {
 
 for (int x = 0; x < width; x+=DS) {
    for (int y = 0; y < height; y+=DS) {
      //i cycles through the entire image array
      int i = width*y + x;
      //littleI cycles throug hte downsampled boolean arrays
      int littleI = (DSW)*(y/DS) + (x/DS);
      color thisColor = v.pixels[i];
      float thisR = red(v.pixels[i]);
      float thisG = green(v.pixels[i]);
      float thisB = blue(v.pixels[i]);
      float distanceTest = dist(thisR,thisG,thisB,targetR,targetG,targetB);
      if (distanceTest < distanceThreshold) {
       testOne[littleI] = true;
      } else {
       testOne[littleI] = false; 
      }
    }
  }
}
//creates a little display
void showInfo() {
  if (clickCount > 0 && showImage == false) {
    fill(target);
    rect(5,height-15,10,10);
    fill(0);
    text("max distance: " + distanceThreshold,20,height-6);
  }
}

//shows image and samples it
void displayAndSample() {
 if (clickCount % 2 == 0) {
    image(v,0,0);
    showImage = true;
 } else {
  if (showImage) {
  target = v.get(mouseX,mouseY);
  println(hex(target)); 
  targetR = red(target);
  targetG = green(target);
  targetB = blue(target);
  showImage = false;
  }
 }
}

void initialize() {
  background(255);
  v.read();
  v.loadPixels(); 
}

void mousePressed() {
  clickCount++;
}

void keyPressed() {
  if (keyCode == UP) {
     distanceThreshold++; 
  } else if (keyCode == DOWN) {
     distanceThreshold--;
  }  
}

