/*
  created by john gruen
  
  this game works by allowing the user to select a color then
  track a blob based on the appearance of that color
  note: hold a brightly colored object in front of your camera and click on it
  preferably bright blue or bright green
  
  the player blob can then strike a bouncy ball
  
  controls
  click: click on a color to set that color
  click again: reshow image to change the color
  click again: select a new color
  
  spacebar: start the bouncy ball
  
  move your object: move the blob on the the screen!

*/

import processing.video.*;
Capture v;
color target;//accesses target color
color vColor;//color for video indices;
final int DS = 2;//rapid traverse incrementer downsamples pixel array
final int THRESH = 40; //color distance threshold

float r,g,b,rT,gT,bT; // used to store target channels
float xPos,yPos,xPosPrev,yPosPrev,xTarget,yTarget,dX,dY;

float hEasing = .2; //horizontal easing of player ball
float vEasing = .2; //vertical easing of player ball
float dia = 40;

int xTotal;    //total x value (see below)
int yTotal;    //total y value (see below)
int grabTotal; //total number of sampled points in each blob (see below)

final int TQ = 20; //array size for blob's 'tail'
float[] dxa = new float[TQ]; //blob tail x points
float[] dya = new float[TQ]; //blob tail y points

float ballX, ballY,ballVX,ballVY; //coords for bouncy ball
float ballDia = 40; //dia of bouncy ball
boolean moveBall = false; //decides whether or not to move bouncy ball
boolean collide  = false; //checks for collisons
boolean showImg = true; //tests if video is showing
int fc; //frame count value
int clickCount; //numbber of clicks




void setup() {
  size(640,480);
  v = new Capture(this,640,480,30);
  smooth();
  noStroke();
  //these initialize things about the bouncy ball
  ballX = width/2;
  ballY = height/2;
  ballVX = random(5,10);
  ballVY = random(5,10);
}

void draw() {
  v.read(); //read vid
  v.loadPixels(); //load v pixels array
  if (showImg == true) image(v,0,0); //test whether or not to show v
  else background(255); //if not, just show white
  trackArray();// creates the blob tail based on previous ball positions
  traverseOne(); //traverse the v.pixels array looking at various points
  setBlob(); //puts the blob in place
  moveBall(); //moves the bouncy ball
  drawBall(); //draws the bouncy ball, colors based on collisions
  
  v.updatePixels();
}

//draws the bouncy ball
void drawBall() {
  if (collide == false) fill(200);
  else fill(255,100,100);
  ellipse(ballX,ballY,ballDia,ballDia);
  
}

//moves the bouncy ball and detects collisions
void moveBall() {
  
  if (ballX <= ballDia/2 || ballX >= width - ballDia/2) {
    ballVX = - ballVX;
  }
  if (ballY <= ballDia/2 || ballY >= height - ballDia/2) {
    ballVY = - ballVY;
  }
  float bDist = dist(ballX,ballY,xPos,yPos);
  if (collide == false && bDist <= ballDia/2 + dia/2) {
    ballVX = - ballVX;
    ballVY = - ballVY;
    fc = frameCount;
    collide = true;
  } 
  if (fc+15 < frameCount) {
     collide = false; 
  }
  if (moveBall == true) {
    ballX+=ballVX;
    ballY+=ballVY;
  }
}


//uses simple easing to interpolate blob movemment, draws blob
void setBlob() {
   dX= xTarget - xPosPrev; //distance btwn  current xTarget and previous x position
   dY= yTarget - yPosPrev; // ditto, but for y

   fill(200); 
   ellipse(xPos,yPos,dia,dia);
   float blobMove = dist(xPos,yPos,xPosPrev,yPosPrev); //get distance between current position and prev position
   //if/else changes easing depending on how much the blob has moved
   if (blobMove < 400) {
     hEasing = .8;
     vEasing = .8;
   } else {
    hEasing = .2;
    vEasing = .2; 
   }
    xPos += dX * hEasing; //xPos is the final x center point for our blob..gets easing applied
     yPos += dY * vEasing; //ditto for y
    xPosPrev = xPos;
    yPosPrev = yPos;
}

//traverses the array & determines center point of color range
void traverseOne() {
  xTotal = 0;
  yTotal = 0;
  grabTotal = 0;
  for( int x =  1; x < v.width-1; x+=DS){
    for( int y = 1; y < v.height-1; y+=DS){
      int pos = x + y*v.width;
      vColor = v.pixels[pos]; //gets color at downsampled points
      r = red(vColor);
      g = green(vColor);
      b = blue(vColor);
      float diff = dist(r,g,b,rT,gT,bT); //distance btwn each pixel and target color
      if (diff < THRESH) {
        
        
        xTotal+=x; //total x equals cumulative total of x positions within range of the target color
        yTotal+=y; //ditto for y
        grabTotal++; //grabtotal is the total number of pixels that match
      }
      //this next bit says that if any pixels match, we find the average x and average y values
      //otherwise nothing happens and xTarget and yTarget stay the same as in the prev frame
      //this cuts down on jitter
      if (grabTotal > 0) {
        xTarget = xTotal / grabTotal;
        yTarget = yTotal / grabTotal;
      }
    }
  } 
}

//this func draws the tail of our blob, by putting the last several positions in an array
//and using these to draw more circles
void trackArray() {
    dxa[0] = xPos;
    dya[0] = yPos;
    float trackTail;
 for (int i = TQ -1; i>0; i--) {
    
    dxa[i] = dxa[i-1];
    dya[i] = dya[i-1];
    
 }

 for (int i = 0; i < TQ-1; i++) {
    fill(map(i,0,TQ,0,255),50);
    trackTail = map(i,0,TQ,dia,1);
    ellipse( dxa[i],dya[i],trackTail,trackTail);   
 }
 
 
  
}
//grabs target color and toggles whether bg image shows
void mousePressed(  )
{  
   if (clickCount % 2 == 0) {
   int index = mouseX + mouseY*v.width;
   target = v.pixels[index];
   rT = red(target);
   gT = green(target);
   bT = blue(target);
   //println(target); 
   showImg = false;
   } else {
    showImg = true;
   } 
   clickCount++;
   
}

//starts ball motion
void keyPressed() {
  if (key == ' ') {
    moveBall = true;
    
  } 
}
