/*All the following examples are 
derived from :
http://processing.org/reference/libraries/pdf/index.html
these demos are not exhaustive

this example records individual frames into separate pdfs
just like the saveFrame

the main difference is that pdf export requires a 
beginRecord() call and endRecord() call to start
and stop the creation of the PDF

each mouse click outputs a single frame as a pdf
press space to reset random circles

*/
import processing.pdf.*;

final int MAX = 120;
float[] x = new float[MAX];
float[] y = new float[MAX];
float[] dia = new float[MAX];




boolean record;

void setup() {
  size(400, 400);
  smooth();
  fill(0);
  for (int i = 0; i < MAX; i++) {
     x[i] = random(0,width);
     y[i] = random(0,height);
     dia[i] = random(10,50);
  }
}

void draw() {
  if (record) {
    // Note that #### will be replaced with the frame number. Fancy!
    beginRecord(PDF, "frame-####.pdf"); 
  }

  // Draw something good here
  background(255);
  
  for (int i = 0; i < MAX; i++) {
    ellipse(x[i],y[i],dia[i],dia[i]);
  }

  if (record) {
    endRecord();
	record = false;
  }
}

// Use a keypress so thousands of files aren't created
void mousePressed() {
  record = true;
}

void keyPressed() {
 if (key == ' ') {
      for (int i = 0; i < MAX; i++) {
     x[i] = random(0,width);
     y[i] = random(0,height);
     dia[i] = random(10,50);
 } 
}
}

