import java.util.*;
import java.io.*;

// Note that this implementation is essentially identical to EM, minus the mixing stuff.

public class KMeans {

    static final int NUM_CLASSES = 2;
    static final int NUM_DATA = 10000;
    static final int NUM_ITERATIONS = 100;

    public static void main(String[] args) {
        String datafile = "gmmdata.txt";
        String classfile = "gmmclasses.txt";
        double[] data = readData(datafile);
        int[] classes = readClasses(classfile);
        

        for (int t = 0; t < NUM_ITERATIONS; ++t) {
            double[] mu = new double[NUM_CLASSES];
            double[][] membership = new double[NUM_CLASSES][NUM_DATA];
            runKMeans(data, mu, membership);
            
            double acc = calculateAccuracy(classes, membership);
            double minMu = Math.min(mu[0], mu[1]);
            double maxMu = Math.max(mu[0], mu[1]);
            System.out.println(minMu + " " + maxMu + " " + acc);
        }


    }

    static double[] readData(String datafile) {
        double[] data = new double[NUM_DATA];
        try {
            BufferedReader br = new BufferedReader(new FileReader(datafile));
            for (int j = 0; j < NUM_DATA; ++j) {
                data[j] = new Double(br.readLine());
            }
        } catch(IOException e) {
            e.printStackTrace();
        }
        return data;

    }
    static int[] readClasses(String classfile) {
        int[] classes = new int[NUM_DATA];
        try {
            BufferedReader br = new BufferedReader(new FileReader(classfile));
            for (int j = 0; j < NUM_DATA; ++j) {
                classes[j] = new Integer(br.readLine());
            }
        } catch(IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    static double calculateAccuracy(int[] classes, double[][] membership) {
        double errors = 0;
        for (int j = 0; j < membership[0].length; ++j) {
            int myclass = 0;
            if (membership[1][j] > membership[0][j])
                myclass = 1;
            if (classes[j] != myclass)
                ++errors;
        }
        double acc = errors / NUM_DATA;
        return Math.max(acc, 1-acc);
    }


    static void runKMeans(double[] data, double[] outMu,
                      double[][] outMembership) {

        // Set up 
        double[] oldMu = {0,0};
        double mu0 = Math.random() * 20 - 10;
        double mu1 = Math.random() * 20 - 10;
        double[] newMu = {mu0, mu1};
        double[][] oldMembership = new double[NUM_CLASSES][NUM_DATA];
        double[][] newMembership = new double[NUM_CLASSES][NUM_DATA];
        for (int i = 0; i < oldMembership.length; ++i) {
            for (int j = 0; j < oldMembership[0].length; ++j) {
                oldMembership[i][j] = 0;
                newMembership[i][j] = 1;
            }
        }

        int iterations = 0;
        while (! converged(oldMembership, newMembership)) {
            ++iterations;
            oldMu = newMu;
            oldMembership = newMembership;
            
            newMembership = new double[NUM_CLASSES][NUM_DATA];
            EStep(data, oldMu, newMembership);
            newMu = new double[2];
            MStep(data, newMembership, oldMu, newMu);
        }
        for (int i = 0; i < NUM_CLASSES; ++i) {
            outMu[i] = newMu[i];
            for (int j = 0; j < NUM_DATA; ++j) {
                outMembership[i][j] = newMembership[i][j];
            }
        }
    }

    static void EStep(double[] data, double[] mu,
                      double[][] membership) {
        for (int j = 0; j < data.length; ++j) {
            double firstval = Math.abs(data[j] - mu[0]);
            double secondval = Math.abs(data[j] - mu[1]);
            if (firstval < secondval) {
                membership[0][j] = 1;
                membership[1][j] = 0;
            } else {
                membership[0][j] = 0;
                membership[1][j] = 1;
            }
        }
    }

    static void MStep(double[] data, double[][] membership, double[] oldMu,
                      double[] newMu) {
        double num0 = 0;
        double denom0 = 0;
        double num1 = 0;
        double denom1 = 0;
        for (int j = 0; j < data.length; ++j) {
            num0 += membership[0][j] * data[j];
            denom0 += membership[0][j];
            num1 += membership[1][j] * data[j];
            denom1 += membership[1][j];
        }
        // Note that we need to return the old value of mu if none fall into the cluster.

        if (denom0 ==0)
            newMu[0] = oldMu[0];
        else
            newMu[0] = num0/denom0;

        if (denom1 == 0)
            newMu[1] = oldMu[1];
        else
            newMu[1] = num1/denom1;
    }

  
    static boolean converged(double[][] oldMembership, double[][] newMembership) {
        for (int i = 0; i < oldMembership.length; ++i) {
            for (int j = 0; j < oldMembership[0].length; ++j) {
                if (oldMembership[i][j] != newMembership[i][j])
                    return false;
            }
        }
        return true;
    }


}