package edu.cmu.cs211.exprtree.ast;

/** An expression representing an unknown, for example `x'. */
public final class VariableExpression implements Expression {
	private final String name;

	/**
	 * Creates a new variable expression.
	 * 
	 * @param name
	 *            the name for the new expression
	 * @throws NullPointerException if name is null
	 */
	public VariableExpression (String name) {
		if (name == null)
			throw new NullPointerException ();
		this.name = name;
	}

	/** An accessor for the name of the expression */
	public String getName ()
	{
		return name;
	}

	/** A nop (an unknown is...unknown) */
	public Expression cfold ()
	{
		return this;
	}

	/** @return the string from getName () */
	@Override
	public String toString ()
	{
		return getName ();
	}

	@Override
	public boolean equals (Object obj)
	{
		if (!(obj instanceof VariableExpression))
			return false;
		return ((VariableExpression) obj).name.equals (name);
	}

	@Override
	public int hashCode ()
	{
		return name.hashCode ();
	}
}
