package edu.cmu.cs211.exprtree.ast;

import java.math.BigDecimal;

/** An expression representing subtraction */
public final class SubtractExpression extends BinaryExpression {

	public SubtractExpression (Expression l, Expression r) {
		super (l, r);
	}

	/**
	 * Constant folding for this node. Uses the following rules:
	 * <p>
	 * (cN = constant expr, eN = any expression)
	 * <p>
	 * <ul>
	 * <li>(c1-c2) → constant with value c1-c2
	 * <li>(0-e1) → -e1
	 * <li>(e1-0) → e1
	 */
	public Expression cfold ()
	{
		throw new RuntimeException ("You need to implement this method");
	}

	/** @return The symbol for subtraction `-' */
	public char getOperatorSymbol ()
	{
		throw new RuntimeException ("You need to implement this method");
	}
}
