package edu.cmu.cs211.exprtree.ast;

import java.math.BigDecimal;

/** An expression representing multiplication */
public final class MultiplyExpression extends BinaryExpression {

	public MultiplyExpression (Expression l, Expression r) {
		super (l, r);
	}

	/**
	 * Constant folding for this node. Uses the following rules:
	 * <p>
	 * (cN = constant expr, eN = any expression)
	 * <p>
	 * <ul>
	 * <li>(c1*c2) → constant with value c1*c2.
	 * <li>(e1*1) → e1
	 * <li>(e1*0) → 0
	 * <li>(e1*-1) → -e1
	 * <li>(1*e1) → e1
	 * <li>(0*e1) → 0
	 * <li>(-1*e1) → -e1
	 * </ul>
	 */
	public Expression cfold ()
	{
		throw new RuntimeException ("You need to implement this method");
	}

	/** @return the symbol for multiplication, `*' */
	@Override
	public char getOperatorSymbol ()
	{
		throw new RuntimeException ("You need to implement this method");
	}

}
