package edu.cmu.cs211.exprtree.ast;

/**
 * A class representing an arithmatic expression, for example 2*3.14*r.
 * Provides a cfold method allowing constant folding.
 */
public interface Expression {
	/**
	 * Executes the <a
	 * href="http://en.wikipedia.org/wiki/Constant_folding">constant folding</a>
	 * optimization. The transformations done are defined in each Expression
	 * subclass.
	 */
	Expression cfold ();

	/**
	 * Tests the equality of two expressions. The Expressions in question must
	 * be exactly the same (same operations, same order) to be equal. For
	 * example, 1+2 and 2+1 are not equal, even though when evaluated they would
	 * be
	 */
	boolean equals (Object obj);

	/**
	 * You haven't learned what this method does yet, however we need to
	 * implement it when we override equals.
	 */
	int hashCode ();

	/**
	 * Turns an expression into a string as defined in each subclass
	 */
	public abstract String toString ();
}
