package edu.cmu.cs211.exprtree.ast;

import java.math.BigDecimal;

/**
 * An expression representing division
 */
public final class DivideExpression extends BinaryExpression {

	public DivideExpression (Expression l, Expression r) {
		super (l, r);
	}

	/** @return The division symbol, `/' */
	@Override
	public char getOperatorSymbol ()
	{
		throw new RuntimeException ("You need to implement this method");
	}

	/**
	 * Constant folding for this node. Uses the following rules:
	 * <p>
	 * (cN = constant expr, eN = any expression)
	 * <p>
	 * <ul>
	 * <li>(c1/c2) → constant with value c1/c2
	 * <li>(0/e1) → 0 (nb: this rule risks turning an NaN into a 0, but you
	 * don't need to worry about that).
	 * <li>(e1/1) → e1
	 * <li>(e1/-1) → -e1
	 * </ul>
	 */
	public Expression cfold ()
	{
		throw new RuntimeException ("You need to implement this method");
	}
}
