package edu.cmu.cs211.exprtree.ast;

import java.math.BigDecimal;

/**
 * An expression node representing a numerical constant.
 */
public final class ConstantExpression implements Expression {
	private final BigDecimal value;

	public static final ConstantExpression ONE = new ConstantExpression (1);
	public static final ConstantExpression ZERO = new ConstantExpression (0);
	public static final ConstantExpression MINUS_ONE = new ConstantExpression (
	        -1);

	/**
	 * Creates a new ConstantExpression with a given value.
	 * 
	 * @param value
	 *            The value of the new ConstantExpression
	 * @throws NullPointerException
	 *             if value is <code>null</code>
	 */
	public ConstantExpression (BigDecimal value) {
		if (value == null)
			throw new NullPointerException ();

		this.value = value;
	}

	public ConstantExpression (int value) {
		this (new BigDecimal (value));
	}

	/** An accessor for the node's value */
	public BigDecimal getValue ()
	{
		return value;
	}

	/** Does nothing */
	public Expression cfold ()
	{
		// hard to fold something that's already a constant
		return this;
	}

	/** Returns the string (value) */
	@Override
	public String toString ()
	{
		// Somebody might add an ^ operator. think about (-1)^n
		return String.format ("(%s)", getValue ());
	}

	@Override
	public boolean equals (Object obj)
	{
		if (!(obj instanceof ConstantExpression))
			return false;

		return getValue ().equals (((ConstantExpression) obj).getValue ());
	}

	@Override
	public int hashCode ()
	{
		return getValue ().hashCode ();
	}
}
