package edu.cmu.cs211.compression.huffman;
import java.io.IOException;

import edu.cmu.cs211.compression.io.BitReader;
import edu.cmu.cs211.compression.io.BitWriter;


/**
 * Serializes and deserializes symbols to and from a stream of bits. Used by
 * HuffmanCode to write and read the header.
 * 
 * Note that it's only for the header...it's easy to get confused.
 * 
 * @param <T>
 *            The type of symbol this class serializes.
 */
public interface HuffmanSymbolSerializer<T> {
	
	/**
	 * Reads a symbol from a stream.
	 * 
	 * @param reader
	 *            The reader to read from.
	 * @return The symbol read from the bit stream.
	 * @throws IOException
	 *             If the underlying bit stream throws an exception or if the
	 *             file ends before the symbol could be fully read.
	 */
	public T read (BitReader reader) throws IOException;

	/**
	 * Writes a value to a stream.
	 * 
	 * @param value
	 *            The value to write.
	 * @param writer
	 *            The stream to write it to.
	 * @throws IOException
	 *             If the underlying stream throws an exception.
	 * @throws NullPointerException
	 *             If the value is null, and this class does not support writing
	 *             null values.
	 */
	public void write (T value, BitWriter writer) throws IOException;
}
